/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFleetRequest extends DeadlineRequest implements
        ToCopyableBuilder<UpdateFleetRequest.Builder, UpdateFleetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateFleetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<FleetConfiguration> CONFIGURATION_FIELD = SdkField
            .<FleetConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(UpdateFleetRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(FleetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateFleetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateFleetRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(UpdateFleetRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetId").getter(getter(UpdateFleetRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("fleetId").build()).build();

    private static final SdkField<Integer> MAX_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxWorkerCount").getter(getter(UpdateFleetRequest::maxWorkerCount))
            .setter(setter(Builder::maxWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxWorkerCount").build()).build();

    private static final SdkField<Integer> MIN_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minWorkerCount").getter(getter(UpdateFleetRequest::minWorkerCount))
            .setter(setter(Builder::minWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minWorkerCount").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateFleetRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CONFIGURATION_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, FARM_ID_FIELD, FLEET_ID_FIELD, MAX_WORKER_COUNT_FIELD,
            MIN_WORKER_COUNT_FIELD, ROLE_ARN_FIELD));

    private final String clientToken;

    private final FleetConfiguration configuration;

    private final String description;

    private final String displayName;

    private final String farmId;

    private final String fleetId;

    private final Integer maxWorkerCount;

    private final Integer minWorkerCount;

    private final String roleArn;

    private UpdateFleetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.farmId = builder.farmId;
        this.fleetId = builder.fleetId;
        this.maxWorkerCount = builder.maxWorkerCount;
        this.minWorkerCount = builder.minWorkerCount;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The unique token which the server uses to recognize retries of the same request.
     * </p>
     * 
     * @return The unique token which the server uses to recognize retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The fleet configuration to update.
     * </p>
     * 
     * @return The fleet configuration to update.
     */
    public final FleetConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The description of the fleet to update.
     * </p>
     * 
     * @return The description of the fleet to update.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of the fleet to update.
     * </p>
     * 
     * @return The display name of the fleet to update.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The farm ID to update.
     * </p>
     * 
     * @return The farm ID to update.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The fleet ID to update.
     * </p>
     * 
     * @return The fleet ID to update.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The maximum number of workers in the fleet.
     * </p>
     * 
     * @return The maximum number of workers in the fleet.
     */
    public final Integer maxWorkerCount() {
        return maxWorkerCount;
    }

    /**
     * <p>
     * The minimum number of workers in the fleet.
     * </p>
     * 
     * @return The minimum number of workers in the fleet.
     */
    public final Integer minWorkerCount() {
        return minWorkerCount;
    }

    /**
     * <p>
     * The IAM role ARN that the fleet's workers assume while running jobs.
     * </p>
     * 
     * @return The IAM role ARN that the fleet's workers assume while running jobs.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(maxWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(minWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetRequest)) {
            return false;
        }
        UpdateFleetRequest other = (UpdateFleetRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(farmId(), other.farmId()) && Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(maxWorkerCount(), other.maxWorkerCount())
                && Objects.equals(minWorkerCount(), other.minWorkerCount()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFleetRequest").add("ClientToken", clientToken()).add("Configuration", configuration())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisplayName", displayName()).add("FarmId", farmId()).add("FleetId", fleetId())
                .add("MaxWorkerCount", maxWorkerCount()).add("MinWorkerCount", minWorkerCount()).add("RoleArn", roleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "fleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "maxWorkerCount":
            return Optional.ofNullable(clazz.cast(maxWorkerCount()));
        case "minWorkerCount":
            return Optional.ofNullable(clazz.cast(minWorkerCount()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFleetRequest, T> g) {
        return obj -> g.apply((UpdateFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFleetRequest> {
        /**
         * <p>
         * The unique token which the server uses to recognize retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        The unique token which the server uses to recognize retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The fleet configuration to update.
         * </p>
         * 
         * @param configuration
         *        The fleet configuration to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(FleetConfiguration configuration);

        /**
         * <p>
         * The fleet configuration to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link FleetConfiguration.Builder} avoiding the
         * need to create one manually via {@link FleetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FleetConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(FleetConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link FleetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(FleetConfiguration)
         */
        default Builder configuration(Consumer<FleetConfiguration.Builder> configuration) {
            return configuration(FleetConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The description of the fleet to update.
         * </p>
         * 
         * @param description
         *        The description of the fleet to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of the fleet to update.
         * </p>
         * 
         * @param displayName
         *        The display name of the fleet to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The farm ID to update.
         * </p>
         * 
         * @param farmId
         *        The farm ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The fleet ID to update.
         * </p>
         * 
         * @param fleetId
         *        The fleet ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The maximum number of workers in the fleet.
         * </p>
         * 
         * @param maxWorkerCount
         *        The maximum number of workers in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWorkerCount(Integer maxWorkerCount);

        /**
         * <p>
         * The minimum number of workers in the fleet.
         * </p>
         * 
         * @param minWorkerCount
         *        The minimum number of workers in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minWorkerCount(Integer minWorkerCount);

        /**
         * <p>
         * The IAM role ARN that the fleet's workers assume while running jobs.
         * </p>
         * 
         * @param roleArn
         *        The IAM role ARN that the fleet's workers assume while running jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String clientToken;

        private FleetConfiguration configuration;

        private String description;

        private String displayName;

        private String farmId;

        private String fleetId;

        private Integer maxWorkerCount;

        private Integer minWorkerCount;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetRequest model) {
            super(model);
            clientToken(model.clientToken);
            configuration(model.configuration);
            description(model.description);
            displayName(model.displayName);
            farmId(model.farmId);
            fleetId(model.fleetId);
            maxWorkerCount(model.maxWorkerCount);
            minWorkerCount(model.minWorkerCount);
            roleArn(model.roleArn);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final FleetConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(FleetConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(FleetConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final Integer getMaxWorkerCount() {
            return maxWorkerCount;
        }

        public final void setMaxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
        }

        @Override
        public final Builder maxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
            return this;
        }

        public final Integer getMinWorkerCount() {
            return minWorkerCount;
        }

        public final void setMinWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
        }

        @Override
        public final Builder minWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFleetRequest build() {
            return new UpdateFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
