/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest;
import software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse;
import software.amazon.awssdk.services.deadline.model.StepDependency;

public class ListStepDependenciesIterable
implements SdkIterable<ListStepDependenciesResponse> {
    private final DeadlineClient client;
    private final ListStepDependenciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStepDependenciesIterable(DeadlineClient client, ListStepDependenciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStepDependenciesResponseFetcher();
    }

    public Iterator<ListStepDependenciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StepDependency> dependencies() {
        Function<ListStepDependenciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dependencies() != null) {
                return response.dependencies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStepDependenciesResponseFetcher
    implements SyncPageFetcher<ListStepDependenciesResponse> {
        private ListStepDependenciesResponseFetcher() {
        }

        public boolean hasNextPage(ListStepDependenciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStepDependenciesResponse nextPage(ListStepDependenciesResponse previousPage) {
            if (previousPage == null) {
                return ListStepDependenciesIterable.this.client.listStepDependencies(ListStepDependenciesIterable.this.firstRequest);
            }
            return ListStepDependenciesIterable.this.client.listStepDependencies((ListStepDependenciesRequest)((Object)ListStepDependenciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

