/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AssignedSessionActionsCopier {
    static List<AssignedSessionAction> copy(Collection<? extends AssignedSessionAction> assignedSessionActionsParam) {
        List<AssignedSessionAction> list;
        if (assignedSessionActionsParam == null || assignedSessionActionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AssignedSessionAction> modifiableList = new ArrayList<>();
            assignedSessionActionsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AssignedSessionAction> copyFromBuilder(
            Collection<? extends AssignedSessionAction.Builder> assignedSessionActionsParam) {
        List<AssignedSessionAction> list;
        if (assignedSessionActionsParam == null || assignedSessionActionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AssignedSessionAction> modifiableList = new ArrayList<>();
            assignedSessionActionsParam.forEach(entry -> {
                AssignedSessionAction member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AssignedSessionAction.Builder> copyToBuilder(
            Collection<? extends AssignedSessionAction> assignedSessionActionsParam) {
        List<AssignedSessionAction.Builder> list;
        if (assignedSessionActionsParam == null || assignedSessionActionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AssignedSessionAction.Builder> modifiableList = new ArrayList<>();
            assignedSessionActionsParam.forEach(entry -> {
                AssignedSessionAction.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
