/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action for a session defined by the session action ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssignedSessionAction implements SdkPojo, Serializable,
        ToCopyableBuilder<AssignedSessionAction.Builder, AssignedSessionAction> {
    private static final SdkField<AssignedSessionActionDefinition> DEFINITION_FIELD = SdkField
            .<AssignedSessionActionDefinition> builder(MarshallingType.SDK_POJO).memberName("definition")
            .getter(getter(AssignedSessionAction::definition)).setter(setter(Builder::definition))
            .constructor(AssignedSessionActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> SESSION_ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionActionId").getter(getter(AssignedSessionAction::sessionActionId))
            .setter(setter(Builder::sessionActionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionActionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD,
            SESSION_ACTION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final AssignedSessionActionDefinition definition;

    private final String sessionActionId;

    private AssignedSessionAction(BuilderImpl builder) {
        this.definition = builder.definition;
        this.sessionActionId = builder.sessionActionId;
    }

    /**
     * <p>
     * The definition of the assigned session action.
     * </p>
     * 
     * @return The definition of the assigned session action.
     */
    public final AssignedSessionActionDefinition definition() {
        return definition;
    }

    /**
     * <p>
     * The session action ID for the assigned session.
     * </p>
     * 
     * @return The session action ID for the assigned session.
     */
    public final String sessionActionId() {
        return sessionActionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(sessionActionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignedSessionAction)) {
            return false;
        }
        AssignedSessionAction other = (AssignedSessionAction) obj;
        return Objects.equals(definition(), other.definition()) && Objects.equals(sessionActionId(), other.sessionActionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssignedSessionAction").add("Definition", definition())
                .add("SessionActionId", sessionActionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "sessionActionId":
            return Optional.ofNullable(clazz.cast(sessionActionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssignedSessionAction, T> g) {
        return obj -> g.apply((AssignedSessionAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssignedSessionAction> {
        /**
         * <p>
         * The definition of the assigned session action.
         * </p>
         * 
         * @param definition
         *        The definition of the assigned session action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(AssignedSessionActionDefinition definition);

        /**
         * <p>
         * The definition of the assigned session action.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssignedSessionActionDefinition.Builder}
         * avoiding the need to create one manually via {@link AssignedSessionActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssignedSessionActionDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #definition(AssignedSessionActionDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link AssignedSessionActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(AssignedSessionActionDefinition)
         */
        default Builder definition(Consumer<AssignedSessionActionDefinition.Builder> definition) {
            return definition(AssignedSessionActionDefinition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The session action ID for the assigned session.
         * </p>
         * 
         * @param sessionActionId
         *        The session action ID for the assigned session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionActionId(String sessionActionId);
    }

    static final class BuilderImpl implements Builder {
        private AssignedSessionActionDefinition definition;

        private String sessionActionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignedSessionAction model) {
            definition(model.definition);
            sessionActionId(model.sessionActionId);
        }

        public final AssignedSessionActionDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(AssignedSessionActionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(AssignedSessionActionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final String getSessionActionId() {
            return sessionActionId;
        }

        public final void setSessionActionId(String sessionActionId) {
            this.sessionActionId = sessionActionId;
        }

        @Override
        public final Builder sessionActionId(String sessionActionId) {
            this.sessionActionId = sessionActionId;
            return this;
        }

        @Override
        public AssignedSessionAction build() {
            return new AssignedSessionAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
