/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The budget action to add.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BudgetActionToAdd implements SdkPojo, Serializable,
        ToCopyableBuilder<BudgetActionToAdd.Builder, BudgetActionToAdd> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BudgetActionToAdd::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Float> THRESHOLD_PERCENTAGE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("thresholdPercentage").getter(getter(BudgetActionToAdd::thresholdPercentage))
            .setter(setter(Builder::thresholdPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdPercentage").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(BudgetActionToAdd::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            THRESHOLD_PERCENTAGE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final Float thresholdPercentage;

    private final String type;

    private BudgetActionToAdd(BuilderImpl builder) {
        this.description = builder.description;
        this.thresholdPercentage = builder.thresholdPercentage;
        this.type = builder.type;
    }

    /**
     * <p>
     * A description for the budget action to add.
     * </p>
     * 
     * @return A description for the budget action to add.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The percentage threshold for the budget action to add.
     * </p>
     * 
     * @return The percentage threshold for the budget action to add.
     */
    public final Float thresholdPercentage() {
        return thresholdPercentage;
    }

    /**
     * <p>
     * The type of budget action to add.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BudgetActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of budget action to add.
     * @see BudgetActionType
     */
    public final BudgetActionType type() {
        return BudgetActionType.fromValue(type);
    }

    /**
     * <p>
     * The type of budget action to add.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BudgetActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of budget action to add.
     * @see BudgetActionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetActionToAdd)) {
            return false;
        }
        BudgetActionToAdd other = (BudgetActionToAdd) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(thresholdPercentage(), other.thresholdPercentage())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BudgetActionToAdd")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ThresholdPercentage", thresholdPercentage()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "thresholdPercentage":
            return Optional.ofNullable(clazz.cast(thresholdPercentage()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BudgetActionToAdd, T> g) {
        return obj -> g.apply((BudgetActionToAdd) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BudgetActionToAdd> {
        /**
         * <p>
         * A description for the budget action to add.
         * </p>
         * 
         * @param description
         *        A description for the budget action to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The percentage threshold for the budget action to add.
         * </p>
         * 
         * @param thresholdPercentage
         *        The percentage threshold for the budget action to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdPercentage(Float thresholdPercentage);

        /**
         * <p>
         * The type of budget action to add.
         * </p>
         * 
         * @param type
         *        The type of budget action to add.
         * @see BudgetActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetActionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of budget action to add.
         * </p>
         * 
         * @param type
         *        The type of budget action to add.
         * @see BudgetActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetActionType
         */
        Builder type(BudgetActionType type);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private Float thresholdPercentage;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(BudgetActionToAdd model) {
            description(model.description);
            thresholdPercentage(model.thresholdPercentage);
            type(model.type);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Float getThresholdPercentage() {
            return thresholdPercentage;
        }

        public final void setThresholdPercentage(Float thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
        }

        @Override
        public final Builder thresholdPercentage(Float thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BudgetActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public BudgetActionToAdd build() {
            return new BudgetActionToAdd(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
