/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The budget summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BudgetSummary implements SdkPojo, Serializable, ToCopyableBuilder<BudgetSummary.Builder, BudgetSummary> {
    private static final SdkField<Float> APPROXIMATE_DOLLAR_LIMIT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("approximateDollarLimit").getter(getter(BudgetSummary::approximateDollarLimit))
            .setter(setter(Builder::approximateDollarLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateDollarLimit").build())
            .build();

    private static final SdkField<String> BUDGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("budgetId").getter(getter(BudgetSummary::budgetId)).setter(setter(Builder::budgetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budgetId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(BudgetSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(BudgetSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BudgetSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(BudgetSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BudgetSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(BudgetSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(BudgetSummary::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<UsageTrackingResource> USAGE_TRACKING_RESOURCE_FIELD = SdkField
            .<UsageTrackingResource> builder(MarshallingType.SDK_POJO).memberName("usageTrackingResource")
            .getter(getter(BudgetSummary::usageTrackingResource)).setter(setter(Builder::usageTrackingResource))
            .constructor(UsageTrackingResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTrackingResource").build())
            .build();

    private static final SdkField<ConsumedUsages> USAGES_FIELD = SdkField.<ConsumedUsages> builder(MarshallingType.SDK_POJO)
            .memberName("usages").getter(getter(BudgetSummary::usages)).setter(setter(Builder::usages))
            .constructor(ConsumedUsages::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usages").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPROXIMATE_DOLLAR_LIMIT_FIELD, BUDGET_ID_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD,
            DISPLAY_NAME_FIELD, STATUS_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, USAGE_TRACKING_RESOURCE_FIELD, USAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float approximateDollarLimit;

    private final String budgetId;

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final String displayName;

    private final String status;

    private final Instant updatedAt;

    private final String updatedBy;

    private final UsageTrackingResource usageTrackingResource;

    private final ConsumedUsages usages;

    private BudgetSummary(BuilderImpl builder) {
        this.approximateDollarLimit = builder.approximateDollarLimit;
        this.budgetId = builder.budgetId;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.usageTrackingResource = builder.usageTrackingResource;
        this.usages = builder.usages;
    }

    /**
     * <p>
     * The approximate dollar limit of the budget.
     * </p>
     * 
     * @return The approximate dollar limit of the budget.
     */
    public final Float approximateDollarLimit() {
        return approximateDollarLimit;
    }

    /**
     * <p>
     * The budget ID.
     * </p>
     * 
     * @return The budget ID.
     */
    public final String budgetId() {
        return budgetId;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or system that created this resource.
     * </p>
     * 
     * @return The user or system that created this resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of the budget summary.
     * </p>
     * 
     * @return The description of the budget summary.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of the budget summary to update.
     * </p>
     * 
     * @return The display name of the budget summary to update.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The status of the budget.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>–The budget is being evaluated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted statuses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BudgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the budget.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>–The budget is being evaluated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted
     *         statuses.
     *         </p>
     *         </li>
     * @see BudgetStatus
     */
    public final BudgetStatus status() {
        return BudgetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the budget.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>–The budget is being evaluated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted statuses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BudgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the budget.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>–The budget is being evaluated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted
     *         statuses.
     *         </p>
     *         </li>
     * @see BudgetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The resource used to track expenditure in the budget.
     * </p>
     * 
     * @return The resource used to track expenditure in the budget.
     */
    public final UsageTrackingResource usageTrackingResource() {
        return usageTrackingResource;
    }

    /**
     * <p>
     * The consumed usage for the budget.
     * </p>
     * 
     * @return The consumed usage for the budget.
     */
    public final ConsumedUsages usages() {
        return usages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approximateDollarLimit());
        hashCode = 31 * hashCode + Objects.hashCode(budgetId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(usageTrackingResource());
        hashCode = 31 * hashCode + Objects.hashCode(usages());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetSummary)) {
            return false;
        }
        BudgetSummary other = (BudgetSummary) obj;
        return Objects.equals(approximateDollarLimit(), other.approximateDollarLimit())
                && Objects.equals(budgetId(), other.budgetId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy())
                && Objects.equals(usageTrackingResource(), other.usageTrackingResource())
                && Objects.equals(usages(), other.usages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BudgetSummary").add("ApproximateDollarLimit", approximateDollarLimit())
                .add("BudgetId", budgetId()).add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisplayName", displayName()).add("Status", statusAsString()).add("UpdatedAt", updatedAt())
                .add("UpdatedBy", updatedBy()).add("UsageTrackingResource", usageTrackingResource()).add("Usages", usages())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approximateDollarLimit":
            return Optional.ofNullable(clazz.cast(approximateDollarLimit()));
        case "budgetId":
            return Optional.ofNullable(clazz.cast(budgetId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "usageTrackingResource":
            return Optional.ofNullable(clazz.cast(usageTrackingResource()));
        case "usages":
            return Optional.ofNullable(clazz.cast(usages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BudgetSummary, T> g) {
        return obj -> g.apply((BudgetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BudgetSummary> {
        /**
         * <p>
         * The approximate dollar limit of the budget.
         * </p>
         * 
         * @param approximateDollarLimit
         *        The approximate dollar limit of the budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateDollarLimit(Float approximateDollarLimit);

        /**
         * <p>
         * The budget ID.
         * </p>
         * 
         * @param budgetId
         *        The budget ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetId(String budgetId);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or system that created this resource.
         * </p>
         * 
         * @param createdBy
         *        The user or system that created this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of the budget summary.
         * </p>
         * 
         * @param description
         *        The description of the budget summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of the budget summary to update.
         * </p>
         * 
         * @param displayName
         *        The display name of the budget summary to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The status of the budget.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>–The budget is being evaluated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted
         * statuses.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the budget.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>–The budget is being evaluated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted
         *        statuses.
         *        </p>
         *        </li>
         * @see BudgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the budget.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>–The budget is being evaluated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted
         * statuses.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the budget.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>–The budget is being evaluated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted
         *        statuses.
         *        </p>
         *        </li>
         * @see BudgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetStatus
         */
        Builder status(BudgetStatus status);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The resource used to track expenditure in the budget.
         * </p>
         * 
         * @param usageTrackingResource
         *        The resource used to track expenditure in the budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageTrackingResource(UsageTrackingResource usageTrackingResource);

        /**
         * <p>
         * The resource used to track expenditure in the budget.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsageTrackingResource.Builder} avoiding
         * the need to create one manually via {@link UsageTrackingResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsageTrackingResource.Builder#build()} is called immediately and
         * its result is passed to {@link #usageTrackingResource(UsageTrackingResource)}.
         * 
         * @param usageTrackingResource
         *        a consumer that will call methods on {@link UsageTrackingResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageTrackingResource(UsageTrackingResource)
         */
        default Builder usageTrackingResource(Consumer<UsageTrackingResource.Builder> usageTrackingResource) {
            return usageTrackingResource(UsageTrackingResource.builder().applyMutation(usageTrackingResource).build());
        }

        /**
         * <p>
         * The consumed usage for the budget.
         * </p>
         * 
         * @param usages
         *        The consumed usage for the budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usages(ConsumedUsages usages);

        /**
         * <p>
         * The consumed usage for the budget.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumedUsages.Builder} avoiding the need
         * to create one manually via {@link ConsumedUsages#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsumedUsages.Builder#build()} is called immediately and its
         * result is passed to {@link #usages(ConsumedUsages)}.
         * 
         * @param usages
         *        a consumer that will call methods on {@link ConsumedUsages.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usages(ConsumedUsages)
         */
        default Builder usages(Consumer<ConsumedUsages.Builder> usages) {
            return usages(ConsumedUsages.builder().applyMutation(usages).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Float approximateDollarLimit;

        private String budgetId;

        private Instant createdAt;

        private String createdBy;

        private String description;

        private String displayName;

        private String status;

        private Instant updatedAt;

        private String updatedBy;

        private UsageTrackingResource usageTrackingResource;

        private ConsumedUsages usages;

        private BuilderImpl() {
        }

        private BuilderImpl(BudgetSummary model) {
            approximateDollarLimit(model.approximateDollarLimit);
            budgetId(model.budgetId);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            displayName(model.displayName);
            status(model.status);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            usageTrackingResource(model.usageTrackingResource);
            usages(model.usages);
        }

        public final Float getApproximateDollarLimit() {
            return approximateDollarLimit;
        }

        public final void setApproximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
        }

        @Override
        public final Builder approximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
            return this;
        }

        public final String getBudgetId() {
            return budgetId;
        }

        public final void setBudgetId(String budgetId) {
            this.budgetId = budgetId;
        }

        @Override
        public final Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BudgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final UsageTrackingResource.Builder getUsageTrackingResource() {
            return usageTrackingResource != null ? usageTrackingResource.toBuilder() : null;
        }

        public final void setUsageTrackingResource(UsageTrackingResource.BuilderImpl usageTrackingResource) {
            this.usageTrackingResource = usageTrackingResource != null ? usageTrackingResource.build() : null;
        }

        @Override
        public final Builder usageTrackingResource(UsageTrackingResource usageTrackingResource) {
            this.usageTrackingResource = usageTrackingResource;
            return this;
        }

        public final ConsumedUsages.Builder getUsages() {
            return usages != null ? usages.toBuilder() : null;
        }

        public final void setUsages(ConsumedUsages.BuilderImpl usages) {
            this.usages = usages != null ? usages.build() : null;
        }

        @Override
        public final Builder usages(ConsumedUsages usages) {
            this.usages = usages;
            return this;
        }

        @Override
        public BudgetSummary build() {
            return new BudgetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
