/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBudgetRequest extends DeadlineRequest implements
        ToCopyableBuilder<CreateBudgetRequest.Builder, CreateBudgetRequest> {
    private static final SdkField<List<BudgetActionToAdd>> ACTIONS_FIELD = SdkField
            .<List<BudgetActionToAdd>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(CreateBudgetRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BudgetActionToAdd> builder(MarshallingType.SDK_POJO)
                                            .constructor(BudgetActionToAdd::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Float> APPROXIMATE_DOLLAR_LIMIT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("approximateDollarLimit").getter(getter(CreateBudgetRequest::approximateDollarLimit))
            .setter(setter(Builder::approximateDollarLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateDollarLimit").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateBudgetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateBudgetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateBudgetRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(CreateBudgetRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<BudgetSchedule> SCHEDULE_FIELD = SdkField.<BudgetSchedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(CreateBudgetRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(BudgetSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<UsageTrackingResource> USAGE_TRACKING_RESOURCE_FIELD = SdkField
            .<UsageTrackingResource> builder(MarshallingType.SDK_POJO).memberName("usageTrackingResource")
            .getter(getter(CreateBudgetRequest::usageTrackingResource)).setter(setter(Builder::usageTrackingResource))
            .constructor(UsageTrackingResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTrackingResource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD,
            APPROXIMATE_DOLLAR_LIMIT_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, FARM_ID_FIELD,
            SCHEDULE_FIELD, USAGE_TRACKING_RESOURCE_FIELD));

    private final List<BudgetActionToAdd> actions;

    private final Float approximateDollarLimit;

    private final String clientToken;

    private final String description;

    private final String displayName;

    private final String farmId;

    private final BudgetSchedule schedule;

    private final UsageTrackingResource usageTrackingResource;

    private CreateBudgetRequest(BuilderImpl builder) {
        super(builder);
        this.actions = builder.actions;
        this.approximateDollarLimit = builder.approximateDollarLimit;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.farmId = builder.farmId;
        this.schedule = builder.schedule;
        this.usageTrackingResource = builder.usageTrackingResource;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The budget actions to specify what happens when the budget runs out.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The budget actions to specify what happens when the budget runs out.
     */
    public final List<BudgetActionToAdd> actions() {
        return actions;
    }

    /**
     * <p>
     * The dollar limit based on consumed usage.
     * </p>
     * 
     * @return The dollar limit based on consumed usage.
     */
    public final Float approximateDollarLimit() {
        return approximateDollarLimit;
    }

    /**
     * <p>
     * The unique token which the server uses to recognize retries of the same request.
     * </p>
     * 
     * @return The unique token which the server uses to recognize retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description of the budget.
     * </p>
     * 
     * @return The description of the budget.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of the budget.
     * </p>
     * 
     * @return The display name of the budget.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The farm ID to include in this budget.
     * </p>
     * 
     * @return The farm ID to include in this budget.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The schedule to associate with this budget.
     * </p>
     * 
     * @return The schedule to associate with this budget.
     */
    public final BudgetSchedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The queue ID provided to this budget to track usage.
     * </p>
     * 
     * @return The queue ID provided to this budget to track usage.
     */
    public final UsageTrackingResource usageTrackingResource() {
        return usageTrackingResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(approximateDollarLimit());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(usageTrackingResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBudgetRequest)) {
            return false;
        }
        CreateBudgetRequest other = (CreateBudgetRequest) obj;
        return hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(approximateDollarLimit(), other.approximateDollarLimit())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(schedule(), other.schedule())
                && Objects.equals(usageTrackingResource(), other.usageTrackingResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBudgetRequest").add("Actions", hasActions() ? actions() : null)
                .add("ApproximateDollarLimit", approximateDollarLimit()).add("ClientToken", clientToken())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisplayName", displayName()).add("FarmId", farmId()).add("Schedule", schedule())
                .add("UsageTrackingResource", usageTrackingResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "approximateDollarLimit":
            return Optional.ofNullable(clazz.cast(approximateDollarLimit()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "usageTrackingResource":
            return Optional.ofNullable(clazz.cast(usageTrackingResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBudgetRequest, T> g) {
        return obj -> g.apply((CreateBudgetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBudgetRequest> {
        /**
         * <p>
         * The budget actions to specify what happens when the budget runs out.
         * </p>
         * 
         * @param actions
         *        The budget actions to specify what happens when the budget runs out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<BudgetActionToAdd> actions);

        /**
         * <p>
         * The budget actions to specify what happens when the budget runs out.
         * </p>
         * 
         * @param actions
         *        The budget actions to specify what happens when the budget runs out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(BudgetActionToAdd... actions);

        /**
         * <p>
         * The budget actions to specify what happens when the budget runs out.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.BudgetActionToAdd.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.deadline.model.BudgetActionToAdd#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.BudgetActionToAdd.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<BudgetActionToAdd>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.BudgetActionToAdd.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<BudgetActionToAdd>)
         */
        Builder actions(Consumer<BudgetActionToAdd.Builder>... actions);

        /**
         * <p>
         * The dollar limit based on consumed usage.
         * </p>
         * 
         * @param approximateDollarLimit
         *        The dollar limit based on consumed usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateDollarLimit(Float approximateDollarLimit);

        /**
         * <p>
         * The unique token which the server uses to recognize retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        The unique token which the server uses to recognize retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description of the budget.
         * </p>
         * 
         * @param description
         *        The description of the budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of the budget.
         * </p>
         * 
         * @param displayName
         *        The display name of the budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The farm ID to include in this budget.
         * </p>
         * 
         * @param farmId
         *        The farm ID to include in this budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The schedule to associate with this budget.
         * </p>
         * 
         * @param schedule
         *        The schedule to associate with this budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(BudgetSchedule schedule);

        /**
         * <p>
         * The schedule to associate with this budget.
         * </p>
         * This is a convenience method that creates an instance of the {@link BudgetSchedule.Builder} avoiding the need
         * to create one manually via {@link BudgetSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BudgetSchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #schedule(BudgetSchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link BudgetSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(BudgetSchedule)
         */
        default Builder schedule(Consumer<BudgetSchedule.Builder> schedule) {
            return schedule(BudgetSchedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The queue ID provided to this budget to track usage.
         * </p>
         * 
         * @param usageTrackingResource
         *        The queue ID provided to this budget to track usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageTrackingResource(UsageTrackingResource usageTrackingResource);

        /**
         * <p>
         * The queue ID provided to this budget to track usage.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsageTrackingResource.Builder} avoiding
         * the need to create one manually via {@link UsageTrackingResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsageTrackingResource.Builder#build()} is called immediately and
         * its result is passed to {@link #usageTrackingResource(UsageTrackingResource)}.
         * 
         * @param usageTrackingResource
         *        a consumer that will call methods on {@link UsageTrackingResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageTrackingResource(UsageTrackingResource)
         */
        default Builder usageTrackingResource(Consumer<UsageTrackingResource.Builder> usageTrackingResource) {
            return usageTrackingResource(UsageTrackingResource.builder().applyMutation(usageTrackingResource).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private List<BudgetActionToAdd> actions = DefaultSdkAutoConstructList.getInstance();

        private Float approximateDollarLimit;

        private String clientToken;

        private String description;

        private String displayName;

        private String farmId;

        private BudgetSchedule schedule;

        private UsageTrackingResource usageTrackingResource;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBudgetRequest model) {
            super(model);
            actions(model.actions);
            approximateDollarLimit(model.approximateDollarLimit);
            clientToken(model.clientToken);
            description(model.description);
            displayName(model.displayName);
            farmId(model.farmId);
            schedule(model.schedule);
            usageTrackingResource(model.usageTrackingResource);
        }

        public final List<BudgetActionToAdd.Builder> getActions() {
            List<BudgetActionToAdd.Builder> result = BudgetActionsToAddCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<BudgetActionToAdd.BuilderImpl> actions) {
            this.actions = BudgetActionsToAddCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<BudgetActionToAdd> actions) {
            this.actions = BudgetActionsToAddCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(BudgetActionToAdd... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<BudgetActionToAdd.Builder>... actions) {
            actions(Stream.of(actions).map(c -> BudgetActionToAdd.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Float getApproximateDollarLimit() {
            return approximateDollarLimit;
        }

        public final void setApproximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
        }

        @Override
        public final Builder approximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final BudgetSchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(BudgetSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(BudgetSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final UsageTrackingResource.Builder getUsageTrackingResource() {
            return usageTrackingResource != null ? usageTrackingResource.toBuilder() : null;
        }

        public final void setUsageTrackingResource(UsageTrackingResource.BuilderImpl usageTrackingResource) {
            this.usageTrackingResource = usageTrackingResource != null ? usageTrackingResource.build() : null;
        }

        @Override
        public final Builder usageTrackingResource(UsageTrackingResource usageTrackingResource) {
            this.usageTrackingResource = usageTrackingResource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBudgetRequest build() {
            return new CreateBudgetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
