/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMonitorResponse extends DeadlineResponse implements
        ToCopyableBuilder<CreateMonitorResponse.Builder, CreateMonitorResponse> {
    private static final SdkField<String> IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("identityCenterApplicationArn")
            .getter(getter(CreateMonitorResponse::identityCenterApplicationArn))
            .setter(setter(Builder::identityCenterApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityCenterApplicationArn")
                    .build()).build();

    private static final SdkField<String> MONITOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monitorId").getter(getter(CreateMonitorResponse::monitorId)).setter(setter(Builder::monitorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IDENTITY_CENTER_APPLICATION_ARN_FIELD, MONITOR_ID_FIELD));

    private final String identityCenterApplicationArn;

    private final String monitorId;

    private CreateMonitorResponse(BuilderImpl builder) {
        super(builder);
        this.identityCenterApplicationArn = builder.identityCenterApplicationArn;
        this.monitorId = builder.monitorId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that IAM Identity Center assigns to the monitor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that IAM Identity Center assigns to the monitor.
     */
    public final String identityCenterApplicationArn() {
        return identityCenterApplicationArn;
    }

    /**
     * <p>
     * The unique identifier of the monitor.
     * </p>
     * 
     * @return The unique identifier of the monitor.
     */
    public final String monitorId() {
        return monitorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(monitorId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitorResponse)) {
            return false;
        }
        CreateMonitorResponse other = (CreateMonitorResponse) obj;
        return Objects.equals(identityCenterApplicationArn(), other.identityCenterApplicationArn())
                && Objects.equals(monitorId(), other.monitorId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMonitorResponse").add("IdentityCenterApplicationArn", identityCenterApplicationArn())
                .add("MonitorId", monitorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identityCenterApplicationArn":
            return Optional.ofNullable(clazz.cast(identityCenterApplicationArn()));
        case "monitorId":
            return Optional.ofNullable(clazz.cast(monitorId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMonitorResponse, T> g) {
        return obj -> g.apply((CreateMonitorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateMonitorResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that IAM Identity Center assigns to the monitor.
         * </p>
         * 
         * @param identityCenterApplicationArn
         *        The Amazon Resource Name (ARN) that IAM Identity Center assigns to the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterApplicationArn(String identityCenterApplicationArn);

        /**
         * <p>
         * The unique identifier of the monitor.
         * </p>
         * 
         * @param monitorId
         *        The unique identifier of the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorId(String monitorId);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private String identityCenterApplicationArn;

        private String monitorId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMonitorResponse model) {
            super(model);
            identityCenterApplicationArn(model.identityCenterApplicationArn);
            monitorId(model.monitorId);
        }

        public final String getIdentityCenterApplicationArn() {
            return identityCenterApplicationArn;
        }

        public final void setIdentityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
        }

        @Override
        public final Builder identityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
            return this;
        }

        public final String getMonitorId() {
            return monitorId;
        }

        public final void setMonitorId(String monitorId) {
            this.monitorId = monitorId;
        }

        @Override
        public final Builder monitorId(String monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        @Override
        public CreateMonitorResponse build() {
            return new CreateMonitorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
