/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkerRequest extends DeadlineRequest implements
        ToCopyableBuilder<CreateWorkerRequest.Builder, CreateWorkerRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateWorkerRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(CreateWorkerRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetId").getter(getter(CreateWorkerRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("fleetId").build()).build();

    private static final SdkField<HostPropertiesRequest> HOST_PROPERTIES_FIELD = SdkField
            .<HostPropertiesRequest> builder(MarshallingType.SDK_POJO).memberName("hostProperties")
            .getter(getter(CreateWorkerRequest::hostProperties)).setter(setter(Builder::hostProperties))
            .constructor(HostPropertiesRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            FARM_ID_FIELD, FLEET_ID_FIELD, HOST_PROPERTIES_FIELD));

    private final String clientToken;

    private final String farmId;

    private final String fleetId;

    private final HostPropertiesRequest hostProperties;

    private CreateWorkerRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.fleetId = builder.fleetId;
        this.hostProperties = builder.hostProperties;
    }

    /**
     * <p>
     * The unique token which the server uses to recognize retries of the same request.
     * </p>
     * 
     * @return The unique token which the server uses to recognize retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The farm ID of the farm to connect to the worker.
     * </p>
     * 
     * @return The farm ID of the farm to connect to the worker.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The fleet ID to connect to the worker.
     * </p>
     * 
     * @return The fleet ID to connect to the worker.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The IP address and host name of the worker.
     * </p>
     * 
     * @return The IP address and host name of the worker.
     */
    public final HostPropertiesRequest hostProperties() {
        return hostProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(hostProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkerRequest)) {
            return false;
        }
        CreateWorkerRequest other = (CreateWorkerRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(fleetId(), other.fleetId()) && Objects.equals(hostProperties(), other.hostProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkerRequest").add("ClientToken", clientToken()).add("FarmId", farmId())
                .add("FleetId", fleetId()).add("HostProperties", hostProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "fleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "hostProperties":
            return Optional.ofNullable(clazz.cast(hostProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkerRequest, T> g) {
        return obj -> g.apply((CreateWorkerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkerRequest> {
        /**
         * <p>
         * The unique token which the server uses to recognize retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        The unique token which the server uses to recognize retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The farm ID of the farm to connect to the worker.
         * </p>
         * 
         * @param farmId
         *        The farm ID of the farm to connect to the worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The fleet ID to connect to the worker.
         * </p>
         * 
         * @param fleetId
         *        The fleet ID to connect to the worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The IP address and host name of the worker.
         * </p>
         * 
         * @param hostProperties
         *        The IP address and host name of the worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostProperties(HostPropertiesRequest hostProperties);

        /**
         * <p>
         * The IP address and host name of the worker.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostPropertiesRequest.Builder} avoiding
         * the need to create one manually via {@link HostPropertiesRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostPropertiesRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #hostProperties(HostPropertiesRequest)}.
         * 
         * @param hostProperties
         *        a consumer that will call methods on {@link HostPropertiesRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostProperties(HostPropertiesRequest)
         */
        default Builder hostProperties(Consumer<HostPropertiesRequest.Builder> hostProperties) {
            return hostProperties(HostPropertiesRequest.builder().applyMutation(hostProperties).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String farmId;

        private String fleetId;

        private HostPropertiesRequest hostProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkerRequest model) {
            super(model);
            clientToken(model.clientToken);
            farmId(model.farmId);
            fleetId(model.fleetId);
            hostProperties(model.hostProperties);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final HostPropertiesRequest.Builder getHostProperties() {
            return hostProperties != null ? hostProperties.toBuilder() : null;
        }

        public final void setHostProperties(HostPropertiesRequest.BuilderImpl hostProperties) {
            this.hostProperties = hostProperties != null ? hostProperties.build() : null;
        }

        @Override
        public final Builder hostProperties(HostPropertiesRequest hostProperties) {
            this.hostProperties = hostProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkerRequest build() {
            return new CreateWorkerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
