/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateMemberFromJobRequest extends DeadlineRequest implements
        ToCopyableBuilder<DisassociateMemberFromJobRequest.Builder, DisassociateMemberFromJobRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(DisassociateMemberFromJobRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(DisassociateMemberFromJobRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalId").getter(getter(DisassociateMemberFromJobRequest::principalId))
            .setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("principalId").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(DisassociateMemberFromJobRequest::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, JOB_ID_FIELD,
            PRINCIPAL_ID_FIELD, QUEUE_ID_FIELD));

    private final String farmId;

    private final String jobId;

    private final String principalId;

    private final String queueId;

    private DisassociateMemberFromJobRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.jobId = builder.jobId;
        this.principalId = builder.principalId;
        this.queueId = builder.queueId;
    }

    /**
     * <p>
     * The farm ID for the job to disassociate from the member.
     * </p>
     * 
     * @return The farm ID for the job to disassociate from the member.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The job ID to disassociate from a member in a job.
     * </p>
     * 
     * @return The job ID to disassociate from a member in a job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * A member's principal ID to disassociate from a job.
     * </p>
     * 
     * @return A member's principal ID to disassociate from a job.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The queue ID connected to a job for which you're disassociating a member.
     * </p>
     * 
     * @return The queue ID connected to a job for which you're disassociating a member.
     */
    public final String queueId() {
        return queueId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateMemberFromJobRequest)) {
            return false;
        }
        DisassociateMemberFromJobRequest other = (DisassociateMemberFromJobRequest) obj;
        return Objects.equals(farmId(), other.farmId()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(principalId(), other.principalId()) && Objects.equals(queueId(), other.queueId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateMemberFromJobRequest").add("FarmId", farmId()).add("JobId", jobId())
                .add("PrincipalId", principalId()).add("QueueId", queueId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateMemberFromJobRequest, T> g) {
        return obj -> g.apply((DisassociateMemberFromJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateMemberFromJobRequest> {
        /**
         * <p>
         * The farm ID for the job to disassociate from the member.
         * </p>
         * 
         * @param farmId
         *        The farm ID for the job to disassociate from the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The job ID to disassociate from a member in a job.
         * </p>
         * 
         * @param jobId
         *        The job ID to disassociate from a member in a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * A member's principal ID to disassociate from a job.
         * </p>
         * 
         * @param principalId
         *        A member's principal ID to disassociate from a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The queue ID connected to a job for which you're disassociating a member.
         * </p>
         * 
         * @param queueId
         *        The queue ID connected to a job for which you're disassociating a member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String farmId;

        private String jobId;

        private String principalId;

        private String queueId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateMemberFromJobRequest model) {
            super(model);
            farmId(model.farmId);
            jobId(model.jobId);
            principalId(model.principalId);
            queueId(model.queueId);
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateMemberFromJobRequest build() {
            return new DisassociateMemberFromJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
