/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobResponse extends DeadlineResponse implements ToCopyableBuilder<GetJobResponse.Builder, GetJobResponse> {
    private static final SdkField<Attachments> ATTACHMENTS_FIELD = SdkField.<Attachments> builder(MarshallingType.SDK_POJO)
            .memberName("attachments").getter(getter(GetJobResponse::attachments)).setter(setter(Builder::attachments))
            .constructor(Attachments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetJobResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetJobResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetJobResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(GetJobResponse::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(GetJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStatus").getter(getter(GetJobResponse::lifecycleStatusAsString))
            .setter(setter(Builder::lifecycleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()).build();

    private static final SdkField<String> LIFECYCLE_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStatusMessage").getter(getter(GetJobResponse::lifecycleStatusMessage))
            .setter(setter(Builder::lifecycleStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatusMessage").build())
            .build();

    private static final SdkField<Integer> MAX_FAILED_TASKS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxFailedTasksCount").getter(getter(GetJobResponse::maxFailedTasksCount))
            .setter(setter(Builder::maxFailedTasksCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFailedTasksCount").build())
            .build();

    private static final SdkField<Integer> MAX_RETRIES_PER_TASK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxRetriesPerTask").getter(getter(GetJobResponse::maxRetriesPerTask))
            .setter(setter(Builder::maxRetriesPerTask))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRetriesPerTask").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetJobResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, JobParameter>> PARAMETERS_FIELD = SdkField
            .<Map<String, JobParameter>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(GetJobResponse::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<JobParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(GetJobResponse::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(GetJobResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STORAGE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageProfileId").getter(getter(GetJobResponse::storageProfileId))
            .setter(setter(Builder::storageProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageProfileId").build()).build();

    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetTaskRunStatus").getter(getter(GetJobResponse::targetTaskRunStatusAsString))
            .setter(setter(Builder::targetTaskRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build())
            .build();

    private static final SdkField<String> TASK_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskRunStatus").getter(getter(GetJobResponse::taskRunStatusAsString))
            .setter(setter(Builder::taskRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatus").build()).build();

    private static final SdkField<Map<String, Integer>> TASK_RUN_STATUS_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("taskRunStatusCounts")
            .getter(getter(GetJobResponse::taskRunStatusCountsAsStrings))
            .setter(setter(Builder::taskRunStatusCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatusCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetJobResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(GetJobResponse::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENTS_FIELD,
            CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, ENDED_AT_FIELD, JOB_ID_FIELD, LIFECYCLE_STATUS_FIELD,
            LIFECYCLE_STATUS_MESSAGE_FIELD, MAX_FAILED_TASKS_COUNT_FIELD, MAX_RETRIES_PER_TASK_FIELD, NAME_FIELD,
            PARAMETERS_FIELD, PRIORITY_FIELD, STARTED_AT_FIELD, STORAGE_PROFILE_ID_FIELD, TARGET_TASK_RUN_STATUS_FIELD,
            TASK_RUN_STATUS_FIELD, TASK_RUN_STATUS_COUNTS_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));

    private final Attachments attachments;

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final Instant endedAt;

    private final String jobId;

    private final String lifecycleStatus;

    private final String lifecycleStatusMessage;

    private final Integer maxFailedTasksCount;

    private final Integer maxRetriesPerTask;

    private final String name;

    private final Map<String, JobParameter> parameters;

    private final Integer priority;

    private final Instant startedAt;

    private final String storageProfileId;

    private final String targetTaskRunStatus;

    private final String taskRunStatus;

    private final Map<String, Integer> taskRunStatusCounts;

    private final Instant updatedAt;

    private final String updatedBy;

    private GetJobResponse(BuilderImpl builder) {
        super(builder);
        this.attachments = builder.attachments;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.endedAt = builder.endedAt;
        this.jobId = builder.jobId;
        this.lifecycleStatus = builder.lifecycleStatus;
        this.lifecycleStatusMessage = builder.lifecycleStatusMessage;
        this.maxFailedTasksCount = builder.maxFailedTasksCount;
        this.maxRetriesPerTask = builder.maxRetriesPerTask;
        this.name = builder.name;
        this.parameters = builder.parameters;
        this.priority = builder.priority;
        this.startedAt = builder.startedAt;
        this.storageProfileId = builder.storageProfileId;
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
        this.taskRunStatus = builder.taskRunStatus;
        this.taskRunStatusCounts = builder.taskRunStatusCounts;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The attachments for the job.
     * </p>
     * 
     * @return The attachments for the job.
     */
    public final Attachments attachments() {
        return attachments;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or system that created this resource.
     * </p>
     * 
     * @return The user or system that created this resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of the job.
     * </p>
     * 
     * @return The description of the job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time the resource ended running.
     * </p>
     * 
     * @return The date and time the resource ended running.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The job ID.
     * </p>
     * 
     * @return The job ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The life cycle status for the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link JobLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status for the job.
     * @see JobLifecycleStatus
     */
    public final JobLifecycleStatus lifecycleStatus() {
        return JobLifecycleStatus.fromValue(lifecycleStatus);
    }

    /**
     * <p>
     * The life cycle status for the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link JobLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status for the job.
     * @see JobLifecycleStatus
     */
    public final String lifecycleStatusAsString() {
        return lifecycleStatus;
    }

    /**
     * <p>
     * A message that communicates the status of the life cycle for the job.
     * </p>
     * 
     * @return A message that communicates the status of the life cycle for the job.
     */
    public final String lifecycleStatusMessage() {
        return lifecycleStatusMessage;
    }

    /**
     * <p>
     * The number of task failures before the job stops running and is marked as <code>FAILED</code>.
     * </p>
     * 
     * @return The number of task failures before the job stops running and is marked as <code>FAILED</code>.
     */
    public final Integer maxFailedTasksCount() {
        return maxFailedTasksCount;
    }

    /**
     * <p>
     * The maximum number of retries per failed tasks.
     * </p>
     * 
     * @return The maximum number of retries per failed tasks.
     */
    public final Integer maxRetriesPerTask() {
        return maxRetriesPerTask;
    }

    /**
     * <p>
     * The name of the job.
     * </p>
     * 
     * @return The name of the job.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters for the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters for the job.
     */
    public final Map<String, JobParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The job priority.
     * </p>
     * 
     * @return The job priority.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The date and time the resource started running.
     * </p>
     * 
     * @return The date and time the resource started running.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The storage profile ID associated with the job.
     * </p>
     * 
     * @return The storage profile ID associated with the job.
     */
    public final String storageProfileId() {
        return storageProfileId;
    }

    /**
     * <p>
     * The task status with which the job started.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link JobTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The task status with which the job started.
     * @see JobTargetTaskRunStatus
     */
    public final JobTargetTaskRunStatus targetTaskRunStatus() {
        return JobTargetTaskRunStatus.fromValue(targetTaskRunStatus);
    }

    /**
     * <p>
     * The task status with which the job started.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link JobTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The task status with which the job started.
     * @see JobTargetTaskRunStatus
     */
    public final String targetTaskRunStatusAsString() {
        return targetTaskRunStatus;
    }

    /**
     * <p>
     * The task run status for the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskRunStatus}
     * will return {@link TaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskRunStatusAsString}.
     * </p>
     * 
     * @return The task run status for the job.
     * @see TaskRunStatus
     */
    public final TaskRunStatus taskRunStatus() {
        return TaskRunStatus.fromValue(taskRunStatus);
    }

    /**
     * <p>
     * The task run status for the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskRunStatus}
     * will return {@link TaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskRunStatusAsString}.
     * </p>
     * 
     * @return The task run status for the job.
     * @see TaskRunStatus
     */
    public final String taskRunStatusAsString() {
        return taskRunStatus;
    }

    /**
     * <p>
     * The number of tasks running on the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskRunStatusCounts} method.
     * </p>
     * 
     * @return The number of tasks running on the job.
     */
    public final Map<TaskRunStatus, Integer> taskRunStatusCounts() {
        return TaskRunStatusCountsCopier.copyStringToEnum(taskRunStatusCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskRunStatusCounts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskRunStatusCounts() {
        return taskRunStatusCounts != null && !(taskRunStatusCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The number of tasks running on the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskRunStatusCounts} method.
     * </p>
     * 
     * @return The number of tasks running on the job.
     */
    public final Map<String, Integer> taskRunStatusCountsAsStrings() {
        return taskRunStatusCounts;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachments());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(maxFailedTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetriesPerTask());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(storageProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(targetTaskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(taskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskRunStatusCounts() ? taskRunStatusCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobResponse)) {
            return false;
        }
        GetJobResponse other = (GetJobResponse) obj;
        return Objects.equals(attachments(), other.attachments()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(description(), other.description())
                && Objects.equals(endedAt(), other.endedAt()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(lifecycleStatusAsString(), other.lifecycleStatusAsString())
                && Objects.equals(lifecycleStatusMessage(), other.lifecycleStatusMessage())
                && Objects.equals(maxFailedTasksCount(), other.maxFailedTasksCount())
                && Objects.equals(maxRetriesPerTask(), other.maxRetriesPerTask()) && Objects.equals(name(), other.name())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(priority(), other.priority()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(storageProfileId(), other.storageProfileId())
                && Objects.equals(targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString())
                && Objects.equals(taskRunStatusAsString(), other.taskRunStatusAsString())
                && hasTaskRunStatusCounts() == other.hasTaskRunStatusCounts()
                && Objects.equals(taskRunStatusCountsAsStrings(), other.taskRunStatusCountsAsStrings())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJobResponse").add("Attachments", attachments()).add("CreatedAt", createdAt())
                .add("CreatedBy", createdBy())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("EndedAt", endedAt())
                .add("JobId", jobId()).add("LifecycleStatus", lifecycleStatusAsString())
                .add("LifecycleStatusMessage", lifecycleStatusMessage()).add("MaxFailedTasksCount", maxFailedTasksCount())
                .add("MaxRetriesPerTask", maxRetriesPerTask()).add("Name", name())
                .add("Parameters", parameters() == null ? null : "*** Sensitive Data Redacted ***").add("Priority", priority())
                .add("StartedAt", startedAt()).add("StorageProfileId", storageProfileId())
                .add("TargetTaskRunStatus", targetTaskRunStatusAsString()).add("TaskRunStatus", taskRunStatusAsString())
                .add("TaskRunStatusCounts", hasTaskRunStatusCounts() ? taskRunStatusCountsAsStrings() : null)
                .add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "lifecycleStatus":
            return Optional.ofNullable(clazz.cast(lifecycleStatusAsString()));
        case "lifecycleStatusMessage":
            return Optional.ofNullable(clazz.cast(lifecycleStatusMessage()));
        case "maxFailedTasksCount":
            return Optional.ofNullable(clazz.cast(maxFailedTasksCount()));
        case "maxRetriesPerTask":
            return Optional.ofNullable(clazz.cast(maxRetriesPerTask()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "storageProfileId":
            return Optional.ofNullable(clazz.cast(storageProfileId()));
        case "targetTaskRunStatus":
            return Optional.ofNullable(clazz.cast(targetTaskRunStatusAsString()));
        case "taskRunStatus":
            return Optional.ofNullable(clazz.cast(taskRunStatusAsString()));
        case "taskRunStatusCounts":
            return Optional.ofNullable(clazz.cast(taskRunStatusCountsAsStrings()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobResponse, T> g) {
        return obj -> g.apply((GetJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetJobResponse> {
        /**
         * <p>
         * The attachments for the job.
         * </p>
         * 
         * @param attachments
         *        The attachments for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Attachments attachments);

        /**
         * <p>
         * The attachments for the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link Attachments.Builder} avoiding the need to
         * create one manually via {@link Attachments#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Attachments.Builder#build()} is called immediately and its result
         * is passed to {@link #attachments(Attachments)}.
         * 
         * @param attachments
         *        a consumer that will call methods on {@link Attachments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(Attachments)
         */
        default Builder attachments(Consumer<Attachments.Builder> attachments) {
            return attachments(Attachments.builder().applyMutation(attachments).build());
        }

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or system that created this resource.
         * </p>
         * 
         * @param createdBy
         *        The user or system that created this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of the job.
         * </p>
         * 
         * @param description
         *        The description of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time the resource ended running.
         * </p>
         * 
         * @param endedAt
         *        The date and time the resource ended running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The job ID.
         * </p>
         * 
         * @param jobId
         *        The job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The life cycle status for the job.
         * </p>
         * 
         * @param lifecycleStatus
         *        The life cycle status for the job.
         * @see JobLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobLifecycleStatus
         */
        Builder lifecycleStatus(String lifecycleStatus);

        /**
         * <p>
         * The life cycle status for the job.
         * </p>
         * 
         * @param lifecycleStatus
         *        The life cycle status for the job.
         * @see JobLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobLifecycleStatus
         */
        Builder lifecycleStatus(JobLifecycleStatus lifecycleStatus);

        /**
         * <p>
         * A message that communicates the status of the life cycle for the job.
         * </p>
         * 
         * @param lifecycleStatusMessage
         *        A message that communicates the status of the life cycle for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleStatusMessage(String lifecycleStatusMessage);

        /**
         * <p>
         * The number of task failures before the job stops running and is marked as <code>FAILED</code>.
         * </p>
         * 
         * @param maxFailedTasksCount
         *        The number of task failures before the job stops running and is marked as <code>FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFailedTasksCount(Integer maxFailedTasksCount);

        /**
         * <p>
         * The maximum number of retries per failed tasks.
         * </p>
         * 
         * @param maxRetriesPerTask
         *        The maximum number of retries per failed tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetriesPerTask(Integer maxRetriesPerTask);

        /**
         * <p>
         * The name of the job.
         * </p>
         * 
         * @param name
         *        The name of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The parameters for the job.
         * </p>
         * 
         * @param parameters
         *        The parameters for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, JobParameter> parameters);

        /**
         * <p>
         * The job priority.
         * </p>
         * 
         * @param priority
         *        The job priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The date and time the resource started running.
         * </p>
         * 
         * @param startedAt
         *        The date and time the resource started running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The storage profile ID associated with the job.
         * </p>
         * 
         * @param storageProfileId
         *        The storage profile ID associated with the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageProfileId(String storageProfileId);

        /**
         * <p>
         * The task status with which the job started.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The task status with which the job started.
         * @see JobTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(String targetTaskRunStatus);

        /**
         * <p>
         * The task status with which the job started.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The task status with which the job started.
         * @see JobTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(JobTargetTaskRunStatus targetTaskRunStatus);

        /**
         * <p>
         * The task run status for the job.
         * </p>
         * 
         * @param taskRunStatus
         *        The task run status for the job.
         * @see TaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskRunStatus
         */
        Builder taskRunStatus(String taskRunStatus);

        /**
         * <p>
         * The task run status for the job.
         * </p>
         * 
         * @param taskRunStatus
         *        The task run status for the job.
         * @see TaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskRunStatus
         */
        Builder taskRunStatus(TaskRunStatus taskRunStatus);

        /**
         * <p>
         * The number of tasks running on the job.
         * </p>
         * 
         * @param taskRunStatusCounts
         *        The number of tasks running on the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRunStatusCountsWithStrings(Map<String, Integer> taskRunStatusCounts);

        /**
         * <p>
         * The number of tasks running on the job.
         * </p>
         * 
         * @param taskRunStatusCounts
         *        The number of tasks running on the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> taskRunStatusCounts);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private Attachments attachments;

        private Instant createdAt;

        private String createdBy;

        private String description;

        private Instant endedAt;

        private String jobId;

        private String lifecycleStatus;

        private String lifecycleStatusMessage;

        private Integer maxFailedTasksCount;

        private Integer maxRetriesPerTask;

        private String name;

        private Map<String, JobParameter> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Integer priority;

        private Instant startedAt;

        private String storageProfileId;

        private String targetTaskRunStatus;

        private String taskRunStatus;

        private Map<String, Integer> taskRunStatusCounts = DefaultSdkAutoConstructMap.getInstance();

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobResponse model) {
            super(model);
            attachments(model.attachments);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            endedAt(model.endedAt);
            jobId(model.jobId);
            lifecycleStatus(model.lifecycleStatus);
            lifecycleStatusMessage(model.lifecycleStatusMessage);
            maxFailedTasksCount(model.maxFailedTasksCount);
            maxRetriesPerTask(model.maxRetriesPerTask);
            name(model.name);
            parameters(model.parameters);
            priority(model.priority);
            startedAt(model.startedAt);
            storageProfileId(model.storageProfileId);
            targetTaskRunStatus(model.targetTaskRunStatus);
            taskRunStatus(model.taskRunStatus);
            taskRunStatusCountsWithStrings(model.taskRunStatusCounts);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final Attachments.Builder getAttachments() {
            return attachments != null ? attachments.toBuilder() : null;
        }

        public final void setAttachments(Attachments.BuilderImpl attachments) {
            this.attachments = attachments != null ? attachments.build() : null;
        }

        @Override
        public final Builder attachments(Attachments attachments) {
            this.attachments = attachments;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getLifecycleStatus() {
            return lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(JobLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        public final String getLifecycleStatusMessage() {
            return lifecycleStatusMessage;
        }

        public final void setLifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
        }

        @Override
        public final Builder lifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
            return this;
        }

        public final Integer getMaxFailedTasksCount() {
            return maxFailedTasksCount;
        }

        public final void setMaxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
        }

        @Override
        public final Builder maxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
            return this;
        }

        public final Integer getMaxRetriesPerTask() {
            return maxRetriesPerTask;
        }

        public final void setMaxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
        }

        @Override
        public final Builder maxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, JobParameter.Builder> getParameters() {
            Map<String, JobParameter.Builder> result = JobParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, JobParameter.BuilderImpl> parameters) {
            this.parameters = JobParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, JobParameter> parameters) {
            this.parameters = JobParametersCopier.copy(parameters);
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStorageProfileId() {
            return storageProfileId;
        }

        public final void setStorageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
        }

        @Override
        public final Builder storageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
            return this;
        }

        public final String getTargetTaskRunStatus() {
            return targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(JobTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        public final String getTaskRunStatus() {
            return taskRunStatus;
        }

        public final void setTaskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
        }

        @Override
        public final Builder taskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
            return this;
        }

        @Override
        public final Builder taskRunStatus(TaskRunStatus taskRunStatus) {
            this.taskRunStatus(taskRunStatus == null ? null : taskRunStatus.toString());
            return this;
        }

        public final Map<String, Integer> getTaskRunStatusCounts() {
            if (taskRunStatusCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return taskRunStatusCounts;
        }

        public final void setTaskRunStatusCounts(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
        }

        @Override
        public final Builder taskRunStatusCountsWithStrings(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
            return this;
        }

        @Override
        public final Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copyEnumToString(taskRunStatusCounts);
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public GetJobResponse build() {
            return new GetJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
