/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSessionActionResponse extends DeadlineResponse implements
        ToCopyableBuilder<GetSessionActionResponse.Builder, GetSessionActionResponse> {
    private static final SdkField<SessionActionDefinition> DEFINITION_FIELD = SdkField
            .<SessionActionDefinition> builder(MarshallingType.SDK_POJO).memberName("definition")
            .getter(getter(GetSessionActionResponse::definition)).setter(setter(Builder::definition))
            .constructor(SessionActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(GetSessionActionResponse::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> PROCESS_EXIT_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("processExitCode").getter(getter(GetSessionActionResponse::processExitCode))
            .setter(setter(Builder::processExitCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processExitCode").build()).build();

    private static final SdkField<String> PROGRESS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("progressMessage").getter(getter(GetSessionActionResponse::progressMessage))
            .setter(setter(Builder::progressMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressMessage").build()).build();

    private static final SdkField<Float> PROGRESS_PERCENT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("progressPercent").getter(getter(GetSessionActionResponse::progressPercent))
            .setter(setter(Builder::progressPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressPercent").build()).build();

    private static final SdkField<String> SESSION_ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionActionId").getter(getter(GetSessionActionResponse::sessionActionId))
            .setter(setter(Builder::sessionActionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionActionId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(GetSessionActionResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(GetSessionActionResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetSessionActionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> WORKER_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("workerUpdatedAt")
            .getter(getter(GetSessionActionResponse::workerUpdatedAt))
            .setter(setter(Builder::workerUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD,
            ENDED_AT_FIELD, PROCESS_EXIT_CODE_FIELD, PROGRESS_MESSAGE_FIELD, PROGRESS_PERCENT_FIELD, SESSION_ACTION_ID_FIELD,
            SESSION_ID_FIELD, STARTED_AT_FIELD, STATUS_FIELD, WORKER_UPDATED_AT_FIELD));

    private final SessionActionDefinition definition;

    private final Instant endedAt;

    private final Integer processExitCode;

    private final String progressMessage;

    private final Float progressPercent;

    private final String sessionActionId;

    private final String sessionId;

    private final Instant startedAt;

    private final String status;

    private final Instant workerUpdatedAt;

    private GetSessionActionResponse(BuilderImpl builder) {
        super(builder);
        this.definition = builder.definition;
        this.endedAt = builder.endedAt;
        this.processExitCode = builder.processExitCode;
        this.progressMessage = builder.progressMessage;
        this.progressPercent = builder.progressPercent;
        this.sessionActionId = builder.sessionActionId;
        this.sessionId = builder.sessionId;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.workerUpdatedAt = builder.workerUpdatedAt;
    }

    /**
     * <p>
     * The session action definition.
     * </p>
     * 
     * @return The session action definition.
     */
    public final SessionActionDefinition definition() {
        return definition;
    }

    /**
     * <p>
     * The date and time the resource ended running.
     * </p>
     * 
     * @return The date and time the resource ended running.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The exit code to exit the session.
     * </p>
     * 
     * @return The exit code to exit the session.
     */
    public final Integer processExitCode() {
        return processExitCode;
    }

    /**
     * <p>
     * The message that communicates the progress of the session action.
     * </p>
     * 
     * @return The message that communicates the progress of the session action.
     */
    public final String progressMessage() {
        return progressMessage;
    }

    /**
     * <p>
     * The percentage completed for a session action.
     * </p>
     * 
     * @return The percentage completed for a session action.
     */
    public final Float progressPercent() {
        return progressPercent;
    }

    /**
     * <p>
     * The session action ID.
     * </p>
     * 
     * @return The session action ID.
     */
    public final String sessionActionId() {
        return sessionActionId;
    }

    /**
     * <p>
     * The session ID for the session action.
     * </p>
     * 
     * @return The session ID for the session action.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The date and time the resource started running.
     * </p>
     * 
     * @return The date and time the resource started running.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The status of the session action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the session action.
     * @see SessionActionStatus
     */
    public final SessionActionStatus status() {
        return SessionActionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the session action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the session action.
     * @see SessionActionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Linux timestamp of the date and time the session action was last updated.
     * </p>
     * 
     * @return The Linux timestamp of the date and time the session action was last updated.
     */
    public final Instant workerUpdatedAt() {
        return workerUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(processExitCode());
        hashCode = 31 * hashCode + Objects.hashCode(progressMessage());
        hashCode = 31 * hashCode + Objects.hashCode(progressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(sessionActionId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workerUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionActionResponse)) {
            return false;
        }
        GetSessionActionResponse other = (GetSessionActionResponse) obj;
        return Objects.equals(definition(), other.definition()) && Objects.equals(endedAt(), other.endedAt())
                && Objects.equals(processExitCode(), other.processExitCode())
                && Objects.equals(progressMessage(), other.progressMessage())
                && Objects.equals(progressPercent(), other.progressPercent())
                && Objects.equals(sessionActionId(), other.sessionActionId()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(workerUpdatedAt(), other.workerUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSessionActionResponse").add("Definition", definition()).add("EndedAt", endedAt())
                .add("ProcessExitCode", processExitCode())
                .add("ProgressMessage", progressMessage() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProgressPercent", progressPercent()).add("SessionActionId", sessionActionId())
                .add("SessionId", sessionId()).add("StartedAt", startedAt()).add("Status", statusAsString())
                .add("WorkerUpdatedAt", workerUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "processExitCode":
            return Optional.ofNullable(clazz.cast(processExitCode()));
        case "progressMessage":
            return Optional.ofNullable(clazz.cast(progressMessage()));
        case "progressPercent":
            return Optional.ofNullable(clazz.cast(progressPercent()));
        case "sessionActionId":
            return Optional.ofNullable(clazz.cast(sessionActionId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "workerUpdatedAt":
            return Optional.ofNullable(clazz.cast(workerUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSessionActionResponse, T> g) {
        return obj -> g.apply((GetSessionActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSessionActionResponse> {
        /**
         * <p>
         * The session action definition.
         * </p>
         * 
         * @param definition
         *        The session action definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(SessionActionDefinition definition);

        /**
         * <p>
         * The session action definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionActionDefinition.Builder} avoiding
         * the need to create one manually via {@link SessionActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionActionDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #definition(SessionActionDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link SessionActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(SessionActionDefinition)
         */
        default Builder definition(Consumer<SessionActionDefinition.Builder> definition) {
            return definition(SessionActionDefinition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The date and time the resource ended running.
         * </p>
         * 
         * @param endedAt
         *        The date and time the resource ended running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The exit code to exit the session.
         * </p>
         * 
         * @param processExitCode
         *        The exit code to exit the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processExitCode(Integer processExitCode);

        /**
         * <p>
         * The message that communicates the progress of the session action.
         * </p>
         * 
         * @param progressMessage
         *        The message that communicates the progress of the session action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressMessage(String progressMessage);

        /**
         * <p>
         * The percentage completed for a session action.
         * </p>
         * 
         * @param progressPercent
         *        The percentage completed for a session action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercent(Float progressPercent);

        /**
         * <p>
         * The session action ID.
         * </p>
         * 
         * @param sessionActionId
         *        The session action ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionActionId(String sessionActionId);

        /**
         * <p>
         * The session ID for the session action.
         * </p>
         * 
         * @param sessionId
         *        The session ID for the session action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The date and time the resource started running.
         * </p>
         * 
         * @param startedAt
         *        The date and time the resource started running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The status of the session action.
         * </p>
         * 
         * @param status
         *        The status of the session action.
         * @see SessionActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionActionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the session action.
         * </p>
         * 
         * @param status
         *        The status of the session action.
         * @see SessionActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionActionStatus
         */
        Builder status(SessionActionStatus status);

        /**
         * <p>
         * The Linux timestamp of the date and time the session action was last updated.
         * </p>
         * 
         * @param workerUpdatedAt
         *        The Linux timestamp of the date and time the session action was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerUpdatedAt(Instant workerUpdatedAt);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private SessionActionDefinition definition;

        private Instant endedAt;

        private Integer processExitCode;

        private String progressMessage;

        private Float progressPercent;

        private String sessionActionId;

        private String sessionId;

        private Instant startedAt;

        private String status;

        private Instant workerUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionActionResponse model) {
            super(model);
            definition(model.definition);
            endedAt(model.endedAt);
            processExitCode(model.processExitCode);
            progressMessage(model.progressMessage);
            progressPercent(model.progressPercent);
            sessionActionId(model.sessionActionId);
            sessionId(model.sessionId);
            startedAt(model.startedAt);
            status(model.status);
            workerUpdatedAt(model.workerUpdatedAt);
        }

        public final SessionActionDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(SessionActionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(SessionActionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Integer getProcessExitCode() {
            return processExitCode;
        }

        public final void setProcessExitCode(Integer processExitCode) {
            this.processExitCode = processExitCode;
        }

        @Override
        public final Builder processExitCode(Integer processExitCode) {
            this.processExitCode = processExitCode;
            return this;
        }

        public final String getProgressMessage() {
            return progressMessage;
        }

        public final void setProgressMessage(String progressMessage) {
            this.progressMessage = progressMessage;
        }

        @Override
        public final Builder progressMessage(String progressMessage) {
            this.progressMessage = progressMessage;
            return this;
        }

        public final Float getProgressPercent() {
            return progressPercent;
        }

        public final void setProgressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        public final Builder progressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final String getSessionActionId() {
            return sessionActionId;
        }

        public final void setSessionActionId(String sessionActionId) {
            this.sessionActionId = sessionActionId;
        }

        @Override
        public final Builder sessionActionId(String sessionActionId) {
            this.sessionActionId = sessionActionId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getWorkerUpdatedAt() {
            return workerUpdatedAt;
        }

        public final void setWorkerUpdatedAt(Instant workerUpdatedAt) {
            this.workerUpdatedAt = workerUpdatedAt;
        }

        @Override
        public final Builder workerUpdatedAt(Instant workerUpdatedAt) {
            this.workerUpdatedAt = workerUpdatedAt;
            return this;
        }

        @Override
        public GetSessionActionResponse build() {
            return new GetSessionActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
