/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStorageProfileForQueueResponse extends DeadlineResponse implements
        ToCopyableBuilder<GetStorageProfileForQueueResponse.Builder, GetStorageProfileForQueueResponse> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetStorageProfileForQueueResponse::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<List<FileSystemLocation>> FILE_SYSTEM_LOCATIONS_FIELD = SdkField
            .<List<FileSystemLocation>> builder(MarshallingType.LIST)
            .memberName("fileSystemLocations")
            .getter(getter(GetStorageProfileForQueueResponse::fileSystemLocations))
            .setter(setter(Builder::fileSystemLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileSystemLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileSystemLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OS_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("osFamily").getter(getter(GetStorageProfileForQueueResponse::osFamilyAsString))
            .setter(setter(Builder::osFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osFamily").build()).build();

    private static final SdkField<String> STORAGE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageProfileId").getter(getter(GetStorageProfileForQueueResponse::storageProfileId))
            .setter(setter(Builder::storageProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageProfileId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            FILE_SYSTEM_LOCATIONS_FIELD, OS_FAMILY_FIELD, STORAGE_PROFILE_ID_FIELD));

    private final String displayName;

    private final List<FileSystemLocation> fileSystemLocations;

    private final String osFamily;

    private final String storageProfileId;

    private GetStorageProfileForQueueResponse(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.fileSystemLocations = builder.fileSystemLocations;
        this.osFamily = builder.osFamily;
        this.storageProfileId = builder.storageProfileId;
    }

    /**
     * <p>
     * The display name of the storage profile connected to a queue.
     * </p>
     * 
     * @return The display name of the storage profile connected to a queue.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileSystemLocations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileSystemLocations() {
        return fileSystemLocations != null && !(fileSystemLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The location of the files for the storage profile within the queue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileSystemLocations} method.
     * </p>
     * 
     * @return The location of the files for the storage profile within the queue.
     */
    public final List<FileSystemLocation> fileSystemLocations() {
        return fileSystemLocations;
    }

    /**
     * <p>
     * The operating system of the storage profile in the queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osFamily} will
     * return {@link StorageProfileOperatingSystemFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #osFamilyAsString}.
     * </p>
     * 
     * @return The operating system of the storage profile in the queue.
     * @see StorageProfileOperatingSystemFamily
     */
    public final StorageProfileOperatingSystemFamily osFamily() {
        return StorageProfileOperatingSystemFamily.fromValue(osFamily);
    }

    /**
     * <p>
     * The operating system of the storage profile in the queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osFamily} will
     * return {@link StorageProfileOperatingSystemFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #osFamilyAsString}.
     * </p>
     * 
     * @return The operating system of the storage profile in the queue.
     * @see StorageProfileOperatingSystemFamily
     */
    public final String osFamilyAsString() {
        return osFamily;
    }

    /**
     * <p>
     * The storage profile ID.
     * </p>
     * 
     * @return The storage profile ID.
     */
    public final String storageProfileId() {
        return storageProfileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFileSystemLocations() ? fileSystemLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(osFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storageProfileId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStorageProfileForQueueResponse)) {
            return false;
        }
        GetStorageProfileForQueueResponse other = (GetStorageProfileForQueueResponse) obj;
        return Objects.equals(displayName(), other.displayName()) && hasFileSystemLocations() == other.hasFileSystemLocations()
                && Objects.equals(fileSystemLocations(), other.fileSystemLocations())
                && Objects.equals(osFamilyAsString(), other.osFamilyAsString())
                && Objects.equals(storageProfileId(), other.storageProfileId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStorageProfileForQueueResponse").add("DisplayName", displayName())
                .add("FileSystemLocations", fileSystemLocations() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OsFamily", osFamilyAsString()).add("StorageProfileId", storageProfileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "fileSystemLocations":
            return Optional.ofNullable(clazz.cast(fileSystemLocations()));
        case "osFamily":
            return Optional.ofNullable(clazz.cast(osFamilyAsString()));
        case "storageProfileId":
            return Optional.ofNullable(clazz.cast(storageProfileId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStorageProfileForQueueResponse, T> g) {
        return obj -> g.apply((GetStorageProfileForQueueResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetStorageProfileForQueueResponse> {
        /**
         * <p>
         * The display name of the storage profile connected to a queue.
         * </p>
         * 
         * @param displayName
         *        The display name of the storage profile connected to a queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The location of the files for the storage profile within the queue.
         * </p>
         * 
         * @param fileSystemLocations
         *        The location of the files for the storage profile within the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemLocations(Collection<FileSystemLocation> fileSystemLocations);

        /**
         * <p>
         * The location of the files for the storage profile within the queue.
         * </p>
         * 
         * @param fileSystemLocations
         *        The location of the files for the storage profile within the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemLocations(FileSystemLocation... fileSystemLocations);

        /**
         * <p>
         * The location of the files for the storage profile within the queue.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.FileSystemLocation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.deadline.model.FileSystemLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.FileSystemLocation.Builder#build()} is called
         * immediately and its result is passed to {@link #fileSystemLocations(List<FileSystemLocation>)}.
         * 
         * @param fileSystemLocations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.FileSystemLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemLocations(java.util.Collection<FileSystemLocation>)
         */
        Builder fileSystemLocations(Consumer<FileSystemLocation.Builder>... fileSystemLocations);

        /**
         * <p>
         * The operating system of the storage profile in the queue.
         * </p>
         * 
         * @param osFamily
         *        The operating system of the storage profile in the queue.
         * @see StorageProfileOperatingSystemFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageProfileOperatingSystemFamily
         */
        Builder osFamily(String osFamily);

        /**
         * <p>
         * The operating system of the storage profile in the queue.
         * </p>
         * 
         * @param osFamily
         *        The operating system of the storage profile in the queue.
         * @see StorageProfileOperatingSystemFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageProfileOperatingSystemFamily
         */
        Builder osFamily(StorageProfileOperatingSystemFamily osFamily);

        /**
         * <p>
         * The storage profile ID.
         * </p>
         * 
         * @param storageProfileId
         *        The storage profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageProfileId(String storageProfileId);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private String displayName;

        private List<FileSystemLocation> fileSystemLocations = DefaultSdkAutoConstructList.getInstance();

        private String osFamily;

        private String storageProfileId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStorageProfileForQueueResponse model) {
            super(model);
            displayName(model.displayName);
            fileSystemLocations(model.fileSystemLocations);
            osFamily(model.osFamily);
            storageProfileId(model.storageProfileId);
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final List<FileSystemLocation.Builder> getFileSystemLocations() {
            List<FileSystemLocation.Builder> result = FileSystemLocationsListCopier.copyToBuilder(this.fileSystemLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemLocations(Collection<FileSystemLocation.BuilderImpl> fileSystemLocations) {
            this.fileSystemLocations = FileSystemLocationsListCopier.copyFromBuilder(fileSystemLocations);
        }

        @Override
        public final Builder fileSystemLocations(Collection<FileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = FileSystemLocationsListCopier.copy(fileSystemLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(FileSystemLocation... fileSystemLocations) {
            fileSystemLocations(Arrays.asList(fileSystemLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(Consumer<FileSystemLocation.Builder>... fileSystemLocations) {
            fileSystemLocations(Stream.of(fileSystemLocations).map(c -> FileSystemLocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOsFamily() {
            return osFamily;
        }

        public final void setOsFamily(String osFamily) {
            this.osFamily = osFamily;
        }

        @Override
        public final Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        @Override
        public final Builder osFamily(StorageProfileOperatingSystemFamily osFamily) {
            this.osFamily(osFamily == null ? null : osFamily.toString());
            return this;
        }

        public final String getStorageProfileId() {
            return storageProfileId;
        }

        public final void setStorageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
        }

        @Override
        public final Builder storageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
            return this;
        }

        @Override
        public GetStorageProfileForQueueResponse build() {
            return new GetStorageProfileForQueueResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
