/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The job details for a specific job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobDetailsEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<JobDetailsEntity.Builder, JobDetailsEntity> {
    private static final SdkField<JobAttachmentSettings> JOB_ATTACHMENT_SETTINGS_FIELD = SdkField
            .<JobAttachmentSettings> builder(MarshallingType.SDK_POJO).memberName("jobAttachmentSettings")
            .getter(getter(JobDetailsEntity::jobAttachmentSettings)).setter(setter(Builder::jobAttachmentSettings))
            .constructor(JobAttachmentSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobAttachmentSettings").build())
            .build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(JobDetailsEntity::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<JobRunAsUser> JOB_RUN_AS_USER_FIELD = SdkField.<JobRunAsUser> builder(MarshallingType.SDK_POJO)
            .memberName("jobRunAsUser").getter(getter(JobDetailsEntity::jobRunAsUser)).setter(setter(Builder::jobRunAsUser))
            .constructor(JobRunAsUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRunAsUser").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(JobDetailsEntity::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<Map<String, JobParameter>> PARAMETERS_FIELD = SdkField
            .<Map<String, JobParameter>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(JobDetailsEntity::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<JobParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<PathMappingRule>> PATH_MAPPING_RULES_FIELD = SdkField
            .<List<PathMappingRule>> builder(MarshallingType.LIST)
            .memberName("pathMappingRules")
            .getter(getter(JobDetailsEntity::pathMappingRules))
            .setter(setter(Builder::pathMappingRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathMappingRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PathMappingRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(PathMappingRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> QUEUE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueRoleArn").getter(getter(JobDetailsEntity::queueRoleArn)).setter(setter(Builder::queueRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueRoleArn").build()).build();

    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaVersion").getter(getter(JobDetailsEntity::schemaVersion)).setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ATTACHMENT_SETTINGS_FIELD,
            JOB_ID_FIELD, JOB_RUN_AS_USER_FIELD, LOG_GROUP_NAME_FIELD, PARAMETERS_FIELD, PATH_MAPPING_RULES_FIELD,
            QUEUE_ROLE_ARN_FIELD, SCHEMA_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final JobAttachmentSettings jobAttachmentSettings;

    private final String jobId;

    private final JobRunAsUser jobRunAsUser;

    private final String logGroupName;

    private final Map<String, JobParameter> parameters;

    private final List<PathMappingRule> pathMappingRules;

    private final String queueRoleArn;

    private final String schemaVersion;

    private JobDetailsEntity(BuilderImpl builder) {
        this.jobAttachmentSettings = builder.jobAttachmentSettings;
        this.jobId = builder.jobId;
        this.jobRunAsUser = builder.jobRunAsUser;
        this.logGroupName = builder.logGroupName;
        this.parameters = builder.parameters;
        this.pathMappingRules = builder.pathMappingRules;
        this.queueRoleArn = builder.queueRoleArn;
        this.schemaVersion = builder.schemaVersion;
    }

    /**
     * <p>
     * The job attachment settings.
     * </p>
     * 
     * @return The job attachment settings.
     */
    public final JobAttachmentSettings jobAttachmentSettings() {
        return jobAttachmentSettings;
    }

    /**
     * <p>
     * The job ID.
     * </p>
     * 
     * @return The job ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The user name and group that the job uses when run.
     * </p>
     * 
     * @return The user name and group that the job uses when run.
     */
    public final JobRunAsUser jobRunAsUser() {
        return jobRunAsUser;
    }

    /**
     * <p>
     * The log group name.
     * </p>
     * 
     * @return The log group name.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters.
     */
    public final Map<String, JobParameter> parameters() {
        return parameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the PathMappingRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPathMappingRules() {
        return pathMappingRules != null && !(pathMappingRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The path mapping rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPathMappingRules} method.
     * </p>
     * 
     * @return The path mapping rules.
     */
    public final List<PathMappingRule> pathMappingRules() {
        return pathMappingRules;
    }

    /**
     * <p>
     * The queue role ARN.
     * </p>
     * 
     * @return The queue role ARN.
     */
    public final String queueRoleArn() {
        return queueRoleArn;
    }

    /**
     * <p>
     * The schema version.
     * </p>
     * 
     * @return The schema version.
     */
    public final String schemaVersion() {
        return schemaVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobAttachmentSettings());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobRunAsUser());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPathMappingRules() ? pathMappingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queueRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetailsEntity)) {
            return false;
        }
        JobDetailsEntity other = (JobDetailsEntity) obj;
        return Objects.equals(jobAttachmentSettings(), other.jobAttachmentSettings()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(jobRunAsUser(), other.jobRunAsUser()) && Objects.equals(logGroupName(), other.logGroupName())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && hasPathMappingRules() == other.hasPathMappingRules()
                && Objects.equals(pathMappingRules(), other.pathMappingRules())
                && Objects.equals(queueRoleArn(), other.queueRoleArn()) && Objects.equals(schemaVersion(), other.schemaVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobDetailsEntity").add("JobAttachmentSettings", jobAttachmentSettings()).add("JobId", jobId())
                .add("JobRunAsUser", jobRunAsUser()).add("LogGroupName", logGroupName())
                .add("Parameters", parameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PathMappingRules", pathMappingRules() == null ? null : "*** Sensitive Data Redacted ***")
                .add("QueueRoleArn", queueRoleArn()).add("SchemaVersion", schemaVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobAttachmentSettings":
            return Optional.ofNullable(clazz.cast(jobAttachmentSettings()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobRunAsUser":
            return Optional.ofNullable(clazz.cast(jobRunAsUser()));
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "pathMappingRules":
            return Optional.ofNullable(clazz.cast(pathMappingRules()));
        case "queueRoleArn":
            return Optional.ofNullable(clazz.cast(queueRoleArn()));
        case "schemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobDetailsEntity, T> g) {
        return obj -> g.apply((JobDetailsEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobDetailsEntity> {
        /**
         * <p>
         * The job attachment settings.
         * </p>
         * 
         * @param jobAttachmentSettings
         *        The job attachment settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings);

        /**
         * <p>
         * The job attachment settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobAttachmentSettings.Builder} avoiding
         * the need to create one manually via {@link JobAttachmentSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobAttachmentSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #jobAttachmentSettings(JobAttachmentSettings)}.
         * 
         * @param jobAttachmentSettings
         *        a consumer that will call methods on {@link JobAttachmentSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobAttachmentSettings(JobAttachmentSettings)
         */
        default Builder jobAttachmentSettings(Consumer<JobAttachmentSettings.Builder> jobAttachmentSettings) {
            return jobAttachmentSettings(JobAttachmentSettings.builder().applyMutation(jobAttachmentSettings).build());
        }

        /**
         * <p>
         * The job ID.
         * </p>
         * 
         * @param jobId
         *        The job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The user name and group that the job uses when run.
         * </p>
         * 
         * @param jobRunAsUser
         *        The user name and group that the job uses when run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRunAsUser(JobRunAsUser jobRunAsUser);

        /**
         * <p>
         * The user name and group that the job uses when run.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobRunAsUser.Builder} avoiding the need
         * to create one manually via {@link JobRunAsUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobRunAsUser.Builder#build()} is called immediately and its
         * result is passed to {@link #jobRunAsUser(JobRunAsUser)}.
         * 
         * @param jobRunAsUser
         *        a consumer that will call methods on {@link JobRunAsUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobRunAsUser(JobRunAsUser)
         */
        default Builder jobRunAsUser(Consumer<JobRunAsUser.Builder> jobRunAsUser) {
            return jobRunAsUser(JobRunAsUser.builder().applyMutation(jobRunAsUser).build());
        }

        /**
         * <p>
         * The log group name.
         * </p>
         * 
         * @param logGroupName
         *        The log group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The parameters.
         * </p>
         * 
         * @param parameters
         *        The parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, JobParameter> parameters);

        /**
         * <p>
         * The path mapping rules.
         * </p>
         * 
         * @param pathMappingRules
         *        The path mapping rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathMappingRules(Collection<PathMappingRule> pathMappingRules);

        /**
         * <p>
         * The path mapping rules.
         * </p>
         * 
         * @param pathMappingRules
         *        The path mapping rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathMappingRules(PathMappingRule... pathMappingRules);

        /**
         * <p>
         * The path mapping rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.PathMappingRule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.deadline.model.PathMappingRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.PathMappingRule.Builder#build()} is called immediately
         * and its result is passed to {@link #pathMappingRules(List<PathMappingRule>)}.
         * 
         * @param pathMappingRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.PathMappingRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pathMappingRules(java.util.Collection<PathMappingRule>)
         */
        Builder pathMappingRules(Consumer<PathMappingRule.Builder>... pathMappingRules);

        /**
         * <p>
         * The queue role ARN.
         * </p>
         * 
         * @param queueRoleArn
         *        The queue role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueRoleArn(String queueRoleArn);

        /**
         * <p>
         * The schema version.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);
    }

    static final class BuilderImpl implements Builder {
        private JobAttachmentSettings jobAttachmentSettings;

        private String jobId;

        private JobRunAsUser jobRunAsUser;

        private String logGroupName;

        private Map<String, JobParameter> parameters = DefaultSdkAutoConstructMap.getInstance();

        private List<PathMappingRule> pathMappingRules = DefaultSdkAutoConstructList.getInstance();

        private String queueRoleArn;

        private String schemaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetailsEntity model) {
            jobAttachmentSettings(model.jobAttachmentSettings);
            jobId(model.jobId);
            jobRunAsUser(model.jobRunAsUser);
            logGroupName(model.logGroupName);
            parameters(model.parameters);
            pathMappingRules(model.pathMappingRules);
            queueRoleArn(model.queueRoleArn);
            schemaVersion(model.schemaVersion);
        }

        public final JobAttachmentSettings.Builder getJobAttachmentSettings() {
            return jobAttachmentSettings != null ? jobAttachmentSettings.toBuilder() : null;
        }

        public final void setJobAttachmentSettings(JobAttachmentSettings.BuilderImpl jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings != null ? jobAttachmentSettings.build() : null;
        }

        @Override
        public final Builder jobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final JobRunAsUser.Builder getJobRunAsUser() {
            return jobRunAsUser != null ? jobRunAsUser.toBuilder() : null;
        }

        public final void setJobRunAsUser(JobRunAsUser.BuilderImpl jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser != null ? jobRunAsUser.build() : null;
        }

        @Override
        public final Builder jobRunAsUser(JobRunAsUser jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser;
            return this;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Map<String, JobParameter.Builder> getParameters() {
            Map<String, JobParameter.Builder> result = JobParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, JobParameter.BuilderImpl> parameters) {
            this.parameters = JobParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, JobParameter> parameters) {
            this.parameters = JobParametersCopier.copy(parameters);
            return this;
        }

        public final List<PathMappingRule.Builder> getPathMappingRules() {
            List<PathMappingRule.Builder> result = PathMappingRulesCopier.copyToBuilder(this.pathMappingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPathMappingRules(Collection<PathMappingRule.BuilderImpl> pathMappingRules) {
            this.pathMappingRules = PathMappingRulesCopier.copyFromBuilder(pathMappingRules);
        }

        @Override
        public final Builder pathMappingRules(Collection<PathMappingRule> pathMappingRules) {
            this.pathMappingRules = PathMappingRulesCopier.copy(pathMappingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathMappingRules(PathMappingRule... pathMappingRules) {
            pathMappingRules(Arrays.asList(pathMappingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathMappingRules(Consumer<PathMappingRule.Builder>... pathMappingRules) {
            pathMappingRules(Stream.of(pathMappingRules).map(c -> PathMappingRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getQueueRoleArn() {
            return queueRoleArn;
        }

        public final void setQueueRoleArn(String queueRoleArn) {
            this.queueRoleArn = queueRoleArn;
        }

        @Override
        public final Builder queueRoleArn(String queueRoleArn) {
            this.queueRoleArn = queueRoleArn;
            return this;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public JobDetailsEntity build() {
            return new JobDetailsEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
