/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFarmsResponse extends DeadlineResponse implements
        ToCopyableBuilder<ListFarmsResponse.Builder, ListFarmsResponse> {
    private static final SdkField<List<FarmSummary>> FARMS_FIELD = SdkField
            .<List<FarmSummary>> builder(MarshallingType.LIST)
            .memberName("farms")
            .getter(getter(ListFarmsResponse::farms))
            .setter(setter(Builder::farms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FarmSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FarmSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFarmsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FARMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<FarmSummary> farms;

    private final String nextToken;

    private ListFarmsResponse(BuilderImpl builder) {
        super(builder);
        this.farms = builder.farms;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Farms property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFarms() {
        return farms != null && !(farms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Farms on the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFarms} method.
     * </p>
     * 
     * @return Farms on the list.
     */
    public final List<FarmSummary> farms() {
        return farms;
    }

    /**
     * <p>
     * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation
     * again using the returned token. Keep all other arguments unchanged. If no results remain, then
     * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide
     * a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     * </p>
     * 
     * @return If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
     *         operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
     *         <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
     *         provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFarms() ? farms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFarmsResponse)) {
            return false;
        }
        ListFarmsResponse other = (ListFarmsResponse) obj;
        return hasFarms() == other.hasFarms() && Objects.equals(farms(), other.farms())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFarmsResponse").add("Farms", hasFarms() ? farms() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "farms":
            return Optional.ofNullable(clazz.cast(farms()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFarmsResponse, T> g) {
        return obj -> g.apply((ListFarmsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFarmsResponse> {
        /**
         * <p>
         * Farms on the list.
         * </p>
         * 
         * @param farms
         *        Farms on the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farms(Collection<FarmSummary> farms);

        /**
         * <p>
         * Farms on the list.
         * </p>
         * 
         * @param farms
         *        Farms on the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farms(FarmSummary... farms);

        /**
         * <p>
         * Farms on the list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.FarmSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.deadline.model.FarmSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.FarmSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #farms(List<FarmSummary>)}.
         * 
         * @param farms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.FarmSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #farms(java.util.Collection<FarmSummary>)
         */
        Builder farms(Consumer<FarmSummary.Builder>... farms);

        /**
         * <p>
         * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         * operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
         * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
         * provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
         * </p>
         * 
         * @param nextToken
         *        If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         *        operation again using the returned token. Keep all other arguments unchanged. If no results remain,
         *        then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours.
         *        If you provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private List<FarmSummary> farms = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFarmsResponse model) {
            super(model);
            farms(model.farms);
            nextToken(model.nextToken);
        }

        public final List<FarmSummary.Builder> getFarms() {
            List<FarmSummary.Builder> result = FarmSummariesCopier.copyToBuilder(this.farms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFarms(Collection<FarmSummary.BuilderImpl> farms) {
            this.farms = FarmSummariesCopier.copyFromBuilder(farms);
        }

        @Override
        public final Builder farms(Collection<FarmSummary> farms) {
            this.farms = FarmSummariesCopier.copy(farms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder farms(FarmSummary... farms) {
            farms(Arrays.asList(farms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder farms(Consumer<FarmSummary.Builder>... farms) {
            farms(Stream.of(farms).map(c -> FarmSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFarmsResponse build() {
            return new ListFarmsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
