/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueuesRequest extends DeadlineRequest implements
        ToCopyableBuilder<ListQueuesRequest.Builder, ListQueuesRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(ListQueuesRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListQueuesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListQueuesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalId").getter(getter(ListQueuesRequest::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("principalId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListQueuesRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PRINCIPAL_ID_FIELD, STATUS_FIELD));

    private final String farmId;

    private final Integer maxResults;

    private final String nextToken;

    private final String principalId;

    private final String status;

    private ListQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.principalId = builder.principalId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The farm ID of the queue.
     * </p>
     * 
     * @return The farm ID of the queue.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential pages.
     * </p>
     * 
     * @return The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
     *         a set of sequential pages.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results, or <code>null</code> to start from the beginning.
     * </p>
     * 
     * @return The token for the next set of results, or <code>null</code> to start from the beginning.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The principal ID. This filter is only valid when using Nimble Studio credentials and should match the user ID in
     * the credentials of the caller.
     * </p>
     * 
     * @return The principal ID. This filter is only valid when using Nimble Studio credentials and should match the
     *         user ID in the credentials of the caller.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The status of the queues listed.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>–The queues are active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULING</code>–The queues are scheduling.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked for these queues.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the queues listed.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>–The queues are active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULING</code>–The queues are scheduling.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked for these queues.
     *         </p>
     *         </li>
     * @see QueueStatus
     */
    public final QueueStatus status() {
        return QueueStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the queues listed.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>–The queues are active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULING</code>–The queues are scheduling.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked for these queues.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the queues listed.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>–The queues are active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULING</code>–The queues are scheduling.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked for these queues.
     *         </p>
     *         </li>
     * @see QueueStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesRequest)) {
            return false;
        }
        ListQueuesRequest other = (ListQueuesRequest) obj;
        return Objects.equals(farmId(), other.farmId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(principalId(), other.principalId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQueuesRequest").add("FarmId", farmId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("PrincipalId", principalId()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueuesRequest, T> g) {
        return obj -> g.apply((ListQueuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListQueuesRequest> {
        /**
         * <p>
         * The farm ID of the queue.
         * </p>
         * 
         * @param farmId
         *        The farm ID of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a
         * set of sequential pages.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results
         *        as a set of sequential pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results, or <code>null</code> to start from the beginning.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or <code>null</code> to start from the beginning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The principal ID. This filter is only valid when using Nimble Studio credentials and should match the user ID
         * in the credentials of the caller.
         * </p>
         * 
         * @param principalId
         *        The principal ID. This filter is only valid when using Nimble Studio credentials and should match the
         *        user ID in the credentials of the caller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The status of the queues listed.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>–The queues are active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULING</code>–The queues are scheduling.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked for these queues.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the queues listed.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>–The queues are active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULING</code>–The queues are scheduling.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked for these queues.
         *        </p>
         *        </li>
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the queues listed.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>–The queues are active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULING</code>–The queues are scheduling.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked for these queues.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the queues listed.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>–The queues are active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULING</code>–The queues are scheduling.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked for these queues.
         *        </p>
         *        </li>
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(QueueStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String farmId;

        private Integer maxResults;

        private String nextToken;

        private String principalId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesRequest model) {
            super(model);
            farmId(model.farmId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            principalId(model.principalId);
            status(model.status);
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListQueuesRequest build() {
            return new ListQueuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
