/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of a queue environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueueEnvironmentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<QueueEnvironmentSummary.Builder, QueueEnvironmentSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(QueueEnvironmentSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(QueueEnvironmentSummary::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> QUEUE_ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueEnvironmentId").getter(getter(QueueEnvironmentSummary::queueEnvironmentId))
            .setter(setter(Builder::queueEnvironmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueEnvironmentId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PRIORITY_FIELD,
            QUEUE_ENVIRONMENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer priority;

    private final String queueEnvironmentId;

    private QueueEnvironmentSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.priority = builder.priority;
        this.queueEnvironmentId = builder.queueEnvironmentId;
    }

    /**
     * <p>
     * The name of the queue environment.
     * </p>
     * 
     * @return The name of the queue environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The queue environment's priority.
     * </p>
     * 
     * @return The queue environment's priority.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The queue environment ID.
     * </p>
     * 
     * @return The queue environment ID.
     */
    public final String queueEnvironmentId() {
        return queueEnvironmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(queueEnvironmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueEnvironmentSummary)) {
            return false;
        }
        QueueEnvironmentSummary other = (QueueEnvironmentSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(priority(), other.priority())
                && Objects.equals(queueEnvironmentId(), other.queueEnvironmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueueEnvironmentSummary").add("Name", name()).add("Priority", priority())
                .add("QueueEnvironmentId", queueEnvironmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "queueEnvironmentId":
            return Optional.ofNullable(clazz.cast(queueEnvironmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueueEnvironmentSummary, T> g) {
        return obj -> g.apply((QueueEnvironmentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueueEnvironmentSummary> {
        /**
         * <p>
         * The name of the queue environment.
         * </p>
         * 
         * @param name
         *        The name of the queue environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The queue environment's priority.
         * </p>
         * 
         * @param priority
         *        The queue environment's priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The queue environment ID.
         * </p>
         * 
         * @param queueEnvironmentId
         *        The queue environment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueEnvironmentId(String queueEnvironmentId);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer priority;

        private String queueEnvironmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueEnvironmentSummary model) {
            name(model.name);
            priority(model.priority);
            queueEnvironmentId(model.queueEnvironmentId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getQueueEnvironmentId() {
            return queueEnvironmentId;
        }

        public final void setQueueEnvironmentId(String queueEnvironmentId) {
            this.queueEnvironmentId = queueEnvironmentId;
        }

        @Override
        public final Builder queueEnvironmentId(String queueEnvironmentId) {
            this.queueEnvironmentId = queueEnvironmentId;
            return this;
        }

        @Override
        public QueueEnvironmentSummary build() {
            return new QueueEnvironmentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
