/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a queue member.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueueMember implements SdkPojo, Serializable, ToCopyableBuilder<QueueMember.Builder, QueueMember> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(QueueMember::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farmId").build()).build();

    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityStoreId").getter(getter(QueueMember::identityStoreId)).setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityStoreId").build()).build();

    private static final SdkField<String> MEMBERSHIP_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipLevel").getter(getter(QueueMember::membershipLevelAsString))
            .setter(setter(Builder::membershipLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipLevel").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalId").getter(getter(QueueMember::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()).build();

    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalType").getter(getter(QueueMember::principalTypeAsString))
            .setter(setter(Builder::principalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalType").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(QueueMember::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD,
            IDENTITY_STORE_ID_FIELD, MEMBERSHIP_LEVEL_FIELD, PRINCIPAL_ID_FIELD, PRINCIPAL_TYPE_FIELD, QUEUE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String farmId;

    private final String identityStoreId;

    private final String membershipLevel;

    private final String principalId;

    private final String principalType;

    private final String queueId;

    private QueueMember(BuilderImpl builder) {
        this.farmId = builder.farmId;
        this.identityStoreId = builder.identityStoreId;
        this.membershipLevel = builder.membershipLevel;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
        this.queueId = builder.queueId;
    }

    /**
     * <p>
     * The farm ID.
     * </p>
     * 
     * @return The farm ID.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The identity store ID.
     * </p>
     * 
     * @return The identity store ID.
     */
    public final String identityStoreId() {
        return identityStoreId;
    }

    /**
     * <p>
     * The queue member's membership level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipLevel}
     * will return {@link MembershipLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #membershipLevelAsString}.
     * </p>
     * 
     * @return The queue member's membership level.
     * @see MembershipLevel
     */
    public final MembershipLevel membershipLevel() {
        return MembershipLevel.fromValue(membershipLevel);
    }

    /**
     * <p>
     * The queue member's membership level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipLevel}
     * will return {@link MembershipLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #membershipLevelAsString}.
     * </p>
     * 
     * @return The queue member's membership level.
     * @see MembershipLevel
     */
    public final String membershipLevelAsString() {
        return membershipLevel;
    }

    /**
     * <p>
     * The principal ID of the queue member.
     * </p>
     * 
     * @return The principal ID of the queue member.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The principal type of the queue member.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The principal type of the queue member.
     * @see PrincipalType
     */
    public final PrincipalType principalType() {
        return PrincipalType.fromValue(principalType);
    }

    /**
     * <p>
     * The principal type of the queue member.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The principal type of the queue member.
     * @see PrincipalType
     */
    public final String principalTypeAsString() {
        return principalType;
    }

    /**
     * <p>
     * The queue ID.
     * </p>
     * 
     * @return The queue ID.
     */
    public final String queueId() {
        return queueId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueMember)) {
            return false;
        }
        QueueMember other = (QueueMember) obj;
        return Objects.equals(farmId(), other.farmId()) && Objects.equals(identityStoreId(), other.identityStoreId())
                && Objects.equals(membershipLevelAsString(), other.membershipLevelAsString())
                && Objects.equals(principalId(), other.principalId())
                && Objects.equals(principalTypeAsString(), other.principalTypeAsString())
                && Objects.equals(queueId(), other.queueId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueueMember").add("FarmId", farmId()).add("IdentityStoreId", identityStoreId())
                .add("MembershipLevel", membershipLevelAsString()).add("PrincipalId", principalId())
                .add("PrincipalType", principalTypeAsString()).add("QueueId", queueId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "identityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        case "membershipLevel":
            return Optional.ofNullable(clazz.cast(membershipLevelAsString()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "principalType":
            return Optional.ofNullable(clazz.cast(principalTypeAsString()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueueMember, T> g) {
        return obj -> g.apply((QueueMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueueMember> {
        /**
         * <p>
         * The farm ID.
         * </p>
         * 
         * @param farmId
         *        The farm ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The identity store ID.
         * </p>
         * 
         * @param identityStoreId
         *        The identity store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);

        /**
         * <p>
         * The queue member's membership level.
         * </p>
         * 
         * @param membershipLevel
         *        The queue member's membership level.
         * @see MembershipLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipLevel
         */
        Builder membershipLevel(String membershipLevel);

        /**
         * <p>
         * The queue member's membership level.
         * </p>
         * 
         * @param membershipLevel
         *        The queue member's membership level.
         * @see MembershipLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipLevel
         */
        Builder membershipLevel(MembershipLevel membershipLevel);

        /**
         * <p>
         * The principal ID of the queue member.
         * </p>
         * 
         * @param principalId
         *        The principal ID of the queue member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The principal type of the queue member.
         * </p>
         * 
         * @param principalType
         *        The principal type of the queue member.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(String principalType);

        /**
         * <p>
         * The principal type of the queue member.
         * </p>
         * 
         * @param principalType
         *        The principal type of the queue member.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(PrincipalType principalType);

        /**
         * <p>
         * The queue ID.
         * </p>
         * 
         * @param queueId
         *        The queue ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);
    }

    static final class BuilderImpl implements Builder {
        private String farmId;

        private String identityStoreId;

        private String membershipLevel;

        private String principalId;

        private String principalType;

        private String queueId;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueMember model) {
            farmId(model.farmId);
            identityStoreId(model.identityStoreId);
            membershipLevel(model.membershipLevel);
            principalId(model.principalId);
            principalType(model.principalType);
            queueId(model.queueId);
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final String getMembershipLevel() {
            return membershipLevel;
        }

        public final void setMembershipLevel(String membershipLevel) {
            this.membershipLevel = membershipLevel;
        }

        @Override
        public final Builder membershipLevel(String membershipLevel) {
            this.membershipLevel = membershipLevel;
            return this;
        }

        @Override
        public final Builder membershipLevel(MembershipLevel membershipLevel) {
            this.membershipLevel(membershipLevel == null ? null : membershipLevel.toString());
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getPrincipalType() {
            return principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        @Override
        public QueueMember build() {
            return new QueueMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
