/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchTasksResponse extends DeadlineResponse implements
        ToCopyableBuilder<SearchTasksResponse.Builder, SearchTasksResponse> {
    private static final SdkField<Integer> NEXT_ITEM_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("nextItemOffset").getter(getter(SearchTasksResponse::nextItemOffset))
            .setter(setter(Builder::nextItemOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextItemOffset").build()).build();

    private static final SdkField<List<TaskSearchSummary>> TASKS_FIELD = SdkField
            .<List<TaskSearchSummary>> builder(MarshallingType.LIST)
            .memberName("tasks")
            .getter(getter(SearchTasksResponse::tasks))
            .setter(setter(Builder::tasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskSearchSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskSearchSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalResults").getter(getter(SearchTasksResponse::totalResults)).setter(setter(Builder::totalResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_ITEM_OFFSET_FIELD,
            TASKS_FIELD, TOTAL_RESULTS_FIELD));

    private final Integer nextItemOffset;

    private final List<TaskSearchSummary> tasks;

    private final Integer totalResults;

    private SearchTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextItemOffset = builder.nextItemOffset;
        this.tasks = builder.tasks;
        this.totalResults = builder.totalResults;
    }

    /**
     * <p>
     * The next incremental starting point after the defined <code>itemOffset</code>.
     * </p>
     * 
     * @return The next incremental starting point after the defined <code>itemOffset</code>.
     */
    public final Integer nextItemOffset() {
        return nextItemOffset;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tasks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTasks() {
        return tasks != null && !(tasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tasks in the search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTasks} method.
     * </p>
     * 
     * @return Tasks in the search.
     */
    public final List<TaskSearchSummary> tasks() {
        return tasks;
    }

    /**
     * <p>
     * The total number of results in the search.
     * </p>
     * 
     * @return The total number of results in the search.
     */
    public final Integer totalResults() {
        return totalResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextItemOffset());
        hashCode = 31 * hashCode + Objects.hashCode(hasTasks() ? tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTasksResponse)) {
            return false;
        }
        SearchTasksResponse other = (SearchTasksResponse) obj;
        return Objects.equals(nextItemOffset(), other.nextItemOffset()) && hasTasks() == other.hasTasks()
                && Objects.equals(tasks(), other.tasks()) && Objects.equals(totalResults(), other.totalResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchTasksResponse").add("NextItemOffset", nextItemOffset())
                .add("Tasks", hasTasks() ? tasks() : null).add("TotalResults", totalResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextItemOffset":
            return Optional.ofNullable(clazz.cast(nextItemOffset()));
        case "tasks":
            return Optional.ofNullable(clazz.cast(tasks()));
        case "totalResults":
            return Optional.ofNullable(clazz.cast(totalResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchTasksResponse, T> g) {
        return obj -> g.apply((SearchTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchTasksResponse> {
        /**
         * <p>
         * The next incremental starting point after the defined <code>itemOffset</code>.
         * </p>
         * 
         * @param nextItemOffset
         *        The next incremental starting point after the defined <code>itemOffset</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextItemOffset(Integer nextItemOffset);

        /**
         * <p>
         * Tasks in the search.
         * </p>
         * 
         * @param tasks
         *        Tasks in the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Collection<TaskSearchSummary> tasks);

        /**
         * <p>
         * Tasks in the search.
         * </p>
         * 
         * @param tasks
         *        Tasks in the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(TaskSearchSummary... tasks);

        /**
         * <p>
         * Tasks in the search.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.TaskSearchSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.deadline.model.TaskSearchSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.TaskSearchSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #tasks(List<TaskSearchSummary>)}.
         * 
         * @param tasks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.TaskSearchSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tasks(java.util.Collection<TaskSearchSummary>)
         */
        Builder tasks(Consumer<TaskSearchSummary.Builder>... tasks);

        /**
         * <p>
         * The total number of results in the search.
         * </p>
         * 
         * @param totalResults
         *        The total number of results in the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResults(Integer totalResults);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private Integer nextItemOffset;

        private List<TaskSearchSummary> tasks = DefaultSdkAutoConstructList.getInstance();

        private Integer totalResults;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTasksResponse model) {
            super(model);
            nextItemOffset(model.nextItemOffset);
            tasks(model.tasks);
            totalResults(model.totalResults);
        }

        public final Integer getNextItemOffset() {
            return nextItemOffset;
        }

        public final void setNextItemOffset(Integer nextItemOffset) {
            this.nextItemOffset = nextItemOffset;
        }

        @Override
        public final Builder nextItemOffset(Integer nextItemOffset) {
            this.nextItemOffset = nextItemOffset;
            return this;
        }

        public final List<TaskSearchSummary.Builder> getTasks() {
            List<TaskSearchSummary.Builder> result = TaskSearchSummariesCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<TaskSearchSummary.BuilderImpl> tasks) {
            this.tasks = TaskSearchSummariesCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<TaskSearchSummary> tasks) {
            this.tasks = TaskSearchSummariesCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(TaskSearchSummary... tasks) {
            tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<TaskSearchSummary.Builder>... tasks) {
            tasks(Stream.of(tasks).map(c -> TaskSearchSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalResults() {
            return totalResults;
        }

        public final void setTotalResults(Integer totalResults) {
            this.totalResults = totalResults;
        }

        @Override
        public final Builder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        @Override
        public SearchTasksResponse build() {
            return new SearchTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
