/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of statistics for a session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Statistics implements SdkPojo, Serializable, ToCopyableBuilder<Statistics.Builder, Statistics> {
    private static final SdkField<Instant> AGGREGATION_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("aggregationEndTime")
            .getter(getter(Statistics::aggregationEndTime))
            .setter(setter(Builder::aggregationEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationEndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> AGGREGATION_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("aggregationStartTime")
            .getter(getter(Statistics::aggregationStartTime))
            .setter(setter(Builder::aggregationStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Stats> COST_IN_USD_FIELD = SdkField.<Stats> builder(MarshallingType.SDK_POJO)
            .memberName("costInUsd").getter(getter(Statistics::costInUsd)).setter(setter(Builder::costInUsd))
            .constructor(Stats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costInUsd").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(Statistics::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetId").getter(getter(Statistics::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(Statistics::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(Statistics::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(Statistics::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> LICENSE_PRODUCT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseProduct").getter(getter(Statistics::licenseProduct)).setter(setter(Builder::licenseProduct))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseProduct").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(Statistics::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()).build();

    private static final SdkField<Stats> RUNTIME_IN_SECONDS_FIELD = SdkField.<Stats> builder(MarshallingType.SDK_POJO)
            .memberName("runtimeInSeconds").getter(getter(Statistics::runtimeInSeconds))
            .setter(setter(Builder::runtimeInSeconds)).constructor(Stats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeInSeconds").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(Statistics::usageTypeAsString)).setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(Statistics::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_END_TIME_FIELD,
            AGGREGATION_START_TIME_FIELD, COST_IN_USD_FIELD, COUNT_FIELD, FLEET_ID_FIELD, INSTANCE_TYPE_FIELD, JOB_ID_FIELD,
            JOB_NAME_FIELD, LICENSE_PRODUCT_FIELD, QUEUE_ID_FIELD, RUNTIME_IN_SECONDS_FIELD, USAGE_TYPE_FIELD, USER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant aggregationEndTime;

    private final Instant aggregationStartTime;

    private final Stats costInUsd;

    private final Integer count;

    private final String fleetId;

    private final String instanceType;

    private final String jobId;

    private final String jobName;

    private final String licenseProduct;

    private final String queueId;

    private final Stats runtimeInSeconds;

    private final String usageType;

    private final String userId;

    private Statistics(BuilderImpl builder) {
        this.aggregationEndTime = builder.aggregationEndTime;
        this.aggregationStartTime = builder.aggregationStartTime;
        this.costInUsd = builder.costInUsd;
        this.count = builder.count;
        this.fleetId = builder.fleetId;
        this.instanceType = builder.instanceType;
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.licenseProduct = builder.licenseProduct;
        this.queueId = builder.queueId;
        this.runtimeInSeconds = builder.runtimeInSeconds;
        this.usageType = builder.usageType;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * The end time for the aggregation.
     * </p>
     * 
     * @return The end time for the aggregation.
     */
    public final Instant aggregationEndTime() {
        return aggregationEndTime;
    }

    /**
     * <p>
     * The start time for the aggregation.
     * </p>
     * 
     * @return The start time for the aggregation.
     */
    public final Instant aggregationStartTime() {
        return aggregationStartTime;
    }

    /**
     * <p>
     * How the statistics should appear in USD. Options include: minimum, maximum, average or sum.
     * </p>
     * 
     * @return How the statistics should appear in USD. Options include: minimum, maximum, average or sum.
     */
    public final Stats costInUsd() {
        return costInUsd;
    }

    /**
     * <p>
     * The number of instances in a list of statistics.
     * </p>
     * 
     * @return The number of instances in a list of statistics.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The fleet ID.
     * </p>
     * 
     * @return The fleet ID.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The type of instance.
     * </p>
     * 
     * @return The type of instance.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The job ID.
     * </p>
     * 
     * @return The job ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The job name.
     * </p>
     * 
     * @return The job name.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The licensed product.
     * </p>
     * 
     * @return The licensed product.
     */
    public final String licenseProduct() {
        return licenseProduct;
    }

    /**
     * <p>
     * The queue ID.
     * </p>
     * 
     * @return The queue ID.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The total aggregated runtime.
     * </p>
     * 
     * @return The total aggregated runtime.
     */
    public final Stats runtimeInSeconds() {
        return runtimeInSeconds;
    }

    /**
     * <p>
     * The type of usage for the statistics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageType} will
     * return {@link UsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageTypeAsString}.
     * </p>
     * 
     * @return The type of usage for the statistics.
     * @see UsageType
     */
    public final UsageType usageType() {
        return UsageType.fromValue(usageType);
    }

    /**
     * <p>
     * The type of usage for the statistics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageType} will
     * return {@link UsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageTypeAsString}.
     * </p>
     * 
     * @return The type of usage for the statistics.
     * @see UsageType
     */
    public final String usageTypeAsString() {
        return usageType;
    }

    /**
     * <p>
     * The user ID.
     * </p>
     * 
     * @return The user ID.
     */
    public final String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(costInUsd());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(licenseProduct());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(usageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statistics)) {
            return false;
        }
        Statistics other = (Statistics) obj;
        return Objects.equals(aggregationEndTime(), other.aggregationEndTime())
                && Objects.equals(aggregationStartTime(), other.aggregationStartTime())
                && Objects.equals(costInUsd(), other.costInUsd()) && Objects.equals(count(), other.count())
                && Objects.equals(fleetId(), other.fleetId()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(jobId(), other.jobId()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(licenseProduct(), other.licenseProduct()) && Objects.equals(queueId(), other.queueId())
                && Objects.equals(runtimeInSeconds(), other.runtimeInSeconds())
                && Objects.equals(usageTypeAsString(), other.usageTypeAsString()) && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Statistics").add("AggregationEndTime", aggregationEndTime())
                .add("AggregationStartTime", aggregationStartTime()).add("CostInUsd", costInUsd()).add("Count", count())
                .add("FleetId", fleetId()).add("InstanceType", instanceType()).add("JobId", jobId()).add("JobName", jobName())
                .add("LicenseProduct", licenseProduct()).add("QueueId", queueId()).add("RuntimeInSeconds", runtimeInSeconds())
                .add("UsageType", usageTypeAsString()).add("UserId", userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aggregationEndTime":
            return Optional.ofNullable(clazz.cast(aggregationEndTime()));
        case "aggregationStartTime":
            return Optional.ofNullable(clazz.cast(aggregationStartTime()));
        case "costInUsd":
            return Optional.ofNullable(clazz.cast(costInUsd()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "fleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "licenseProduct":
            return Optional.ofNullable(clazz.cast(licenseProduct()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "runtimeInSeconds":
            return Optional.ofNullable(clazz.cast(runtimeInSeconds()));
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageTypeAsString()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Statistics, T> g) {
        return obj -> g.apply((Statistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Statistics> {
        /**
         * <p>
         * The end time for the aggregation.
         * </p>
         * 
         * @param aggregationEndTime
         *        The end time for the aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationEndTime(Instant aggregationEndTime);

        /**
         * <p>
         * The start time for the aggregation.
         * </p>
         * 
         * @param aggregationStartTime
         *        The start time for the aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationStartTime(Instant aggregationStartTime);

        /**
         * <p>
         * How the statistics should appear in USD. Options include: minimum, maximum, average or sum.
         * </p>
         * 
         * @param costInUsd
         *        How the statistics should appear in USD. Options include: minimum, maximum, average or sum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costInUsd(Stats costInUsd);

        /**
         * <p>
         * How the statistics should appear in USD. Options include: minimum, maximum, average or sum.
         * </p>
         * This is a convenience method that creates an instance of the {@link Stats.Builder} avoiding the need to
         * create one manually via {@link Stats#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Stats.Builder#build()} is called immediately and its result is
         * passed to {@link #costInUsd(Stats)}.
         * 
         * @param costInUsd
         *        a consumer that will call methods on {@link Stats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costInUsd(Stats)
         */
        default Builder costInUsd(Consumer<Stats.Builder> costInUsd) {
            return costInUsd(Stats.builder().applyMutation(costInUsd).build());
        }

        /**
         * <p>
         * The number of instances in a list of statistics.
         * </p>
         * 
         * @param count
         *        The number of instances in a list of statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The fleet ID.
         * </p>
         * 
         * @param fleetId
         *        The fleet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The type of instance.
         * </p>
         * 
         * @param instanceType
         *        The type of instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The job ID.
         * </p>
         * 
         * @param jobId
         *        The job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The job name.
         * </p>
         * 
         * @param jobName
         *        The job name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The licensed product.
         * </p>
         * 
         * @param licenseProduct
         *        The licensed product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseProduct(String licenseProduct);

        /**
         * <p>
         * The queue ID.
         * </p>
         * 
         * @param queueId
         *        The queue ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The total aggregated runtime.
         * </p>
         * 
         * @param runtimeInSeconds
         *        The total aggregated runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeInSeconds(Stats runtimeInSeconds);

        /**
         * <p>
         * The total aggregated runtime.
         * </p>
         * This is a convenience method that creates an instance of the {@link Stats.Builder} avoiding the need to
         * create one manually via {@link Stats#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Stats.Builder#build()} is called immediately and its result is
         * passed to {@link #runtimeInSeconds(Stats)}.
         * 
         * @param runtimeInSeconds
         *        a consumer that will call methods on {@link Stats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeInSeconds(Stats)
         */
        default Builder runtimeInSeconds(Consumer<Stats.Builder> runtimeInSeconds) {
            return runtimeInSeconds(Stats.builder().applyMutation(runtimeInSeconds).build());
        }

        /**
         * <p>
         * The type of usage for the statistics.
         * </p>
         * 
         * @param usageType
         *        The type of usage for the statistics.
         * @see UsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageType
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * The type of usage for the statistics.
         * </p>
         * 
         * @param usageType
         *        The type of usage for the statistics.
         * @see UsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageType
         */
        Builder usageType(UsageType usageType);

        /**
         * <p>
         * The user ID.
         * </p>
         * 
         * @param userId
         *        The user ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);
    }

    static final class BuilderImpl implements Builder {
        private Instant aggregationEndTime;

        private Instant aggregationStartTime;

        private Stats costInUsd;

        private Integer count;

        private String fleetId;

        private String instanceType;

        private String jobId;

        private String jobName;

        private String licenseProduct;

        private String queueId;

        private Stats runtimeInSeconds;

        private String usageType;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(Statistics model) {
            aggregationEndTime(model.aggregationEndTime);
            aggregationStartTime(model.aggregationStartTime);
            costInUsd(model.costInUsd);
            count(model.count);
            fleetId(model.fleetId);
            instanceType(model.instanceType);
            jobId(model.jobId);
            jobName(model.jobName);
            licenseProduct(model.licenseProduct);
            queueId(model.queueId);
            runtimeInSeconds(model.runtimeInSeconds);
            usageType(model.usageType);
            userId(model.userId);
        }

        public final Instant getAggregationEndTime() {
            return aggregationEndTime;
        }

        public final void setAggregationEndTime(Instant aggregationEndTime) {
            this.aggregationEndTime = aggregationEndTime;
        }

        @Override
        public final Builder aggregationEndTime(Instant aggregationEndTime) {
            this.aggregationEndTime = aggregationEndTime;
            return this;
        }

        public final Instant getAggregationStartTime() {
            return aggregationStartTime;
        }

        public final void setAggregationStartTime(Instant aggregationStartTime) {
            this.aggregationStartTime = aggregationStartTime;
        }

        @Override
        public final Builder aggregationStartTime(Instant aggregationStartTime) {
            this.aggregationStartTime = aggregationStartTime;
            return this;
        }

        public final Stats.Builder getCostInUsd() {
            return costInUsd != null ? costInUsd.toBuilder() : null;
        }

        public final void setCostInUsd(Stats.BuilderImpl costInUsd) {
            this.costInUsd = costInUsd != null ? costInUsd.build() : null;
        }

        @Override
        public final Builder costInUsd(Stats costInUsd) {
            this.costInUsd = costInUsd;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getLicenseProduct() {
            return licenseProduct;
        }

        public final void setLicenseProduct(String licenseProduct) {
            this.licenseProduct = licenseProduct;
        }

        @Override
        public final Builder licenseProduct(String licenseProduct) {
            this.licenseProduct = licenseProduct;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final Stats.Builder getRuntimeInSeconds() {
            return runtimeInSeconds != null ? runtimeInSeconds.toBuilder() : null;
        }

        public final void setRuntimeInSeconds(Stats.BuilderImpl runtimeInSeconds) {
            this.runtimeInSeconds = runtimeInSeconds != null ? runtimeInSeconds.build() : null;
        }

        @Override
        public final Builder runtimeInSeconds(Stats runtimeInSeconds) {
            this.runtimeInSeconds = runtimeInSeconds;
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        @Override
        public final Builder usageType(UsageType usageType) {
            this.usageType(usageType == null ? null : usageType.toString());
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public Statistics build() {
            return new Statistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
