/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStepRequest extends DeadlineRequest implements
        ToCopyableBuilder<UpdateStepRequest.Builder, UpdateStepRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateStepRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(UpdateStepRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(UpdateStepRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(UpdateStepRequest::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()).build();

    private static final SdkField<String> STEP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stepId")
            .getter(getter(UpdateStepRequest::stepId)).setter(setter(Builder::stepId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("stepId").build()).build();

    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetTaskRunStatus").getter(getter(UpdateStepRequest::targetTaskRunStatusAsString))
            .setter(setter(Builder::targetTaskRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            FARM_ID_FIELD, JOB_ID_FIELD, QUEUE_ID_FIELD, STEP_ID_FIELD, TARGET_TASK_RUN_STATUS_FIELD));

    private final String clientToken;

    private final String farmId;

    private final String jobId;

    private final String queueId;

    private final String stepId;

    private final String targetTaskRunStatus;

    private UpdateStepRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.jobId = builder.jobId;
        this.queueId = builder.queueId;
        this.stepId = builder.stepId;
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
    }

    /**
     * <p>
     * The unique token which the server uses to recognize retries of the same request.
     * </p>
     * 
     * @return The unique token which the server uses to recognize retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The farm ID to update.
     * </p>
     * 
     * @return The farm ID to update.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The job ID to update.
     * </p>
     * 
     * @return The job ID to update.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The queue ID to update.
     * </p>
     * 
     * @return The queue ID to update.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The step ID to update.
     * </p>
     * 
     * @return The step ID to update.
     */
    public final String stepId() {
        return stepId;
    }

    /**
     * <p>
     * The task status to update the step's tasks to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link StepTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The task status to update the step's tasks to.
     * @see StepTargetTaskRunStatus
     */
    public final StepTargetTaskRunStatus targetTaskRunStatus() {
        return StepTargetTaskRunStatus.fromValue(targetTaskRunStatus);
    }

    /**
     * <p>
     * The task status to update the step's tasks to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link StepTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The task status to update the step's tasks to.
     * @see StepTargetTaskRunStatus
     */
    public final String targetTaskRunStatusAsString() {
        return targetTaskRunStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(stepId());
        hashCode = 31 * hashCode + Objects.hashCode(targetTaskRunStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStepRequest)) {
            return false;
        }
        UpdateStepRequest other = (UpdateStepRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(jobId(), other.jobId()) && Objects.equals(queueId(), other.queueId())
                && Objects.equals(stepId(), other.stepId())
                && Objects.equals(targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStepRequest").add("ClientToken", clientToken()).add("FarmId", farmId())
                .add("JobId", jobId()).add("QueueId", queueId()).add("StepId", stepId())
                .add("TargetTaskRunStatus", targetTaskRunStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "stepId":
            return Optional.ofNullable(clazz.cast(stepId()));
        case "targetTaskRunStatus":
            return Optional.ofNullable(clazz.cast(targetTaskRunStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStepRequest, T> g) {
        return obj -> g.apply((UpdateStepRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStepRequest> {
        /**
         * <p>
         * The unique token which the server uses to recognize retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        The unique token which the server uses to recognize retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The farm ID to update.
         * </p>
         * 
         * @param farmId
         *        The farm ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The job ID to update.
         * </p>
         * 
         * @param jobId
         *        The job ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The queue ID to update.
         * </p>
         * 
         * @param queueId
         *        The queue ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The step ID to update.
         * </p>
         * 
         * @param stepId
         *        The step ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepId(String stepId);

        /**
         * <p>
         * The task status to update the step's tasks to.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The task status to update the step's tasks to.
         * @see StepTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(String targetTaskRunStatus);

        /**
         * <p>
         * The task status to update the step's tasks to.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The task status to update the step's tasks to.
         * @see StepTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(StepTargetTaskRunStatus targetTaskRunStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String farmId;

        private String jobId;

        private String queueId;

        private String stepId;

        private String targetTaskRunStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStepRequest model) {
            super(model);
            clientToken(model.clientToken);
            farmId(model.farmId);
            jobId(model.jobId);
            queueId(model.queueId);
            stepId(model.stepId);
            targetTaskRunStatus(model.targetTaskRunStatus);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getStepId() {
            return stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getTargetTaskRunStatus() {
            return targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(StepTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStepRequest build() {
            return new UpdateStepRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
