/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.deadline.model.AccessDeniedException;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFarmRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFarmResponse;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFleetRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFleetResponse;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToJobRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToJobResponse;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToQueueRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToQueueResponse;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadRequest;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadResponse;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadRequest;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadResponse;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForUserRequest;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForUserResponse;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.BatchGetJobEntityRequest;
import software.amazon.awssdk.services.deadline.model.BatchGetJobEntityResponse;
import software.amazon.awssdk.services.deadline.model.ConflictException;
import software.amazon.awssdk.services.deadline.model.CopyJobTemplateRequest;
import software.amazon.awssdk.services.deadline.model.CopyJobTemplateResponse;
import software.amazon.awssdk.services.deadline.model.CreateBudgetRequest;
import software.amazon.awssdk.services.deadline.model.CreateBudgetResponse;
import software.amazon.awssdk.services.deadline.model.CreateFarmRequest;
import software.amazon.awssdk.services.deadline.model.CreateFarmResponse;
import software.amazon.awssdk.services.deadline.model.CreateFleetRequest;
import software.amazon.awssdk.services.deadline.model.CreateFleetResponse;
import software.amazon.awssdk.services.deadline.model.CreateJobRequest;
import software.amazon.awssdk.services.deadline.model.CreateJobResponse;
import software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.CreateMonitorRequest;
import software.amazon.awssdk.services.deadline.model.CreateMonitorResponse;
import software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.CreateQueueRequest;
import software.amazon.awssdk.services.deadline.model.CreateQueueResponse;
import software.amazon.awssdk.services.deadline.model.CreateStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.CreateStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.CreateWorkerRequest;
import software.amazon.awssdk.services.deadline.model.CreateWorkerResponse;
import software.amazon.awssdk.services.deadline.model.DeadlineException;
import software.amazon.awssdk.services.deadline.model.DeleteBudgetRequest;
import software.amazon.awssdk.services.deadline.model.DeleteBudgetResponse;
import software.amazon.awssdk.services.deadline.model.DeleteFarmRequest;
import software.amazon.awssdk.services.deadline.model.DeleteFarmResponse;
import software.amazon.awssdk.services.deadline.model.DeleteFleetRequest;
import software.amazon.awssdk.services.deadline.model.DeleteFleetResponse;
import software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.DeleteMeteredProductRequest;
import software.amazon.awssdk.services.deadline.model.DeleteMeteredProductResponse;
import software.amazon.awssdk.services.deadline.model.DeleteMonitorRequest;
import software.amazon.awssdk.services.deadline.model.DeleteMonitorResponse;
import software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.DeleteQueueRequest;
import software.amazon.awssdk.services.deadline.model.DeleteQueueResponse;
import software.amazon.awssdk.services.deadline.model.DeleteStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.DeleteStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.DeleteWorkerRequest;
import software.amazon.awssdk.services.deadline.model.DeleteWorkerResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueResponse;
import software.amazon.awssdk.services.deadline.model.GetBudgetRequest;
import software.amazon.awssdk.services.deadline.model.GetBudgetResponse;
import software.amazon.awssdk.services.deadline.model.GetFarmRequest;
import software.amazon.awssdk.services.deadline.model.GetFarmResponse;
import software.amazon.awssdk.services.deadline.model.GetFleetRequest;
import software.amazon.awssdk.services.deadline.model.GetFleetResponse;
import software.amazon.awssdk.services.deadline.model.GetJobRequest;
import software.amazon.awssdk.services.deadline.model.GetJobResponse;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.GetMonitorRequest;
import software.amazon.awssdk.services.deadline.model.GetMonitorResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueResponse;
import software.amazon.awssdk.services.deadline.model.GetSessionActionRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionActionResponse;
import software.amazon.awssdk.services.deadline.model.GetSessionRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionResponse;
import software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse;
import software.amazon.awssdk.services.deadline.model.GetStepRequest;
import software.amazon.awssdk.services.deadline.model.GetStepResponse;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueRequest;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueResponse;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.GetTaskRequest;
import software.amazon.awssdk.services.deadline.model.GetTaskResponse;
import software.amazon.awssdk.services.deadline.model.GetWorkerRequest;
import software.amazon.awssdk.services.deadline.model.GetWorkerResponse;
import software.amazon.awssdk.services.deadline.model.InternalServerErrorException;
import software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest;
import software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse;
import software.amazon.awssdk.services.deadline.model.ListBudgetsRequest;
import software.amazon.awssdk.services.deadline.model.ListBudgetsResponse;
import software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListFarmsRequest;
import software.amazon.awssdk.services.deadline.model.ListFarmsResponse;
import software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListFleetsRequest;
import software.amazon.awssdk.services.deadline.model.ListFleetsResponse;
import software.amazon.awssdk.services.deadline.model.ListJobMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListJobMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListJobsRequest;
import software.amazon.awssdk.services.deadline.model.ListJobsResponse;
import software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest;
import software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse;
import software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest;
import software.amazon.awssdk.services.deadline.model.ListMeteredProductsResponse;
import software.amazon.awssdk.services.deadline.model.ListMonitorsRequest;
import software.amazon.awssdk.services.deadline.model.ListMonitorsResponse;
import software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse;
import software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse;
import software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListQueuesRequest;
import software.amazon.awssdk.services.deadline.model.ListQueuesResponse;
import software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse;
import software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.ListSessionsRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionsResponse;
import software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest;
import software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse;
import software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest;
import software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse;
import software.amazon.awssdk.services.deadline.model.ListStepsRequest;
import software.amazon.awssdk.services.deadline.model.ListStepsResponse;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesResponse;
import software.amazon.awssdk.services.deadline.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.deadline.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.deadline.model.ListTasksRequest;
import software.amazon.awssdk.services.deadline.model.ListTasksResponse;
import software.amazon.awssdk.services.deadline.model.ListWorkersRequest;
import software.amazon.awssdk.services.deadline.model.ListWorkersResponse;
import software.amazon.awssdk.services.deadline.model.PutMeteredProductRequest;
import software.amazon.awssdk.services.deadline.model.PutMeteredProductResponse;
import software.amazon.awssdk.services.deadline.model.ResourceNotFoundException;
import software.amazon.awssdk.services.deadline.model.SearchJobsRequest;
import software.amazon.awssdk.services.deadline.model.SearchJobsResponse;
import software.amazon.awssdk.services.deadline.model.SearchStepsRequest;
import software.amazon.awssdk.services.deadline.model.SearchStepsResponse;
import software.amazon.awssdk.services.deadline.model.SearchTasksRequest;
import software.amazon.awssdk.services.deadline.model.SearchTasksResponse;
import software.amazon.awssdk.services.deadline.model.SearchWorkersRequest;
import software.amazon.awssdk.services.deadline.model.SearchWorkersResponse;
import software.amazon.awssdk.services.deadline.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationRequest;
import software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationResponse;
import software.amazon.awssdk.services.deadline.model.TagResourceRequest;
import software.amazon.awssdk.services.deadline.model.TagResourceResponse;
import software.amazon.awssdk.services.deadline.model.ThrottlingException;
import software.amazon.awssdk.services.deadline.model.UntagResourceRequest;
import software.amazon.awssdk.services.deadline.model.UntagResourceResponse;
import software.amazon.awssdk.services.deadline.model.UpdateBudgetRequest;
import software.amazon.awssdk.services.deadline.model.UpdateBudgetResponse;
import software.amazon.awssdk.services.deadline.model.UpdateFarmRequest;
import software.amazon.awssdk.services.deadline.model.UpdateFarmResponse;
import software.amazon.awssdk.services.deadline.model.UpdateFleetRequest;
import software.amazon.awssdk.services.deadline.model.UpdateFleetResponse;
import software.amazon.awssdk.services.deadline.model.UpdateJobRequest;
import software.amazon.awssdk.services.deadline.model.UpdateJobResponse;
import software.amazon.awssdk.services.deadline.model.UpdateMonitorRequest;
import software.amazon.awssdk.services.deadline.model.UpdateMonitorResponse;
import software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.UpdateQueueRequest;
import software.amazon.awssdk.services.deadline.model.UpdateQueueResponse;
import software.amazon.awssdk.services.deadline.model.UpdateSessionRequest;
import software.amazon.awssdk.services.deadline.model.UpdateSessionResponse;
import software.amazon.awssdk.services.deadline.model.UpdateStepRequest;
import software.amazon.awssdk.services.deadline.model.UpdateStepResponse;
import software.amazon.awssdk.services.deadline.model.UpdateStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.UpdateStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.UpdateTaskRequest;
import software.amazon.awssdk.services.deadline.model.UpdateTaskResponse;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerRequest;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerResponse;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleRequest;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleResponse;
import software.amazon.awssdk.services.deadline.model.ValidationException;
import software.amazon.awssdk.services.deadline.paginators.GetSessionsStatisticsAggregationIterable;
import software.amazon.awssdk.services.deadline.paginators.ListAvailableMeteredProductsIterable;
import software.amazon.awssdk.services.deadline.paginators.ListBudgetsIterable;
import software.amazon.awssdk.services.deadline.paginators.ListFarmMembersIterable;
import software.amazon.awssdk.services.deadline.paginators.ListFarmsIterable;
import software.amazon.awssdk.services.deadline.paginators.ListFleetMembersIterable;
import software.amazon.awssdk.services.deadline.paginators.ListFleetsIterable;
import software.amazon.awssdk.services.deadline.paginators.ListJobMembersIterable;
import software.amazon.awssdk.services.deadline.paginators.ListJobsIterable;
import software.amazon.awssdk.services.deadline.paginators.ListLicenseEndpointsIterable;
import software.amazon.awssdk.services.deadline.paginators.ListMeteredProductsIterable;
import software.amazon.awssdk.services.deadline.paginators.ListMonitorsIterable;
import software.amazon.awssdk.services.deadline.paginators.ListQueueEnvironmentsIterable;
import software.amazon.awssdk.services.deadline.paginators.ListQueueFleetAssociationsIterable;
import software.amazon.awssdk.services.deadline.paginators.ListQueueMembersIterable;
import software.amazon.awssdk.services.deadline.paginators.ListQueuesIterable;
import software.amazon.awssdk.services.deadline.paginators.ListSessionActionsIterable;
import software.amazon.awssdk.services.deadline.paginators.ListSessionsForWorkerIterable;
import software.amazon.awssdk.services.deadline.paginators.ListSessionsIterable;
import software.amazon.awssdk.services.deadline.paginators.ListStepConsumersIterable;
import software.amazon.awssdk.services.deadline.paginators.ListStepDependenciesIterable;
import software.amazon.awssdk.services.deadline.paginators.ListStepsIterable;
import software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesForQueueIterable;
import software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesIterable;
import software.amazon.awssdk.services.deadline.paginators.ListTasksIterable;
import software.amazon.awssdk.services.deadline.paginators.ListWorkersIterable;
import software.amazon.awssdk.services.deadline.waiters.DeadlineWaiter;

/**
 * Service client for accessing AWSDeadlineCloud. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The Amazon Web Services Deadline Cloud API provides infrastructure and centralized management for your projects. Use
 * the Deadline Cloud API to onboard users, assign projects, and attach permissions specific to their job function.
 * </p>
 * <p>
 * With Deadline Cloud, content production teams can deploy resources for their workforce securely in the cloud,
 * reducing the costs of added physical infrastructure. Keep your content production operations secure, while allowing
 * your contributors to access the tools they need, such as scalable high-speed storage, licenses, and cost management
 * services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DeadlineClient extends AwsClient {
    String SERVICE_NAME = "deadline";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "deadline";

    /**
     * <p>
     * Assigns a farm membership level to a member.
     * </p>
     *
     * @param associateMemberToFarmRequest
     * @return Result of the AssociateMemberToFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssociateMemberToFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFarm"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMemberToFarmResponse associateMemberToFarm(AssociateMemberToFarmRequest associateMemberToFarmRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a farm membership level to a member.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberToFarmRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateMemberToFarmRequest#builder()}
     * </p>
     *
     * @param associateMemberToFarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssociateMemberToFarmRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateMemberToFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssociateMemberToFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFarm"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMemberToFarmResponse associateMemberToFarm(
            Consumer<AssociateMemberToFarmRequest.Builder> associateMemberToFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return associateMemberToFarm(AssociateMemberToFarmRequest.builder().applyMutation(associateMemberToFarmRequest).build());
    }

    /**
     * <p>
     * Assigns a fleet membership level to a member.
     * </p>
     *
     * @param associateMemberToFleetRequest
     * @return Result of the AssociateMemberToFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssociateMemberToFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMemberToFleetResponse associateMemberToFleet(AssociateMemberToFleetRequest associateMemberToFleetRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a fleet membership level to a member.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberToFleetRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateMemberToFleetRequest#builder()}
     * </p>
     *
     * @param associateMemberToFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssociateMemberToFleetRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateMemberToFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssociateMemberToFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMemberToFleetResponse associateMemberToFleet(
            Consumer<AssociateMemberToFleetRequest.Builder> associateMemberToFleetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return associateMemberToFleet(AssociateMemberToFleetRequest.builder().applyMutation(associateMemberToFleetRequest)
                .build());
    }

    /**
     * <p>
     * Assigns a job membership level to a member
     * </p>
     *
     * @param associateMemberToJobRequest
     * @return Result of the AssociateMemberToJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssociateMemberToJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToJob" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateMemberToJobResponse associateMemberToJob(AssociateMemberToJobRequest associateMemberToJobRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a job membership level to a member
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberToJobRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateMemberToJobRequest#builder()}
     * </p>
     *
     * @param associateMemberToJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssociateMemberToJobRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateMemberToJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssociateMemberToJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToJob" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateMemberToJobResponse associateMemberToJob(
            Consumer<AssociateMemberToJobRequest.Builder> associateMemberToJobRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return associateMemberToJob(AssociateMemberToJobRequest.builder().applyMutation(associateMemberToJobRequest).build());
    }

    /**
     * <p>
     * Assigns a queue membership level to a member
     * </p>
     *
     * @param associateMemberToQueueRequest
     * @return Result of the AssociateMemberToQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssociateMemberToQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMemberToQueueResponse associateMemberToQueue(AssociateMemberToQueueRequest associateMemberToQueueRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a queue membership level to a member
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberToQueueRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateMemberToQueueRequest#builder()}
     * </p>
     *
     * @param associateMemberToQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssociateMemberToQueueRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateMemberToQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssociateMemberToQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMemberToQueueResponse associateMemberToQueue(
            Consumer<AssociateMemberToQueueRequest.Builder> associateMemberToQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return associateMemberToQueue(AssociateMemberToQueueRequest.builder().applyMutation(associateMemberToQueueRequest)
                .build());
    }

    /**
     * <p>
     * Get Amazon Web Services credentials from the fleet role. The IAM permissions of the credentials are scoped down
     * to have read-only access.
     * </p>
     *
     * @param assumeFleetRoleForReadRequest
     * @return Result of the AssumeFleetRoleForRead operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeFleetRoleForRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForRead"
     *      target="_top">AWS API Documentation</a>
     */
    default AssumeFleetRoleForReadResponse assumeFleetRoleForRead(AssumeFleetRoleForReadRequest assumeFleetRoleForReadRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get Amazon Web Services credentials from the fleet role. The IAM permissions of the credentials are scoped down
     * to have read-only access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssumeFleetRoleForReadRequest.Builder} avoiding the
     * need to create one manually via {@link AssumeFleetRoleForReadRequest#builder()}
     * </p>
     *
     * @param assumeFleetRoleForReadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadRequest.Builder} to create a
     *        request.
     * @return Result of the AssumeFleetRoleForRead operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeFleetRoleForRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForRead"
     *      target="_top">AWS API Documentation</a>
     */
    default AssumeFleetRoleForReadResponse assumeFleetRoleForRead(
            Consumer<AssumeFleetRoleForReadRequest.Builder> assumeFleetRoleForReadRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return assumeFleetRoleForRead(AssumeFleetRoleForReadRequest.builder().applyMutation(assumeFleetRoleForReadRequest)
                .build());
    }

    /**
     * <p>
     * Get credentials from the fleet role for a worker.
     * </p>
     *
     * @param assumeFleetRoleForWorkerRequest
     * @return Result of the AssumeFleetRoleForWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeFleetRoleForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default AssumeFleetRoleForWorkerResponse assumeFleetRoleForWorker(
            AssumeFleetRoleForWorkerRequest assumeFleetRoleForWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get credentials from the fleet role for a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssumeFleetRoleForWorkerRequest.Builder} avoiding
     * the need to create one manually via {@link AssumeFleetRoleForWorkerRequest#builder()}
     * </p>
     *
     * @param assumeFleetRoleForWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForWorkerRequest.Builder} to create a
     *        request.
     * @return Result of the AssumeFleetRoleForWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeFleetRoleForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default AssumeFleetRoleForWorkerResponse assumeFleetRoleForWorker(
            Consumer<AssumeFleetRoleForWorkerRequest.Builder> assumeFleetRoleForWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return assumeFleetRoleForWorker(AssumeFleetRoleForWorkerRequest.builder().applyMutation(assumeFleetRoleForWorkerRequest)
                .build());
    }

    /**
     * <p>
     * Gets Amazon Web Services credentials from the queue role. The IAM permissions of the credentials are scoped down
     * to have read-only access.
     * </p>
     *
     * @param assumeQueueRoleForReadRequest
     * @return Result of the AssumeQueueRoleForRead operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeQueueRoleForRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForRead"
     *      target="_top">AWS API Documentation</a>
     */
    default AssumeQueueRoleForReadResponse assumeQueueRoleForRead(AssumeQueueRoleForReadRequest assumeQueueRoleForReadRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets Amazon Web Services credentials from the queue role. The IAM permissions of the credentials are scoped down
     * to have read-only access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssumeQueueRoleForReadRequest.Builder} avoiding the
     * need to create one manually via {@link AssumeQueueRoleForReadRequest#builder()}
     * </p>
     *
     * @param assumeQueueRoleForReadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadRequest.Builder} to create a
     *        request.
     * @return Result of the AssumeQueueRoleForRead operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeQueueRoleForRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForRead"
     *      target="_top">AWS API Documentation</a>
     */
    default AssumeQueueRoleForReadResponse assumeQueueRoleForRead(
            Consumer<AssumeQueueRoleForReadRequest.Builder> assumeQueueRoleForReadRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return assumeQueueRoleForRead(AssumeQueueRoleForReadRequest.builder().applyMutation(assumeQueueRoleForReadRequest)
                .build());
    }

    /**
     * <p>
     * Allows a user to assume a role for a queue.
     * </p>
     *
     * @param assumeQueueRoleForUserRequest
     * @return Result of the AssumeQueueRoleForUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeQueueRoleForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AssumeQueueRoleForUserResponse assumeQueueRoleForUser(AssumeQueueRoleForUserRequest assumeQueueRoleForUserRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a user to assume a role for a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssumeQueueRoleForUserRequest.Builder} avoiding the
     * need to create one manually via {@link AssumeQueueRoleForUserRequest#builder()}
     * </p>
     *
     * @param assumeQueueRoleForUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForUserRequest.Builder} to create a
     *        request.
     * @return Result of the AssumeQueueRoleForUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeQueueRoleForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AssumeQueueRoleForUserResponse assumeQueueRoleForUser(
            Consumer<AssumeQueueRoleForUserRequest.Builder> assumeQueueRoleForUserRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return assumeQueueRoleForUser(AssumeQueueRoleForUserRequest.builder().applyMutation(assumeQueueRoleForUserRequest)
                .build());
    }

    /**
     * <p>
     * Allows a worker to assume a queue role.
     * </p>
     *
     * @param assumeQueueRoleForWorkerRequest
     * @return Result of the AssumeQueueRoleForWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeQueueRoleForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default AssumeQueueRoleForWorkerResponse assumeQueueRoleForWorker(
            AssumeQueueRoleForWorkerRequest assumeQueueRoleForWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a worker to assume a queue role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssumeQueueRoleForWorkerRequest.Builder} avoiding
     * the need to create one manually via {@link AssumeQueueRoleForWorkerRequest#builder()}
     * </p>
     *
     * @param assumeQueueRoleForWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerRequest.Builder} to create a
     *        request.
     * @return Result of the AssumeQueueRoleForWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeQueueRoleForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default AssumeQueueRoleForWorkerResponse assumeQueueRoleForWorker(
            Consumer<AssumeQueueRoleForWorkerRequest.Builder> assumeQueueRoleForWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return assumeQueueRoleForWorker(AssumeQueueRoleForWorkerRequest.builder().applyMutation(assumeQueueRoleForWorkerRequest)
                .build());
    }

    /**
     * <p>
     * Get batched job details for a worker.
     * </p>
     *
     * @param batchGetJobEntityRequest
     * @return Result of the BatchGetJobEntity operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.BatchGetJobEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/BatchGetJobEntity" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchGetJobEntityResponse batchGetJobEntity(BatchGetJobEntityRequest batchGetJobEntityRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get batched job details for a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetJobEntityRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetJobEntityRequest#builder()}
     * </p>
     *
     * @param batchGetJobEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.BatchGetJobEntityRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetJobEntity operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.BatchGetJobEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/BatchGetJobEntity" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchGetJobEntityResponse batchGetJobEntity(Consumer<BatchGetJobEntityRequest.Builder> batchGetJobEntityRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return batchGetJobEntity(BatchGetJobEntityRequest.builder().applyMutation(batchGetJobEntityRequest).build());
    }

    /**
     * <p>
     * Copies a job template to an Amazon S3 bucket.
     * </p>
     *
     * @param copyJobTemplateRequest
     * @return Result of the CopyJobTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CopyJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CopyJobTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyJobTemplateResponse copyJobTemplate(CopyJobTemplateRequest copyJobTemplateRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies a job template to an Amazon S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyJobTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link CopyJobTemplateRequest#builder()}
     * </p>
     *
     * @param copyJobTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CopyJobTemplateRequest.Builder} to create a request.
     * @return Result of the CopyJobTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CopyJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CopyJobTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyJobTemplateResponse copyJobTemplate(Consumer<CopyJobTemplateRequest.Builder> copyJobTemplateRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return copyJobTemplate(CopyJobTemplateRequest.builder().applyMutation(copyJobTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a budget to set spending thresholds for your rendering activity.
     * </p>
     *
     * @param createBudgetRequest
     * @return Result of the CreateBudget operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBudgetResponse createBudget(CreateBudgetRequest createBudgetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a budget to set spending thresholds for your rendering activity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBudgetRequest#builder()}
     * </p>
     *
     * @param createBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateBudgetRequest.Builder} to create a request.
     * @return Result of the CreateBudget operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBudgetResponse createBudget(Consumer<CreateBudgetRequest.Builder> createBudgetRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return createBudget(CreateBudgetRequest.builder().applyMutation(createBudgetRequest).build());
    }

    /**
     * <p>
     * Creates a farm to allow space for queues and fleets. Farms are the space where the components of your renders
     * gather and are pieced together in the cloud. Farms contain budgets and allow you to enforce permissions. Deadline
     * Cloud farms are a useful container for large projects.
     * </p>
     *
     * @param createFarmRequest
     * @return Result of the CreateFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFarmResponse createFarm(CreateFarmRequest createFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a farm to allow space for queues and fleets. Farms are the space where the components of your renders
     * gather and are pieced together in the cloud. Farms contain budgets and allow you to enforce permissions. Deadline
     * Cloud farms are a useful container for large projects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFarmRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFarmRequest#builder()}
     * </p>
     *
     * @param createFarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateFarmRequest.Builder} to create a request.
     * @return Result of the CreateFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFarmResponse createFarm(Consumer<CreateFarmRequest.Builder> createFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return createFarm(CreateFarmRequest.builder().applyMutation(createFarmRequest).build());
    }

    /**
     * <p>
     * Creates a fleet. Fleets gather information relating to compute, or capacity, for renders within your farms. You
     * can choose to manage your own capacity or opt to have fleets fully managed by Deadline Cloud.
     * </p>
     *
     * @param createFleetRequest
     * @return Result of the CreateFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet. Fleets gather information relating to compute, or capacity, for renders within your farms. You
     * can choose to manage your own capacity or opt to have fleets fully managed by Deadline Cloud.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateFleetRequest.Builder} to create a request.
     * @return Result of the CreateFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * Creates a job. A job is a set of instructions that AWS Deadline Cloud uses to schedule and run work on available
     * workers. For more information, see <a
     * href="https://docs.aws.amazon.com/deadline-cloud/latest/userguide/deadline-cloud-jobs.html">Deadline Cloud
     * jobs</a>.
     * </p>
     *
     * @param createJobRequest
     * @return Result of the CreateJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateJobResponse createJob(CreateJobRequest createJobRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job. A job is a set of instructions that AWS Deadline Cloud uses to schedule and run work on available
     * workers. For more information, see <a
     * href="https://docs.aws.amazon.com/deadline-cloud/latest/userguide/deadline-cloud-jobs.html">Deadline Cloud
     * jobs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJobRequest#builder()}
     * </p>
     *
     * @param createJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateJobRequest.Builder} to create a request.
     * @return Result of the CreateJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateJobResponse createJob(Consumer<CreateJobRequest.Builder> createJobRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return createJob(CreateJobRequest.builder().applyMutation(createJobRequest).build());
    }

    /**
     * <p>
     * Creates a license endpoint to integrate your various licensed software used for rendering on Deadline Cloud.
     * </p>
     *
     * @param createLicenseEndpointRequest
     * @return Result of the CreateLicenseEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateLicenseEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLicenseEndpointResponse createLicenseEndpoint(CreateLicenseEndpointRequest createLicenseEndpointRequest)
            throws AccessDeniedException, InternalServerErrorException, ThrottlingException, ConflictException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a license endpoint to integrate your various licensed software used for rendering on Deadline Cloud.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLicenseEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLicenseEndpointRequest#builder()}
     * </p>
     *
     * @param createLicenseEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLicenseEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateLicenseEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLicenseEndpointResponse createLicenseEndpoint(
            Consumer<CreateLicenseEndpointRequest.Builder> createLicenseEndpointRequest) throws AccessDeniedException,
            InternalServerErrorException, ThrottlingException, ConflictException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return createLicenseEndpoint(CreateLicenseEndpointRequest.builder().applyMutation(createLicenseEndpointRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Web Services Deadline Cloud monitor that you can use to view your farms, queues, and fleets.
     * After you submit a job, you can track the progress of the tasks and steps that make up the job, and then download
     * the job's results.
     * </p>
     *
     * @param createMonitorRequest
     * @return Result of the CreateMonitor operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMonitorResponse createMonitor(CreateMonitorRequest createMonitorRequest) throws AccessDeniedException,
            InternalServerErrorException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Web Services Deadline Cloud monitor that you can use to view your farms, queues, and fleets.
     * After you submit a job, you can track the progress of the tasks and steps that make up the job, and then download
     * the job's results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMonitorRequest#builder()}
     * </p>
     *
     * @param createMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateMonitorRequest.Builder} to create a request.
     * @return Result of the CreateMonitor operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMonitorResponse createMonitor(Consumer<CreateMonitorRequest.Builder> createMonitorRequest)
            throws AccessDeniedException, InternalServerErrorException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return createMonitor(CreateMonitorRequest.builder().applyMutation(createMonitorRequest).build());
    }

    /**
     * <p>
     * Creates a queue to coordinate the order in which jobs run on a farm. A queue can also specify where to pull
     * resources and indicate where to output completed jobs.
     * </p>
     *
     * @param createQueueRequest
     * @return Result of the CreateQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateQueueResponse createQueue(CreateQueueRequest createQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a queue to coordinate the order in which jobs run on a farm. A queue can also specify where to pull
     * resources and indicate where to output completed jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQueueRequest.Builder} avoiding the need to
     * create one manually via {@link CreateQueueRequest#builder()}
     * </p>
     *
     * @param createQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateQueueRequest.Builder} to create a request.
     * @return Result of the CreateQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateQueueResponse createQueue(Consumer<CreateQueueRequest.Builder> createQueueRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return createQueue(CreateQueueRequest.builder().applyMutation(createQueueRequest).build());
    }

    /**
     * <p>
     * Creates an environment for a queue that defines how jobs in the queue run.
     * </p>
     *
     * @param createQueueEnvironmentRequest
     * @return Result of the CreateQueueEnvironment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateQueueEnvironmentResponse createQueueEnvironment(CreateQueueEnvironmentRequest createQueueEnvironmentRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an environment for a queue that defines how jobs in the queue run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQueueEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link CreateQueueEnvironmentRequest#builder()}
     * </p>
     *
     * @param createQueueEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentRequest.Builder} to create a
     *        request.
     * @return Result of the CreateQueueEnvironment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateQueueEnvironmentResponse createQueueEnvironment(
            Consumer<CreateQueueEnvironmentRequest.Builder> createQueueEnvironmentRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return createQueueEnvironment(CreateQueueEnvironmentRequest.builder().applyMutation(createQueueEnvironmentRequest)
                .build());
    }

    /**
     * <p>
     * Creates an association between a queue and a fleet.
     * </p>
     *
     * @param createQueueFleetAssociationRequest
     * @return Result of the CreateQueueFleetAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateQueueFleetAssociationResponse createQueueFleetAssociation(
            CreateQueueFleetAssociationRequest createQueueFleetAssociationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between a queue and a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQueueFleetAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateQueueFleetAssociationRequest#builder()}
     * </p>
     *
     * @param createQueueFleetAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateQueueFleetAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateQueueFleetAssociationResponse createQueueFleetAssociation(
            Consumer<CreateQueueFleetAssociationRequest.Builder> createQueueFleetAssociationRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return createQueueFleetAssociation(CreateQueueFleetAssociationRequest.builder()
                .applyMutation(createQueueFleetAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a storage profile that specifies the operating system, file type, and file location of resources used on
     * a farm.
     * </p>
     *
     * @param createStorageProfileRequest
     * @return Result of the CreateStorageProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateStorageProfileResponse createStorageProfile(CreateStorageProfileRequest createStorageProfileRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a storage profile that specifies the operating system, file type, and file location of resources used on
     * a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStorageProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStorageProfileRequest#builder()}
     * </p>
     *
     * @param createStorageProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateStorageProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateStorageProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateStorageProfileResponse createStorageProfile(
            Consumer<CreateStorageProfileRequest.Builder> createStorageProfileRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return createStorageProfile(CreateStorageProfileRequest.builder().applyMutation(createStorageProfileRequest).build());
    }

    /**
     * <p>
     * Creates a worker. A worker tells your instance how much processing power (vCPU), and memory (GiB) you’ll need to
     * assemble the digital assets held within a particular instance. You can specify certain instance types to use, or
     * let the worker know which instances types to exclude.
     * </p>
     *
     * @param createWorkerRequest
     * @return Result of the CreateWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkerResponse createWorker(CreateWorkerRequest createWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a worker. A worker tells your instance how much processing power (vCPU), and memory (GiB) you’ll need to
     * assemble the digital assets held within a particular instance. You can specify certain instance types to use, or
     * let the worker know which instances types to exclude.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkerRequest#builder()}
     * </p>
     *
     * @param createWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateWorkerRequest.Builder} to create a request.
     * @return Result of the CreateWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkerResponse createWorker(Consumer<CreateWorkerRequest.Builder> createWorkerRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return createWorker(CreateWorkerRequest.builder().applyMutation(createWorkerRequest).build());
    }

    /**
     * <p>
     * Deletes a budget.
     * </p>
     *
     * @param deleteBudgetRequest
     * @return Result of the DeleteBudget operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBudgetResponse deleteBudget(DeleteBudgetRequest deleteBudgetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a budget.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBudgetRequest#builder()}
     * </p>
     *
     * @param deleteBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteBudgetRequest.Builder} to create a request.
     * @return Result of the DeleteBudget operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBudgetResponse deleteBudget(Consumer<DeleteBudgetRequest.Builder> deleteBudgetRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return deleteBudget(DeleteBudgetRequest.builder().applyMutation(deleteBudgetRequest).build());
    }

    /**
     * <p>
     * Deletes a farm.
     * </p>
     *
     * @param deleteFarmRequest
     * @return Result of the DeleteFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFarmResponse deleteFarm(DeleteFarmRequest deleteFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFarmRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFarmRequest#builder()}
     * </p>
     *
     * @param deleteFarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteFarmRequest.Builder} to create a request.
     * @return Result of the DeleteFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFarmResponse deleteFarm(Consumer<DeleteFarmRequest.Builder> deleteFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return deleteFarm(DeleteFarmRequest.builder().applyMutation(deleteFarmRequest).build());
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     *
     * @param deleteFleetRequest
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteFleetRequest.Builder} to create a request.
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * <p>
     * Deletes a license endpoint.
     * </p>
     *
     * @param deleteLicenseEndpointRequest
     * @return Result of the DeleteLicenseEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteLicenseEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLicenseEndpointResponse deleteLicenseEndpoint(DeleteLicenseEndpointRequest deleteLicenseEndpointRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a license endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLicenseEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLicenseEndpointRequest#builder()}
     * </p>
     *
     * @param deleteLicenseEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLicenseEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteLicenseEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLicenseEndpointResponse deleteLicenseEndpoint(
            Consumer<DeleteLicenseEndpointRequest.Builder> deleteLicenseEndpointRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return deleteLicenseEndpoint(DeleteLicenseEndpointRequest.builder().applyMutation(deleteLicenseEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes a metered product.
     * </p>
     *
     * @param deleteMeteredProductRequest
     * @return Result of the DeleteMeteredProduct operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteMeteredProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMeteredProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteMeteredProductResponse deleteMeteredProduct(DeleteMeteredProductRequest deleteMeteredProductRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a metered product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMeteredProductRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMeteredProductRequest#builder()}
     * </p>
     *
     * @param deleteMeteredProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteMeteredProductRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteMeteredProduct operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteMeteredProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMeteredProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteMeteredProductResponse deleteMeteredProduct(
            Consumer<DeleteMeteredProductRequest.Builder> deleteMeteredProductRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return deleteMeteredProduct(DeleteMeteredProductRequest.builder().applyMutation(deleteMeteredProductRequest).build());
    }

    /**
     * <p>
     * Removes a Deadline Cloud monitor. After you delete a monitor, you can create a new one and attach farms to the
     * monitor.
     * </p>
     *
     * @param deleteMonitorRequest
     * @return Result of the DeleteMonitor operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMonitorResponse deleteMonitor(DeleteMonitorRequest deleteMonitorRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a Deadline Cloud monitor. After you delete a monitor, you can create a new one and attach farms to the
     * monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMonitorRequest#builder()}
     * </p>
     *
     * @param deleteMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteMonitorRequest.Builder} to create a request.
     * @return Result of the DeleteMonitor operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMonitorResponse deleteMonitor(Consumer<DeleteMonitorRequest.Builder> deleteMonitorRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return deleteMonitor(DeleteMonitorRequest.builder().applyMutation(deleteMonitorRequest).build());
    }

    /**
     * <p>
     * Deletes a queue.
     * </p>
     * <important>
     * <p>
     * You can't recover the jobs in a queue if you delete the queue. Deleting the queue also deletes the jobs in that
     * queue.
     * </p>
     * </important>
     *
     * @param deleteQueueRequest
     * @return Result of the DeleteQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteQueueResponse deleteQueue(DeleteQueueRequest deleteQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a queue.
     * </p>
     * <important>
     * <p>
     * You can't recover the jobs in a queue if you delete the queue. Deleting the queue also deletes the jobs in that
     * queue.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueueRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteQueueRequest#builder()}
     * </p>
     *
     * @param deleteQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteQueueRequest.Builder} to create a request.
     * @return Result of the DeleteQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteQueueResponse deleteQueue(Consumer<DeleteQueueRequest.Builder> deleteQueueRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return deleteQueue(DeleteQueueRequest.builder().applyMutation(deleteQueueRequest).build());
    }

    /**
     * <p>
     * Deletes a queue environment.
     * </p>
     *
     * @param deleteQueueEnvironmentRequest
     * @return Result of the DeleteQueueEnvironment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteQueueEnvironmentResponse deleteQueueEnvironment(DeleteQueueEnvironmentRequest deleteQueueEnvironmentRequest)
            throws AccessDeniedException, InternalServerErrorException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a queue environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueueEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteQueueEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteQueueEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteQueueEnvironment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteQueueEnvironmentResponse deleteQueueEnvironment(
            Consumer<DeleteQueueEnvironmentRequest.Builder> deleteQueueEnvironmentRequest) throws AccessDeniedException,
            InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        return deleteQueueEnvironment(DeleteQueueEnvironmentRequest.builder().applyMutation(deleteQueueEnvironmentRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a queue-fleet association.
     * </p>
     *
     * @param deleteQueueFleetAssociationRequest
     * @return Result of the DeleteQueueFleetAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteQueueFleetAssociationResponse deleteQueueFleetAssociation(
            DeleteQueueFleetAssociationRequest deleteQueueFleetAssociationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a queue-fleet association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueueFleetAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteQueueFleetAssociationRequest#builder()}
     * </p>
     *
     * @param deleteQueueFleetAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteQueueFleetAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteQueueFleetAssociationResponse deleteQueueFleetAssociation(
            Consumer<DeleteQueueFleetAssociationRequest.Builder> deleteQueueFleetAssociationRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return deleteQueueFleetAssociation(DeleteQueueFleetAssociationRequest.builder()
                .applyMutation(deleteQueueFleetAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes a storage profile.
     * </p>
     *
     * @param deleteStorageProfileRequest
     * @return Result of the DeleteStorageProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteStorageProfileResponse deleteStorageProfile(DeleteStorageProfileRequest deleteStorageProfileRequest)
            throws AccessDeniedException, InternalServerErrorException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a storage profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStorageProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteStorageProfileRequest#builder()}
     * </p>
     *
     * @param deleteStorageProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteStorageProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteStorageProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteStorageProfileResponse deleteStorageProfile(
            Consumer<DeleteStorageProfileRequest.Builder> deleteStorageProfileRequest) throws AccessDeniedException,
            InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        return deleteStorageProfile(DeleteStorageProfileRequest.builder().applyMutation(deleteStorageProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a worker.
     * </p>
     *
     * @param deleteWorkerRequest
     * @return Result of the DeleteWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkerResponse deleteWorker(DeleteWorkerRequest deleteWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkerRequest#builder()}
     * </p>
     *
     * @param deleteWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteWorkerRequest.Builder} to create a request.
     * @return Result of the DeleteWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkerResponse deleteWorker(Consumer<DeleteWorkerRequest.Builder> deleteWorkerRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return deleteWorker(DeleteWorkerRequest.builder().applyMutation(deleteWorkerRequest).build());
    }

    /**
     * <p>
     * Disassociates a member from a farm.
     * </p>
     *
     * @param disassociateMemberFromFarmRequest
     * @return Result of the DisassociateMemberFromFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DisassociateMemberFromFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFarm"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMemberFromFarmResponse disassociateMemberFromFarm(
            DisassociateMemberFromFarmRequest disassociateMemberFromFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a member from a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberFromFarmRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateMemberFromFarmRequest#builder()}
     * </p>
     *
     * @param disassociateMemberFromFarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmRequest.Builder} to create
     *        a request.
     * @return Result of the DisassociateMemberFromFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DisassociateMemberFromFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFarm"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMemberFromFarmResponse disassociateMemberFromFarm(
            Consumer<DisassociateMemberFromFarmRequest.Builder> disassociateMemberFromFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return disassociateMemberFromFarm(DisassociateMemberFromFarmRequest.builder()
                .applyMutation(disassociateMemberFromFarmRequest).build());
    }

    /**
     * <p>
     * Disassociates a member from a fleet.
     * </p>
     *
     * @param disassociateMemberFromFleetRequest
     * @return Result of the DisassociateMemberFromFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DisassociateMemberFromFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMemberFromFleetResponse disassociateMemberFromFleet(
            DisassociateMemberFromFleetRequest disassociateMemberFromFleetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a member from a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberFromFleetRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateMemberFromFleetRequest#builder()}
     * </p>
     *
     * @param disassociateMemberFromFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateMemberFromFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DisassociateMemberFromFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMemberFromFleetResponse disassociateMemberFromFleet(
            Consumer<DisassociateMemberFromFleetRequest.Builder> disassociateMemberFromFleetRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return disassociateMemberFromFleet(DisassociateMemberFromFleetRequest.builder()
                .applyMutation(disassociateMemberFromFleetRequest).build());
    }

    /**
     * <p>
     * Disassociates a member from a job.
     * </p>
     *
     * @param disassociateMemberFromJobRequest
     * @return Result of the DisassociateMemberFromJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DisassociateMemberFromJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMemberFromJobResponse disassociateMemberFromJob(
            DisassociateMemberFromJobRequest disassociateMemberFromJobRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a member from a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberFromJobRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateMemberFromJobRequest#builder()}
     * </p>
     *
     * @param disassociateMemberFromJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobRequest.Builder} to create
     *        a request.
     * @return Result of the DisassociateMemberFromJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DisassociateMemberFromJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMemberFromJobResponse disassociateMemberFromJob(
            Consumer<DisassociateMemberFromJobRequest.Builder> disassociateMemberFromJobRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return disassociateMemberFromJob(DisassociateMemberFromJobRequest.builder()
                .applyMutation(disassociateMemberFromJobRequest).build());
    }

    /**
     * <p>
     * Disassociates a member from a queue.
     * </p>
     *
     * @param disassociateMemberFromQueueRequest
     * @return Result of the DisassociateMemberFromQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DisassociateMemberFromQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMemberFromQueueResponse disassociateMemberFromQueue(
            DisassociateMemberFromQueueRequest disassociateMemberFromQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a member from a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberFromQueueRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateMemberFromQueueRequest#builder()}
     * </p>
     *
     * @param disassociateMemberFromQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateMemberFromQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DisassociateMemberFromQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMemberFromQueueResponse disassociateMemberFromQueue(
            Consumer<DisassociateMemberFromQueueRequest.Builder> disassociateMemberFromQueueRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return disassociateMemberFromQueue(DisassociateMemberFromQueueRequest.builder()
                .applyMutation(disassociateMemberFromQueueRequest).build());
    }

    /**
     * <p>
     * Get a budget.
     * </p>
     *
     * @param getBudgetRequest
     * @return Result of the GetBudget operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBudgetResponse getBudget(GetBudgetRequest getBudgetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a budget.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link GetBudgetRequest#builder()}
     * </p>
     *
     * @param getBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetBudgetRequest.Builder} to create a request.
     * @return Result of the GetBudget operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBudgetResponse getBudget(Consumer<GetBudgetRequest.Builder> getBudgetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return getBudget(GetBudgetRequest.builder().applyMutation(getBudgetRequest).build());
    }

    /**
     * <p>
     * Get a farm.
     * </p>
     *
     * @param getFarmRequest
     * @return Result of the GetFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFarmResponse getFarm(GetFarmRequest getFarmRequest) throws AccessDeniedException, InternalServerErrorException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFarmRequest.Builder} avoiding the need to create
     * one manually via {@link GetFarmRequest#builder()}
     * </p>
     *
     * @param getFarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetFarmRequest.Builder} to create a request.
     * @return Result of the GetFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFarmResponse getFarm(Consumer<GetFarmRequest.Builder> getFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return getFarm(GetFarmRequest.builder().applyMutation(getFarmRequest).build());
    }

    /**
     * <p>
     * Get a fleet.
     * </p>
     *
     * @param getFleetRequest
     * @return Result of the GetFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFleetResponse getFleet(GetFleetRequest getFleetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFleetRequest.Builder} avoiding the need to
     * create one manually via {@link GetFleetRequest#builder()}
     * </p>
     *
     * @param getFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetFleetRequest.Builder} to create a request.
     * @return Result of the GetFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFleetResponse getFleet(Consumer<GetFleetRequest.Builder> getFleetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return getFleet(GetFleetRequest.builder().applyMutation(getFleetRequest).build());
    }

    /**
     * <p>
     * Gets a Deadline Cloud job.
     * </p>
     *
     * @param getJobRequest
     * @return Result of the GetJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(GetJobRequest getJobRequest) throws AccessDeniedException, InternalServerErrorException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a Deadline Cloud job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobRequest#builder()}
     * </p>
     *
     * @param getJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetJobRequest.Builder} to create a request.
     * @return Result of the GetJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(Consumer<GetJobRequest.Builder> getJobRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return getJob(GetJobRequest.builder().applyMutation(getJobRequest).build());
    }

    /**
     * <p>
     * Gets a licence endpoint.
     * </p>
     *
     * @param getLicenseEndpointRequest
     * @return Result of the GetLicenseEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetLicenseEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLicenseEndpointResponse getLicenseEndpoint(GetLicenseEndpointRequest getLicenseEndpointRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a licence endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLicenseEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link GetLicenseEndpointRequest#builder()}
     * </p>
     *
     * @param getLicenseEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the GetLicenseEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetLicenseEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLicenseEndpointResponse getLicenseEndpoint(Consumer<GetLicenseEndpointRequest.Builder> getLicenseEndpointRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return getLicenseEndpoint(GetLicenseEndpointRequest.builder().applyMutation(getLicenseEndpointRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified monitor.
     * </p>
     *
     * @param getMonitorRequest
     * @return Result of the GetMonitor operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMonitorResponse getMonitor(GetMonitorRequest getMonitorRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link GetMonitorRequest#builder()}
     * </p>
     *
     * @param getMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetMonitorRequest.Builder} to create a request.
     * @return Result of the GetMonitor operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMonitorResponse getMonitor(Consumer<GetMonitorRequest.Builder> getMonitorRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return getMonitor(GetMonitorRequest.builder().applyMutation(getMonitorRequest).build());
    }

    /**
     * <p>
     * Gets a queue.
     * </p>
     *
     * @param getQueueRequest
     * @return Result of the GetQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQueueResponse getQueue(GetQueueRequest getQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueueRequest.Builder} avoiding the need to
     * create one manually via {@link GetQueueRequest#builder()}
     * </p>
     *
     * @param getQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetQueueRequest.Builder} to create a request.
     * @return Result of the GetQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQueueResponse getQueue(Consumer<GetQueueRequest.Builder> getQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return getQueue(GetQueueRequest.builder().applyMutation(getQueueRequest).build());
    }

    /**
     * <p>
     * Gets a queue environment.
     * </p>
     *
     * @param getQueueEnvironmentRequest
     * @return Result of the GetQueueEnvironment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default GetQueueEnvironmentResponse getQueueEnvironment(GetQueueEnvironmentRequest getQueueEnvironmentRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a queue environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueueEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link GetQueueEnvironmentRequest#builder()}
     * </p>
     *
     * @param getQueueEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentRequest.Builder} to create a
     *        request.
     * @return Result of the GetQueueEnvironment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default GetQueueEnvironmentResponse getQueueEnvironment(
            Consumer<GetQueueEnvironmentRequest.Builder> getQueueEnvironmentRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return getQueueEnvironment(GetQueueEnvironmentRequest.builder().applyMutation(getQueueEnvironmentRequest).build());
    }

    /**
     * <p>
     * Gets a queue-fleet association.
     * </p>
     *
     * @param getQueueFleetAssociationRequest
     * @return Result of the GetQueueFleetAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueueFleetAssociationResponse getQueueFleetAssociation(
            GetQueueFleetAssociationRequest getQueueFleetAssociationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a queue-fleet association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueueFleetAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link GetQueueFleetAssociationRequest#builder()}
     * </p>
     *
     * @param getQueueFleetAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationRequest.Builder} to create a
     *        request.
     * @return Result of the GetQueueFleetAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueueFleetAssociationResponse getQueueFleetAssociation(
            Consumer<GetQueueFleetAssociationRequest.Builder> getQueueFleetAssociationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return getQueueFleetAssociation(GetQueueFleetAssociationRequest.builder().applyMutation(getQueueFleetAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Gets a session.
     * </p>
     *
     * @param getSessionRequest
     * @return Result of the GetSession operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionRequest.Builder} avoiding the need to
     * create one manually via {@link GetSessionRequest#builder()}
     * </p>
     *
     * @param getSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetSessionRequest.Builder} to create a request.
     * @return Result of the GetSession operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSessionResponse getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return getSession(GetSessionRequest.builder().applyMutation(getSessionRequest).build());
    }

    /**
     * <p>
     * Gets a session action for the job.
     * </p>
     *
     * @param getSessionActionRequest
     * @return Result of the GetSessionAction operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetSessionAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionAction" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSessionActionResponse getSessionAction(GetSessionActionRequest getSessionActionRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a session action for the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionActionRequest.Builder} avoiding the need
     * to create one manually via {@link GetSessionActionRequest#builder()}
     * </p>
     *
     * @param getSessionActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetSessionActionRequest.Builder} to create a
     *        request.
     * @return Result of the GetSessionAction operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetSessionAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionAction" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSessionActionResponse getSessionAction(Consumer<GetSessionActionRequest.Builder> getSessionActionRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return getSessionAction(GetSessionActionRequest.builder().applyMutation(getSessionActionRequest).build());
    }

    /**
     * <p>
     * Gets a set of statistics for queues or farms. Before you can call the
     * <code>GetSessionStatisticsAggregation</code> operation, you must first call the
     * <code>StartSessionsStatisticsAggregation</code> operation. Statistics are available for 1 hour after you call the
     * <code>StartSessionsStatisticsAggregation</code> operation.
     * </p>
     *
     * @param getSessionsStatisticsAggregationRequest
     * @return Result of the GetSessionsStatisticsAggregation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSessionsStatisticsAggregationResponse getSessionsStatisticsAggregation(
            GetSessionsStatisticsAggregationRequest getSessionsStatisticsAggregationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a set of statistics for queues or farms. Before you can call the
     * <code>GetSessionStatisticsAggregation</code> operation, you must first call the
     * <code>StartSessionsStatisticsAggregation</code> operation. Statistics are available for 1 hour after you call the
     * <code>StartSessionsStatisticsAggregation</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionsStatisticsAggregationRequest.Builder}
     * avoiding the need to create one manually via {@link GetSessionsStatisticsAggregationRequest#builder()}
     * </p>
     *
     * @param getSessionsStatisticsAggregationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest.Builder} to
     *        create a request.
     * @return Result of the GetSessionsStatisticsAggregation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSessionsStatisticsAggregationResponse getSessionsStatisticsAggregation(
            Consumer<GetSessionsStatisticsAggregationRequest.Builder> getSessionsStatisticsAggregationRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return getSessionsStatisticsAggregation(GetSessionsStatisticsAggregationRequest.builder()
                .applyMutation(getSessionsStatisticsAggregationRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getSessionsStatisticsAggregation(software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.GetSessionsStatisticsAggregationIterable responses = client.getSessionsStatisticsAggregationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.GetSessionsStatisticsAggregationIterable responses = client
     *             .getSessionsStatisticsAggregationPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.GetSessionsStatisticsAggregationIterable responses = client.getSessionsStatisticsAggregationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSessionsStatisticsAggregation(software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSessionsStatisticsAggregationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSessionsStatisticsAggregationIterable getSessionsStatisticsAggregationPaginator(
            GetSessionsStatisticsAggregationRequest getSessionsStatisticsAggregationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return new GetSessionsStatisticsAggregationIterable(this, getSessionsStatisticsAggregationRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getSessionsStatisticsAggregation(software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.GetSessionsStatisticsAggregationIterable responses = client.getSessionsStatisticsAggregationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.GetSessionsStatisticsAggregationIterable responses = client
     *             .getSessionsStatisticsAggregationPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.GetSessionsStatisticsAggregationIterable responses = client.getSessionsStatisticsAggregationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSessionsStatisticsAggregation(software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionsStatisticsAggregationRequest.Builder}
     * avoiding the need to create one manually via {@link GetSessionsStatisticsAggregationRequest#builder()}
     * </p>
     *
     * @param getSessionsStatisticsAggregationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSessionsStatisticsAggregationIterable getSessionsStatisticsAggregationPaginator(
            Consumer<GetSessionsStatisticsAggregationRequest.Builder> getSessionsStatisticsAggregationRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return getSessionsStatisticsAggregationPaginator(GetSessionsStatisticsAggregationRequest.builder()
                .applyMutation(getSessionsStatisticsAggregationRequest).build());
    }

    /**
     * <p>
     * Gets a step.
     * </p>
     *
     * @param getStepRequest
     * @return Result of the GetStep operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStep" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStepResponse getStep(GetStepRequest getStepRequest) throws AccessDeniedException, InternalServerErrorException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a step.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStepRequest.Builder} avoiding the need to create
     * one manually via {@link GetStepRequest#builder()}
     * </p>
     *
     * @param getStepRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetStepRequest.Builder} to create a request.
     * @return Result of the GetStep operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStep" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStepResponse getStep(Consumer<GetStepRequest.Builder> getStepRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return getStep(GetStepRequest.builder().applyMutation(getStepRequest).build());
    }

    /**
     * <p>
     * Gets a storage profile.
     * </p>
     *
     * @param getStorageProfileRequest
     * @return Result of the GetStorageProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetStorageProfileResponse getStorageProfile(GetStorageProfileRequest getStorageProfileRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a storage profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStorageProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetStorageProfileRequest#builder()}
     * </p>
     *
     * @param getStorageProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetStorageProfileRequest.Builder} to create a
     *        request.
     * @return Result of the GetStorageProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetStorageProfileResponse getStorageProfile(Consumer<GetStorageProfileRequest.Builder> getStorageProfileRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return getStorageProfile(GetStorageProfileRequest.builder().applyMutation(getStorageProfileRequest).build());
    }

    /**
     * <p>
     * Gets a storage profile for a queue.
     * </p>
     *
     * @param getStorageProfileForQueueRequest
     * @return Result of the GetStorageProfileForQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetStorageProfileForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfileForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStorageProfileForQueueResponse getStorageProfileForQueue(
            GetStorageProfileForQueueRequest getStorageProfileForQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a storage profile for a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStorageProfileForQueueRequest.Builder} avoiding
     * the need to create one manually via {@link GetStorageProfileForQueueRequest#builder()}
     * </p>
     *
     * @param getStorageProfileForQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueRequest.Builder} to create
     *        a request.
     * @return Result of the GetStorageProfileForQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetStorageProfileForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfileForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStorageProfileForQueueResponse getStorageProfileForQueue(
            Consumer<GetStorageProfileForQueueRequest.Builder> getStorageProfileForQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return getStorageProfileForQueue(GetStorageProfileForQueueRequest.builder()
                .applyMutation(getStorageProfileForQueueRequest).build());
    }

    /**
     * <p>
     * Gets a task.
     * </p>
     *
     * @param getTaskRequest
     * @return Result of the GetTask operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetTask" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTaskResponse getTask(GetTaskRequest getTaskRequest) throws AccessDeniedException, InternalServerErrorException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTaskRequest.Builder} avoiding the need to create
     * one manually via {@link GetTaskRequest#builder()}
     * </p>
     *
     * @param getTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetTaskRequest.Builder} to create a request.
     * @return Result of the GetTask operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetTask" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTaskResponse getTask(Consumer<GetTaskRequest.Builder> getTaskRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return getTask(GetTaskRequest.builder().applyMutation(getTaskRequest).build());
    }

    /**
     * <p>
     * Gets a worker.
     * </p>
     *
     * @param getWorkerRequest
     * @return Result of the GetWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkerResponse getWorker(GetWorkerRequest getWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkerRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkerRequest#builder()}
     * </p>
     *
     * @param getWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetWorkerRequest.Builder} to create a request.
     * @return Result of the GetWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkerResponse getWorker(Consumer<GetWorkerRequest.Builder> getWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return getWorker(GetWorkerRequest.builder().applyMutation(getWorkerRequest).build());
    }

    /**
     * <p>
     * A list of the available metered products.
     * </p>
     *
     * @param listAvailableMeteredProductsRequest
     * @return Result of the ListAvailableMeteredProducts operation returned by the service.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListAvailableMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListAvailableMeteredProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableMeteredProductsResponse listAvailableMeteredProducts(
            ListAvailableMeteredProductsRequest listAvailableMeteredProductsRequest) throws InternalServerErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of the available metered products.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableMeteredProductsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableMeteredProductsRequest#builder()}
     * </p>
     *
     * @param listAvailableMeteredProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAvailableMeteredProducts operation returned by the service.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListAvailableMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListAvailableMeteredProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableMeteredProductsResponse listAvailableMeteredProducts(
            Consumer<ListAvailableMeteredProductsRequest.Builder> listAvailableMeteredProductsRequest)
            throws InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, DeadlineException {
        return listAvailableMeteredProducts(ListAvailableMeteredProductsRequest.builder()
                .applyMutation(listAvailableMeteredProductsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAvailableMeteredProducts(software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListAvailableMeteredProductsIterable responses = client.listAvailableMeteredProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListAvailableMeteredProductsIterable responses = client
     *             .listAvailableMeteredProductsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListAvailableMeteredProductsIterable responses = client.listAvailableMeteredProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAvailableMeteredProducts(software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAvailableMeteredProductsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListAvailableMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListAvailableMeteredProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableMeteredProductsIterable listAvailableMeteredProductsPaginator(
            ListAvailableMeteredProductsRequest listAvailableMeteredProductsRequest) throws InternalServerErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, DeadlineException {
        return new ListAvailableMeteredProductsIterable(this, listAvailableMeteredProductsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAvailableMeteredProducts(software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListAvailableMeteredProductsIterable responses = client.listAvailableMeteredProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListAvailableMeteredProductsIterable responses = client
     *             .listAvailableMeteredProductsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListAvailableMeteredProductsIterable responses = client.listAvailableMeteredProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAvailableMeteredProducts(software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableMeteredProductsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableMeteredProductsRequest#builder()}
     * </p>
     *
     * @param listAvailableMeteredProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListAvailableMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListAvailableMeteredProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableMeteredProductsIterable listAvailableMeteredProductsPaginator(
            Consumer<ListAvailableMeteredProductsRequest.Builder> listAvailableMeteredProductsRequest)
            throws InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, DeadlineException {
        return listAvailableMeteredProductsPaginator(ListAvailableMeteredProductsRequest.builder()
                .applyMutation(listAvailableMeteredProductsRequest).build());
    }

    /**
     * <p>
     * A list of budgets in a farm.
     * </p>
     *
     * @param listBudgetsRequest
     * @return Result of the ListBudgets operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListBudgets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListBudgets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBudgetsResponse listBudgets(ListBudgetsRequest listBudgetsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of budgets in a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBudgetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBudgetsRequest#builder()}
     * </p>
     *
     * @param listBudgetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListBudgetsRequest.Builder} to create a request.
     * @return Result of the ListBudgets operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListBudgets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListBudgets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBudgetsResponse listBudgets(Consumer<ListBudgetsRequest.Builder> listBudgetsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listBudgets(ListBudgetsRequest.builder().applyMutation(listBudgetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listBudgets(software.amazon.awssdk.services.deadline.model.ListBudgetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListBudgetsIterable responses = client.listBudgetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListBudgetsIterable responses = client.listBudgetsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListBudgetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListBudgetsIterable responses = client.listBudgetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBudgets(software.amazon.awssdk.services.deadline.model.ListBudgetsRequest)} operation.</b>
     * </p>
     *
     * @param listBudgetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListBudgets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListBudgets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBudgetsIterable listBudgetsPaginator(ListBudgetsRequest listBudgetsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return new ListBudgetsIterable(this, listBudgetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listBudgets(software.amazon.awssdk.services.deadline.model.ListBudgetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListBudgetsIterable responses = client.listBudgetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListBudgetsIterable responses = client.listBudgetsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListBudgetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListBudgetsIterable responses = client.listBudgetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBudgets(software.amazon.awssdk.services.deadline.model.ListBudgetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBudgetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBudgetsRequest#builder()}
     * </p>
     *
     * @param listBudgetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListBudgetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListBudgets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListBudgets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBudgetsIterable listBudgetsPaginator(Consumer<ListBudgetsRequest.Builder> listBudgetsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listBudgetsPaginator(ListBudgetsRequest.builder().applyMutation(listBudgetsRequest).build());
    }

    /**
     * <p>
     * Lists the members of a farm.
     * </p>
     *
     * @param listFarmMembersRequest
     * @return Result of the ListFarmMembers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFarmMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarmMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFarmMembersResponse listFarmMembers(ListFarmMembersRequest listFarmMembersRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the members of a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFarmMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListFarmMembersRequest#builder()}
     * </p>
     *
     * @param listFarmMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest.Builder} to create a request.
     * @return Result of the ListFarmMembers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFarmMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarmMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFarmMembersResponse listFarmMembers(Consumer<ListFarmMembersRequest.Builder> listFarmMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listFarmMembers(ListFarmMembersRequest.builder().applyMutation(listFarmMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFarmMembers(software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmMembersIterable responses = client.listFarmMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListFarmMembersIterable responses = client
     *             .listFarmMembersPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmMembersIterable responses = client.listFarmMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFarmMembers(software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest)} operation.</b>
     * </p>
     *
     * @param listFarmMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFarmMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarmMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFarmMembersIterable listFarmMembersPaginator(ListFarmMembersRequest listFarmMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return new ListFarmMembersIterable(this, listFarmMembersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFarmMembers(software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmMembersIterable responses = client.listFarmMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListFarmMembersIterable responses = client
     *             .listFarmMembersPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmMembersIterable responses = client.listFarmMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFarmMembers(software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFarmMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListFarmMembersRequest#builder()}
     * </p>
     *
     * @param listFarmMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFarmMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarmMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFarmMembersIterable listFarmMembersPaginator(Consumer<ListFarmMembersRequest.Builder> listFarmMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listFarmMembersPaginator(ListFarmMembersRequest.builder().applyMutation(listFarmMembersRequest).build());
    }

    /**
     * <p>
     * Lists farms.
     * </p>
     *
     * @param listFarmsRequest
     * @return Result of the ListFarms operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFarmsResponse listFarms(ListFarmsRequest listFarmsRequest) throws AccessDeniedException,
            InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists farms.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFarmsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFarmsRequest#builder()}
     * </p>
     *
     * @param listFarmsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFarmsRequest.Builder} to create a request.
     * @return Result of the ListFarms operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFarmsResponse listFarms(Consumer<ListFarmsRequest.Builder> listFarmsRequest) throws AccessDeniedException,
            InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        return listFarms(ListFarmsRequest.builder().applyMutation(listFarmsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFarms(software.amazon.awssdk.services.deadline.model.ListFarmsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmsIterable responses = client.listFarmsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListFarmsIterable responses = client.listFarmsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListFarmsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmsIterable responses = client.listFarmsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFarms(software.amazon.awssdk.services.deadline.model.ListFarmsRequest)} operation.</b>
     * </p>
     *
     * @param listFarmsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFarmsIterable listFarmsPaginator(ListFarmsRequest listFarmsRequest) throws AccessDeniedException,
            InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        return new ListFarmsIterable(this, listFarmsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFarms(software.amazon.awssdk.services.deadline.model.ListFarmsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmsIterable responses = client.listFarmsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListFarmsIterable responses = client.listFarmsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListFarmsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmsIterable responses = client.listFarmsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFarms(software.amazon.awssdk.services.deadline.model.ListFarmsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFarmsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFarmsRequest#builder()}
     * </p>
     *
     * @param listFarmsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFarmsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFarmsIterable listFarmsPaginator(Consumer<ListFarmsRequest.Builder> listFarmsRequest)
            throws AccessDeniedException, InternalServerErrorException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listFarmsPaginator(ListFarmsRequest.builder().applyMutation(listFarmsRequest).build());
    }

    /**
     * <p>
     * Lists fleet members.
     * </p>
     *
     * @param listFleetMembersRequest
     * @return Result of the ListFleetMembers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFleetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetMembersResponse listFleetMembers(ListFleetMembersRequest listFleetMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists fleet members.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListFleetMembersRequest#builder()}
     * </p>
     *
     * @param listFleetMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest.Builder} to create a
     *        request.
     * @return Result of the ListFleetMembers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFleetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetMembersResponse listFleetMembers(Consumer<ListFleetMembersRequest.Builder> listFleetMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listFleetMembers(ListFleetMembersRequest.builder().applyMutation(listFleetMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFleetMembers(software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetMembersIterable responses = client.listFleetMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListFleetMembersIterable responses = client
     *             .listFleetMembersPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetMembersIterable responses = client.listFleetMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleetMembers(software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest)} operation.</b>
     * </p>
     *
     * @param listFleetMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFleetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetMembersIterable listFleetMembersPaginator(ListFleetMembersRequest listFleetMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return new ListFleetMembersIterable(this, listFleetMembersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFleetMembers(software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetMembersIterable responses = client.listFleetMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListFleetMembersIterable responses = client
     *             .listFleetMembersPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetMembersIterable responses = client.listFleetMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleetMembers(software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListFleetMembersRequest#builder()}
     * </p>
     *
     * @param listFleetMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFleetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetMembersIterable listFleetMembersPaginator(Consumer<ListFleetMembersRequest.Builder> listFleetMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listFleetMembersPaginator(ListFleetMembersRequest.builder().applyMutation(listFleetMembersRequest).build());
    }

    /**
     * <p>
     * Lists fleets.
     * </p>
     *
     * @param listFleetsRequest
     * @return Result of the ListFleets operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsResponse listFleets(ListFleetsRequest listFleetsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists fleets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFleetsRequest.Builder} to create a request.
     * @return Result of the ListFleets operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsResponse listFleets(Consumer<ListFleetsRequest.Builder> listFleetsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listFleets(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.deadline.model.ListFleetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.deadline.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listFleetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsIterable listFleetsPaginator(ListFleetsRequest listFleetsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return new ListFleetsIterable(this, listFleetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.deadline.model.ListFleetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.deadline.model.ListFleetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFleetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsIterable listFleetsPaginator(Consumer<ListFleetsRequest.Builder> listFleetsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listFleetsPaginator(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Lists members on a job.
     * </p>
     *
     * @param listJobMembersRequest
     * @return Result of the ListJobMembers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListJobMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobMembersResponse listJobMembers(ListJobMembersRequest listJobMembersRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists members on a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobMembersRequest#builder()}
     * </p>
     *
     * @param listJobMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListJobMembersRequest.Builder} to create a request.
     * @return Result of the ListJobMembers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListJobMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobMembersResponse listJobMembers(Consumer<ListJobMembersRequest.Builder> listJobMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listJobMembers(ListJobMembersRequest.builder().applyMutation(listJobMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listJobMembers(software.amazon.awssdk.services.deadline.model.ListJobMembersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobMembersIterable responses = client.listJobMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListJobMembersIterable responses = client
     *             .listJobMembersPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListJobMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobMembersIterable responses = client.listJobMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobMembers(software.amazon.awssdk.services.deadline.model.ListJobMembersRequest)} operation.</b>
     * </p>
     *
     * @param listJobMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListJobMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobMembersIterable listJobMembersPaginator(ListJobMembersRequest listJobMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return new ListJobMembersIterable(this, listJobMembersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listJobMembers(software.amazon.awssdk.services.deadline.model.ListJobMembersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobMembersIterable responses = client.listJobMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListJobMembersIterable responses = client
     *             .listJobMembersPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListJobMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobMembersIterable responses = client.listJobMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobMembers(software.amazon.awssdk.services.deadline.model.ListJobMembersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobMembersRequest#builder()}
     * </p>
     *
     * @param listJobMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListJobMembersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListJobMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobMembersIterable listJobMembersPaginator(Consumer<ListJobMembersRequest.Builder> listJobMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listJobMembersPaginator(ListJobMembersRequest.builder().applyMutation(listJobMembersRequest).build());
    }

    /**
     * <p>
     * Lists jobs.
     * </p>
     *
     * @param listJobsRequest
     * @return Result of the ListJobs operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListJobsRequest.Builder} to create a request.
     * @return Result of the ListJobs operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listJobs(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.deadline.model.ListJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.deadline.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return new ListJobsIterable(this, listJobsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.deadline.model.ListJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.deadline.model.ListJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listJobsPaginator(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * Lists license endpoints.
     * </p>
     *
     * @param listLicenseEndpointsRequest
     * @return Result of the ListLicenseEndpoints operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListLicenseEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListLicenseEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLicenseEndpointsResponse listLicenseEndpoints(ListLicenseEndpointsRequest listLicenseEndpointsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists license endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLicenseEndpointsRequest#builder()}
     * </p>
     *
     * @param listLicenseEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest.Builder} to create a
     *        request.
     * @return Result of the ListLicenseEndpoints operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListLicenseEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListLicenseEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLicenseEndpointsResponse listLicenseEndpoints(
            Consumer<ListLicenseEndpointsRequest.Builder> listLicenseEndpointsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listLicenseEndpoints(ListLicenseEndpointsRequest.builder().applyMutation(listLicenseEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLicenseEndpoints(software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListLicenseEndpointsIterable responses = client.listLicenseEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListLicenseEndpointsIterable responses = client
     *             .listLicenseEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListLicenseEndpointsIterable responses = client.listLicenseEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLicenseEndpoints(software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLicenseEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListLicenseEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListLicenseEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLicenseEndpointsIterable listLicenseEndpointsPaginator(ListLicenseEndpointsRequest listLicenseEndpointsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return new ListLicenseEndpointsIterable(this, listLicenseEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLicenseEndpoints(software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListLicenseEndpointsIterable responses = client.listLicenseEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListLicenseEndpointsIterable responses = client
     *             .listLicenseEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListLicenseEndpointsIterable responses = client.listLicenseEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLicenseEndpoints(software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLicenseEndpointsRequest#builder()}
     * </p>
     *
     * @param listLicenseEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListLicenseEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListLicenseEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLicenseEndpointsIterable listLicenseEndpointsPaginator(
            Consumer<ListLicenseEndpointsRequest.Builder> listLicenseEndpointsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listLicenseEndpointsPaginator(ListLicenseEndpointsRequest.builder().applyMutation(listLicenseEndpointsRequest)
                .build());
    }

    /**
     * <p>
     * Lists metered products.
     * </p>
     *
     * @param listMeteredProductsRequest
     * @return Result of the ListMeteredProducts operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMeteredProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMeteredProductsResponse listMeteredProducts(ListMeteredProductsRequest listMeteredProductsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists metered products.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMeteredProductsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMeteredProductsRequest#builder()}
     * </p>
     *
     * @param listMeteredProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest.Builder} to create a
     *        request.
     * @return Result of the ListMeteredProducts operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMeteredProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMeteredProductsResponse listMeteredProducts(
            Consumer<ListMeteredProductsRequest.Builder> listMeteredProductsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listMeteredProducts(ListMeteredProductsRequest.builder().applyMutation(listMeteredProductsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMeteredProducts(software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMeteredProductsIterable responses = client.listMeteredProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListMeteredProductsIterable responses = client
     *             .listMeteredProductsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListMeteredProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMeteredProductsIterable responses = client.listMeteredProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMeteredProducts(software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMeteredProductsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMeteredProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMeteredProductsIterable listMeteredProductsPaginator(ListMeteredProductsRequest listMeteredProductsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return new ListMeteredProductsIterable(this, listMeteredProductsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMeteredProducts(software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMeteredProductsIterable responses = client.listMeteredProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListMeteredProductsIterable responses = client
     *             .listMeteredProductsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListMeteredProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMeteredProductsIterable responses = client.listMeteredProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMeteredProducts(software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMeteredProductsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMeteredProductsRequest#builder()}
     * </p>
     *
     * @param listMeteredProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMeteredProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMeteredProductsIterable listMeteredProductsPaginator(
            Consumer<ListMeteredProductsRequest.Builder> listMeteredProductsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listMeteredProductsPaginator(ListMeteredProductsRequest.builder().applyMutation(listMeteredProductsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of your monitors in Deadline Cloud.
     * </p>
     *
     * @param listMonitorsRequest
     * @return Result of the ListMonitors operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMonitorsResponse listMonitors(ListMonitorsRequest listMonitorsRequest) throws AccessDeniedException,
            InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of your monitors in Deadline Cloud.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMonitorsRequest#builder()}
     * </p>
     *
     * @param listMonitorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListMonitorsRequest.Builder} to create a request.
     * @return Result of the ListMonitors operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMonitorsResponse listMonitors(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest)
            throws AccessDeniedException, InternalServerErrorException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listMonitors(ListMonitorsRequest.builder().applyMutation(listMonitorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listMonitors(software.amazon.awssdk.services.deadline.model.ListMonitorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListMonitorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitors(software.amazon.awssdk.services.deadline.model.ListMonitorsRequest)} operation.</b>
     * </p>
     *
     * @param listMonitorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMonitorsIterable listMonitorsPaginator(ListMonitorsRequest listMonitorsRequest) throws AccessDeniedException,
            InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        return new ListMonitorsIterable(this, listMonitorsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listMonitors(software.amazon.awssdk.services.deadline.model.ListMonitorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListMonitorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitors(software.amazon.awssdk.services.deadline.model.ListMonitorsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMonitorsRequest#builder()}
     * </p>
     *
     * @param listMonitorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListMonitorsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMonitorsIterable listMonitorsPaginator(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest)
            throws AccessDeniedException, InternalServerErrorException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listMonitorsPaginator(ListMonitorsRequest.builder().applyMutation(listMonitorsRequest).build());
    }

    /**
     * <p>
     * Lists queue environments.
     * </p>
     *
     * @param listQueueEnvironmentsRequest
     * @return Result of the ListQueueEnvironments operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueEnvironmentsResponse listQueueEnvironments(ListQueueEnvironmentsRequest listQueueEnvironmentsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists queue environments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueEnvironmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueueEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listQueueEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListQueueEnvironments operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueEnvironmentsResponse listQueueEnvironments(
            Consumer<ListQueueEnvironmentsRequest.Builder> listQueueEnvironmentsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listQueueEnvironments(ListQueueEnvironmentsRequest.builder().applyMutation(listQueueEnvironmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueEnvironments(software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueEnvironmentsIterable responses = client.listQueueEnvironmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListQueueEnvironmentsIterable responses = client
     *             .listQueueEnvironmentsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueEnvironmentsIterable responses = client.listQueueEnvironmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueEnvironments(software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQueueEnvironmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueEnvironmentsIterable listQueueEnvironmentsPaginator(ListQueueEnvironmentsRequest listQueueEnvironmentsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return new ListQueueEnvironmentsIterable(this, listQueueEnvironmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueEnvironments(software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueEnvironmentsIterable responses = client.listQueueEnvironmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListQueueEnvironmentsIterable responses = client
     *             .listQueueEnvironmentsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueEnvironmentsIterable responses = client.listQueueEnvironmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueEnvironments(software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueEnvironmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueueEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listQueueEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueEnvironmentsIterable listQueueEnvironmentsPaginator(
            Consumer<ListQueueEnvironmentsRequest.Builder> listQueueEnvironmentsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listQueueEnvironmentsPaginator(ListQueueEnvironmentsRequest.builder().applyMutation(listQueueEnvironmentsRequest)
                .build());
    }

    /**
     * <p>
     * Lists queue-fleet associations.
     * </p>
     *
     * @param listQueueFleetAssociationsRequest
     * @return Result of the ListQueueFleetAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueFleetAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueFleetAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueFleetAssociationsResponse listQueueFleetAssociations(
            ListQueueFleetAssociationsRequest listQueueFleetAssociationsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists queue-fleet associations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueFleetAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListQueueFleetAssociationsRequest#builder()}
     * </p>
     *
     * @param listQueueFleetAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest.Builder} to create
     *        a request.
     * @return Result of the ListQueueFleetAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueFleetAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueFleetAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueFleetAssociationsResponse listQueueFleetAssociations(
            Consumer<ListQueueFleetAssociationsRequest.Builder> listQueueFleetAssociationsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, DeadlineException {
        return listQueueFleetAssociations(ListQueueFleetAssociationsRequest.builder()
                .applyMutation(listQueueFleetAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueFleetAssociations(software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueFleetAssociationsIterable responses = client.listQueueFleetAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListQueueFleetAssociationsIterable responses = client
     *             .listQueueFleetAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueFleetAssociationsIterable responses = client.listQueueFleetAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueFleetAssociations(software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQueueFleetAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueFleetAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueFleetAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueFleetAssociationsIterable listQueueFleetAssociationsPaginator(
            ListQueueFleetAssociationsRequest listQueueFleetAssociationsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, DeadlineException {
        return new ListQueueFleetAssociationsIterable(this, listQueueFleetAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueFleetAssociations(software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueFleetAssociationsIterable responses = client.listQueueFleetAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListQueueFleetAssociationsIterable responses = client
     *             .listQueueFleetAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueFleetAssociationsIterable responses = client.listQueueFleetAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueFleetAssociations(software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueFleetAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListQueueFleetAssociationsRequest#builder()}
     * </p>
     *
     * @param listQueueFleetAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueFleetAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueFleetAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueFleetAssociationsIterable listQueueFleetAssociationsPaginator(
            Consumer<ListQueueFleetAssociationsRequest.Builder> listQueueFleetAssociationsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, DeadlineException {
        return listQueueFleetAssociationsPaginator(ListQueueFleetAssociationsRequest.builder()
                .applyMutation(listQueueFleetAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the members in a queue.
     * </p>
     *
     * @param listQueueMembersRequest
     * @return Result of the ListQueueMembers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueueMembersResponse listQueueMembers(ListQueueMembersRequest listQueueMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the members in a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListQueueMembersRequest#builder()}
     * </p>
     *
     * @param listQueueMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest.Builder} to create a
     *        request.
     * @return Result of the ListQueueMembers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueueMembersResponse listQueueMembers(Consumer<ListQueueMembersRequest.Builder> listQueueMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listQueueMembers(ListQueueMembersRequest.builder().applyMutation(listQueueMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueMembers(software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueMembersIterable responses = client.listQueueMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListQueueMembersIterable responses = client
     *             .listQueueMembersPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueMembersIterable responses = client.listQueueMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueMembers(software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest)} operation.</b>
     * </p>
     *
     * @param listQueueMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueueMembersIterable listQueueMembersPaginator(ListQueueMembersRequest listQueueMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return new ListQueueMembersIterable(this, listQueueMembersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueMembers(software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueMembersIterable responses = client.listQueueMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListQueueMembersIterable responses = client
     *             .listQueueMembersPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueMembersIterable responses = client.listQueueMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueMembers(software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListQueueMembersRequest#builder()}
     * </p>
     *
     * @param listQueueMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueueMembersIterable listQueueMembersPaginator(Consumer<ListQueueMembersRequest.Builder> listQueueMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listQueueMembersPaginator(ListQueueMembersRequest.builder().applyMutation(listQueueMembersRequest).build());
    }

    /**
     * <p>
     * Lists queues.
     * </p>
     *
     * @param listQueuesRequest
     * @return Result of the ListQueues operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesResponse listQueues(ListQueuesRequest listQueuesRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists queues.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueuesRequest.Builder} to create a request.
     * @return Result of the ListQueues operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesResponse listQueues(Consumer<ListQueuesRequest.Builder> listQueuesRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listQueues(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.deadline.model.ListQueuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListQueuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.deadline.model.ListQueuesRequest)} operation.</b>
     * </p>
     *
     * @param listQueuesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesIterable listQueuesPaginator(ListQueuesRequest listQueuesRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return new ListQueuesIterable(this, listQueuesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.deadline.model.ListQueuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListQueuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.deadline.model.ListQueuesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueuesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesIterable listQueuesPaginator(Consumer<ListQueuesRequest.Builder> listQueuesRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listQueuesPaginator(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * <p>
     * Lists session actions.
     * </p>
     *
     * @param listSessionActionsRequest
     * @return Result of the ListSessionActions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSessionActionsResponse listSessionActions(ListSessionActionsRequest listSessionActionsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists session actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSessionActionsRequest#builder()}
     * </p>
     *
     * @param listSessionActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSessionActions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSessionActionsResponse listSessionActions(Consumer<ListSessionActionsRequest.Builder> listSessionActionsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listSessionActions(ListSessionActionsRequest.builder().applyMutation(listSessionActionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessionActions(software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionActionsIterable responses = client.listSessionActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListSessionActionsIterable responses = client
     *             .listSessionActionsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionActionsIterable responses = client.listSessionActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessionActions(software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSessionActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSessionActionsIterable listSessionActionsPaginator(ListSessionActionsRequest listSessionActionsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return new ListSessionActionsIterable(this, listSessionActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessionActions(software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionActionsIterable responses = client.listSessionActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListSessionActionsIterable responses = client
     *             .listSessionActionsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionActionsIterable responses = client.listSessionActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessionActions(software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSessionActionsRequest#builder()}
     * </p>
     *
     * @param listSessionActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSessionActionsIterable listSessionActionsPaginator(
            Consumer<ListSessionActionsRequest.Builder> listSessionActionsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listSessionActionsPaginator(ListSessionActionsRequest.builder().applyMutation(listSessionActionsRequest).build());
    }

    /**
     * <p>
     * Lists sessions.
     * </p>
     *
     * @param listSessionsRequest
     * @return Result of the ListSessions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSessionsResponse listSessions(ListSessionsRequest listSessionsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists sessions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListSessionsRequest.Builder} to create a request.
     * @return Result of the ListSessions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSessionsResponse listSessions(Consumer<ListSessionsRequest.Builder> listSessionsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listSessions(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSessions(software.amazon.awssdk.services.deadline.model.ListSessionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.deadline.model.ListSessionsRequest)} operation.</b>
     * </p>
     *
     * @param listSessionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSessionsIterable listSessionsPaginator(ListSessionsRequest listSessionsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return new ListSessionsIterable(this, listSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSessions(software.amazon.awssdk.services.deadline.model.ListSessionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.deadline.model.ListSessionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListSessionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSessionsIterable listSessionsPaginator(Consumer<ListSessionsRequest.Builder> listSessionsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listSessionsPaginator(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * Lists sessions for a worker.
     * </p>
     *
     * @param listSessionsForWorkerRequest
     * @return Result of the ListSessionsForWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessionsForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionsForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsForWorkerResponse listSessionsForWorker(ListSessionsForWorkerRequest listSessionsForWorkerRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists sessions for a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsForWorkerRequest.Builder} avoiding the
     * need to create one manually via {@link ListSessionsForWorkerRequest#builder()}
     * </p>
     *
     * @param listSessionsForWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest.Builder} to create a
     *        request.
     * @return Result of the ListSessionsForWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessionsForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionsForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsForWorkerResponse listSessionsForWorker(
            Consumer<ListSessionsForWorkerRequest.Builder> listSessionsForWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listSessionsForWorker(ListSessionsForWorkerRequest.builder().applyMutation(listSessionsForWorkerRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessionsForWorker(software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsForWorkerIterable responses = client.listSessionsForWorkerPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListSessionsForWorkerIterable responses = client
     *             .listSessionsForWorkerPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsForWorkerIterable responses = client.listSessionsForWorkerPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessionsForWorker(software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSessionsForWorkerRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessionsForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionsForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsForWorkerIterable listSessionsForWorkerPaginator(ListSessionsForWorkerRequest listSessionsForWorkerRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return new ListSessionsForWorkerIterable(this, listSessionsForWorkerRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessionsForWorker(software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsForWorkerIterable responses = client.listSessionsForWorkerPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListSessionsForWorkerIterable responses = client
     *             .listSessionsForWorkerPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsForWorkerIterable responses = client.listSessionsForWorkerPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessionsForWorker(software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsForWorkerRequest.Builder} avoiding the
     * need to create one manually via {@link ListSessionsForWorkerRequest#builder()}
     * </p>
     *
     * @param listSessionsForWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessionsForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionsForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsForWorkerIterable listSessionsForWorkerPaginator(
            Consumer<ListSessionsForWorkerRequest.Builder> listSessionsForWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listSessionsForWorkerPaginator(ListSessionsForWorkerRequest.builder().applyMutation(listSessionsForWorkerRequest)
                .build());
    }

    /**
     * <p>
     * Lists step consumers.
     * </p>
     *
     * @param listStepConsumersRequest
     * @return Result of the ListStepConsumers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStepConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepConsumersResponse listStepConsumers(ListStepConsumersRequest listStepConsumersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists step consumers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepConsumersRequest.Builder} avoiding the need
     * to create one manually via {@link ListStepConsumersRequest#builder()}
     * </p>
     *
     * @param listStepConsumersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest.Builder} to create a
     *        request.
     * @return Result of the ListStepConsumers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStepConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepConsumersResponse listStepConsumers(Consumer<ListStepConsumersRequest.Builder> listStepConsumersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listStepConsumers(ListStepConsumersRequest.builder().applyMutation(listStepConsumersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStepConsumers(software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepConsumersIterable responses = client.listStepConsumersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListStepConsumersIterable responses = client
     *             .listStepConsumersPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepConsumersIterable responses = client.listStepConsumersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStepConsumers(software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStepConsumersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStepConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepConsumersIterable listStepConsumersPaginator(ListStepConsumersRequest listStepConsumersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return new ListStepConsumersIterable(this, listStepConsumersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStepConsumers(software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepConsumersIterable responses = client.listStepConsumersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListStepConsumersIterable responses = client
     *             .listStepConsumersPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepConsumersIterable responses = client.listStepConsumersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStepConsumers(software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepConsumersRequest.Builder} avoiding the need
     * to create one manually via {@link ListStepConsumersRequest#builder()}
     * </p>
     *
     * @param listStepConsumersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStepConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepConsumersIterable listStepConsumersPaginator(
            Consumer<ListStepConsumersRequest.Builder> listStepConsumersRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listStepConsumersPaginator(ListStepConsumersRequest.builder().applyMutation(listStepConsumersRequest).build());
    }

    /**
     * <p>
     * Lists the dependencies for a step.
     * </p>
     *
     * @param listStepDependenciesRequest
     * @return Result of the ListStepDependencies operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStepDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepDependencies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepDependenciesResponse listStepDependencies(ListStepDependenciesRequest listStepDependenciesRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the dependencies for a step.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepDependenciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStepDependenciesRequest#builder()}
     * </p>
     *
     * @param listStepDependenciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest.Builder} to create a
     *        request.
     * @return Result of the ListStepDependencies operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStepDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepDependencies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepDependenciesResponse listStepDependencies(
            Consumer<ListStepDependenciesRequest.Builder> listStepDependenciesRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listStepDependencies(ListStepDependenciesRequest.builder().applyMutation(listStepDependenciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStepDependencies(software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepDependenciesIterable responses = client.listStepDependenciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListStepDependenciesIterable responses = client
     *             .listStepDependenciesPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepDependenciesIterable responses = client.listStepDependenciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStepDependencies(software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStepDependenciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStepDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepDependencies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepDependenciesIterable listStepDependenciesPaginator(ListStepDependenciesRequest listStepDependenciesRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return new ListStepDependenciesIterable(this, listStepDependenciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStepDependencies(software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepDependenciesIterable responses = client.listStepDependenciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListStepDependenciesIterable responses = client
     *             .listStepDependenciesPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepDependenciesIterable responses = client.listStepDependenciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStepDependencies(software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepDependenciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStepDependenciesRequest#builder()}
     * </p>
     *
     * @param listStepDependenciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStepDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepDependencies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepDependenciesIterable listStepDependenciesPaginator(
            Consumer<ListStepDependenciesRequest.Builder> listStepDependenciesRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listStepDependenciesPaginator(ListStepDependenciesRequest.builder().applyMutation(listStepDependenciesRequest)
                .build());
    }

    /**
     * <p>
     * Lists steps for a job.
     * </p>
     *
     * @param listStepsRequest
     * @return Result of the ListSteps operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStepsResponse listSteps(ListStepsRequest listStepsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists steps for a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStepsRequest#builder()}
     * </p>
     *
     * @param listStepsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStepsRequest.Builder} to create a request.
     * @return Result of the ListSteps operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStepsResponse listSteps(Consumer<ListStepsRequest.Builder> listStepsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listSteps(ListStepsRequest.builder().applyMutation(listStepsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSteps(software.amazon.awssdk.services.deadline.model.ListStepsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepsIterable responses = client.listStepsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListStepsIterable responses = client.listStepsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListStepsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepsIterable responses = client.listStepsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSteps(software.amazon.awssdk.services.deadline.model.ListStepsRequest)} operation.</b>
     * </p>
     *
     * @param listStepsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStepsIterable listStepsPaginator(ListStepsRequest listStepsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return new ListStepsIterable(this, listStepsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSteps(software.amazon.awssdk.services.deadline.model.ListStepsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepsIterable responses = client.listStepsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListStepsIterable responses = client.listStepsPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListStepsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepsIterable responses = client.listStepsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSteps(software.amazon.awssdk.services.deadline.model.ListStepsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStepsRequest#builder()}
     * </p>
     *
     * @param listStepsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStepsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStepsIterable listStepsPaginator(Consumer<ListStepsRequest.Builder> listStepsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listStepsPaginator(ListStepsRequest.builder().applyMutation(listStepsRequest).build());
    }

    /**
     * <p>
     * Lists storage profiles.
     * </p>
     *
     * @param listStorageProfilesRequest
     * @return Result of the ListStorageProfiles operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStorageProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStorageProfilesResponse listStorageProfiles(ListStorageProfilesRequest listStorageProfilesRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists storage profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStorageProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStorageProfilesRequest#builder()}
     * </p>
     *
     * @param listStorageProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListStorageProfiles operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStorageProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStorageProfilesResponse listStorageProfiles(
            Consumer<ListStorageProfilesRequest.Builder> listStorageProfilesRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listStorageProfiles(ListStorageProfilesRequest.builder().applyMutation(listStorageProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStorageProfiles(software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesIterable responses = client.listStorageProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesIterable responses = client
     *             .listStorageProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListStorageProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesIterable responses = client.listStorageProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStorageProfiles(software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStorageProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStorageProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStorageProfilesIterable listStorageProfilesPaginator(ListStorageProfilesRequest listStorageProfilesRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return new ListStorageProfilesIterable(this, listStorageProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStorageProfiles(software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesIterable responses = client.listStorageProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesIterable responses = client
     *             .listStorageProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListStorageProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesIterable responses = client.listStorageProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStorageProfiles(software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStorageProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStorageProfilesRequest#builder()}
     * </p>
     *
     * @param listStorageProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStorageProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStorageProfilesIterable listStorageProfilesPaginator(
            Consumer<ListStorageProfilesRequest.Builder> listStorageProfilesRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listStorageProfilesPaginator(ListStorageProfilesRequest.builder().applyMutation(listStorageProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Lists storage profiles for a queue.
     * </p>
     *
     * @param listStorageProfilesForQueueRequest
     * @return Result of the ListStorageProfilesForQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStorageProfilesForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfilesForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStorageProfilesForQueueResponse listStorageProfilesForQueue(
            ListStorageProfilesForQueueRequest listStorageProfilesForQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists storage profiles for a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStorageProfilesForQueueRequest.Builder}
     * avoiding the need to create one manually via {@link ListStorageProfilesForQueueRequest#builder()}
     * </p>
     *
     * @param listStorageProfilesForQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest.Builder} to
     *        create a request.
     * @return Result of the ListStorageProfilesForQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStorageProfilesForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfilesForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStorageProfilesForQueueResponse listStorageProfilesForQueue(
            Consumer<ListStorageProfilesForQueueRequest.Builder> listStorageProfilesForQueueRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listStorageProfilesForQueue(ListStorageProfilesForQueueRequest.builder()
                .applyMutation(listStorageProfilesForQueueRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStorageProfilesForQueue(software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesForQueueIterable responses = client.listStorageProfilesForQueuePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesForQueueIterable responses = client
     *             .listStorageProfilesForQueuePaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesForQueueIterable responses = client.listStorageProfilesForQueuePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStorageProfilesForQueue(software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStorageProfilesForQueueRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStorageProfilesForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfilesForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStorageProfilesForQueueIterable listStorageProfilesForQueuePaginator(
            ListStorageProfilesForQueueRequest listStorageProfilesForQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return new ListStorageProfilesForQueueIterable(this, listStorageProfilesForQueueRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStorageProfilesForQueue(software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesForQueueIterable responses = client.listStorageProfilesForQueuePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesForQueueIterable responses = client
     *             .listStorageProfilesForQueuePaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesForQueueIterable responses = client.listStorageProfilesForQueuePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStorageProfilesForQueue(software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStorageProfilesForQueueRequest.Builder}
     * avoiding the need to create one manually via {@link ListStorageProfilesForQueueRequest#builder()}
     * </p>
     *
     * @param listStorageProfilesForQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStorageProfilesForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfilesForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStorageProfilesForQueueIterable listStorageProfilesForQueuePaginator(
            Consumer<ListStorageProfilesForQueueRequest.Builder> listStorageProfilesForQueueRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listStorageProfilesForQueuePaginator(ListStorageProfilesForQueueRequest.builder()
                .applyMutation(listStorageProfilesForQueueRequest).build());
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists tasks for a job.
     * </p>
     *
     * @param listTasksRequest
     * @return Result of the ListTasks operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksResponse listTasks(ListTasksRequest listTasksRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tasks for a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListTasksRequest.Builder} to create a request.
     * @return Result of the ListTasks operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksResponse listTasks(Consumer<ListTasksRequest.Builder> listTasksRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return listTasks(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTasks(software.amazon.awssdk.services.deadline.model.ListTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.deadline.model.ListTasksRequest)} operation.</b>
     * </p>
     *
     * @param listTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksIterable listTasksPaginator(ListTasksRequest listTasksRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return new ListTasksIterable(this, listTasksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTasks(software.amazon.awssdk.services.deadline.model.ListTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.deadline.model.ListTasksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListTasksRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksIterable listTasksPaginator(Consumer<ListTasksRequest.Builder> listTasksRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listTasksPaginator(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * Lists workers.
     * </p>
     *
     * @param listWorkersRequest
     * @return Result of the ListWorkers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkersResponse listWorkers(ListWorkersRequest listWorkersRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists workers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkersRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkersRequest#builder()}
     * </p>
     *
     * @param listWorkersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListWorkersRequest.Builder} to create a request.
     * @return Result of the ListWorkers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkersResponse listWorkers(Consumer<ListWorkersRequest.Builder> listWorkersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listWorkers(ListWorkersRequest.builder().applyMutation(listWorkersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkers(software.amazon.awssdk.services.deadline.model.ListWorkersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListWorkersIterable responses = client.listWorkersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListWorkersIterable responses = client.listWorkersPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListWorkersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListWorkersIterable responses = client.listWorkersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkers(software.amazon.awssdk.services.deadline.model.ListWorkersRequest)} operation.</b>
     * </p>
     *
     * @param listWorkersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkersIterable listWorkersPaginator(ListWorkersRequest listWorkersRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return new ListWorkersIterable(this, listWorkersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkers(software.amazon.awssdk.services.deadline.model.ListWorkersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListWorkersIterable responses = client.listWorkersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.deadline.paginators.ListWorkersIterable responses = client.listWorkersPaginator(request);
     *     for (software.amazon.awssdk.services.deadline.model.ListWorkersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListWorkersIterable responses = client.listWorkersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkers(software.amazon.awssdk.services.deadline.model.ListWorkersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkersRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkersRequest#builder()}
     * </p>
     *
     * @param listWorkersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListWorkersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkersIterable listWorkersPaginator(Consumer<ListWorkersRequest.Builder> listWorkersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return listWorkersPaginator(ListWorkersRequest.builder().applyMutation(listWorkersRequest).build());
    }

    /**
     * <p>
     * Adds a metered product.
     * </p>
     *
     * @param putMeteredProductRequest
     * @return Result of the PutMeteredProduct operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.PutMeteredProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/PutMeteredProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default PutMeteredProductResponse putMeteredProduct(PutMeteredProductRequest putMeteredProductRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a metered product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMeteredProductRequest.Builder} avoiding the need
     * to create one manually via {@link PutMeteredProductRequest#builder()}
     * </p>
     *
     * @param putMeteredProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.PutMeteredProductRequest.Builder} to create a
     *        request.
     * @return Result of the PutMeteredProduct operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.PutMeteredProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/PutMeteredProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default PutMeteredProductResponse putMeteredProduct(Consumer<PutMeteredProductRequest.Builder> putMeteredProductRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return putMeteredProduct(PutMeteredProductRequest.builder().applyMutation(putMeteredProductRequest).build());
    }

    /**
     * <p>
     * Searches for jobs.
     * </p>
     *
     * @param searchJobsRequest
     * @return Result of the SearchJobs operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.SearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchJobsResponse searchJobs(SearchJobsRequest searchJobsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchJobsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchJobsRequest#builder()}
     * </p>
     *
     * @param searchJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.SearchJobsRequest.Builder} to create a request.
     * @return Result of the SearchJobs operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.SearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchJobsResponse searchJobs(Consumer<SearchJobsRequest.Builder> searchJobsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return searchJobs(SearchJobsRequest.builder().applyMutation(searchJobsRequest).build());
    }

    /**
     * <p>
     * Searches for steps.
     * </p>
     *
     * @param searchStepsRequest
     * @return Result of the SearchSteps operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.SearchSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchStepsResponse searchSteps(SearchStepsRequest searchStepsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for steps.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchStepsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchStepsRequest#builder()}
     * </p>
     *
     * @param searchStepsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.SearchStepsRequest.Builder} to create a request.
     * @return Result of the SearchSteps operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.SearchSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchStepsResponse searchSteps(Consumer<SearchStepsRequest.Builder> searchStepsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return searchSteps(SearchStepsRequest.builder().applyMutation(searchStepsRequest).build());
    }

    /**
     * <p>
     * Searches for tasks.
     * </p>
     *
     * @param searchTasksRequest
     * @return Result of the SearchTasks operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.SearchTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTasksResponse searchTasks(SearchTasksRequest searchTasksRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for tasks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchTasksRequest.Builder} avoiding the need to
     * create one manually via {@link SearchTasksRequest#builder()}
     * </p>
     *
     * @param searchTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.SearchTasksRequest.Builder} to create a request.
     * @return Result of the SearchTasks operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.SearchTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTasksResponse searchTasks(Consumer<SearchTasksRequest.Builder> searchTasksRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return searchTasks(SearchTasksRequest.builder().applyMutation(searchTasksRequest).build());
    }

    /**
     * <p>
     * Searches for workers.
     * </p>
     *
     * @param searchWorkersRequest
     * @return Result of the SearchWorkers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.SearchWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchWorkersResponse searchWorkers(SearchWorkersRequest searchWorkersRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for workers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchWorkersRequest.Builder} avoiding the need to
     * create one manually via {@link SearchWorkersRequest#builder()}
     * </p>
     *
     * @param searchWorkersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.SearchWorkersRequest.Builder} to create a request.
     * @return Result of the SearchWorkers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.SearchWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchWorkersResponse searchWorkers(Consumer<SearchWorkersRequest.Builder> searchWorkersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return searchWorkers(SearchWorkersRequest.builder().applyMutation(searchWorkersRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous request for getting aggregated statistics about queues and farms. Get the statistics using
     * the <code>GetSessionsStatisticsAggregation</code> operation. You can only have one running aggregation for your
     * Deadline Cloud farm. Call the <code>GetSessionsStatisticsAggregation</code> operation and check the
     * <code>status</code> field to see if an aggregation is running. Statistics are available for 1 hour after you call
     * the <code>StartSessionsStatisticsAggregation</code> operation.
     * </p>
     *
     * @param startSessionsStatisticsAggregationRequest
     * @return Result of the StartSessionsStatisticsAggregation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.StartSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/StartSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSessionsStatisticsAggregationResponse startSessionsStatisticsAggregation(
            StartSessionsStatisticsAggregationRequest startSessionsStatisticsAggregationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous request for getting aggregated statistics about queues and farms. Get the statistics using
     * the <code>GetSessionsStatisticsAggregation</code> operation. You can only have one running aggregation for your
     * Deadline Cloud farm. Call the <code>GetSessionsStatisticsAggregation</code> operation and check the
     * <code>status</code> field to see if an aggregation is running. Statistics are available for 1 hour after you call
     * the <code>StartSessionsStatisticsAggregation</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSessionsStatisticsAggregationRequest.Builder}
     * avoiding the need to create one manually via {@link StartSessionsStatisticsAggregationRequest#builder()}
     * </p>
     *
     * @param startSessionsStatisticsAggregationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationRequest.Builder}
     *        to create a request.
     * @return Result of the StartSessionsStatisticsAggregation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.StartSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/StartSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSessionsStatisticsAggregationResponse startSessionsStatisticsAggregation(
            Consumer<StartSessionsStatisticsAggregationRequest.Builder> startSessionsStatisticsAggregationRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return startSessionsStatisticsAggregation(StartSessionsStatisticsAggregationRequest.builder()
                .applyMutation(startSessionsStatisticsAggregationRequest).build());
    }

    /**
     * <p>
     * Tags a resource using the resource's ARN and desired tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource using the resource's ARN and desired tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource using the resource's ARN and tag to remove.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource using the resource's ARN and tag to remove.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a budget that sets spending thresholds for rendering activity.
     * </p>
     *
     * @param updateBudgetRequest
     * @return Result of the UpdateBudget operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBudgetResponse updateBudget(UpdateBudgetRequest updateBudgetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a budget that sets spending thresholds for rendering activity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBudgetRequest#builder()}
     * </p>
     *
     * @param updateBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateBudgetRequest.Builder} to create a request.
     * @return Result of the UpdateBudget operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBudgetResponse updateBudget(Consumer<UpdateBudgetRequest.Builder> updateBudgetRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return updateBudget(UpdateBudgetRequest.builder().applyMutation(updateBudgetRequest).build());
    }

    /**
     * <p>
     * Updates a farm.
     * </p>
     *
     * @param updateFarmRequest
     * @return Result of the UpdateFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFarmResponse updateFarm(UpdateFarmRequest updateFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFarmRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFarmRequest#builder()}
     * </p>
     *
     * @param updateFarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateFarmRequest.Builder} to create a request.
     * @return Result of the UpdateFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFarmResponse updateFarm(Consumer<UpdateFarmRequest.Builder> updateFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return updateFarm(UpdateFarmRequest.builder().applyMutation(updateFarmRequest).build());
    }

    /**
     * <p>
     * Updates a fleet.
     * </p>
     *
     * @param updateFleetRequest
     * @return Result of the UpdateFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFleetResponse updateFleet(UpdateFleetRequest updateFleetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFleetRequest#builder()}
     * </p>
     *
     * @param updateFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateFleetRequest.Builder} to create a request.
     * @return Result of the UpdateFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFleetResponse updateFleet(Consumer<UpdateFleetRequest.Builder> updateFleetRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        return updateFleet(UpdateFleetRequest.builder().applyMutation(updateFleetRequest).build());
    }

    /**
     * <p>
     * Updates a job.
     * </p>
     * <p>
     * When you change the status of the job to <code>ARCHIVED</code>, the job can't be scheduled or archived.
     * </p>
     * <important>
     * <p>
     * An archived jobs and its steps and tasks are deleted after 120 days. The job can't be recovered.
     * </p>
     * </important>
     *
     * @param updateJobRequest
     * @return Result of the UpdateJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateJobResponse updateJob(UpdateJobRequest updateJobRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a job.
     * </p>
     * <p>
     * When you change the status of the job to <code>ARCHIVED</code>, the job can't be scheduled or archived.
     * </p>
     * <important>
     * <p>
     * An archived jobs and its steps and tasks are deleted after 120 days. The job can't be recovered.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateJobRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateJobRequest#builder()}
     * </p>
     *
     * @param updateJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateJobRequest.Builder} to create a request.
     * @return Result of the UpdateJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateJobResponse updateJob(Consumer<UpdateJobRequest.Builder> updateJobRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return updateJob(UpdateJobRequest.builder().applyMutation(updateJobRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for a Deadline Cloud monitor. You can modify one or all of the settings when you call
     * <code>UpdateMonitor</code>.
     * </p>
     *
     * @param updateMonitorRequest
     * @return Result of the UpdateMonitor operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMonitorResponse updateMonitor(UpdateMonitorRequest updateMonitorRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a Deadline Cloud monitor. You can modify one or all of the settings when you call
     * <code>UpdateMonitor</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMonitorRequest#builder()}
     * </p>
     *
     * @param updateMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateMonitorRequest.Builder} to create a request.
     * @return Result of the UpdateMonitor operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMonitorResponse updateMonitor(Consumer<UpdateMonitorRequest.Builder> updateMonitorRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return updateMonitor(UpdateMonitorRequest.builder().applyMutation(updateMonitorRequest).build());
    }

    /**
     * <p>
     * Updates a queue.
     * </p>
     *
     * @param updateQueueRequest
     * @return Result of the UpdateQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateQueueResponse updateQueue(UpdateQueueRequest updateQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateQueueRequest#builder()}
     * </p>
     *
     * @param updateQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateQueueRequest.Builder} to create a request.
     * @return Result of the UpdateQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateQueueResponse updateQueue(Consumer<UpdateQueueRequest.Builder> updateQueueRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return updateQueue(UpdateQueueRequest.builder().applyMutation(updateQueueRequest).build());
    }

    /**
     * <p>
     * Updates the queue environment.
     * </p>
     *
     * @param updateQueueEnvironmentRequest
     * @return Result of the UpdateQueueEnvironment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQueueEnvironmentResponse updateQueueEnvironment(UpdateQueueEnvironmentRequest updateQueueEnvironmentRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the queue environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateQueueEnvironmentRequest#builder()}
     * </p>
     *
     * @param updateQueueEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateQueueEnvironment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQueueEnvironmentResponse updateQueueEnvironment(
            Consumer<UpdateQueueEnvironmentRequest.Builder> updateQueueEnvironmentRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return updateQueueEnvironment(UpdateQueueEnvironmentRequest.builder().applyMutation(updateQueueEnvironmentRequest)
                .build());
    }

    /**
     * <p>
     * Updates a queue-fleet association.
     * </p>
     *
     * @param updateQueueFleetAssociationRequest
     * @return Result of the UpdateQueueFleetAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQueueFleetAssociationResponse updateQueueFleetAssociation(
            UpdateQueueFleetAssociationRequest updateQueueFleetAssociationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a queue-fleet association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueFleetAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateQueueFleetAssociationRequest#builder()}
     * </p>
     *
     * @param updateQueueFleetAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateQueueFleetAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQueueFleetAssociationResponse updateQueueFleetAssociation(
            Consumer<UpdateQueueFleetAssociationRequest.Builder> updateQueueFleetAssociationRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return updateQueueFleetAssociation(UpdateQueueFleetAssociationRequest.builder()
                .applyMutation(updateQueueFleetAssociationRequest).build());
    }

    /**
     * <p>
     * Updates a session.
     * </p>
     *
     * @param updateSessionRequest
     * @return Result of the UpdateSession operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSessionResponse updateSession(UpdateSessionRequest updateSessionRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSessionRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSessionRequest#builder()}
     * </p>
     *
     * @param updateSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateSessionRequest.Builder} to create a request.
     * @return Result of the UpdateSession operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSessionResponse updateSession(Consumer<UpdateSessionRequest.Builder> updateSessionRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return updateSession(UpdateSessionRequest.builder().applyMutation(updateSessionRequest).build());
    }

    /**
     * <p>
     * Updates a step.
     * </p>
     *
     * @param updateStepRequest
     * @return Result of the UpdateStep operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStep" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateStepResponse updateStep(UpdateStepRequest updateStepRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a step.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStepRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStepRequest#builder()}
     * </p>
     *
     * @param updateStepRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateStepRequest.Builder} to create a request.
     * @return Result of the UpdateStep operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStep" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateStepResponse updateStep(Consumer<UpdateStepRequest.Builder> updateStepRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return updateStep(UpdateStepRequest.builder().applyMutation(updateStepRequest).build());
    }

    /**
     * <p>
     * Updates a storage profile.
     * </p>
     *
     * @param updateStorageProfileRequest
     * @return Result of the UpdateStorageProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateStorageProfileResponse updateStorageProfile(UpdateStorageProfileRequest updateStorageProfileRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a storage profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStorageProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStorageProfileRequest#builder()}
     * </p>
     *
     * @param updateStorageProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateStorageProfileRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateStorageProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateStorageProfileResponse updateStorageProfile(
            Consumer<UpdateStorageProfileRequest.Builder> updateStorageProfileRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return updateStorageProfile(UpdateStorageProfileRequest.builder().applyMutation(updateStorageProfileRequest).build());
    }

    /**
     * <p>
     * Updates a task.
     * </p>
     *
     * @param updateTaskRequest
     * @return Result of the UpdateTask operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateTask" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTaskResponse updateTask(UpdateTaskRequest updateTaskRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTaskRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTaskRequest#builder()}
     * </p>
     *
     * @param updateTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateTaskRequest.Builder} to create a request.
     * @return Result of the UpdateTask operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateTask" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTaskResponse updateTask(Consumer<UpdateTaskRequest.Builder> updateTaskRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return updateTask(UpdateTaskRequest.builder().applyMutation(updateTaskRequest).build());
    }

    /**
     * <p>
     * Updates a worker.
     * </p>
     *
     * @param updateWorkerRequest
     * @return Result of the UpdateWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWorkerResponse updateWorker(UpdateWorkerRequest updateWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWorkerRequest#builder()}
     * </p>
     *
     * @param updateWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateWorkerRequest.Builder} to create a request.
     * @return Result of the UpdateWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWorkerResponse updateWorker(Consumer<UpdateWorkerRequest.Builder> updateWorkerRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        return updateWorker(UpdateWorkerRequest.builder().applyMutation(updateWorkerRequest).build());
    }

    /**
     * <p>
     * Updates the schedule for a worker.
     * </p>
     *
     * @param updateWorkerScheduleRequest
     * @return Result of the UpdateWorkerSchedule operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateWorkerSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorkerSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateWorkerScheduleResponse updateWorkerSchedule(UpdateWorkerScheduleRequest updateWorkerScheduleRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the schedule for a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkerScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkerScheduleRequest#builder()}
     * </p>
     *
     * @param updateWorkerScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateWorkerSchedule operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateWorkerSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorkerSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateWorkerScheduleResponse updateWorkerSchedule(
            Consumer<UpdateWorkerScheduleRequest.Builder> updateWorkerScheduleRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        return updateWorkerSchedule(UpdateWorkerScheduleRequest.builder().applyMutation(updateWorkerScheduleRequest).build());
    }

    /**
     * Create an instance of {@link DeadlineWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link DeadlineWaiter}
     */
    default DeadlineWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link DeadlineClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DeadlineClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DeadlineClient}.
     */
    static DeadlineClientBuilder builder() {
        return new DefaultDeadlineClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default DeadlineServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
