/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of the assigned session action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssignedSessionActionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<AssignedSessionActionDefinition.Builder, AssignedSessionActionDefinition> {
    private static final SdkField<AssignedEnvironmentEnterSessionActionDefinition> ENV_ENTER_FIELD = SdkField
            .<AssignedEnvironmentEnterSessionActionDefinition> builder(MarshallingType.SDK_POJO).memberName("envEnter")
            .getter(getter(AssignedSessionActionDefinition::envEnter)).setter(setter(Builder::envEnter))
            .constructor(AssignedEnvironmentEnterSessionActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("envEnter").build()).build();

    private static final SdkField<AssignedEnvironmentExitSessionActionDefinition> ENV_EXIT_FIELD = SdkField
            .<AssignedEnvironmentExitSessionActionDefinition> builder(MarshallingType.SDK_POJO).memberName("envExit")
            .getter(getter(AssignedSessionActionDefinition::envExit)).setter(setter(Builder::envExit))
            .constructor(AssignedEnvironmentExitSessionActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("envExit").build()).build();

    private static final SdkField<AssignedTaskRunSessionActionDefinition> TASK_RUN_FIELD = SdkField
            .<AssignedTaskRunSessionActionDefinition> builder(MarshallingType.SDK_POJO).memberName("taskRun")
            .getter(getter(AssignedSessionActionDefinition::taskRun)).setter(setter(Builder::taskRun))
            .constructor(AssignedTaskRunSessionActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRun").build()).build();

    private static final SdkField<AssignedSyncInputJobAttachmentsSessionActionDefinition> SYNC_INPUT_JOB_ATTACHMENTS_FIELD = SdkField
            .<AssignedSyncInputJobAttachmentsSessionActionDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("syncInputJobAttachments").getter(getter(AssignedSessionActionDefinition::syncInputJobAttachments))
            .setter(setter(Builder::syncInputJobAttachments))
            .constructor(AssignedSyncInputJobAttachmentsSessionActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncInputJobAttachments").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENV_ENTER_FIELD,
            ENV_EXIT_FIELD, TASK_RUN_FIELD, SYNC_INPUT_JOB_ATTACHMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AssignedEnvironmentEnterSessionActionDefinition envEnter;

    private final AssignedEnvironmentExitSessionActionDefinition envExit;

    private final AssignedTaskRunSessionActionDefinition taskRun;

    private final AssignedSyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments;

    private final Type type;

    private AssignedSessionActionDefinition(BuilderImpl builder) {
        this.envEnter = builder.envEnter;
        this.envExit = builder.envExit;
        this.taskRun = builder.taskRun;
        this.syncInputJobAttachments = builder.syncInputJobAttachments;
        this.type = builder.type;
    }

    /**
     * <p>
     * The environment a session starts on.
     * </p>
     * 
     * @return The environment a session starts on.
     */
    public final AssignedEnvironmentEnterSessionActionDefinition envEnter() {
        return envEnter;
    }

    /**
     * <p>
     * The environment a session exits from.
     * </p>
     * 
     * @return The environment a session exits from.
     */
    public final AssignedEnvironmentExitSessionActionDefinition envExit() {
        return envExit;
    }

    /**
     * <p>
     * The task run.
     * </p>
     * 
     * @return The task run.
     */
    public final AssignedTaskRunSessionActionDefinition taskRun() {
        return taskRun;
    }

    /**
     * <p>
     * The job attachment to sync with an assigned session action.
     * </p>
     * 
     * @return The job attachment to sync with an assigned session action.
     */
    public final AssignedSyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments() {
        return syncInputJobAttachments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(envEnter());
        hashCode = 31 * hashCode + Objects.hashCode(envExit());
        hashCode = 31 * hashCode + Objects.hashCode(taskRun());
        hashCode = 31 * hashCode + Objects.hashCode(syncInputJobAttachments());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignedSessionActionDefinition)) {
            return false;
        }
        AssignedSessionActionDefinition other = (AssignedSessionActionDefinition) obj;
        return Objects.equals(envEnter(), other.envEnter()) && Objects.equals(envExit(), other.envExit())
                && Objects.equals(taskRun(), other.taskRun())
                && Objects.equals(syncInputJobAttachments(), other.syncInputJobAttachments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssignedSessionActionDefinition").add("EnvEnter", envEnter()).add("EnvExit", envExit())
                .add("TaskRun", taskRun()).add("SyncInputJobAttachments", syncInputJobAttachments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "envEnter":
            return Optional.ofNullable(clazz.cast(envEnter()));
        case "envExit":
            return Optional.ofNullable(clazz.cast(envExit()));
        case "taskRun":
            return Optional.ofNullable(clazz.cast(taskRun()));
        case "syncInputJobAttachments":
            return Optional.ofNullable(clazz.cast(syncInputJobAttachments()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #envEnter()} initialized to the given value.
     *
     * <p>
     * The environment a session starts on.
     * </p>
     * 
     * @param envEnter
     *        The environment a session starts on.
     */
    public static AssignedSessionActionDefinition fromEnvEnter(AssignedEnvironmentEnterSessionActionDefinition envEnter) {
        return builder().envEnter(envEnter).build();
    }

    /**
     * Create an instance of this class with {@link #envEnter()} initialized to the given value.
     *
     * <p>
     * The environment a session starts on.
     * </p>
     * 
     * @param envEnter
     *        The environment a session starts on.
     */
    public static AssignedSessionActionDefinition fromEnvEnter(
            Consumer<AssignedEnvironmentEnterSessionActionDefinition.Builder> envEnter) {
        AssignedEnvironmentEnterSessionActionDefinition.Builder builder = AssignedEnvironmentEnterSessionActionDefinition
                .builder();
        envEnter.accept(builder);
        return fromEnvEnter(builder.build());
    }

    /**
     * Create an instance of this class with {@link #envExit()} initialized to the given value.
     *
     * <p>
     * The environment a session exits from.
     * </p>
     * 
     * @param envExit
     *        The environment a session exits from.
     */
    public static AssignedSessionActionDefinition fromEnvExit(AssignedEnvironmentExitSessionActionDefinition envExit) {
        return builder().envExit(envExit).build();
    }

    /**
     * Create an instance of this class with {@link #envExit()} initialized to the given value.
     *
     * <p>
     * The environment a session exits from.
     * </p>
     * 
     * @param envExit
     *        The environment a session exits from.
     */
    public static AssignedSessionActionDefinition fromEnvExit(
            Consumer<AssignedEnvironmentExitSessionActionDefinition.Builder> envExit) {
        AssignedEnvironmentExitSessionActionDefinition.Builder builder = AssignedEnvironmentExitSessionActionDefinition.builder();
        envExit.accept(builder);
        return fromEnvExit(builder.build());
    }

    /**
     * Create an instance of this class with {@link #taskRun()} initialized to the given value.
     *
     * <p>
     * The task run.
     * </p>
     * 
     * @param taskRun
     *        The task run.
     */
    public static AssignedSessionActionDefinition fromTaskRun(AssignedTaskRunSessionActionDefinition taskRun) {
        return builder().taskRun(taskRun).build();
    }

    /**
     * Create an instance of this class with {@link #taskRun()} initialized to the given value.
     *
     * <p>
     * The task run.
     * </p>
     * 
     * @param taskRun
     *        The task run.
     */
    public static AssignedSessionActionDefinition fromTaskRun(Consumer<AssignedTaskRunSessionActionDefinition.Builder> taskRun) {
        AssignedTaskRunSessionActionDefinition.Builder builder = AssignedTaskRunSessionActionDefinition.builder();
        taskRun.accept(builder);
        return fromTaskRun(builder.build());
    }

    /**
     * Create an instance of this class with {@link #syncInputJobAttachments()} initialized to the given value.
     *
     * <p>
     * The job attachment to sync with an assigned session action.
     * </p>
     * 
     * @param syncInputJobAttachments
     *        The job attachment to sync with an assigned session action.
     */
    public static AssignedSessionActionDefinition fromSyncInputJobAttachments(
            AssignedSyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments) {
        return builder().syncInputJobAttachments(syncInputJobAttachments).build();
    }

    /**
     * Create an instance of this class with {@link #syncInputJobAttachments()} initialized to the given value.
     *
     * <p>
     * The job attachment to sync with an assigned session action.
     * </p>
     * 
     * @param syncInputJobAttachments
     *        The job attachment to sync with an assigned session action.
     */
    public static AssignedSessionActionDefinition fromSyncInputJobAttachments(
            Consumer<AssignedSyncInputJobAttachmentsSessionActionDefinition.Builder> syncInputJobAttachments) {
        AssignedSyncInputJobAttachmentsSessionActionDefinition.Builder builder = AssignedSyncInputJobAttachmentsSessionActionDefinition
                .builder();
        syncInputJobAttachments.accept(builder);
        return fromSyncInputJobAttachments(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssignedSessionActionDefinition, T> g) {
        return obj -> g.apply((AssignedSessionActionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssignedSessionActionDefinition> {
        /**
         * <p>
         * The environment a session starts on.
         * </p>
         * 
         * @param envEnter
         *        The environment a session starts on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder envEnter(AssignedEnvironmentEnterSessionActionDefinition envEnter);

        /**
         * <p>
         * The environment a session starts on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssignedEnvironmentEnterSessionActionDefinition.Builder} avoiding the need to create one manually via
         * {@link AssignedEnvironmentEnterSessionActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssignedEnvironmentEnterSessionActionDefinition.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #envEnter(AssignedEnvironmentEnterSessionActionDefinition)}.
         * 
         * @param envEnter
         *        a consumer that will call methods on {@link AssignedEnvironmentEnterSessionActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #envEnter(AssignedEnvironmentEnterSessionActionDefinition)
         */
        default Builder envEnter(Consumer<AssignedEnvironmentEnterSessionActionDefinition.Builder> envEnter) {
            return envEnter(AssignedEnvironmentEnterSessionActionDefinition.builder().applyMutation(envEnter).build());
        }

        /**
         * <p>
         * The environment a session exits from.
         * </p>
         * 
         * @param envExit
         *        The environment a session exits from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder envExit(AssignedEnvironmentExitSessionActionDefinition envExit);

        /**
         * <p>
         * The environment a session exits from.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssignedEnvironmentExitSessionActionDefinition.Builder} avoiding the need to create one manually via
         * {@link AssignedEnvironmentExitSessionActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssignedEnvironmentExitSessionActionDefinition.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #envExit(AssignedEnvironmentExitSessionActionDefinition)}.
         * 
         * @param envExit
         *        a consumer that will call methods on {@link AssignedEnvironmentExitSessionActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #envExit(AssignedEnvironmentExitSessionActionDefinition)
         */
        default Builder envExit(Consumer<AssignedEnvironmentExitSessionActionDefinition.Builder> envExit) {
            return envExit(AssignedEnvironmentExitSessionActionDefinition.builder().applyMutation(envExit).build());
        }

        /**
         * <p>
         * The task run.
         * </p>
         * 
         * @param taskRun
         *        The task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRun(AssignedTaskRunSessionActionDefinition taskRun);

        /**
         * <p>
         * The task run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssignedTaskRunSessionActionDefinition.Builder} avoiding the need to create one manually via
         * {@link AssignedTaskRunSessionActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssignedTaskRunSessionActionDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #taskRun(AssignedTaskRunSessionActionDefinition)}.
         * 
         * @param taskRun
         *        a consumer that will call methods on {@link AssignedTaskRunSessionActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskRun(AssignedTaskRunSessionActionDefinition)
         */
        default Builder taskRun(Consumer<AssignedTaskRunSessionActionDefinition.Builder> taskRun) {
            return taskRun(AssignedTaskRunSessionActionDefinition.builder().applyMutation(taskRun).build());
        }

        /**
         * <p>
         * The job attachment to sync with an assigned session action.
         * </p>
         * 
         * @param syncInputJobAttachments
         *        The job attachment to sync with an assigned session action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncInputJobAttachments(AssignedSyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments);

        /**
         * <p>
         * The job attachment to sync with an assigned session action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssignedSyncInputJobAttachmentsSessionActionDefinition.Builder} avoiding the need to create one
         * manually via {@link AssignedSyncInputJobAttachmentsSessionActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AssignedSyncInputJobAttachmentsSessionActionDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #syncInputJobAttachments(AssignedSyncInputJobAttachmentsSessionActionDefinition)}.
         * 
         * @param syncInputJobAttachments
         *        a consumer that will call methods on
         *        {@link AssignedSyncInputJobAttachmentsSessionActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncInputJobAttachments(AssignedSyncInputJobAttachmentsSessionActionDefinition)
         */
        default Builder syncInputJobAttachments(
                Consumer<AssignedSyncInputJobAttachmentsSessionActionDefinition.Builder> syncInputJobAttachments) {
            return syncInputJobAttachments(AssignedSyncInputJobAttachmentsSessionActionDefinition.builder()
                    .applyMutation(syncInputJobAttachments).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AssignedEnvironmentEnterSessionActionDefinition envEnter;

        private AssignedEnvironmentExitSessionActionDefinition envExit;

        private AssignedTaskRunSessionActionDefinition taskRun;

        private AssignedSyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AssignedSessionActionDefinition model) {
            envEnter(model.envEnter);
            envExit(model.envExit);
            taskRun(model.taskRun);
            syncInputJobAttachments(model.syncInputJobAttachments);
        }

        public final AssignedEnvironmentEnterSessionActionDefinition.Builder getEnvEnter() {
            return envEnter != null ? envEnter.toBuilder() : null;
        }

        public final void setEnvEnter(AssignedEnvironmentEnterSessionActionDefinition.BuilderImpl envEnter) {
            Object oldValue = this.envEnter;
            this.envEnter = envEnter != null ? envEnter.build() : null;
            handleUnionValueChange(Type.ENV_ENTER, oldValue, this.envEnter);
        }

        @Override
        public final Builder envEnter(AssignedEnvironmentEnterSessionActionDefinition envEnter) {
            Object oldValue = this.envEnter;
            this.envEnter = envEnter;
            handleUnionValueChange(Type.ENV_ENTER, oldValue, this.envEnter);
            return this;
        }

        public final AssignedEnvironmentExitSessionActionDefinition.Builder getEnvExit() {
            return envExit != null ? envExit.toBuilder() : null;
        }

        public final void setEnvExit(AssignedEnvironmentExitSessionActionDefinition.BuilderImpl envExit) {
            Object oldValue = this.envExit;
            this.envExit = envExit != null ? envExit.build() : null;
            handleUnionValueChange(Type.ENV_EXIT, oldValue, this.envExit);
        }

        @Override
        public final Builder envExit(AssignedEnvironmentExitSessionActionDefinition envExit) {
            Object oldValue = this.envExit;
            this.envExit = envExit;
            handleUnionValueChange(Type.ENV_EXIT, oldValue, this.envExit);
            return this;
        }

        public final AssignedTaskRunSessionActionDefinition.Builder getTaskRun() {
            return taskRun != null ? taskRun.toBuilder() : null;
        }

        public final void setTaskRun(AssignedTaskRunSessionActionDefinition.BuilderImpl taskRun) {
            Object oldValue = this.taskRun;
            this.taskRun = taskRun != null ? taskRun.build() : null;
            handleUnionValueChange(Type.TASK_RUN, oldValue, this.taskRun);
        }

        @Override
        public final Builder taskRun(AssignedTaskRunSessionActionDefinition taskRun) {
            Object oldValue = this.taskRun;
            this.taskRun = taskRun;
            handleUnionValueChange(Type.TASK_RUN, oldValue, this.taskRun);
            return this;
        }

        public final AssignedSyncInputJobAttachmentsSessionActionDefinition.Builder getSyncInputJobAttachments() {
            return syncInputJobAttachments != null ? syncInputJobAttachments.toBuilder() : null;
        }

        public final void setSyncInputJobAttachments(
                AssignedSyncInputJobAttachmentsSessionActionDefinition.BuilderImpl syncInputJobAttachments) {
            Object oldValue = this.syncInputJobAttachments;
            this.syncInputJobAttachments = syncInputJobAttachments != null ? syncInputJobAttachments.build() : null;
            handleUnionValueChange(Type.SYNC_INPUT_JOB_ATTACHMENTS, oldValue, this.syncInputJobAttachments);
        }

        @Override
        public final Builder syncInputJobAttachments(
                AssignedSyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments) {
            Object oldValue = this.syncInputJobAttachments;
            this.syncInputJobAttachments = syncInputJobAttachments;
            handleUnionValueChange(Type.SYNC_INPUT_JOB_ATTACHMENTS, oldValue, this.syncInputJobAttachments);
            return this;
        }

        @Override
        public AssignedSessionActionDefinition build() {
            return new AssignedSessionActionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AssignedSessionActionDefinition#type()
     */
    public enum Type {
        ENV_ENTER,

        ENV_EXIT,

        TASK_RUN,

        SYNC_INPUT_JOB_ATTACHMENTS,

        UNKNOWN_TO_SDK_VERSION
    }
}
