/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the EBS volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2EbsVolume implements SdkPojo, Serializable, ToCopyableBuilder<Ec2EbsVolume.Builder, Ec2EbsVolume> {
    private static final SdkField<Integer> SIZE_GIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sizeGiB").getter(getter(Ec2EbsVolume::sizeGiB)).setter(setter(Builder::sizeGiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeGiB").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("iops")
            .getter(getter(Ec2EbsVolume::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()).build();

    private static final SdkField<Integer> THROUGHPUT_MIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("throughputMiB").getter(getter(Ec2EbsVolume::throughputMiB)).setter(setter(Builder::throughputMiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughputMiB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_GIB_FIELD, IOPS_FIELD,
            THROUGHPUT_MIB_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer sizeGiB;

    private final Integer iops;

    private final Integer throughputMiB;

    private Ec2EbsVolume(BuilderImpl builder) {
        this.sizeGiB = builder.sizeGiB;
        this.iops = builder.iops;
        this.throughputMiB = builder.throughputMiB;
    }

    /**
     * <p>
     * The EBS volume size in GiB.
     * </p>
     * 
     * @return The EBS volume size in GiB.
     */
    public final Integer sizeGiB() {
        return sizeGiB;
    }

    /**
     * <p>
     * The IOPS per volume.
     * </p>
     * 
     * @return The IOPS per volume.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The throughput per volume in MiB.
     * </p>
     * 
     * @return The throughput per volume in MiB.
     */
    public final Integer throughputMiB() {
        return throughputMiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizeGiB());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(throughputMiB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2EbsVolume)) {
            return false;
        }
        Ec2EbsVolume other = (Ec2EbsVolume) obj;
        return Objects.equals(sizeGiB(), other.sizeGiB()) && Objects.equals(iops(), other.iops())
                && Objects.equals(throughputMiB(), other.throughputMiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2EbsVolume").add("SizeGiB", sizeGiB()).add("Iops", iops())
                .add("ThroughputMiB", throughputMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sizeGiB":
            return Optional.ofNullable(clazz.cast(sizeGiB()));
        case "iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "throughputMiB":
            return Optional.ofNullable(clazz.cast(throughputMiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2EbsVolume, T> g) {
        return obj -> g.apply((Ec2EbsVolume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2EbsVolume> {
        /**
         * <p>
         * The EBS volume size in GiB.
         * </p>
         * 
         * @param sizeGiB
         *        The EBS volume size in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeGiB(Integer sizeGiB);

        /**
         * <p>
         * The IOPS per volume.
         * </p>
         * 
         * @param iops
         *        The IOPS per volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The throughput per volume in MiB.
         * </p>
         * 
         * @param throughputMiB
         *        The throughput per volume in MiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputMiB(Integer throughputMiB);
    }

    static final class BuilderImpl implements Builder {
        private Integer sizeGiB;

        private Integer iops;

        private Integer throughputMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2EbsVolume model) {
            sizeGiB(model.sizeGiB);
            iops(model.iops);
            throughputMiB(model.throughputMiB);
        }

        public final Integer getSizeGiB() {
            return sizeGiB;
        }

        public final void setSizeGiB(Integer sizeGiB) {
            this.sizeGiB = sizeGiB;
        }

        @Override
        public final Builder sizeGiB(Integer sizeGiB) {
            this.sizeGiB = sizeGiB;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getThroughputMiB() {
            return throughputMiB;
        }

        public final void setThroughputMiB(Integer throughputMiB) {
            this.throughputMiB = throughputMiB;
        }

        @Override
        public final Builder throughputMiB(Integer throughputMiB) {
            this.throughputMiB = throughputMiB;
            return this;
        }

        @Override
        public Ec2EbsVolume build() {
            return new Ec2EbsVolume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
