/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueueResponse extends DeadlineResponse implements
        ToCopyableBuilder<GetQueueResponse.Builder, GetQueueResponse> {
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(GetQueueResponse::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetQueueResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetQueueResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(GetQueueResponse::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farmId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetQueueResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DEFAULT_BUDGET_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultBudgetAction").getter(getter(GetQueueResponse::defaultBudgetActionAsString))
            .setter(setter(Builder::defaultBudgetAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBudgetAction").build())
            .build();

    private static final SdkField<String> BLOCKED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockedReason").getter(getter(GetQueueResponse::blockedReasonAsString))
            .setter(setter(Builder::blockedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedReason").build()).build();

    private static final SdkField<JobAttachmentSettings> JOB_ATTACHMENT_SETTINGS_FIELD = SdkField
            .<JobAttachmentSettings> builder(MarshallingType.SDK_POJO).memberName("jobAttachmentSettings")
            .getter(getter(GetQueueResponse::jobAttachmentSettings)).setter(setter(Builder::jobAttachmentSettings))
            .constructor(JobAttachmentSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobAttachmentSettings").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetQueueResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<String>> REQUIRED_FILE_SYSTEM_LOCATION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("requiredFileSystemLocationNames")
            .getter(getter(GetQueueResponse::requiredFileSystemLocationNames))
            .setter(setter(Builder::requiredFileSystemLocationNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredFileSystemLocationNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_STORAGE_PROFILE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedStorageProfileIds")
            .getter(getter(GetQueueResponse::allowedStorageProfileIds))
            .setter(setter(Builder::allowedStorageProfileIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedStorageProfileIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<JobRunAsUser> JOB_RUN_AS_USER_FIELD = SdkField.<JobRunAsUser> builder(MarshallingType.SDK_POJO)
            .memberName("jobRunAsUser").getter(getter(GetQueueResponse::jobRunAsUser)).setter(setter(Builder::jobRunAsUser))
            .constructor(JobRunAsUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRunAsUser").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetQueueResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetQueueResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetQueueResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(GetQueueResponse::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ID_FIELD,
            DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, FARM_ID_FIELD, STATUS_FIELD, DEFAULT_BUDGET_ACTION_FIELD,
            BLOCKED_REASON_FIELD, JOB_ATTACHMENT_SETTINGS_FIELD, ROLE_ARN_FIELD, REQUIRED_FILE_SYSTEM_LOCATION_NAMES_FIELD,
            ALLOWED_STORAGE_PROFILE_IDS_FIELD, JOB_RUN_AS_USER_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD,
            UPDATED_BY_FIELD));

    private final String queueId;

    private final String displayName;

    private final String description;

    private final String farmId;

    private final String status;

    private final String defaultBudgetAction;

    private final String blockedReason;

    private final JobAttachmentSettings jobAttachmentSettings;

    private final String roleArn;

    private final List<String> requiredFileSystemLocationNames;

    private final List<String> allowedStorageProfileIds;

    private final JobRunAsUser jobRunAsUser;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private GetQueueResponse(BuilderImpl builder) {
        super(builder);
        this.queueId = builder.queueId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.farmId = builder.farmId;
        this.status = builder.status;
        this.defaultBudgetAction = builder.defaultBudgetAction;
        this.blockedReason = builder.blockedReason;
        this.jobAttachmentSettings = builder.jobAttachmentSettings;
        this.roleArn = builder.roleArn;
        this.requiredFileSystemLocationNames = builder.requiredFileSystemLocationNames;
        this.allowedStorageProfileIds = builder.allowedStorageProfileIds;
        this.jobRunAsUser = builder.jobRunAsUser;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The queue ID.
     * </p>
     * 
     * @return The queue ID.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The display name of the queue.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The display name of the queue.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the queue.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The description of the queue.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The farm ID for the queue.
     * </p>
     * 
     * @return The farm ID for the queue.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The status of the queue.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>–The queue is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULING</code>–The queue is scheduling.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked. See the provided reason.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the queue.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>–The queue is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULING</code>–The queue is scheduling.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked. See the provided reason.
     *         </p>
     *         </li>
     * @see QueueStatus
     */
    public final QueueStatus status() {
        return QueueStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the queue.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>–The queue is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULING</code>–The queue is scheduling.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked. See the provided reason.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the queue.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>–The queue is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULING</code>–The queue is scheduling.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked. See the provided reason.
     *         </p>
     *         </li>
     * @see QueueStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The default action taken on a queue if a budget wasn't configured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultBudgetAction} will return {@link DefaultQueueBudgetAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultBudgetActionAsString}.
     * </p>
     * 
     * @return The default action taken on a queue if a budget wasn't configured.
     * @see DefaultQueueBudgetAction
     */
    public final DefaultQueueBudgetAction defaultBudgetAction() {
        return DefaultQueueBudgetAction.fromValue(defaultBudgetAction);
    }

    /**
     * <p>
     * The default action taken on a queue if a budget wasn't configured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultBudgetAction} will return {@link DefaultQueueBudgetAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultBudgetActionAsString}.
     * </p>
     * 
     * @return The default action taken on a queue if a budget wasn't configured.
     * @see DefaultQueueBudgetAction
     */
    public final String defaultBudgetActionAsString() {
        return defaultBudgetAction;
    }

    /**
     * <p>
     * The reason the queue was blocked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blockedReason}
     * will return {@link QueueBlockedReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blockedReasonAsString}.
     * </p>
     * 
     * @return The reason the queue was blocked.
     * @see QueueBlockedReason
     */
    public final QueueBlockedReason blockedReason() {
        return QueueBlockedReason.fromValue(blockedReason);
    }

    /**
     * <p>
     * The reason the queue was blocked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blockedReason}
     * will return {@link QueueBlockedReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blockedReasonAsString}.
     * </p>
     * 
     * @return The reason the queue was blocked.
     * @see QueueBlockedReason
     */
    public final String blockedReasonAsString() {
        return blockedReason;
    }

    /**
     * <p>
     * The job attachment settings for the queue.
     * </p>
     * 
     * @return The job attachment settings for the queue.
     */
    public final JobAttachmentSettings jobAttachmentSettings() {
        return jobAttachmentSettings;
    }

    /**
     * <p>
     * The IAM role ARN.
     * </p>
     * 
     * @return The IAM role ARN.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequiredFileSystemLocationNames
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasRequiredFileSystemLocationNames() {
        return requiredFileSystemLocationNames != null && !(requiredFileSystemLocationNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the required file system location names in the queue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequiredFileSystemLocationNames}
     * method.
     * </p>
     * 
     * @return A list of the required file system location names in the queue.
     */
    public final List<String> requiredFileSystemLocationNames() {
        return requiredFileSystemLocationNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedStorageProfileIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedStorageProfileIds() {
        return allowedStorageProfileIds != null && !(allowedStorageProfileIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The storage profile IDs for the queue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedStorageProfileIds} method.
     * </p>
     * 
     * @return The storage profile IDs for the queue.
     */
    public final List<String> allowedStorageProfileIds() {
        return allowedStorageProfileIds;
    }

    /**
     * <p>
     * The jobs in the queue ran as this specified POSIX user.
     * </p>
     * 
     * @return The jobs in the queue ran as this specified POSIX user.
     */
    public final JobRunAsUser jobRunAsUser() {
        return jobRunAsUser;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or system that created this resource.
     * </p>
     * 
     * @return The user or system that created this resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultBudgetActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockedReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobAttachmentSettings());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRequiredFileSystemLocationNames() ? requiredFileSystemLocationNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedStorageProfileIds() ? allowedStorageProfileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobRunAsUser());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueResponse)) {
            return false;
        }
        GetQueueResponse other = (GetQueueResponse) obj;
        return Objects.equals(queueId(), other.queueId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(description(), other.description()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(defaultBudgetActionAsString(), other.defaultBudgetActionAsString())
                && Objects.equals(blockedReasonAsString(), other.blockedReasonAsString())
                && Objects.equals(jobAttachmentSettings(), other.jobAttachmentSettings())
                && Objects.equals(roleArn(), other.roleArn())
                && hasRequiredFileSystemLocationNames() == other.hasRequiredFileSystemLocationNames()
                && Objects.equals(requiredFileSystemLocationNames(), other.requiredFileSystemLocationNames())
                && hasAllowedStorageProfileIds() == other.hasAllowedStorageProfileIds()
                && Objects.equals(allowedStorageProfileIds(), other.allowedStorageProfileIds())
                && Objects.equals(jobRunAsUser(), other.jobRunAsUser()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetQueueResponse")
                .add("QueueId", queueId())
                .add("DisplayName", displayName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FarmId", farmId())
                .add("Status", statusAsString())
                .add("DefaultBudgetAction", defaultBudgetActionAsString())
                .add("BlockedReason", blockedReasonAsString())
                .add("JobAttachmentSettings", jobAttachmentSettings())
                .add("RoleArn", roleArn())
                .add("RequiredFileSystemLocationNames",
                        requiredFileSystemLocationNames() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AllowedStorageProfileIds", hasAllowedStorageProfileIds() ? allowedStorageProfileIds() : null)
                .add("JobRunAsUser", jobRunAsUser()).add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "defaultBudgetAction":
            return Optional.ofNullable(clazz.cast(defaultBudgetActionAsString()));
        case "blockedReason":
            return Optional.ofNullable(clazz.cast(blockedReasonAsString()));
        case "jobAttachmentSettings":
            return Optional.ofNullable(clazz.cast(jobAttachmentSettings()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "requiredFileSystemLocationNames":
            return Optional.ofNullable(clazz.cast(requiredFileSystemLocationNames()));
        case "allowedStorageProfileIds":
            return Optional.ofNullable(clazz.cast(allowedStorageProfileIds()));
        case "jobRunAsUser":
            return Optional.ofNullable(clazz.cast(jobRunAsUser()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQueueResponse, T> g) {
        return obj -> g.apply((GetQueueResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQueueResponse> {
        /**
         * <p>
         * The queue ID.
         * </p>
         * 
         * @param queueId
         *        The queue ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The display name of the queue.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param displayName
         *        The display name of the queue.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the queue.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param description
         *        The description of the queue.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The farm ID for the queue.
         * </p>
         * 
         * @param farmId
         *        The farm ID for the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The status of the queue.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>–The queue is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULING</code>–The queue is scheduling.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked. See the provided reason.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the queue.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>–The queue is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULING</code>–The queue is scheduling.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked. See the provided reason.
         *        </p>
         *        </li>
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the queue.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>–The queue is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULING</code>–The queue is scheduling.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked. See the provided reason.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the queue.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>–The queue is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULING</code>–The queue is scheduling.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked. See the provided reason.
         *        </p>
         *        </li>
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(QueueStatus status);

        /**
         * <p>
         * The default action taken on a queue if a budget wasn't configured.
         * </p>
         * 
         * @param defaultBudgetAction
         *        The default action taken on a queue if a budget wasn't configured.
         * @see DefaultQueueBudgetAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultQueueBudgetAction
         */
        Builder defaultBudgetAction(String defaultBudgetAction);

        /**
         * <p>
         * The default action taken on a queue if a budget wasn't configured.
         * </p>
         * 
         * @param defaultBudgetAction
         *        The default action taken on a queue if a budget wasn't configured.
         * @see DefaultQueueBudgetAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultQueueBudgetAction
         */
        Builder defaultBudgetAction(DefaultQueueBudgetAction defaultBudgetAction);

        /**
         * <p>
         * The reason the queue was blocked.
         * </p>
         * 
         * @param blockedReason
         *        The reason the queue was blocked.
         * @see QueueBlockedReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueBlockedReason
         */
        Builder blockedReason(String blockedReason);

        /**
         * <p>
         * The reason the queue was blocked.
         * </p>
         * 
         * @param blockedReason
         *        The reason the queue was blocked.
         * @see QueueBlockedReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueBlockedReason
         */
        Builder blockedReason(QueueBlockedReason blockedReason);

        /**
         * <p>
         * The job attachment settings for the queue.
         * </p>
         * 
         * @param jobAttachmentSettings
         *        The job attachment settings for the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings);

        /**
         * <p>
         * The job attachment settings for the queue.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobAttachmentSettings.Builder} avoiding
         * the need to create one manually via {@link JobAttachmentSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobAttachmentSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #jobAttachmentSettings(JobAttachmentSettings)}.
         * 
         * @param jobAttachmentSettings
         *        a consumer that will call methods on {@link JobAttachmentSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobAttachmentSettings(JobAttachmentSettings)
         */
        default Builder jobAttachmentSettings(Consumer<JobAttachmentSettings.Builder> jobAttachmentSettings) {
            return jobAttachmentSettings(JobAttachmentSettings.builder().applyMutation(jobAttachmentSettings).build());
        }

        /**
         * <p>
         * The IAM role ARN.
         * </p>
         * 
         * @param roleArn
         *        The IAM role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of the required file system location names in the queue.
         * </p>
         * 
         * @param requiredFileSystemLocationNames
         *        A list of the required file system location names in the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredFileSystemLocationNames(Collection<String> requiredFileSystemLocationNames);

        /**
         * <p>
         * A list of the required file system location names in the queue.
         * </p>
         * 
         * @param requiredFileSystemLocationNames
         *        A list of the required file system location names in the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredFileSystemLocationNames(String... requiredFileSystemLocationNames);

        /**
         * <p>
         * The storage profile IDs for the queue.
         * </p>
         * 
         * @param allowedStorageProfileIds
         *        The storage profile IDs for the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedStorageProfileIds(Collection<String> allowedStorageProfileIds);

        /**
         * <p>
         * The storage profile IDs for the queue.
         * </p>
         * 
         * @param allowedStorageProfileIds
         *        The storage profile IDs for the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedStorageProfileIds(String... allowedStorageProfileIds);

        /**
         * <p>
         * The jobs in the queue ran as this specified POSIX user.
         * </p>
         * 
         * @param jobRunAsUser
         *        The jobs in the queue ran as this specified POSIX user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRunAsUser(JobRunAsUser jobRunAsUser);

        /**
         * <p>
         * The jobs in the queue ran as this specified POSIX user.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobRunAsUser.Builder} avoiding the need
         * to create one manually via {@link JobRunAsUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobRunAsUser.Builder#build()} is called immediately and its
         * result is passed to {@link #jobRunAsUser(JobRunAsUser)}.
         * 
         * @param jobRunAsUser
         *        a consumer that will call methods on {@link JobRunAsUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobRunAsUser(JobRunAsUser)
         */
        default Builder jobRunAsUser(Consumer<JobRunAsUser.Builder> jobRunAsUser) {
            return jobRunAsUser(JobRunAsUser.builder().applyMutation(jobRunAsUser).build());
        }

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or system that created this resource.
         * </p>
         * 
         * @param createdBy
         *        The user or system that created this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private String queueId;

        private String displayName;

        private String description;

        private String farmId;

        private String status;

        private String defaultBudgetAction;

        private String blockedReason;

        private JobAttachmentSettings jobAttachmentSettings;

        private String roleArn;

        private List<String> requiredFileSystemLocationNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedStorageProfileIds = DefaultSdkAutoConstructList.getInstance();

        private JobRunAsUser jobRunAsUser;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueResponse model) {
            super(model);
            queueId(model.queueId);
            displayName(model.displayName);
            description(model.description);
            farmId(model.farmId);
            status(model.status);
            defaultBudgetAction(model.defaultBudgetAction);
            blockedReason(model.blockedReason);
            jobAttachmentSettings(model.jobAttachmentSettings);
            roleArn(model.roleArn);
            requiredFileSystemLocationNames(model.requiredFileSystemLocationNames);
            allowedStorageProfileIds(model.allowedStorageProfileIds);
            jobRunAsUser(model.jobRunAsUser);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDefaultBudgetAction() {
            return defaultBudgetAction;
        }

        public final void setDefaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
        }

        @Override
        public final Builder defaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
            return this;
        }

        @Override
        public final Builder defaultBudgetAction(DefaultQueueBudgetAction defaultBudgetAction) {
            this.defaultBudgetAction(defaultBudgetAction == null ? null : defaultBudgetAction.toString());
            return this;
        }

        public final String getBlockedReason() {
            return blockedReason;
        }

        public final void setBlockedReason(String blockedReason) {
            this.blockedReason = blockedReason;
        }

        @Override
        public final Builder blockedReason(String blockedReason) {
            this.blockedReason = blockedReason;
            return this;
        }

        @Override
        public final Builder blockedReason(QueueBlockedReason blockedReason) {
            this.blockedReason(blockedReason == null ? null : blockedReason.toString());
            return this;
        }

        public final JobAttachmentSettings.Builder getJobAttachmentSettings() {
            return jobAttachmentSettings != null ? jobAttachmentSettings.toBuilder() : null;
        }

        public final void setJobAttachmentSettings(JobAttachmentSettings.BuilderImpl jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings != null ? jobAttachmentSettings.build() : null;
        }

        @Override
        public final Builder jobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getRequiredFileSystemLocationNames() {
            if (requiredFileSystemLocationNames instanceof SdkAutoConstructList) {
                return null;
            }
            return requiredFileSystemLocationNames;
        }

        public final void setRequiredFileSystemLocationNames(Collection<String> requiredFileSystemLocationNames) {
            this.requiredFileSystemLocationNames = RequiredFileSystemLocationNamesCopier.copy(requiredFileSystemLocationNames);
        }

        @Override
        public final Builder requiredFileSystemLocationNames(Collection<String> requiredFileSystemLocationNames) {
            this.requiredFileSystemLocationNames = RequiredFileSystemLocationNamesCopier.copy(requiredFileSystemLocationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFileSystemLocationNames(String... requiredFileSystemLocationNames) {
            requiredFileSystemLocationNames(Arrays.asList(requiredFileSystemLocationNames));
            return this;
        }

        public final Collection<String> getAllowedStorageProfileIds() {
            if (allowedStorageProfileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedStorageProfileIds;
        }

        public final void setAllowedStorageProfileIds(Collection<String> allowedStorageProfileIds) {
            this.allowedStorageProfileIds = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIds);
        }

        @Override
        public final Builder allowedStorageProfileIds(Collection<String> allowedStorageProfileIds) {
            this.allowedStorageProfileIds = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedStorageProfileIds(String... allowedStorageProfileIds) {
            allowedStorageProfileIds(Arrays.asList(allowedStorageProfileIds));
            return this;
        }

        public final JobRunAsUser.Builder getJobRunAsUser() {
            return jobRunAsUser != null ? jobRunAsUser.toBuilder() : null;
        }

        public final void setJobRunAsUser(JobRunAsUser.BuilderImpl jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser != null ? jobRunAsUser.build() : null;
        }

        @Override
        public final Builder jobRunAsUser(JobRunAsUser jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public GetQueueResponse build() {
            return new GetQueueResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
