/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSessionsStatisticsAggregationResponse extends DeadlineResponse implements
        ToCopyableBuilder<GetSessionsStatisticsAggregationResponse.Builder, GetSessionsStatisticsAggregationResponse> {
    private static final SdkField<List<Statistics>> STATISTICS_FIELD = SdkField
            .<List<Statistics>> builder(MarshallingType.LIST)
            .memberName("statistics")
            .getter(getter(GetSessionsStatisticsAggregationResponse::statistics))
            .setter(setter(Builder::statistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Statistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(Statistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetSessionsStatisticsAggregationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetSessionsStatisticsAggregationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(GetSessionsStatisticsAggregationResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTICS_FIELD,
            NEXT_TOKEN_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private final List<Statistics> statistics;

    private final String nextToken;

    private final String status;

    private final String statusMessage;

    private GetSessionsStatisticsAggregationResponse(BuilderImpl builder) {
        super(builder);
        this.statistics = builder.statistics;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Statistics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatistics() {
        return statistics != null && !(statistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The statistics for the specified fleets or queues.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatistics} method.
     * </p>
     * 
     * @return The statistics for the specified fleets or queues.
     */
    public final List<Statistics> statistics() {
        return statistics;
    }

    /**
     * <p>
     * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation
     * again using the returned token. Keep all other arguments unchanged. If no results remain, then
     * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide
     * a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     * </p>
     * 
     * @return If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
     *         operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
     *         <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
     *         provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The status of the aggregated results. An aggregation may fail or time out if the results are too large. If this
     * happens, you can call the <code>StartSessionsStatisticsAggregation</code> operation after you reduce the
     * aggregation time frame, reduce the number of queues or fleets in the aggregation, or increase the period length.
     * </p>
     * <p>
     * If you call the <code>StartSessionsStatisticsAggregation </code> operation when the status is
     * <code>IN_PROGRESS</code>, you will receive a <code>ThrottlingException</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionsStatisticsAggregationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the aggregated results. An aggregation may fail or time out if the results are too large.
     *         If this happens, you can call the <code>StartSessionsStatisticsAggregation</code> operation after you
     *         reduce the aggregation time frame, reduce the number of queues or fleets in the aggregation, or increase
     *         the period length.</p>
     *         <p>
     *         If you call the <code>StartSessionsStatisticsAggregation </code> operation when the status is
     *         <code>IN_PROGRESS</code>, you will receive a <code>ThrottlingException</code>.
     * @see SessionsStatisticsAggregationStatus
     */
    public final SessionsStatisticsAggregationStatus status() {
        return SessionsStatisticsAggregationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the aggregated results. An aggregation may fail or time out if the results are too large. If this
     * happens, you can call the <code>StartSessionsStatisticsAggregation</code> operation after you reduce the
     * aggregation time frame, reduce the number of queues or fleets in the aggregation, or increase the period length.
     * </p>
     * <p>
     * If you call the <code>StartSessionsStatisticsAggregation </code> operation when the status is
     * <code>IN_PROGRESS</code>, you will receive a <code>ThrottlingException</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionsStatisticsAggregationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the aggregated results. An aggregation may fail or time out if the results are too large.
     *         If this happens, you can call the <code>StartSessionsStatisticsAggregation</code> operation after you
     *         reduce the aggregation time frame, reduce the number of queues or fleets in the aggregation, or increase
     *         the period length.</p>
     *         <p>
     *         If you call the <code>StartSessionsStatisticsAggregation </code> operation when the status is
     *         <code>IN_PROGRESS</code>, you will receive a <code>ThrottlingException</code>.
     * @see SessionsStatisticsAggregationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message that describes the status.
     * </p>
     * 
     * @return A message that describes the status.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStatistics() ? statistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionsStatisticsAggregationResponse)) {
            return false;
        }
        GetSessionsStatisticsAggregationResponse other = (GetSessionsStatisticsAggregationResponse) obj;
        return hasStatistics() == other.hasStatistics() && Objects.equals(statistics(), other.statistics())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSessionsStatisticsAggregationResponse")
                .add("Statistics", hasStatistics() ? statistics() : null).add("NextToken", nextToken())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSessionsStatisticsAggregationResponse, T> g) {
        return obj -> g.apply((GetSessionsStatisticsAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSessionsStatisticsAggregationResponse> {
        /**
         * <p>
         * The statistics for the specified fleets or queues.
         * </p>
         * 
         * @param statistics
         *        The statistics for the specified fleets or queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(Collection<Statistics> statistics);

        /**
         * <p>
         * The statistics for the specified fleets or queues.
         * </p>
         * 
         * @param statistics
         *        The statistics for the specified fleets or queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(Statistics... statistics);

        /**
         * <p>
         * The statistics for the specified fleets or queues.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.Statistics.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.deadline.model.Statistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.Statistics.Builder#build()} is called immediately and
         * its result is passed to {@link #statistics(List<Statistics>)}.
         * 
         * @param statistics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.Statistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(java.util.Collection<Statistics>)
         */
        Builder statistics(Consumer<Statistics.Builder>... statistics);

        /**
         * <p>
         * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         * operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
         * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
         * provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
         * </p>
         * 
         * @param nextToken
         *        If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         *        operation again using the returned token. Keep all other arguments unchanged. If no results remain,
         *        then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours.
         *        If you provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The status of the aggregated results. An aggregation may fail or time out if the results are too large. If
         * this happens, you can call the <code>StartSessionsStatisticsAggregation</code> operation after you reduce the
         * aggregation time frame, reduce the number of queues or fleets in the aggregation, or increase the period
         * length.
         * </p>
         * <p>
         * If you call the <code>StartSessionsStatisticsAggregation </code> operation when the status is
         * <code>IN_PROGRESS</code>, you will receive a <code>ThrottlingException</code>.
         * </p>
         * 
         * @param status
         *        The status of the aggregated results. An aggregation may fail or time out if the results are too
         *        large. If this happens, you can call the <code>StartSessionsStatisticsAggregation</code> operation
         *        after you reduce the aggregation time frame, reduce the number of queues or fleets in the aggregation,
         *        or increase the period length.</p>
         *        <p>
         *        If you call the <code>StartSessionsStatisticsAggregation </code> operation when the status is
         *        <code>IN_PROGRESS</code>, you will receive a <code>ThrottlingException</code>.
         * @see SessionsStatisticsAggregationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionsStatisticsAggregationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the aggregated results. An aggregation may fail or time out if the results are too large. If
         * this happens, you can call the <code>StartSessionsStatisticsAggregation</code> operation after you reduce the
         * aggregation time frame, reduce the number of queues or fleets in the aggregation, or increase the period
         * length.
         * </p>
         * <p>
         * If you call the <code>StartSessionsStatisticsAggregation </code> operation when the status is
         * <code>IN_PROGRESS</code>, you will receive a <code>ThrottlingException</code>.
         * </p>
         * 
         * @param status
         *        The status of the aggregated results. An aggregation may fail or time out if the results are too
         *        large. If this happens, you can call the <code>StartSessionsStatisticsAggregation</code> operation
         *        after you reduce the aggregation time frame, reduce the number of queues or fleets in the aggregation,
         *        or increase the period length.</p>
         *        <p>
         *        If you call the <code>StartSessionsStatisticsAggregation </code> operation when the status is
         *        <code>IN_PROGRESS</code>, you will receive a <code>ThrottlingException</code>.
         * @see SessionsStatisticsAggregationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionsStatisticsAggregationStatus
         */
        Builder status(SessionsStatisticsAggregationStatus status);

        /**
         * <p>
         * A message that describes the status.
         * </p>
         * 
         * @param statusMessage
         *        A message that describes the status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private List<Statistics> statistics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionsStatisticsAggregationResponse model) {
            super(model);
            statistics(model.statistics);
            nextToken(model.nextToken);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final List<Statistics.Builder> getStatistics() {
            List<Statistics.Builder> result = StatisticsListCopier.copyToBuilder(this.statistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatistics(Collection<Statistics.BuilderImpl> statistics) {
            this.statistics = StatisticsListCopier.copyFromBuilder(statistics);
        }

        @Override
        public final Builder statistics(Collection<Statistics> statistics) {
            this.statistics = StatisticsListCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(Statistics... statistics) {
            statistics(Arrays.asList(statistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(Consumer<Statistics.Builder>... statistics) {
            statistics(Stream.of(statistics).map(c -> Statistics.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionsStatisticsAggregationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public GetSessionsStatisticsAggregationResponse build() {
            return new GetSessionsStatisticsAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
