/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type of search filter to apply.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchFilterExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchFilterExpression.Builder, SearchFilterExpression> {
    private static final SdkField<DateTimeFilterExpression> DATE_TIME_FILTER_FIELD = SdkField
            .<DateTimeFilterExpression> builder(MarshallingType.SDK_POJO).memberName("dateTimeFilter")
            .getter(getter(SearchFilterExpression::dateTimeFilter)).setter(setter(Builder::dateTimeFilter))
            .constructor(DateTimeFilterExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateTimeFilter").build()).build();

    private static final SdkField<ParameterFilterExpression> PARAMETER_FILTER_FIELD = SdkField
            .<ParameterFilterExpression> builder(MarshallingType.SDK_POJO).memberName("parameterFilter")
            .getter(getter(SearchFilterExpression::parameterFilter)).setter(setter(Builder::parameterFilter))
            .constructor(ParameterFilterExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterFilter").build()).build();

    private static final SdkField<SearchTermFilterExpression> SEARCH_TERM_FILTER_FIELD = SdkField
            .<SearchTermFilterExpression> builder(MarshallingType.SDK_POJO).memberName("searchTermFilter")
            .getter(getter(SearchFilterExpression::searchTermFilter)).setter(setter(Builder::searchTermFilter))
            .constructor(SearchTermFilterExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchTermFilter").build()).build();

    private static final SdkField<StringFilterExpression> STRING_FILTER_FIELD = SdkField
            .<StringFilterExpression> builder(MarshallingType.SDK_POJO).memberName("stringFilter")
            .getter(getter(SearchFilterExpression::stringFilter)).setter(setter(Builder::stringFilter))
            .constructor(StringFilterExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringFilter").build()).build();

    private static final SdkField<SearchGroupedFilterExpressions> GROUP_FILTER_FIELD = SdkField
            .<SearchGroupedFilterExpressions> builder(MarshallingType.SDK_POJO).memberName("groupFilter")
            .getter(getter(SearchFilterExpression::groupFilter)).setter(setter(Builder::groupFilter))
            .constructor(SearchGroupedFilterExpressions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_TIME_FILTER_FIELD,
            PARAMETER_FILTER_FIELD, SEARCH_TERM_FILTER_FIELD, STRING_FILTER_FIELD, GROUP_FILTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final DateTimeFilterExpression dateTimeFilter;

    private final ParameterFilterExpression parameterFilter;

    private final SearchTermFilterExpression searchTermFilter;

    private final StringFilterExpression stringFilter;

    private final SearchGroupedFilterExpressions groupFilter;

    private final Type type;

    private SearchFilterExpression(BuilderImpl builder) {
        this.dateTimeFilter = builder.dateTimeFilter;
        this.parameterFilter = builder.parameterFilter;
        this.searchTermFilter = builder.searchTermFilter;
        this.stringFilter = builder.stringFilter;
        this.groupFilter = builder.groupFilter;
        this.type = builder.type;
    }

    /**
     * <p>
     * Filters based on date and time.
     * </p>
     * 
     * @return Filters based on date and time.
     */
    public final DateTimeFilterExpression dateTimeFilter() {
        return dateTimeFilter;
    }

    /**
     * <p>
     * Filters by parameter.
     * </p>
     * 
     * @return Filters by parameter.
     */
    public final ParameterFilterExpression parameterFilter() {
        return parameterFilter;
    }

    /**
     * <p>
     * Filters by a specified search term.
     * </p>
     * 
     * @return Filters by a specified search term.
     */
    public final SearchTermFilterExpression searchTermFilter() {
        return searchTermFilter;
    }

    /**
     * <p>
     * Filters by a string.
     * </p>
     * 
     * @return Filters by a string.
     */
    public final StringFilterExpression stringFilter() {
        return stringFilter;
    }

    /**
     * <p>
     * Filters by group.
     * </p>
     * 
     * @return Filters by group.
     */
    public final SearchGroupedFilterExpressions groupFilter() {
        return groupFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dateTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(parameterFilter());
        hashCode = 31 * hashCode + Objects.hashCode(searchTermFilter());
        hashCode = 31 * hashCode + Objects.hashCode(stringFilter());
        hashCode = 31 * hashCode + Objects.hashCode(groupFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFilterExpression)) {
            return false;
        }
        SearchFilterExpression other = (SearchFilterExpression) obj;
        return Objects.equals(dateTimeFilter(), other.dateTimeFilter())
                && Objects.equals(parameterFilter(), other.parameterFilter())
                && Objects.equals(searchTermFilter(), other.searchTermFilter())
                && Objects.equals(stringFilter(), other.stringFilter()) && Objects.equals(groupFilter(), other.groupFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchFilterExpression").add("DateTimeFilter", dateTimeFilter())
                .add("ParameterFilter", parameterFilter()).add("SearchTermFilter", searchTermFilter())
                .add("StringFilter", stringFilter()).add("GroupFilter", groupFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dateTimeFilter":
            return Optional.ofNullable(clazz.cast(dateTimeFilter()));
        case "parameterFilter":
            return Optional.ofNullable(clazz.cast(parameterFilter()));
        case "searchTermFilter":
            return Optional.ofNullable(clazz.cast(searchTermFilter()));
        case "stringFilter":
            return Optional.ofNullable(clazz.cast(stringFilter()));
        case "groupFilter":
            return Optional.ofNullable(clazz.cast(groupFilter()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #dateTimeFilter()} initialized to the given value.
     *
     * <p>
     * Filters based on date and time.
     * </p>
     * 
     * @param dateTimeFilter
     *        Filters based on date and time.
     */
    public static SearchFilterExpression fromDateTimeFilter(DateTimeFilterExpression dateTimeFilter) {
        return builder().dateTimeFilter(dateTimeFilter).build();
    }

    /**
     * Create an instance of this class with {@link #dateTimeFilter()} initialized to the given value.
     *
     * <p>
     * Filters based on date and time.
     * </p>
     * 
     * @param dateTimeFilter
     *        Filters based on date and time.
     */
    public static SearchFilterExpression fromDateTimeFilter(Consumer<DateTimeFilterExpression.Builder> dateTimeFilter) {
        DateTimeFilterExpression.Builder builder = DateTimeFilterExpression.builder();
        dateTimeFilter.accept(builder);
        return fromDateTimeFilter(builder.build());
    }

    /**
     * Create an instance of this class with {@link #parameterFilter()} initialized to the given value.
     *
     * <p>
     * Filters by parameter.
     * </p>
     * 
     * @param parameterFilter
     *        Filters by parameter.
     */
    public static SearchFilterExpression fromParameterFilter(ParameterFilterExpression parameterFilter) {
        return builder().parameterFilter(parameterFilter).build();
    }

    /**
     * Create an instance of this class with {@link #parameterFilter()} initialized to the given value.
     *
     * <p>
     * Filters by parameter.
     * </p>
     * 
     * @param parameterFilter
     *        Filters by parameter.
     */
    public static SearchFilterExpression fromParameterFilter(Consumer<ParameterFilterExpression.Builder> parameterFilter) {
        ParameterFilterExpression.Builder builder = ParameterFilterExpression.builder();
        parameterFilter.accept(builder);
        return fromParameterFilter(builder.build());
    }

    /**
     * Create an instance of this class with {@link #searchTermFilter()} initialized to the given value.
     *
     * <p>
     * Filters by a specified search term.
     * </p>
     * 
     * @param searchTermFilter
     *        Filters by a specified search term.
     */
    public static SearchFilterExpression fromSearchTermFilter(SearchTermFilterExpression searchTermFilter) {
        return builder().searchTermFilter(searchTermFilter).build();
    }

    /**
     * Create an instance of this class with {@link #searchTermFilter()} initialized to the given value.
     *
     * <p>
     * Filters by a specified search term.
     * </p>
     * 
     * @param searchTermFilter
     *        Filters by a specified search term.
     */
    public static SearchFilterExpression fromSearchTermFilter(Consumer<SearchTermFilterExpression.Builder> searchTermFilter) {
        SearchTermFilterExpression.Builder builder = SearchTermFilterExpression.builder();
        searchTermFilter.accept(builder);
        return fromSearchTermFilter(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stringFilter()} initialized to the given value.
     *
     * <p>
     * Filters by a string.
     * </p>
     * 
     * @param stringFilter
     *        Filters by a string.
     */
    public static SearchFilterExpression fromStringFilter(StringFilterExpression stringFilter) {
        return builder().stringFilter(stringFilter).build();
    }

    /**
     * Create an instance of this class with {@link #stringFilter()} initialized to the given value.
     *
     * <p>
     * Filters by a string.
     * </p>
     * 
     * @param stringFilter
     *        Filters by a string.
     */
    public static SearchFilterExpression fromStringFilter(Consumer<StringFilterExpression.Builder> stringFilter) {
        StringFilterExpression.Builder builder = StringFilterExpression.builder();
        stringFilter.accept(builder);
        return fromStringFilter(builder.build());
    }

    /**
     * Create an instance of this class with {@link #groupFilter()} initialized to the given value.
     *
     * <p>
     * Filters by group.
     * </p>
     * 
     * @param groupFilter
     *        Filters by group.
     */
    public static SearchFilterExpression fromGroupFilter(SearchGroupedFilterExpressions groupFilter) {
        return builder().groupFilter(groupFilter).build();
    }

    /**
     * Create an instance of this class with {@link #groupFilter()} initialized to the given value.
     *
     * <p>
     * Filters by group.
     * </p>
     * 
     * @param groupFilter
     *        Filters by group.
     */
    public static SearchFilterExpression fromGroupFilter(Consumer<SearchGroupedFilterExpressions.Builder> groupFilter) {
        SearchGroupedFilterExpressions.Builder builder = SearchGroupedFilterExpressions.builder();
        groupFilter.accept(builder);
        return fromGroupFilter(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchFilterExpression, T> g) {
        return obj -> g.apply((SearchFilterExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchFilterExpression> {
        /**
         * <p>
         * Filters based on date and time.
         * </p>
         * 
         * @param dateTimeFilter
         *        Filters based on date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeFilter(DateTimeFilterExpression dateTimeFilter);

        /**
         * <p>
         * Filters based on date and time.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateTimeFilterExpression.Builder}
         * avoiding the need to create one manually via {@link DateTimeFilterExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateTimeFilterExpression.Builder#build()} is called immediately
         * and its result is passed to {@link #dateTimeFilter(DateTimeFilterExpression)}.
         * 
         * @param dateTimeFilter
         *        a consumer that will call methods on {@link DateTimeFilterExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateTimeFilter(DateTimeFilterExpression)
         */
        default Builder dateTimeFilter(Consumer<DateTimeFilterExpression.Builder> dateTimeFilter) {
            return dateTimeFilter(DateTimeFilterExpression.builder().applyMutation(dateTimeFilter).build());
        }

        /**
         * <p>
         * Filters by parameter.
         * </p>
         * 
         * @param parameterFilter
         *        Filters by parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterFilter(ParameterFilterExpression parameterFilter);

        /**
         * <p>
         * Filters by parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterFilterExpression.Builder}
         * avoiding the need to create one manually via {@link ParameterFilterExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterFilterExpression.Builder#build()} is called immediately
         * and its result is passed to {@link #parameterFilter(ParameterFilterExpression)}.
         * 
         * @param parameterFilter
         *        a consumer that will call methods on {@link ParameterFilterExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterFilter(ParameterFilterExpression)
         */
        default Builder parameterFilter(Consumer<ParameterFilterExpression.Builder> parameterFilter) {
            return parameterFilter(ParameterFilterExpression.builder().applyMutation(parameterFilter).build());
        }

        /**
         * <p>
         * Filters by a specified search term.
         * </p>
         * 
         * @param searchTermFilter
         *        Filters by a specified search term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchTermFilter(SearchTermFilterExpression searchTermFilter);

        /**
         * <p>
         * Filters by a specified search term.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchTermFilterExpression.Builder}
         * avoiding the need to create one manually via {@link SearchTermFilterExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchTermFilterExpression.Builder#build()} is called immediately
         * and its result is passed to {@link #searchTermFilter(SearchTermFilterExpression)}.
         * 
         * @param searchTermFilter
         *        a consumer that will call methods on {@link SearchTermFilterExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchTermFilter(SearchTermFilterExpression)
         */
        default Builder searchTermFilter(Consumer<SearchTermFilterExpression.Builder> searchTermFilter) {
            return searchTermFilter(SearchTermFilterExpression.builder().applyMutation(searchTermFilter).build());
        }

        /**
         * <p>
         * Filters by a string.
         * </p>
         * 
         * @param stringFilter
         *        Filters by a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringFilter(StringFilterExpression stringFilter);

        /**
         * <p>
         * Filters by a string.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringFilterExpression.Builder} avoiding
         * the need to create one manually via {@link StringFilterExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringFilterExpression.Builder#build()} is called immediately and
         * its result is passed to {@link #stringFilter(StringFilterExpression)}.
         * 
         * @param stringFilter
         *        a consumer that will call methods on {@link StringFilterExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringFilter(StringFilterExpression)
         */
        default Builder stringFilter(Consumer<StringFilterExpression.Builder> stringFilter) {
            return stringFilter(StringFilterExpression.builder().applyMutation(stringFilter).build());
        }

        /**
         * <p>
         * Filters by group.
         * </p>
         * 
         * @param groupFilter
         *        Filters by group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupFilter(SearchGroupedFilterExpressions groupFilter);

        /**
         * <p>
         * Filters by group.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchGroupedFilterExpressions.Builder}
         * avoiding the need to create one manually via {@link SearchGroupedFilterExpressions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchGroupedFilterExpressions.Builder#build()} is called
         * immediately and its result is passed to {@link #groupFilter(SearchGroupedFilterExpressions)}.
         * 
         * @param groupFilter
         *        a consumer that will call methods on {@link SearchGroupedFilterExpressions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupFilter(SearchGroupedFilterExpressions)
         */
        default Builder groupFilter(Consumer<SearchGroupedFilterExpressions.Builder> groupFilter) {
            return groupFilter(SearchGroupedFilterExpressions.builder().applyMutation(groupFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DateTimeFilterExpression dateTimeFilter;

        private ParameterFilterExpression parameterFilter;

        private SearchTermFilterExpression searchTermFilter;

        private StringFilterExpression stringFilter;

        private SearchGroupedFilterExpressions groupFilter;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFilterExpression model) {
            dateTimeFilter(model.dateTimeFilter);
            parameterFilter(model.parameterFilter);
            searchTermFilter(model.searchTermFilter);
            stringFilter(model.stringFilter);
            groupFilter(model.groupFilter);
        }

        public final DateTimeFilterExpression.Builder getDateTimeFilter() {
            return dateTimeFilter != null ? dateTimeFilter.toBuilder() : null;
        }

        public final void setDateTimeFilter(DateTimeFilterExpression.BuilderImpl dateTimeFilter) {
            Object oldValue = this.dateTimeFilter;
            this.dateTimeFilter = dateTimeFilter != null ? dateTimeFilter.build() : null;
            handleUnionValueChange(Type.DATE_TIME_FILTER, oldValue, this.dateTimeFilter);
        }

        @Override
        public final Builder dateTimeFilter(DateTimeFilterExpression dateTimeFilter) {
            Object oldValue = this.dateTimeFilter;
            this.dateTimeFilter = dateTimeFilter;
            handleUnionValueChange(Type.DATE_TIME_FILTER, oldValue, this.dateTimeFilter);
            return this;
        }

        public final ParameterFilterExpression.Builder getParameterFilter() {
            return parameterFilter != null ? parameterFilter.toBuilder() : null;
        }

        public final void setParameterFilter(ParameterFilterExpression.BuilderImpl parameterFilter) {
            Object oldValue = this.parameterFilter;
            this.parameterFilter = parameterFilter != null ? parameterFilter.build() : null;
            handleUnionValueChange(Type.PARAMETER_FILTER, oldValue, this.parameterFilter);
        }

        @Override
        public final Builder parameterFilter(ParameterFilterExpression parameterFilter) {
            Object oldValue = this.parameterFilter;
            this.parameterFilter = parameterFilter;
            handleUnionValueChange(Type.PARAMETER_FILTER, oldValue, this.parameterFilter);
            return this;
        }

        public final SearchTermFilterExpression.Builder getSearchTermFilter() {
            return searchTermFilter != null ? searchTermFilter.toBuilder() : null;
        }

        public final void setSearchTermFilter(SearchTermFilterExpression.BuilderImpl searchTermFilter) {
            Object oldValue = this.searchTermFilter;
            this.searchTermFilter = searchTermFilter != null ? searchTermFilter.build() : null;
            handleUnionValueChange(Type.SEARCH_TERM_FILTER, oldValue, this.searchTermFilter);
        }

        @Override
        public final Builder searchTermFilter(SearchTermFilterExpression searchTermFilter) {
            Object oldValue = this.searchTermFilter;
            this.searchTermFilter = searchTermFilter;
            handleUnionValueChange(Type.SEARCH_TERM_FILTER, oldValue, this.searchTermFilter);
            return this;
        }

        public final StringFilterExpression.Builder getStringFilter() {
            return stringFilter != null ? stringFilter.toBuilder() : null;
        }

        public final void setStringFilter(StringFilterExpression.BuilderImpl stringFilter) {
            Object oldValue = this.stringFilter;
            this.stringFilter = stringFilter != null ? stringFilter.build() : null;
            handleUnionValueChange(Type.STRING_FILTER, oldValue, this.stringFilter);
        }

        @Override
        public final Builder stringFilter(StringFilterExpression stringFilter) {
            Object oldValue = this.stringFilter;
            this.stringFilter = stringFilter;
            handleUnionValueChange(Type.STRING_FILTER, oldValue, this.stringFilter);
            return this;
        }

        public final SearchGroupedFilterExpressions.Builder getGroupFilter() {
            return groupFilter != null ? groupFilter.toBuilder() : null;
        }

        public final void setGroupFilter(SearchGroupedFilterExpressions.BuilderImpl groupFilter) {
            Object oldValue = this.groupFilter;
            this.groupFilter = groupFilter != null ? groupFilter.build() : null;
            handleUnionValueChange(Type.GROUP_FILTER, oldValue, this.groupFilter);
        }

        @Override
        public final Builder groupFilter(SearchGroupedFilterExpressions groupFilter) {
            Object oldValue = this.groupFilter;
            this.groupFilter = groupFilter;
            handleUnionValueChange(Type.GROUP_FILTER, oldValue, this.groupFilter);
            return this;
        }

        @Override
        public SearchFilterExpression build() {
            return new SearchFilterExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SearchFilterExpression#type()
     */
    public enum Type {
        DATE_TIME_FILTER,

        PARAMETER_FILTER,

        SEARCH_TERM_FILTER,

        STRING_FILTER,

        GROUP_FILTER,

        UNKNOWN_TO_SDK_VERSION
    }
}
