/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a task search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskSearchSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskSearchSummary.Builder, TaskSearchSummary> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(TaskSearchSummary::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> STEP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stepId")
            .getter(getter(TaskSearchSummary::stepId)).setter(setter(Builder::stepId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(TaskSearchSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(TaskSearchSummary::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()).build();

    private static final SdkField<String> RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runStatus").getter(getter(TaskSearchSummary::runStatusAsString)).setter(setter(Builder::runStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runStatus").build()).build();

    private static final SdkField<String> TARGET_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetRunStatus").getter(getter(TaskSearchSummary::targetRunStatusAsString))
            .setter(setter(Builder::targetRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRunStatus").build()).build();

    private static final SdkField<Map<String, TaskParameterValue>> PARAMETERS_FIELD = SdkField
            .<Map<String, TaskParameterValue>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(TaskSearchSummary::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TaskParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> FAILURE_RETRY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failureRetryCount").getter(getter(TaskSearchSummary::failureRetryCount))
            .setter(setter(Builder::failureRetryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureRetryCount").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(TaskSearchSummary::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(TaskSearchSummary::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, STEP_ID_FIELD,
            JOB_ID_FIELD, QUEUE_ID_FIELD, RUN_STATUS_FIELD, TARGET_RUN_STATUS_FIELD, PARAMETERS_FIELD, FAILURE_RETRY_COUNT_FIELD,
            STARTED_AT_FIELD, ENDED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String taskId;

    private final String stepId;

    private final String jobId;

    private final String queueId;

    private final String runStatus;

    private final String targetRunStatus;

    private final Map<String, TaskParameterValue> parameters;

    private final Integer failureRetryCount;

    private final Instant startedAt;

    private final Instant endedAt;

    private TaskSearchSummary(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.stepId = builder.stepId;
        this.jobId = builder.jobId;
        this.queueId = builder.queueId;
        this.runStatus = builder.runStatus;
        this.targetRunStatus = builder.targetRunStatus;
        this.parameters = builder.parameters;
        this.failureRetryCount = builder.failureRetryCount;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
    }

    /**
     * <p>
     * The task ID.
     * </p>
     * 
     * @return The task ID.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The step ID.
     * </p>
     * 
     * @return The step ID.
     */
    public final String stepId() {
        return stepId;
    }

    /**
     * <p>
     * The job ID.
     * </p>
     * 
     * @return The job ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The queue ID.
     * </p>
     * 
     * @return The queue ID.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The run status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runStatus} will
     * return {@link TaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runStatusAsString}.
     * </p>
     * 
     * @return The run status of the task.
     * @see TaskRunStatus
     */
    public final TaskRunStatus runStatus() {
        return TaskRunStatus.fromValue(runStatus);
    }

    /**
     * <p>
     * The run status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runStatus} will
     * return {@link TaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runStatusAsString}.
     * </p>
     * 
     * @return The run status of the task.
     * @see TaskRunStatus
     */
    public final String runStatusAsString() {
        return runStatus;
    }

    /**
     * <p>
     * The run status that the task is being updated to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetRunStatus}
     * will return {@link TaskTargetRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetRunStatusAsString}.
     * </p>
     * 
     * @return The run status that the task is being updated to.
     * @see TaskTargetRunStatus
     */
    public final TaskTargetRunStatus targetRunStatus() {
        return TaskTargetRunStatus.fromValue(targetRunStatus);
    }

    /**
     * <p>
     * The run status that the task is being updated to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetRunStatus}
     * will return {@link TaskTargetRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetRunStatusAsString}.
     * </p>
     * 
     * @return The run status that the task is being updated to.
     * @see TaskTargetRunStatus
     */
    public final String targetRunStatusAsString() {
        return targetRunStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters to search for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters to search for.
     */
    public final Map<String, TaskParameterValue> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The number of times that the task failed and was retried.
     * </p>
     * 
     * @return The number of times that the task failed and was retried.
     */
    public final Integer failureRetryCount() {
        return failureRetryCount;
    }

    /**
     * <p>
     * The date and time the resource started running.
     * </p>
     * 
     * @return The date and time the resource started running.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The date and time the resource ended running.
     * </p>
     * 
     * @return The date and time the resource ended running.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(stepId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(runStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(failureRetryCount());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskSearchSummary)) {
            return false;
        }
        TaskSearchSummary other = (TaskSearchSummary) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(stepId(), other.stepId())
                && Objects.equals(jobId(), other.jobId()) && Objects.equals(queueId(), other.queueId())
                && Objects.equals(runStatusAsString(), other.runStatusAsString())
                && Objects.equals(targetRunStatusAsString(), other.targetRunStatusAsString())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(failureRetryCount(), other.failureRetryCount())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(endedAt(), other.endedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskSearchSummary").add("TaskId", taskId()).add("StepId", stepId()).add("JobId", jobId())
                .add("QueueId", queueId()).add("RunStatus", runStatusAsString())
                .add("TargetRunStatus", targetRunStatusAsString())
                .add("Parameters", parameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FailureRetryCount", failureRetryCount()).add("StartedAt", startedAt()).add("EndedAt", endedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "stepId":
            return Optional.ofNullable(clazz.cast(stepId()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "runStatus":
            return Optional.ofNullable(clazz.cast(runStatusAsString()));
        case "targetRunStatus":
            return Optional.ofNullable(clazz.cast(targetRunStatusAsString()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "failureRetryCount":
            return Optional.ofNullable(clazz.cast(failureRetryCount()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskSearchSummary, T> g) {
        return obj -> g.apply((TaskSearchSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskSearchSummary> {
        /**
         * <p>
         * The task ID.
         * </p>
         * 
         * @param taskId
         *        The task ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The step ID.
         * </p>
         * 
         * @param stepId
         *        The step ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepId(String stepId);

        /**
         * <p>
         * The job ID.
         * </p>
         * 
         * @param jobId
         *        The job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The queue ID.
         * </p>
         * 
         * @param queueId
         *        The queue ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The run status of the task.
         * </p>
         * 
         * @param runStatus
         *        The run status of the task.
         * @see TaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskRunStatus
         */
        Builder runStatus(String runStatus);

        /**
         * <p>
         * The run status of the task.
         * </p>
         * 
         * @param runStatus
         *        The run status of the task.
         * @see TaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskRunStatus
         */
        Builder runStatus(TaskRunStatus runStatus);

        /**
         * <p>
         * The run status that the task is being updated to.
         * </p>
         * 
         * @param targetRunStatus
         *        The run status that the task is being updated to.
         * @see TaskTargetRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskTargetRunStatus
         */
        Builder targetRunStatus(String targetRunStatus);

        /**
         * <p>
         * The run status that the task is being updated to.
         * </p>
         * 
         * @param targetRunStatus
         *        The run status that the task is being updated to.
         * @see TaskTargetRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskTargetRunStatus
         */
        Builder targetRunStatus(TaskTargetRunStatus targetRunStatus);

        /**
         * <p>
         * The parameters to search for.
         * </p>
         * 
         * @param parameters
         *        The parameters to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, TaskParameterValue> parameters);

        /**
         * <p>
         * The number of times that the task failed and was retried.
         * </p>
         * 
         * @param failureRetryCount
         *        The number of times that the task failed and was retried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureRetryCount(Integer failureRetryCount);

        /**
         * <p>
         * The date and time the resource started running.
         * </p>
         * 
         * @param startedAt
         *        The date and time the resource started running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The date and time the resource ended running.
         * </p>
         * 
         * @param endedAt
         *        The date and time the resource ended running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);
    }

    static final class BuilderImpl implements Builder {
        private String taskId;

        private String stepId;

        private String jobId;

        private String queueId;

        private String runStatus;

        private String targetRunStatus;

        private Map<String, TaskParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Integer failureRetryCount;

        private Instant startedAt;

        private Instant endedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskSearchSummary model) {
            taskId(model.taskId);
            stepId(model.stepId);
            jobId(model.jobId);
            queueId(model.queueId);
            runStatus(model.runStatus);
            targetRunStatus(model.targetRunStatus);
            parameters(model.parameters);
            failureRetryCount(model.failureRetryCount);
            startedAt(model.startedAt);
            endedAt(model.endedAt);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getStepId() {
            return stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getRunStatus() {
            return runStatus;
        }

        public final void setRunStatus(String runStatus) {
            this.runStatus = runStatus;
        }

        @Override
        public final Builder runStatus(String runStatus) {
            this.runStatus = runStatus;
            return this;
        }

        @Override
        public final Builder runStatus(TaskRunStatus runStatus) {
            this.runStatus(runStatus == null ? null : runStatus.toString());
            return this;
        }

        public final String getTargetRunStatus() {
            return targetRunStatus;
        }

        public final void setTargetRunStatus(String targetRunStatus) {
            this.targetRunStatus = targetRunStatus;
        }

        @Override
        public final Builder targetRunStatus(String targetRunStatus) {
            this.targetRunStatus = targetRunStatus;
            return this;
        }

        @Override
        public final Builder targetRunStatus(TaskTargetRunStatus targetRunStatus) {
            this.targetRunStatus(targetRunStatus == null ? null : targetRunStatus.toString());
            return this;
        }

        public final Map<String, TaskParameterValue.Builder> getParameters() {
            Map<String, TaskParameterValue.Builder> result = TaskParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, TaskParameterValue.BuilderImpl> parameters) {
            this.parameters = TaskParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, TaskParameterValue> parameters) {
            this.parameters = TaskParametersCopier.copy(parameters);
            return this;
        }

        public final Integer getFailureRetryCount() {
            return failureRetryCount;
        }

        public final void setFailureRetryCount(Integer failureRetryCount) {
            this.failureRetryCount = failureRetryCount;
        }

        @Override
        public final Builder failureRetryCount(Integer failureRetryCount) {
            this.failureRetryCount = failureRetryCount;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        @Override
        public TaskSearchSummary build() {
            return new TaskSearchSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
