/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQueueRequest extends DeadlineRequest implements
        ToCopyableBuilder<UpdateQueueRequest.Builder, UpdateQueueRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateQueueRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(UpdateQueueRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(UpdateQueueRequest::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateQueueRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateQueueRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DEFAULT_BUDGET_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultBudgetAction").getter(getter(UpdateQueueRequest::defaultBudgetActionAsString))
            .setter(setter(Builder::defaultBudgetAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBudgetAction").build())
            .build();

    private static final SdkField<JobAttachmentSettings> JOB_ATTACHMENT_SETTINGS_FIELD = SdkField
            .<JobAttachmentSettings> builder(MarshallingType.SDK_POJO).memberName("jobAttachmentSettings")
            .getter(getter(UpdateQueueRequest::jobAttachmentSettings)).setter(setter(Builder::jobAttachmentSettings))
            .constructor(JobAttachmentSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobAttachmentSettings").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateQueueRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<JobRunAsUser> JOB_RUN_AS_USER_FIELD = SdkField.<JobRunAsUser> builder(MarshallingType.SDK_POJO)
            .memberName("jobRunAsUser").getter(getter(UpdateQueueRequest::jobRunAsUser)).setter(setter(Builder::jobRunAsUser))
            .constructor(JobRunAsUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRunAsUser").build()).build();

    private static final SdkField<List<String>> REQUIRED_FILE_SYSTEM_LOCATION_NAMES_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("requiredFileSystemLocationNamesToAdd")
            .getter(getter(UpdateQueueRequest::requiredFileSystemLocationNamesToAdd))
            .setter(setter(Builder::requiredFileSystemLocationNamesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("requiredFileSystemLocationNamesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REQUIRED_FILE_SYSTEM_LOCATION_NAMES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("requiredFileSystemLocationNamesToRemove")
            .getter(getter(UpdateQueueRequest::requiredFileSystemLocationNamesToRemove))
            .setter(setter(Builder::requiredFileSystemLocationNamesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("requiredFileSystemLocationNamesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_STORAGE_PROFILE_IDS_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedStorageProfileIdsToAdd")
            .getter(getter(UpdateQueueRequest::allowedStorageProfileIdsToAdd))
            .setter(setter(Builder::allowedStorageProfileIdsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedStorageProfileIdsToAdd")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_STORAGE_PROFILE_IDS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedStorageProfileIdsToRemove")
            .getter(getter(UpdateQueueRequest::allowedStorageProfileIdsToRemove))
            .setter(setter(Builder::allowedStorageProfileIdsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedStorageProfileIdsToRemove")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            FARM_ID_FIELD, QUEUE_ID_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, DEFAULT_BUDGET_ACTION_FIELD,
            JOB_ATTACHMENT_SETTINGS_FIELD, ROLE_ARN_FIELD, JOB_RUN_AS_USER_FIELD,
            REQUIRED_FILE_SYSTEM_LOCATION_NAMES_TO_ADD_FIELD, REQUIRED_FILE_SYSTEM_LOCATION_NAMES_TO_REMOVE_FIELD,
            ALLOWED_STORAGE_PROFILE_IDS_TO_ADD_FIELD, ALLOWED_STORAGE_PROFILE_IDS_TO_REMOVE_FIELD));

    private final String clientToken;

    private final String farmId;

    private final String queueId;

    private final String displayName;

    private final String description;

    private final String defaultBudgetAction;

    private final JobAttachmentSettings jobAttachmentSettings;

    private final String roleArn;

    private final JobRunAsUser jobRunAsUser;

    private final List<String> requiredFileSystemLocationNamesToAdd;

    private final List<String> requiredFileSystemLocationNamesToRemove;

    private final List<String> allowedStorageProfileIdsToAdd;

    private final List<String> allowedStorageProfileIdsToRemove;

    private UpdateQueueRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.queueId = builder.queueId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.defaultBudgetAction = builder.defaultBudgetAction;
        this.jobAttachmentSettings = builder.jobAttachmentSettings;
        this.roleArn = builder.roleArn;
        this.jobRunAsUser = builder.jobRunAsUser;
        this.requiredFileSystemLocationNamesToAdd = builder.requiredFileSystemLocationNamesToAdd;
        this.requiredFileSystemLocationNamesToRemove = builder.requiredFileSystemLocationNamesToRemove;
        this.allowedStorageProfileIdsToAdd = builder.allowedStorageProfileIdsToAdd;
        this.allowedStorageProfileIdsToRemove = builder.allowedStorageProfileIdsToRemove;
    }

    /**
     * <p>
     * The idempotency token to update in the queue.
     * </p>
     * 
     * @return The idempotency token to update in the queue.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The farm ID to update in the queue.
     * </p>
     * 
     * @return The farm ID to update in the queue.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The queue ID to update.
     * </p>
     * 
     * @return The queue ID to update.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The display name of the queue to update.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The display name of the queue to update.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the queue to update.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The description of the queue to update.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The default action to take for a queue update if a budget isn't configured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultBudgetAction} will return {@link DefaultQueueBudgetAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultBudgetActionAsString}.
     * </p>
     * 
     * @return The default action to take for a queue update if a budget isn't configured.
     * @see DefaultQueueBudgetAction
     */
    public final DefaultQueueBudgetAction defaultBudgetAction() {
        return DefaultQueueBudgetAction.fromValue(defaultBudgetAction);
    }

    /**
     * <p>
     * The default action to take for a queue update if a budget isn't configured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultBudgetAction} will return {@link DefaultQueueBudgetAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultBudgetActionAsString}.
     * </p>
     * 
     * @return The default action to take for a queue update if a budget isn't configured.
     * @see DefaultQueueBudgetAction
     */
    public final String defaultBudgetActionAsString() {
        return defaultBudgetAction;
    }

    /**
     * <p>
     * The job attachment settings to update for the queue.
     * </p>
     * 
     * @return The job attachment settings to update for the queue.
     */
    public final JobAttachmentSettings jobAttachmentSettings() {
        return jobAttachmentSettings;
    }

    /**
     * <p>
     * The IAM role ARN that's used to run jobs from this queue.
     * </p>
     * 
     * @return The IAM role ARN that's used to run jobs from this queue.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Update the jobs in the queue to run as a specified POSIX user.
     * </p>
     * 
     * @return Update the jobs in the queue to run as a specified POSIX user.
     */
    public final JobRunAsUser jobRunAsUser() {
        return jobRunAsUser;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequiredFileSystemLocationNamesToAdd
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasRequiredFileSystemLocationNamesToAdd() {
        return requiredFileSystemLocationNamesToAdd != null
                && !(requiredFileSystemLocationNamesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The required file system location names to add to the queue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequiredFileSystemLocationNamesToAdd}
     * method.
     * </p>
     * 
     * @return The required file system location names to add to the queue.
     */
    public final List<String> requiredFileSystemLocationNamesToAdd() {
        return requiredFileSystemLocationNamesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequiredFileSystemLocationNamesToRemove
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasRequiredFileSystemLocationNamesToRemove() {
        return requiredFileSystemLocationNamesToRemove != null
                && !(requiredFileSystemLocationNamesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The required file system location names to remove from the queue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasRequiredFileSystemLocationNamesToRemove} method.
     * </p>
     * 
     * @return The required file system location names to remove from the queue.
     */
    public final List<String> requiredFileSystemLocationNamesToRemove() {
        return requiredFileSystemLocationNamesToRemove;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedStorageProfileIdsToAdd property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedStorageProfileIdsToAdd() {
        return allowedStorageProfileIdsToAdd != null && !(allowedStorageProfileIdsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The storage profile IDs to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedStorageProfileIdsToAdd} method.
     * </p>
     * 
     * @return The storage profile IDs to add.
     */
    public final List<String> allowedStorageProfileIdsToAdd() {
        return allowedStorageProfileIdsToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedStorageProfileIdsToRemove
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAllowedStorageProfileIdsToRemove() {
        return allowedStorageProfileIdsToRemove != null && !(allowedStorageProfileIdsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The storage profile ID to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedStorageProfileIdsToRemove}
     * method.
     * </p>
     * 
     * @return The storage profile ID to remove.
     */
    public final List<String> allowedStorageProfileIdsToRemove() {
        return allowedStorageProfileIdsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultBudgetActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobAttachmentSettings());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobRunAsUser());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRequiredFileSystemLocationNamesToAdd() ? requiredFileSystemLocationNamesToAdd() : null);
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasRequiredFileSystemLocationNamesToRemove() ? requiredFileSystemLocationNamesToRemove()
                        : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedStorageProfileIdsToAdd() ? allowedStorageProfileIdsToAdd() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAllowedStorageProfileIdsToRemove() ? allowedStorageProfileIdsToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQueueRequest)) {
            return false;
        }
        UpdateQueueRequest other = (UpdateQueueRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(queueId(), other.queueId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(description(), other.description())
                && Objects.equals(defaultBudgetActionAsString(), other.defaultBudgetActionAsString())
                && Objects.equals(jobAttachmentSettings(), other.jobAttachmentSettings())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(jobRunAsUser(), other.jobRunAsUser())
                && hasRequiredFileSystemLocationNamesToAdd() == other.hasRequiredFileSystemLocationNamesToAdd()
                && Objects.equals(requiredFileSystemLocationNamesToAdd(), other.requiredFileSystemLocationNamesToAdd())
                && hasRequiredFileSystemLocationNamesToRemove() == other.hasRequiredFileSystemLocationNamesToRemove()
                && Objects.equals(requiredFileSystemLocationNamesToRemove(), other.requiredFileSystemLocationNamesToRemove())
                && hasAllowedStorageProfileIdsToAdd() == other.hasAllowedStorageProfileIdsToAdd()
                && Objects.equals(allowedStorageProfileIdsToAdd(), other.allowedStorageProfileIdsToAdd())
                && hasAllowedStorageProfileIdsToRemove() == other.hasAllowedStorageProfileIdsToRemove()
                && Objects.equals(allowedStorageProfileIdsToRemove(), other.allowedStorageProfileIdsToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateQueueRequest")
                .add("ClientToken", clientToken())
                .add("FarmId", farmId())
                .add("QueueId", queueId())
                .add("DisplayName", displayName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DefaultBudgetAction", defaultBudgetActionAsString())
                .add("JobAttachmentSettings", jobAttachmentSettings())
                .add("RoleArn", roleArn())
                .add("JobRunAsUser", jobRunAsUser())
                .add("RequiredFileSystemLocationNamesToAdd",
                        requiredFileSystemLocationNamesToAdd() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RequiredFileSystemLocationNamesToRemove",
                        requiredFileSystemLocationNamesToRemove() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AllowedStorageProfileIdsToAdd", hasAllowedStorageProfileIdsToAdd() ? allowedStorageProfileIdsToAdd() : null)
                .add("AllowedStorageProfileIdsToRemove",
                        hasAllowedStorageProfileIdsToRemove() ? allowedStorageProfileIdsToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "defaultBudgetAction":
            return Optional.ofNullable(clazz.cast(defaultBudgetActionAsString()));
        case "jobAttachmentSettings":
            return Optional.ofNullable(clazz.cast(jobAttachmentSettings()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "jobRunAsUser":
            return Optional.ofNullable(clazz.cast(jobRunAsUser()));
        case "requiredFileSystemLocationNamesToAdd":
            return Optional.ofNullable(clazz.cast(requiredFileSystemLocationNamesToAdd()));
        case "requiredFileSystemLocationNamesToRemove":
            return Optional.ofNullable(clazz.cast(requiredFileSystemLocationNamesToRemove()));
        case "allowedStorageProfileIdsToAdd":
            return Optional.ofNullable(clazz.cast(allowedStorageProfileIdsToAdd()));
        case "allowedStorageProfileIdsToRemove":
            return Optional.ofNullable(clazz.cast(allowedStorageProfileIdsToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateQueueRequest, T> g) {
        return obj -> g.apply((UpdateQueueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateQueueRequest> {
        /**
         * <p>
         * The idempotency token to update in the queue.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token to update in the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The farm ID to update in the queue.
         * </p>
         * 
         * @param farmId
         *        The farm ID to update in the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The queue ID to update.
         * </p>
         * 
         * @param queueId
         *        The queue ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The display name of the queue to update.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param displayName
         *        The display name of the queue to update.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the queue to update.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param description
         *        The description of the queue to update.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The default action to take for a queue update if a budget isn't configured.
         * </p>
         * 
         * @param defaultBudgetAction
         *        The default action to take for a queue update if a budget isn't configured.
         * @see DefaultQueueBudgetAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultQueueBudgetAction
         */
        Builder defaultBudgetAction(String defaultBudgetAction);

        /**
         * <p>
         * The default action to take for a queue update if a budget isn't configured.
         * </p>
         * 
         * @param defaultBudgetAction
         *        The default action to take for a queue update if a budget isn't configured.
         * @see DefaultQueueBudgetAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultQueueBudgetAction
         */
        Builder defaultBudgetAction(DefaultQueueBudgetAction defaultBudgetAction);

        /**
         * <p>
         * The job attachment settings to update for the queue.
         * </p>
         * 
         * @param jobAttachmentSettings
         *        The job attachment settings to update for the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings);

        /**
         * <p>
         * The job attachment settings to update for the queue.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobAttachmentSettings.Builder} avoiding
         * the need to create one manually via {@link JobAttachmentSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobAttachmentSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #jobAttachmentSettings(JobAttachmentSettings)}.
         * 
         * @param jobAttachmentSettings
         *        a consumer that will call methods on {@link JobAttachmentSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobAttachmentSettings(JobAttachmentSettings)
         */
        default Builder jobAttachmentSettings(Consumer<JobAttachmentSettings.Builder> jobAttachmentSettings) {
            return jobAttachmentSettings(JobAttachmentSettings.builder().applyMutation(jobAttachmentSettings).build());
        }

        /**
         * <p>
         * The IAM role ARN that's used to run jobs from this queue.
         * </p>
         * 
         * @param roleArn
         *        The IAM role ARN that's used to run jobs from this queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Update the jobs in the queue to run as a specified POSIX user.
         * </p>
         * 
         * @param jobRunAsUser
         *        Update the jobs in the queue to run as a specified POSIX user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRunAsUser(JobRunAsUser jobRunAsUser);

        /**
         * <p>
         * Update the jobs in the queue to run as a specified POSIX user.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobRunAsUser.Builder} avoiding the need
         * to create one manually via {@link JobRunAsUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobRunAsUser.Builder#build()} is called immediately and its
         * result is passed to {@link #jobRunAsUser(JobRunAsUser)}.
         * 
         * @param jobRunAsUser
         *        a consumer that will call methods on {@link JobRunAsUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobRunAsUser(JobRunAsUser)
         */
        default Builder jobRunAsUser(Consumer<JobRunAsUser.Builder> jobRunAsUser) {
            return jobRunAsUser(JobRunAsUser.builder().applyMutation(jobRunAsUser).build());
        }

        /**
         * <p>
         * The required file system location names to add to the queue.
         * </p>
         * 
         * @param requiredFileSystemLocationNamesToAdd
         *        The required file system location names to add to the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredFileSystemLocationNamesToAdd(Collection<String> requiredFileSystemLocationNamesToAdd);

        /**
         * <p>
         * The required file system location names to add to the queue.
         * </p>
         * 
         * @param requiredFileSystemLocationNamesToAdd
         *        The required file system location names to add to the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredFileSystemLocationNamesToAdd(String... requiredFileSystemLocationNamesToAdd);

        /**
         * <p>
         * The required file system location names to remove from the queue.
         * </p>
         * 
         * @param requiredFileSystemLocationNamesToRemove
         *        The required file system location names to remove from the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredFileSystemLocationNamesToRemove(Collection<String> requiredFileSystemLocationNamesToRemove);

        /**
         * <p>
         * The required file system location names to remove from the queue.
         * </p>
         * 
         * @param requiredFileSystemLocationNamesToRemove
         *        The required file system location names to remove from the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredFileSystemLocationNamesToRemove(String... requiredFileSystemLocationNamesToRemove);

        /**
         * <p>
         * The storage profile IDs to add.
         * </p>
         * 
         * @param allowedStorageProfileIdsToAdd
         *        The storage profile IDs to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedStorageProfileIdsToAdd(Collection<String> allowedStorageProfileIdsToAdd);

        /**
         * <p>
         * The storage profile IDs to add.
         * </p>
         * 
         * @param allowedStorageProfileIdsToAdd
         *        The storage profile IDs to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedStorageProfileIdsToAdd(String... allowedStorageProfileIdsToAdd);

        /**
         * <p>
         * The storage profile ID to remove.
         * </p>
         * 
         * @param allowedStorageProfileIdsToRemove
         *        The storage profile ID to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedStorageProfileIdsToRemove(Collection<String> allowedStorageProfileIdsToRemove);

        /**
         * <p>
         * The storage profile ID to remove.
         * </p>
         * 
         * @param allowedStorageProfileIdsToRemove
         *        The storage profile ID to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedStorageProfileIdsToRemove(String... allowedStorageProfileIdsToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String farmId;

        private String queueId;

        private String displayName;

        private String description;

        private String defaultBudgetAction;

        private JobAttachmentSettings jobAttachmentSettings;

        private String roleArn;

        private JobRunAsUser jobRunAsUser;

        private List<String> requiredFileSystemLocationNamesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> requiredFileSystemLocationNamesToRemove = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedStorageProfileIdsToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedStorageProfileIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQueueRequest model) {
            super(model);
            clientToken(model.clientToken);
            farmId(model.farmId);
            queueId(model.queueId);
            displayName(model.displayName);
            description(model.description);
            defaultBudgetAction(model.defaultBudgetAction);
            jobAttachmentSettings(model.jobAttachmentSettings);
            roleArn(model.roleArn);
            jobRunAsUser(model.jobRunAsUser);
            requiredFileSystemLocationNamesToAdd(model.requiredFileSystemLocationNamesToAdd);
            requiredFileSystemLocationNamesToRemove(model.requiredFileSystemLocationNamesToRemove);
            allowedStorageProfileIdsToAdd(model.allowedStorageProfileIdsToAdd);
            allowedStorageProfileIdsToRemove(model.allowedStorageProfileIdsToRemove);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultBudgetAction() {
            return defaultBudgetAction;
        }

        public final void setDefaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
        }

        @Override
        public final Builder defaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
            return this;
        }

        @Override
        public final Builder defaultBudgetAction(DefaultQueueBudgetAction defaultBudgetAction) {
            this.defaultBudgetAction(defaultBudgetAction == null ? null : defaultBudgetAction.toString());
            return this;
        }

        public final JobAttachmentSettings.Builder getJobAttachmentSettings() {
            return jobAttachmentSettings != null ? jobAttachmentSettings.toBuilder() : null;
        }

        public final void setJobAttachmentSettings(JobAttachmentSettings.BuilderImpl jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings != null ? jobAttachmentSettings.build() : null;
        }

        @Override
        public final Builder jobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final JobRunAsUser.Builder getJobRunAsUser() {
            return jobRunAsUser != null ? jobRunAsUser.toBuilder() : null;
        }

        public final void setJobRunAsUser(JobRunAsUser.BuilderImpl jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser != null ? jobRunAsUser.build() : null;
        }

        @Override
        public final Builder jobRunAsUser(JobRunAsUser jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser;
            return this;
        }

        public final Collection<String> getRequiredFileSystemLocationNamesToAdd() {
            if (requiredFileSystemLocationNamesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return requiredFileSystemLocationNamesToAdd;
        }

        public final void setRequiredFileSystemLocationNamesToAdd(Collection<String> requiredFileSystemLocationNamesToAdd) {
            this.requiredFileSystemLocationNamesToAdd = RequiredFileSystemLocationNamesCopier
                    .copy(requiredFileSystemLocationNamesToAdd);
        }

        @Override
        public final Builder requiredFileSystemLocationNamesToAdd(Collection<String> requiredFileSystemLocationNamesToAdd) {
            this.requiredFileSystemLocationNamesToAdd = RequiredFileSystemLocationNamesCopier
                    .copy(requiredFileSystemLocationNamesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFileSystemLocationNamesToAdd(String... requiredFileSystemLocationNamesToAdd) {
            requiredFileSystemLocationNamesToAdd(Arrays.asList(requiredFileSystemLocationNamesToAdd));
            return this;
        }

        public final Collection<String> getRequiredFileSystemLocationNamesToRemove() {
            if (requiredFileSystemLocationNamesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return requiredFileSystemLocationNamesToRemove;
        }

        public final void setRequiredFileSystemLocationNamesToRemove(Collection<String> requiredFileSystemLocationNamesToRemove) {
            this.requiredFileSystemLocationNamesToRemove = RequiredFileSystemLocationNamesCopier
                    .copy(requiredFileSystemLocationNamesToRemove);
        }

        @Override
        public final Builder requiredFileSystemLocationNamesToRemove(Collection<String> requiredFileSystemLocationNamesToRemove) {
            this.requiredFileSystemLocationNamesToRemove = RequiredFileSystemLocationNamesCopier
                    .copy(requiredFileSystemLocationNamesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFileSystemLocationNamesToRemove(String... requiredFileSystemLocationNamesToRemove) {
            requiredFileSystemLocationNamesToRemove(Arrays.asList(requiredFileSystemLocationNamesToRemove));
            return this;
        }

        public final Collection<String> getAllowedStorageProfileIdsToAdd() {
            if (allowedStorageProfileIdsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedStorageProfileIdsToAdd;
        }

        public final void setAllowedStorageProfileIdsToAdd(Collection<String> allowedStorageProfileIdsToAdd) {
            this.allowedStorageProfileIdsToAdd = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIdsToAdd);
        }

        @Override
        public final Builder allowedStorageProfileIdsToAdd(Collection<String> allowedStorageProfileIdsToAdd) {
            this.allowedStorageProfileIdsToAdd = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIdsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedStorageProfileIdsToAdd(String... allowedStorageProfileIdsToAdd) {
            allowedStorageProfileIdsToAdd(Arrays.asList(allowedStorageProfileIdsToAdd));
            return this;
        }

        public final Collection<String> getAllowedStorageProfileIdsToRemove() {
            if (allowedStorageProfileIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedStorageProfileIdsToRemove;
        }

        public final void setAllowedStorageProfileIdsToRemove(Collection<String> allowedStorageProfileIdsToRemove) {
            this.allowedStorageProfileIdsToRemove = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIdsToRemove);
        }

        @Override
        public final Builder allowedStorageProfileIdsToRemove(Collection<String> allowedStorageProfileIdsToRemove) {
            this.allowedStorageProfileIdsToRemove = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedStorageProfileIdsToRemove(String... allowedStorageProfileIdsToRemove) {
            allowedStorageProfileIdsToRemove(Arrays.asList(allowedStorageProfileIdsToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQueueRequest build() {
            return new UpdateQueueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
