/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.deadline.internal.DeadlineServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.deadline.model.AccessDeniedException;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFarmRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFarmResponse;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFleetRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFleetResponse;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToJobRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToJobResponse;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToQueueRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToQueueResponse;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadRequest;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadResponse;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadRequest;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadResponse;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForUserRequest;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForUserResponse;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.BatchGetJobEntityRequest;
import software.amazon.awssdk.services.deadline.model.BatchGetJobEntityResponse;
import software.amazon.awssdk.services.deadline.model.ConflictException;
import software.amazon.awssdk.services.deadline.model.CopyJobTemplateRequest;
import software.amazon.awssdk.services.deadline.model.CopyJobTemplateResponse;
import software.amazon.awssdk.services.deadline.model.CreateBudgetRequest;
import software.amazon.awssdk.services.deadline.model.CreateBudgetResponse;
import software.amazon.awssdk.services.deadline.model.CreateFarmRequest;
import software.amazon.awssdk.services.deadline.model.CreateFarmResponse;
import software.amazon.awssdk.services.deadline.model.CreateFleetRequest;
import software.amazon.awssdk.services.deadline.model.CreateFleetResponse;
import software.amazon.awssdk.services.deadline.model.CreateJobRequest;
import software.amazon.awssdk.services.deadline.model.CreateJobResponse;
import software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.CreateMonitorRequest;
import software.amazon.awssdk.services.deadline.model.CreateMonitorResponse;
import software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.CreateQueueRequest;
import software.amazon.awssdk.services.deadline.model.CreateQueueResponse;
import software.amazon.awssdk.services.deadline.model.CreateStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.CreateStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.CreateWorkerRequest;
import software.amazon.awssdk.services.deadline.model.CreateWorkerResponse;
import software.amazon.awssdk.services.deadline.model.DeadlineException;
import software.amazon.awssdk.services.deadline.model.DeleteBudgetRequest;
import software.amazon.awssdk.services.deadline.model.DeleteBudgetResponse;
import software.amazon.awssdk.services.deadline.model.DeleteFarmRequest;
import software.amazon.awssdk.services.deadline.model.DeleteFarmResponse;
import software.amazon.awssdk.services.deadline.model.DeleteFleetRequest;
import software.amazon.awssdk.services.deadline.model.DeleteFleetResponse;
import software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.DeleteMeteredProductRequest;
import software.amazon.awssdk.services.deadline.model.DeleteMeteredProductResponse;
import software.amazon.awssdk.services.deadline.model.DeleteMonitorRequest;
import software.amazon.awssdk.services.deadline.model.DeleteMonitorResponse;
import software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.DeleteQueueRequest;
import software.amazon.awssdk.services.deadline.model.DeleteQueueResponse;
import software.amazon.awssdk.services.deadline.model.DeleteStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.DeleteStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.DeleteWorkerRequest;
import software.amazon.awssdk.services.deadline.model.DeleteWorkerResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueResponse;
import software.amazon.awssdk.services.deadline.model.GetBudgetRequest;
import software.amazon.awssdk.services.deadline.model.GetBudgetResponse;
import software.amazon.awssdk.services.deadline.model.GetFarmRequest;
import software.amazon.awssdk.services.deadline.model.GetFarmResponse;
import software.amazon.awssdk.services.deadline.model.GetFleetRequest;
import software.amazon.awssdk.services.deadline.model.GetFleetResponse;
import software.amazon.awssdk.services.deadline.model.GetJobRequest;
import software.amazon.awssdk.services.deadline.model.GetJobResponse;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.GetMonitorRequest;
import software.amazon.awssdk.services.deadline.model.GetMonitorResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueResponse;
import software.amazon.awssdk.services.deadline.model.GetSessionActionRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionActionResponse;
import software.amazon.awssdk.services.deadline.model.GetSessionRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionResponse;
import software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse;
import software.amazon.awssdk.services.deadline.model.GetStepRequest;
import software.amazon.awssdk.services.deadline.model.GetStepResponse;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueRequest;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueResponse;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.GetTaskRequest;
import software.amazon.awssdk.services.deadline.model.GetTaskResponse;
import software.amazon.awssdk.services.deadline.model.GetWorkerRequest;
import software.amazon.awssdk.services.deadline.model.GetWorkerResponse;
import software.amazon.awssdk.services.deadline.model.InternalServerErrorException;
import software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest;
import software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse;
import software.amazon.awssdk.services.deadline.model.ListBudgetsRequest;
import software.amazon.awssdk.services.deadline.model.ListBudgetsResponse;
import software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListFarmsRequest;
import software.amazon.awssdk.services.deadline.model.ListFarmsResponse;
import software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListFleetsRequest;
import software.amazon.awssdk.services.deadline.model.ListFleetsResponse;
import software.amazon.awssdk.services.deadline.model.ListJobMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListJobMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListJobParameterDefinitionsRequest;
import software.amazon.awssdk.services.deadline.model.ListJobParameterDefinitionsResponse;
import software.amazon.awssdk.services.deadline.model.ListJobsRequest;
import software.amazon.awssdk.services.deadline.model.ListJobsResponse;
import software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest;
import software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse;
import software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest;
import software.amazon.awssdk.services.deadline.model.ListMeteredProductsResponse;
import software.amazon.awssdk.services.deadline.model.ListMonitorsRequest;
import software.amazon.awssdk.services.deadline.model.ListMonitorsResponse;
import software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse;
import software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse;
import software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListQueuesRequest;
import software.amazon.awssdk.services.deadline.model.ListQueuesResponse;
import software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse;
import software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.ListSessionsRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionsResponse;
import software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest;
import software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse;
import software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest;
import software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse;
import software.amazon.awssdk.services.deadline.model.ListStepsRequest;
import software.amazon.awssdk.services.deadline.model.ListStepsResponse;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesResponse;
import software.amazon.awssdk.services.deadline.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.deadline.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.deadline.model.ListTasksRequest;
import software.amazon.awssdk.services.deadline.model.ListTasksResponse;
import software.amazon.awssdk.services.deadline.model.ListWorkersRequest;
import software.amazon.awssdk.services.deadline.model.ListWorkersResponse;
import software.amazon.awssdk.services.deadline.model.PutMeteredProductRequest;
import software.amazon.awssdk.services.deadline.model.PutMeteredProductResponse;
import software.amazon.awssdk.services.deadline.model.ResourceNotFoundException;
import software.amazon.awssdk.services.deadline.model.SearchJobsRequest;
import software.amazon.awssdk.services.deadline.model.SearchJobsResponse;
import software.amazon.awssdk.services.deadline.model.SearchStepsRequest;
import software.amazon.awssdk.services.deadline.model.SearchStepsResponse;
import software.amazon.awssdk.services.deadline.model.SearchTasksRequest;
import software.amazon.awssdk.services.deadline.model.SearchTasksResponse;
import software.amazon.awssdk.services.deadline.model.SearchWorkersRequest;
import software.amazon.awssdk.services.deadline.model.SearchWorkersResponse;
import software.amazon.awssdk.services.deadline.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationRequest;
import software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationResponse;
import software.amazon.awssdk.services.deadline.model.TagResourceRequest;
import software.amazon.awssdk.services.deadline.model.TagResourceResponse;
import software.amazon.awssdk.services.deadline.model.ThrottlingException;
import software.amazon.awssdk.services.deadline.model.UntagResourceRequest;
import software.amazon.awssdk.services.deadline.model.UntagResourceResponse;
import software.amazon.awssdk.services.deadline.model.UpdateBudgetRequest;
import software.amazon.awssdk.services.deadline.model.UpdateBudgetResponse;
import software.amazon.awssdk.services.deadline.model.UpdateFarmRequest;
import software.amazon.awssdk.services.deadline.model.UpdateFarmResponse;
import software.amazon.awssdk.services.deadline.model.UpdateFleetRequest;
import software.amazon.awssdk.services.deadline.model.UpdateFleetResponse;
import software.amazon.awssdk.services.deadline.model.UpdateJobRequest;
import software.amazon.awssdk.services.deadline.model.UpdateJobResponse;
import software.amazon.awssdk.services.deadline.model.UpdateMonitorRequest;
import software.amazon.awssdk.services.deadline.model.UpdateMonitorResponse;
import software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.UpdateQueueRequest;
import software.amazon.awssdk.services.deadline.model.UpdateQueueResponse;
import software.amazon.awssdk.services.deadline.model.UpdateSessionRequest;
import software.amazon.awssdk.services.deadline.model.UpdateSessionResponse;
import software.amazon.awssdk.services.deadline.model.UpdateStepRequest;
import software.amazon.awssdk.services.deadline.model.UpdateStepResponse;
import software.amazon.awssdk.services.deadline.model.UpdateStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.UpdateStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.UpdateTaskRequest;
import software.amazon.awssdk.services.deadline.model.UpdateTaskResponse;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerRequest;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerResponse;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleRequest;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleResponse;
import software.amazon.awssdk.services.deadline.model.ValidationException;
import software.amazon.awssdk.services.deadline.transform.AssociateMemberToFarmRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssociateMemberToFleetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssociateMemberToJobRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssociateMemberToQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssumeFleetRoleForReadRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssumeFleetRoleForWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssumeQueueRoleForReadRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssumeQueueRoleForUserRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssumeQueueRoleForWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.BatchGetJobEntityRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CopyJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateBudgetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateFarmRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateLicenseEndpointRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateMonitorRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateQueueEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateQueueFleetAssociationRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateStorageProfileRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteBudgetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteFarmRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteLicenseEndpointRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteMeteredProductRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteMonitorRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteQueueEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteQueueFleetAssociationRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteStorageProfileRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DisassociateMemberFromFarmRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DisassociateMemberFromFleetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DisassociateMemberFromJobRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DisassociateMemberFromQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetBudgetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetFarmRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetFleetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetJobRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetLicenseEndpointRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetMonitorRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetQueueEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetQueueFleetAssociationRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetSessionActionRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetSessionRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetSessionsStatisticsAggregationRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetStepRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetStorageProfileForQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetStorageProfileRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetTaskRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListAvailableMeteredProductsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListBudgetsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListFarmMembersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListFarmsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListFleetMembersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListFleetsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListJobMembersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListJobParameterDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListLicenseEndpointsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListMeteredProductsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListMonitorsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListQueueEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListQueueFleetAssociationsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListQueueMembersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListQueuesRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListSessionActionsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListSessionsForWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListSessionsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListStepConsumersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListStepDependenciesRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListStepsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListStorageProfilesForQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListStorageProfilesRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListTasksRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListWorkersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.PutMeteredProductRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.SearchJobsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.SearchStepsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.SearchTasksRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.SearchWorkersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.StartSessionsStatisticsAggregationRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateBudgetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateFarmRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateFleetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateJobRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateMonitorRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateQueueEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateQueueFleetAssociationRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateSessionRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateStepRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateStorageProfileRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateTaskRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateWorkerScheduleRequestMarshaller;
import software.amazon.awssdk.services.deadline.waiters.DeadlineWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link DeadlineClient}.
 *
 * @see DeadlineClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultDeadlineClient implements DeadlineClient {
    private static final Logger log = Logger.loggerFor(DefaultDeadlineClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDeadlineClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Assigns a farm membership level to a member.
     * </p>
     *
     * @param associateMemberToFarmRequest
     * @return Result of the AssociateMemberToFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssociateMemberToFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFarm"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateMemberToFarmResponse associateMemberToFarm(AssociateMemberToFarmRequest associateMemberToFarmRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateMemberToFarmResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateMemberToFarmResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateMemberToFarmRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMemberToFarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMemberToFarm");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<AssociateMemberToFarmRequest, AssociateMemberToFarmResponse>()
                    .withOperationName("AssociateMemberToFarm").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(associateMemberToFarmRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateMemberToFarmRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns a fleet membership level to a member.
     * </p>
     *
     * @param associateMemberToFleetRequest
     * @return Result of the AssociateMemberToFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssociateMemberToFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateMemberToFleetResponse associateMemberToFleet(AssociateMemberToFleetRequest associateMemberToFleetRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateMemberToFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateMemberToFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateMemberToFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMemberToFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMemberToFleet");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateMemberToFleetRequest, AssociateMemberToFleetResponse>()
                            .withOperationName("AssociateMemberToFleet").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(associateMemberToFleetRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateMemberToFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns a job membership level to a member
     * </p>
     *
     * @param associateMemberToJobRequest
     * @return Result of the AssociateMemberToJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssociateMemberToJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AssociateMemberToJobResponse associateMemberToJob(AssociateMemberToJobRequest associateMemberToJobRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateMemberToJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateMemberToJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateMemberToJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMemberToJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMemberToJob");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<AssociateMemberToJobRequest, AssociateMemberToJobResponse>()
                    .withOperationName("AssociateMemberToJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(associateMemberToJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateMemberToJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns a queue membership level to a member
     * </p>
     *
     * @param associateMemberToQueueRequest
     * @return Result of the AssociateMemberToQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssociateMemberToQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToQueue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateMemberToQueueResponse associateMemberToQueue(AssociateMemberToQueueRequest associateMemberToQueueRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateMemberToQueueResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateMemberToQueueResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateMemberToQueueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMemberToQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMemberToQueue");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateMemberToQueueRequest, AssociateMemberToQueueResponse>()
                            .withOperationName("AssociateMemberToQueue").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(associateMemberToQueueRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateMemberToQueueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get Amazon Web Services credentials from the fleet role. The IAM permissions of the credentials are scoped down
     * to have read-only access.
     * </p>
     *
     * @param assumeFleetRoleForReadRequest
     * @return Result of the AssumeFleetRoleForRead operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeFleetRoleForRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForRead"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssumeFleetRoleForReadResponse assumeFleetRoleForRead(AssumeFleetRoleForReadRequest assumeFleetRoleForReadRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssumeFleetRoleForReadResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssumeFleetRoleForReadResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assumeFleetRoleForReadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assumeFleetRoleForReadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeFleetRoleForRead");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<AssumeFleetRoleForReadRequest, AssumeFleetRoleForReadResponse>()
                            .withOperationName("AssumeFleetRoleForRead").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(assumeFleetRoleForReadRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssumeFleetRoleForReadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get credentials from the fleet role for a worker.
     * </p>
     *
     * @param assumeFleetRoleForWorkerRequest
     * @return Result of the AssumeFleetRoleForWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeFleetRoleForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssumeFleetRoleForWorkerResponse assumeFleetRoleForWorker(
            AssumeFleetRoleForWorkerRequest assumeFleetRoleForWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssumeFleetRoleForWorkerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssumeFleetRoleForWorkerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assumeFleetRoleForWorkerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assumeFleetRoleForWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeFleetRoleForWorker");
            String hostPrefix = "scheduling.";
            String resolvedHostExpression = "scheduling.";

            return clientHandler
                    .execute(new ClientExecutionParams<AssumeFleetRoleForWorkerRequest, AssumeFleetRoleForWorkerResponse>()
                            .withOperationName("AssumeFleetRoleForWorker").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(assumeFleetRoleForWorkerRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssumeFleetRoleForWorkerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets Amazon Web Services credentials from the queue role. The IAM permissions of the credentials are scoped down
     * to have read-only access.
     * </p>
     *
     * @param assumeQueueRoleForReadRequest
     * @return Result of the AssumeQueueRoleForRead operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeQueueRoleForRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForRead"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssumeQueueRoleForReadResponse assumeQueueRoleForRead(AssumeQueueRoleForReadRequest assumeQueueRoleForReadRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssumeQueueRoleForReadResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssumeQueueRoleForReadResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assumeQueueRoleForReadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assumeQueueRoleForReadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeQueueRoleForRead");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<AssumeQueueRoleForReadRequest, AssumeQueueRoleForReadResponse>()
                            .withOperationName("AssumeQueueRoleForRead").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(assumeQueueRoleForReadRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssumeQueueRoleForReadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows a user to assume a role for a queue.
     * </p>
     *
     * @param assumeQueueRoleForUserRequest
     * @return Result of the AssumeQueueRoleForUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeQueueRoleForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssumeQueueRoleForUserResponse assumeQueueRoleForUser(AssumeQueueRoleForUserRequest assumeQueueRoleForUserRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssumeQueueRoleForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssumeQueueRoleForUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assumeQueueRoleForUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assumeQueueRoleForUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeQueueRoleForUser");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<AssumeQueueRoleForUserRequest, AssumeQueueRoleForUserResponse>()
                            .withOperationName("AssumeQueueRoleForUser").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(assumeQueueRoleForUserRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssumeQueueRoleForUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows a worker to assume a queue role.
     * </p>
     *
     * @param assumeQueueRoleForWorkerRequest
     * @return Result of the AssumeQueueRoleForWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.AssumeQueueRoleForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssumeQueueRoleForWorkerResponse assumeQueueRoleForWorker(
            AssumeQueueRoleForWorkerRequest assumeQueueRoleForWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssumeQueueRoleForWorkerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssumeQueueRoleForWorkerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assumeQueueRoleForWorkerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assumeQueueRoleForWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeQueueRoleForWorker");
            String hostPrefix = "scheduling.";
            String resolvedHostExpression = "scheduling.";

            return clientHandler
                    .execute(new ClientExecutionParams<AssumeQueueRoleForWorkerRequest, AssumeQueueRoleForWorkerResponse>()
                            .withOperationName("AssumeQueueRoleForWorker").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(assumeQueueRoleForWorkerRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssumeQueueRoleForWorkerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get batched job details for a worker.
     * </p>
     *
     * @param batchGetJobEntityRequest
     * @return Result of the BatchGetJobEntity operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.BatchGetJobEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/BatchGetJobEntity" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BatchGetJobEntityResponse batchGetJobEntity(BatchGetJobEntityRequest batchGetJobEntityRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetJobEntityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetJobEntityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetJobEntityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetJobEntityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetJobEntity");
            String hostPrefix = "scheduling.";
            String resolvedHostExpression = "scheduling.";

            return clientHandler.execute(new ClientExecutionParams<BatchGetJobEntityRequest, BatchGetJobEntityResponse>()
                    .withOperationName("BatchGetJobEntity").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(batchGetJobEntityRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetJobEntityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies a job template to an Amazon S3 bucket.
     * </p>
     *
     * @param copyJobTemplateRequest
     * @return Result of the CopyJobTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CopyJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CopyJobTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CopyJobTemplateResponse copyJobTemplate(CopyJobTemplateRequest copyJobTemplateRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CopyJobTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CopyJobTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyJobTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyJobTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyJobTemplate");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<CopyJobTemplateRequest, CopyJobTemplateResponse>()
                    .withOperationName("CopyJobTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(copyJobTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopyJobTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a budget to set spending thresholds for your rendering activity.
     * </p>
     *
     * @param createBudgetRequest
     * @return Result of the CreateBudget operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateBudget" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateBudgetResponse createBudget(CreateBudgetRequest createBudgetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBudgetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBudgetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBudgetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBudgetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBudget");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<CreateBudgetRequest, CreateBudgetResponse>()
                    .withOperationName("CreateBudget").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createBudgetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBudgetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a farm to allow space for queues and fleets. Farms are the space where the components of your renders
     * gather and are pieced together in the cloud. Farms contain budgets and allow you to enforce permissions. Deadline
     * Cloud farms are a useful container for large projects.
     * </p>
     *
     * @param createFarmRequest
     * @return Result of the CreateFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFarm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFarmResponse createFarm(CreateFarmRequest createFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFarmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFarmResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFarm");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<CreateFarmRequest, CreateFarmResponse>().withOperationName("CreateFarm")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(createFarmRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateFarmRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a fleet. Fleets gather information relating to compute, or capacity, for renders within your farms. You
     * can choose to manage your own capacity or opt to have fleets fully managed by Deadline Cloud.
     * </p>
     *
     * @param createFleetRequest
     * @return Result of the CreateFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleet");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<CreateFleetRequest, CreateFleetResponse>()
                    .withOperationName("CreateFleet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(createFleetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a job. A job is a set of instructions that AWS Deadline Cloud uses to schedule and run work on available
     * workers. For more information, see <a
     * href="https://docs.aws.amazon.com/deadline-cloud/latest/userguide/deadline-cloud-jobs.html">Deadline Cloud
     * jobs</a>.
     * </p>
     *
     * @param createJobRequest
     * @return Result of the CreateJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateJob");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<CreateJobRequest, CreateJobResponse>()
                    .withOperationName("CreateJob").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(createJobRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a license endpoint to integrate your various licensed software used for rendering on Deadline Cloud.
     * </p>
     *
     * @param createLicenseEndpointRequest
     * @return Result of the CreateLicenseEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateLicenseEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateLicenseEndpointResponse createLicenseEndpoint(CreateLicenseEndpointRequest createLicenseEndpointRequest)
            throws AccessDeniedException, InternalServerErrorException, ThrottlingException, ConflictException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLicenseEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateLicenseEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLicenseEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLicenseEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLicenseEndpoint");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<CreateLicenseEndpointRequest, CreateLicenseEndpointResponse>()
                    .withOperationName("CreateLicenseEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createLicenseEndpointRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateLicenseEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Web Services Deadline Cloud monitor that you can use to view your farms, queues, and fleets.
     * After you submit a job, you can track the progress of the tasks and steps that make up the job, and then download
     * the job's results.
     * </p>
     *
     * @param createMonitorRequest
     * @return Result of the CreateMonitor operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateMonitorResponse createMonitor(CreateMonitorRequest createMonitorRequest) throws AccessDeniedException,
            InternalServerErrorException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMonitorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateMonitorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMonitorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMonitor");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<CreateMonitorRequest, CreateMonitorResponse>()
                    .withOperationName("CreateMonitor").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createMonitorRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateMonitorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a queue to coordinate the order in which jobs run on a farm. A queue can also specify where to pull
     * resources and indicate where to output completed jobs.
     * </p>
     *
     * @param createQueueRequest
     * @return Result of the CreateQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateQueueResponse createQueue(CreateQueueRequest createQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateQueueResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateQueueResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateQueue");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<CreateQueueRequest, CreateQueueResponse>()
                    .withOperationName("CreateQueue").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(createQueueRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateQueueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an environment for a queue that defines how jobs in the queue run.
     * </p>
     *
     * @param createQueueEnvironmentRequest
     * @return Result of the CreateQueueEnvironment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateQueueEnvironmentResponse createQueueEnvironment(CreateQueueEnvironmentRequest createQueueEnvironmentRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateQueueEnvironmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateQueueEnvironmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createQueueEnvironmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createQueueEnvironmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateQueueEnvironment");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<CreateQueueEnvironmentRequest, CreateQueueEnvironmentResponse>()
                            .withOperationName("CreateQueueEnvironment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(createQueueEnvironmentRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateQueueEnvironmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an association between a queue and a fleet.
     * </p>
     *
     * @param createQueueFleetAssociationRequest
     * @return Result of the CreateQueueFleetAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateQueueFleetAssociationResponse createQueueFleetAssociation(
            CreateQueueFleetAssociationRequest createQueueFleetAssociationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateQueueFleetAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateQueueFleetAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createQueueFleetAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createQueueFleetAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateQueueFleetAssociation");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<CreateQueueFleetAssociationRequest, CreateQueueFleetAssociationResponse>()
                            .withOperationName("CreateQueueFleetAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(createQueueFleetAssociationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateQueueFleetAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a storage profile that specifies the operating system, file type, and file location of resources used on
     * a farm.
     * </p>
     *
     * @param createStorageProfileRequest
     * @return Result of the CreateStorageProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateStorageProfileResponse createStorageProfile(CreateStorageProfileRequest createStorageProfileRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStorageProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateStorageProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStorageProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStorageProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStorageProfile");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<CreateStorageProfileRequest, CreateStorageProfileResponse>()
                    .withOperationName("CreateStorageProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createStorageProfileRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStorageProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a worker. A worker tells your instance how much processing power (vCPU), and memory (GiB) you’ll need to
     * assemble the digital assets held within a particular instance. You can specify certain instance types to use, or
     * let the worker know which instances types to exclude.
     * </p>
     *
     * @param createWorkerRequest
     * @return Result of the CreateWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.CreateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateWorker" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateWorkerResponse createWorker(CreateWorkerRequest createWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorker");
            String hostPrefix = "scheduling.";
            String resolvedHostExpression = "scheduling.";

            return clientHandler.execute(new ClientExecutionParams<CreateWorkerRequest, CreateWorkerResponse>()
                    .withOperationName("CreateWorker").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createWorkerRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a budget.
     * </p>
     *
     * @param deleteBudgetRequest
     * @return Result of the DeleteBudget operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteBudget" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteBudgetResponse deleteBudget(DeleteBudgetRequest deleteBudgetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBudgetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBudgetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBudgetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBudgetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBudget");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<DeleteBudgetRequest, DeleteBudgetResponse>()
                    .withOperationName("DeleteBudget").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteBudgetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBudgetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a farm.
     * </p>
     *
     * @param deleteFarmRequest
     * @return Result of the DeleteFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFarm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFarmResponse deleteFarm(DeleteFarmRequest deleteFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFarmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFarmResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFarm");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFarmRequest, DeleteFarmResponse>().withOperationName("DeleteFarm")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteFarmRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteFarmRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     *
     * @param deleteFleetRequest
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleet");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<DeleteFleetRequest, DeleteFleetResponse>()
                    .withOperationName("DeleteFleet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFleetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a license endpoint.
     * </p>
     *
     * @param deleteLicenseEndpointRequest
     * @return Result of the DeleteLicenseEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteLicenseEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteLicenseEndpointResponse deleteLicenseEndpoint(DeleteLicenseEndpointRequest deleteLicenseEndpointRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLicenseEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteLicenseEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLicenseEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLicenseEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLicenseEndpoint");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<DeleteLicenseEndpointRequest, DeleteLicenseEndpointResponse>()
                    .withOperationName("DeleteLicenseEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteLicenseEndpointRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteLicenseEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a metered product.
     * </p>
     *
     * @param deleteMeteredProductRequest
     * @return Result of the DeleteMeteredProduct operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteMeteredProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMeteredProduct" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteMeteredProductResponse deleteMeteredProduct(DeleteMeteredProductRequest deleteMeteredProductRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMeteredProductResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMeteredProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMeteredProductRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMeteredProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMeteredProduct");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<DeleteMeteredProductRequest, DeleteMeteredProductResponse>()
                    .withOperationName("DeleteMeteredProduct").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteMeteredProductRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteMeteredProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a Deadline Cloud monitor. After you delete a monitor, you can create a new one and attach farms to the
     * monitor.
     * </p>
     *
     * @param deleteMonitorRequest
     * @return Result of the DeleteMonitor operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteMonitorResponse deleteMonitor(DeleteMonitorRequest deleteMonitorRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMonitorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteMonitorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMonitorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMonitor");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<DeleteMonitorRequest, DeleteMonitorResponse>()
                    .withOperationName("DeleteMonitor").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteMonitorRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteMonitorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a queue.
     * </p>
     * <important>
     * <p>
     * You can't recover the jobs in a queue if you delete the queue. Deleting the queue also deletes the jobs in that
     * queue.
     * </p>
     * </important>
     *
     * @param deleteQueueRequest
     * @return Result of the DeleteQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteQueueResponse deleteQueue(DeleteQueueRequest deleteQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteQueueResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteQueueResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQueue");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<DeleteQueueRequest, DeleteQueueResponse>()
                    .withOperationName("DeleteQueue").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteQueueRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteQueueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a queue environment.
     * </p>
     *
     * @param deleteQueueEnvironmentRequest
     * @return Result of the DeleteQueueEnvironment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteQueueEnvironmentResponse deleteQueueEnvironment(DeleteQueueEnvironmentRequest deleteQueueEnvironmentRequest)
            throws AccessDeniedException, InternalServerErrorException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteQueueEnvironmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteQueueEnvironmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQueueEnvironmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteQueueEnvironmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQueueEnvironment");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteQueueEnvironmentRequest, DeleteQueueEnvironmentResponse>()
                            .withOperationName("DeleteQueueEnvironment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteQueueEnvironmentRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteQueueEnvironmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a queue-fleet association.
     * </p>
     *
     * @param deleteQueueFleetAssociationRequest
     * @return Result of the DeleteQueueFleetAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteQueueFleetAssociationResponse deleteQueueFleetAssociation(
            DeleteQueueFleetAssociationRequest deleteQueueFleetAssociationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteQueueFleetAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteQueueFleetAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQueueFleetAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteQueueFleetAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQueueFleetAssociation");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteQueueFleetAssociationRequest, DeleteQueueFleetAssociationResponse>()
                            .withOperationName("DeleteQueueFleetAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteQueueFleetAssociationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteQueueFleetAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a storage profile.
     * </p>
     *
     * @param deleteStorageProfileRequest
     * @return Result of the DeleteStorageProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteStorageProfileResponse deleteStorageProfile(DeleteStorageProfileRequest deleteStorageProfileRequest)
            throws AccessDeniedException, InternalServerErrorException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteStorageProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteStorageProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStorageProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStorageProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStorageProfile");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<DeleteStorageProfileRequest, DeleteStorageProfileResponse>()
                    .withOperationName("DeleteStorageProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteStorageProfileRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteStorageProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a worker.
     * </p>
     *
     * @param deleteWorkerRequest
     * @return Result of the DeleteWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DeleteWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteWorker" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteWorkerResponse deleteWorker(DeleteWorkerRequest deleteWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteWorkerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorker");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkerRequest, DeleteWorkerResponse>()
                    .withOperationName("DeleteWorker").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteWorkerRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a member from a farm.
     * </p>
     *
     * @param disassociateMemberFromFarmRequest
     * @return Result of the DisassociateMemberFromFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DisassociateMemberFromFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFarm"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateMemberFromFarmResponse disassociateMemberFromFarm(
            DisassociateMemberFromFarmRequest disassociateMemberFromFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateMemberFromFarmResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateMemberFromFarmResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMemberFromFarmRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMemberFromFarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMemberFromFarm");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberFromFarmRequest, DisassociateMemberFromFarmResponse>()
                            .withOperationName("DisassociateMemberFromFarm").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(disassociateMemberFromFarmRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateMemberFromFarmRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a member from a fleet.
     * </p>
     *
     * @param disassociateMemberFromFleetRequest
     * @return Result of the DisassociateMemberFromFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DisassociateMemberFromFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateMemberFromFleetResponse disassociateMemberFromFleet(
            DisassociateMemberFromFleetRequest disassociateMemberFromFleetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateMemberFromFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateMemberFromFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMemberFromFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMemberFromFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMemberFromFleet");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberFromFleetRequest, DisassociateMemberFromFleetResponse>()
                            .withOperationName("DisassociateMemberFromFleet").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(disassociateMemberFromFleetRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateMemberFromFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a member from a job.
     * </p>
     *
     * @param disassociateMemberFromJobRequest
     * @return Result of the DisassociateMemberFromJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DisassociateMemberFromJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateMemberFromJobResponse disassociateMemberFromJob(
            DisassociateMemberFromJobRequest disassociateMemberFromJobRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateMemberFromJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateMemberFromJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMemberFromJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMemberFromJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMemberFromJob");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberFromJobRequest, DisassociateMemberFromJobResponse>()
                            .withOperationName("DisassociateMemberFromJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(disassociateMemberFromJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateMemberFromJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a member from a queue.
     * </p>
     *
     * @param disassociateMemberFromQueueRequest
     * @return Result of the DisassociateMemberFromQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.DisassociateMemberFromQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromQueue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateMemberFromQueueResponse disassociateMemberFromQueue(
            DisassociateMemberFromQueueRequest disassociateMemberFromQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateMemberFromQueueResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateMemberFromQueueResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMemberFromQueueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMemberFromQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMemberFromQueue");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberFromQueueRequest, DisassociateMemberFromQueueResponse>()
                            .withOperationName("DisassociateMemberFromQueue").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(disassociateMemberFromQueueRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateMemberFromQueueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a budget.
     * </p>
     *
     * @param getBudgetRequest
     * @return Result of the GetBudget operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetBudget" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBudgetResponse getBudget(GetBudgetRequest getBudgetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBudgetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBudgetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBudgetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBudgetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBudget");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<GetBudgetRequest, GetBudgetResponse>()
                    .withOperationName("GetBudget").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getBudgetRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetBudgetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a farm.
     * </p>
     *
     * @param getFarmRequest
     * @return Result of the GetFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFarm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetFarmResponse getFarm(GetFarmRequest getFarmRequest) throws AccessDeniedException, InternalServerErrorException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFarmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFarmResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFarm");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<GetFarmRequest, GetFarmResponse>()
                    .withOperationName("GetFarm").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getFarmRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetFarmRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a fleet.
     * </p>
     *
     * @param getFleetRequest
     * @return Result of the GetFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetFleetResponse getFleet(GetFleetRequest getFleetRequest) throws AccessDeniedException, InternalServerErrorException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFleet");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<GetFleetRequest, GetFleetResponse>()
                    .withOperationName("GetFleet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getFleetRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a Deadline Cloud job.
     * </p>
     *
     * @param getJobRequest
     * @return Result of the GetJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetJobResponse getJob(GetJobRequest getJobRequest) throws AccessDeniedException, InternalServerErrorException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJob");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<GetJobRequest, GetJobResponse>().withOperationName("GetJob")
                    .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getJobRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a licence endpoint.
     * </p>
     *
     * @param getLicenseEndpointRequest
     * @return Result of the GetLicenseEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetLicenseEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetLicenseEndpointResponse getLicenseEndpoint(GetLicenseEndpointRequest getLicenseEndpointRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLicenseEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLicenseEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLicenseEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLicenseEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLicenseEndpoint");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<GetLicenseEndpointRequest, GetLicenseEndpointResponse>()
                    .withOperationName("GetLicenseEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getLicenseEndpointRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLicenseEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified monitor.
     * </p>
     *
     * @param getMonitorRequest
     * @return Result of the GetMonitor operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMonitorResponse getMonitor(GetMonitorRequest getMonitorRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMonitorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMonitorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMonitorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMonitor");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<GetMonitorRequest, GetMonitorResponse>().withOperationName("GetMonitor")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(getMonitorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetMonitorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a queue.
     * </p>
     *
     * @param getQueueRequest
     * @return Result of the GetQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueue" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetQueueResponse getQueue(GetQueueRequest getQueueRequest) throws AccessDeniedException, InternalServerErrorException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetQueueResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetQueueResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueue");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<GetQueueRequest, GetQueueResponse>()
                    .withOperationName("GetQueue").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getQueueRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetQueueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a queue environment.
     * </p>
     *
     * @param getQueueEnvironmentRequest
     * @return Result of the GetQueueEnvironment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetQueueEnvironmentResponse getQueueEnvironment(GetQueueEnvironmentRequest getQueueEnvironmentRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetQueueEnvironmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetQueueEnvironmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueueEnvironmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueueEnvironmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueueEnvironment");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<GetQueueEnvironmentRequest, GetQueueEnvironmentResponse>()
                    .withOperationName("GetQueueEnvironment").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getQueueEnvironmentRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetQueueEnvironmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a queue-fleet association.
     * </p>
     *
     * @param getQueueFleetAssociationRequest
     * @return Result of the GetQueueFleetAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetQueueFleetAssociationResponse getQueueFleetAssociation(
            GetQueueFleetAssociationRequest getQueueFleetAssociationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetQueueFleetAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetQueueFleetAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueueFleetAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueueFleetAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueueFleetAssociation");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<GetQueueFleetAssociationRequest, GetQueueFleetAssociationResponse>()
                            .withOperationName("GetQueueFleetAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(getQueueFleetAssociationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetQueueFleetAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a session.
     * </p>
     *
     * @param getSessionRequest
     * @return Result of the GetSession operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSession");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<GetSessionRequest, GetSessionResponse>().withOperationName("GetSession")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(getSessionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a session action for the job.
     * </p>
     *
     * @param getSessionActionRequest
     * @return Result of the GetSessionAction operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetSessionAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSessionActionResponse getSessionAction(GetSessionActionRequest getSessionActionRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSessionActionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSessionActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSessionActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSessionActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionAction");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<GetSessionActionRequest, GetSessionActionResponse>()
                    .withOperationName("GetSessionAction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getSessionActionRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSessionActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a set of statistics for queues or farms. Before you can call the
     * <code>GetSessionStatisticsAggregation</code> operation, you must first call the
     * <code>StartSessionsStatisticsAggregation</code> operation. Statistics are available for 1 hour after you call the
     * <code>StartSessionsStatisticsAggregation</code> operation.
     * </p>
     *
     * @param getSessionsStatisticsAggregationRequest
     * @return Result of the GetSessionsStatisticsAggregation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSessionsStatisticsAggregationResponse getSessionsStatisticsAggregation(
            GetSessionsStatisticsAggregationRequest getSessionsStatisticsAggregationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSessionsStatisticsAggregationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSessionsStatisticsAggregationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSessionsStatisticsAggregationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getSessionsStatisticsAggregationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionsStatisticsAggregation");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<GetSessionsStatisticsAggregationRequest, GetSessionsStatisticsAggregationResponse>()
                            .withOperationName("GetSessionsStatisticsAggregation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(getSessionsStatisticsAggregationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetSessionsStatisticsAggregationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a step.
     * </p>
     *
     * @param getStepRequest
     * @return Result of the GetStep operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStep" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetStepResponse getStep(GetStepRequest getStepRequest) throws AccessDeniedException, InternalServerErrorException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStepResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetStepResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStepRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStepRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStep");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<GetStepRequest, GetStepResponse>()
                    .withOperationName("GetStep").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getStepRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetStepRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a storage profile.
     * </p>
     *
     * @param getStorageProfileRequest
     * @return Result of the GetStorageProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetStorageProfileResponse getStorageProfile(GetStorageProfileRequest getStorageProfileRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStorageProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetStorageProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStorageProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStorageProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStorageProfile");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<GetStorageProfileRequest, GetStorageProfileResponse>()
                    .withOperationName("GetStorageProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getStorageProfileRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetStorageProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a storage profile for a queue.
     * </p>
     *
     * @param getStorageProfileForQueueRequest
     * @return Result of the GetStorageProfileForQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetStorageProfileForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfileForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetStorageProfileForQueueResponse getStorageProfileForQueue(
            GetStorageProfileForQueueRequest getStorageProfileForQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStorageProfileForQueueResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetStorageProfileForQueueResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStorageProfileForQueueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStorageProfileForQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStorageProfileForQueue");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<GetStorageProfileForQueueRequest, GetStorageProfileForQueueResponse>()
                            .withOperationName("GetStorageProfileForQueue").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(getStorageProfileForQueueRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetStorageProfileForQueueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a task.
     * </p>
     *
     * @param getTaskRequest
     * @return Result of the GetTask operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTaskResponse getTask(GetTaskRequest getTaskRequest) throws AccessDeniedException, InternalServerErrorException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTask");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<GetTaskRequest, GetTaskResponse>()
                    .withOperationName("GetTask").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getTaskRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a worker.
     * </p>
     *
     * @param getWorkerRequest
     * @return Result of the GetWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.GetWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetWorker" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetWorkerResponse getWorker(GetWorkerRequest getWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetWorkerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorker");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<GetWorkerRequest, GetWorkerResponse>()
                    .withOperationName("GetWorker").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getWorkerRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetWorkerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A list of the available metered products.
     * </p>
     *
     * @param listAvailableMeteredProductsRequest
     * @return Result of the ListAvailableMeteredProducts operation returned by the service.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListAvailableMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListAvailableMeteredProducts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAvailableMeteredProductsResponse listAvailableMeteredProducts(
            ListAvailableMeteredProductsRequest listAvailableMeteredProductsRequest) throws InternalServerErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAvailableMeteredProductsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAvailableMeteredProductsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAvailableMeteredProductsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAvailableMeteredProductsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAvailableMeteredProducts");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<ListAvailableMeteredProductsRequest, ListAvailableMeteredProductsResponse>()
                            .withOperationName("ListAvailableMeteredProducts").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listAvailableMeteredProductsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAvailableMeteredProductsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A list of budgets in a farm.
     * </p>
     *
     * @param listBudgetsRequest
     * @return Result of the ListBudgets operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListBudgets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListBudgets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListBudgetsResponse listBudgets(ListBudgetsRequest listBudgetsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBudgetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBudgetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBudgetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBudgetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBudgets");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListBudgetsRequest, ListBudgetsResponse>()
                    .withOperationName("ListBudgets").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(listBudgetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBudgetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the members of a farm.
     * </p>
     *
     * @param listFarmMembersRequest
     * @return Result of the ListFarmMembers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFarmMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarmMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFarmMembersResponse listFarmMembers(ListFarmMembersRequest listFarmMembersRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFarmMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFarmMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFarmMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFarmMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFarmMembers");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListFarmMembersRequest, ListFarmMembersResponse>()
                    .withOperationName("ListFarmMembers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listFarmMembersRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFarmMembersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists farms.
     * </p>
     *
     * @param listFarmsRequest
     * @return Result of the ListFarms operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarms" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFarmsResponse listFarms(ListFarmsRequest listFarmsRequest) throws AccessDeniedException,
            InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFarmsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFarmsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFarmsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFarmsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFarms");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListFarmsRequest, ListFarmsResponse>()
                    .withOperationName("ListFarms").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(listFarmsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListFarmsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists fleet members.
     * </p>
     *
     * @param listFleetMembersRequest
     * @return Result of the ListFleetMembers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFleetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFleetMembersResponse listFleetMembers(ListFleetMembersRequest listFleetMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFleetMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFleetMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFleetMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFleetMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFleetMembers");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListFleetMembersRequest, ListFleetMembersResponse>()
                    .withOperationName("ListFleetMembers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listFleetMembersRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFleetMembersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists fleets.
     * </p>
     *
     * @param listFleetsRequest
     * @return Result of the ListFleets operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFleetsResponse listFleets(ListFleetsRequest listFleetsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFleetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFleetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFleetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFleets");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<ListFleetsRequest, ListFleetsResponse>().withOperationName("ListFleets")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(listFleetsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListFleetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists members on a job.
     * </p>
     *
     * @param listJobMembersRequest
     * @return Result of the ListJobMembers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListJobMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListJobMembersResponse listJobMembers(ListJobMembersRequest listJobMembersRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListJobMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListJobMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listJobMembersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJobMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJobMembers");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListJobMembersRequest, ListJobMembersResponse>()
                    .withOperationName("ListJobMembers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listJobMembersRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListJobMembersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists parameter definitions of a job.
     * </p>
     *
     * @param listJobParameterDefinitionsRequest
     * @return Result of the ListJobParameterDefinitions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListJobParameterDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobParameterDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListJobParameterDefinitionsResponse listJobParameterDefinitions(
            ListJobParameterDefinitionsRequest listJobParameterDefinitionsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListJobParameterDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListJobParameterDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listJobParameterDefinitionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJobParameterDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJobParameterDefinitions");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<ListJobParameterDefinitionsRequest, ListJobParameterDefinitionsResponse>()
                            .withOperationName("ListJobParameterDefinitions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listJobParameterDefinitionsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListJobParameterDefinitionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists jobs.
     * </p>
     *
     * @param listJobsRequest
     * @return Result of the ListJobs operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws AccessDeniedException, InternalServerErrorException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJobs");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListJobsRequest, ListJobsResponse>()
                    .withOperationName("ListJobs").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(listJobsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists license endpoints.
     * </p>
     *
     * @param listLicenseEndpointsRequest
     * @return Result of the ListLicenseEndpoints operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListLicenseEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListLicenseEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListLicenseEndpointsResponse listLicenseEndpoints(ListLicenseEndpointsRequest listLicenseEndpointsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLicenseEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListLicenseEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLicenseEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLicenseEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLicenseEndpoints");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListLicenseEndpointsRequest, ListLicenseEndpointsResponse>()
                    .withOperationName("ListLicenseEndpoints").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listLicenseEndpointsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListLicenseEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists metered products.
     * </p>
     *
     * @param listMeteredProductsRequest
     * @return Result of the ListMeteredProducts operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMeteredProducts" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListMeteredProductsResponse listMeteredProducts(ListMeteredProductsRequest listMeteredProductsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMeteredProductsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMeteredProductsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMeteredProductsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMeteredProductsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMeteredProducts");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListMeteredProductsRequest, ListMeteredProductsResponse>()
                    .withOperationName("ListMeteredProducts").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listMeteredProductsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMeteredProductsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of your monitors in Deadline Cloud.
     * </p>
     *
     * @param listMonitorsRequest
     * @return Result of the ListMonitors operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListMonitorsResponse listMonitors(ListMonitorsRequest listMonitorsRequest) throws AccessDeniedException,
            InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMonitorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListMonitorsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMonitorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMonitorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMonitors");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListMonitorsRequest, ListMonitorsResponse>()
                    .withOperationName("ListMonitors").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listMonitorsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMonitorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists queue environments.
     * </p>
     *
     * @param listQueueEnvironmentsRequest
     * @return Result of the ListQueueEnvironments operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListQueueEnvironmentsResponse listQueueEnvironments(ListQueueEnvironmentsRequest listQueueEnvironmentsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListQueueEnvironmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListQueueEnvironmentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQueueEnvironmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQueueEnvironmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueueEnvironments");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListQueueEnvironmentsRequest, ListQueueEnvironmentsResponse>()
                    .withOperationName("ListQueueEnvironments").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listQueueEnvironmentsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListQueueEnvironmentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists queue-fleet associations.
     * </p>
     *
     * @param listQueueFleetAssociationsRequest
     * @return Result of the ListQueueFleetAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueFleetAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueFleetAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListQueueFleetAssociationsResponse listQueueFleetAssociations(
            ListQueueFleetAssociationsRequest listQueueFleetAssociationsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListQueueFleetAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListQueueFleetAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQueueFleetAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQueueFleetAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueueFleetAssociations");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<ListQueueFleetAssociationsRequest, ListQueueFleetAssociationsResponse>()
                            .withOperationName("ListQueueFleetAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listQueueFleetAssociationsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListQueueFleetAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the members in a queue.
     * </p>
     *
     * @param listQueueMembersRequest
     * @return Result of the ListQueueMembers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueueMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListQueueMembersResponse listQueueMembers(ListQueueMembersRequest listQueueMembersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListQueueMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListQueueMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQueueMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQueueMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueueMembers");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListQueueMembersRequest, ListQueueMembersResponse>()
                    .withOperationName("ListQueueMembers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listQueueMembersRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListQueueMembersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists queues.
     * </p>
     *
     * @param listQueuesRequest
     * @return Result of the ListQueues operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListQueuesResponse listQueues(ListQueuesRequest listQueuesRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListQueuesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListQueuesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQueuesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQueuesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueues");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<ListQueuesRequest, ListQueuesResponse>().withOperationName("ListQueues")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(listQueuesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListQueuesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists session actions.
     * </p>
     *
     * @param listSessionActionsRequest
     * @return Result of the ListSessionActions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionActions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListSessionActionsResponse listSessionActions(ListSessionActionsRequest listSessionActionsRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSessionActionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSessionActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSessionActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSessionActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessionActions");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListSessionActionsRequest, ListSessionActionsResponse>()
                    .withOperationName("ListSessionActions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listSessionActionsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSessionActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists sessions.
     * </p>
     *
     * @param listSessionsRequest
     * @return Result of the ListSessions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSessionsResponse listSessions(ListSessionsRequest listSessionsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSessionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSessionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessions");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListSessionsRequest, ListSessionsResponse>()
                    .withOperationName("ListSessions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listSessionsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSessionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists sessions for a worker.
     * </p>
     *
     * @param listSessionsForWorkerRequest
     * @return Result of the ListSessionsForWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSessionsForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionsForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSessionsForWorkerResponse listSessionsForWorker(ListSessionsForWorkerRequest listSessionsForWorkerRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSessionsForWorkerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSessionsForWorkerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSessionsForWorkerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSessionsForWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessionsForWorker");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListSessionsForWorkerRequest, ListSessionsForWorkerResponse>()
                    .withOperationName("ListSessionsForWorker").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listSessionsForWorkerRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSessionsForWorkerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists step consumers.
     * </p>
     *
     * @param listStepConsumersRequest
     * @return Result of the ListStepConsumers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStepConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListStepConsumersResponse listStepConsumers(ListStepConsumersRequest listStepConsumersRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStepConsumersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListStepConsumersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStepConsumersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStepConsumersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStepConsumers");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListStepConsumersRequest, ListStepConsumersResponse>()
                    .withOperationName("ListStepConsumers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listStepConsumersRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStepConsumersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the dependencies for a step.
     * </p>
     *
     * @param listStepDependenciesRequest
     * @return Result of the ListStepDependencies operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStepDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepDependencies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListStepDependenciesResponse listStepDependencies(ListStepDependenciesRequest listStepDependenciesRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStepDependenciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListStepDependenciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStepDependenciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStepDependenciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStepDependencies");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListStepDependenciesRequest, ListStepDependenciesResponse>()
                    .withOperationName("ListStepDependencies").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listStepDependenciesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStepDependenciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists steps for a job.
     * </p>
     *
     * @param listStepsRequest
     * @return Result of the ListSteps operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListStepsResponse listSteps(ListStepsRequest listStepsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStepsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListStepsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStepsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStepsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSteps");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListStepsRequest, ListStepsResponse>()
                    .withOperationName("ListSteps").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(listStepsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListStepsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists storage profiles.
     * </p>
     *
     * @param listStorageProfilesRequest
     * @return Result of the ListStorageProfiles operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStorageProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListStorageProfilesResponse listStorageProfiles(ListStorageProfilesRequest listStorageProfilesRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStorageProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListStorageProfilesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStorageProfilesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStorageProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStorageProfiles");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListStorageProfilesRequest, ListStorageProfilesResponse>()
                    .withOperationName("ListStorageProfiles").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listStorageProfilesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStorageProfilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists storage profiles for a queue.
     * </p>
     *
     * @param listStorageProfilesForQueueRequest
     * @return Result of the ListStorageProfilesForQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListStorageProfilesForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfilesForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStorageProfilesForQueueResponse listStorageProfilesForQueue(
            ListStorageProfilesForQueueRequest listStorageProfilesForQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStorageProfilesForQueueResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListStorageProfilesForQueueResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStorageProfilesForQueueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStorageProfilesForQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStorageProfilesForQueue");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<ListStorageProfilesForQueueRequest, ListStorageProfilesForQueueResponse>()
                            .withOperationName("ListStorageProfilesForQueue").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listStorageProfilesForQueueRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListStorageProfilesForQueueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists tasks for a job.
     * </p>
     *
     * @param listTasksRequest
     * @return Result of the ListTasks operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTasksResponse listTasks(ListTasksRequest listTasksRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTasksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTasksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTasks");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListTasksRequest, ListTasksResponse>()
                    .withOperationName("ListTasks").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(listTasksRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists workers.
     * </p>
     *
     * @param listWorkersRequest
     * @return Result of the ListWorkers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListWorkersResponse listWorkers(ListWorkersRequest listWorkersRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListWorkersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkers");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<ListWorkersRequest, ListWorkersResponse>()
                    .withOperationName("ListWorkers").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(listWorkersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWorkersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a metered product.
     * </p>
     *
     * @param putMeteredProductRequest
     * @return Result of the PutMeteredProduct operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.PutMeteredProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/PutMeteredProduct" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutMeteredProductResponse putMeteredProduct(PutMeteredProductRequest putMeteredProductRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutMeteredProductResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutMeteredProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putMeteredProductRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMeteredProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMeteredProduct");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<PutMeteredProductRequest, PutMeteredProductResponse>()
                    .withOperationName("PutMeteredProduct").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(putMeteredProductRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutMeteredProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for jobs.
     * </p>
     *
     * @param searchJobsRequest
     * @return Result of the SearchJobs operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.SearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchJobsResponse searchJobs(SearchJobsRequest searchJobsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchJobs");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<SearchJobsRequest, SearchJobsResponse>().withOperationName("SearchJobs")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(searchJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SearchJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for steps.
     * </p>
     *
     * @param searchStepsRequest
     * @return Result of the SearchSteps operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.SearchSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchSteps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchStepsResponse searchSteps(SearchStepsRequest searchStepsRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchStepsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchStepsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchStepsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchStepsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchSteps");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<SearchStepsRequest, SearchStepsResponse>()
                    .withOperationName("SearchSteps").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(searchStepsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchStepsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for tasks.
     * </p>
     *
     * @param searchTasksRequest
     * @return Result of the SearchTasks operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.SearchTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchTasksResponse searchTasks(SearchTasksRequest searchTasksRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchTasksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchTasksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchTasks");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<SearchTasksRequest, SearchTasksResponse>()
                    .withOperationName("SearchTasks").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(searchTasksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for workers.
     * </p>
     *
     * @param searchWorkersRequest
     * @return Result of the SearchWorkers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.SearchWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchWorkersResponse searchWorkers(SearchWorkersRequest searchWorkersRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchWorkersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchWorkersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchWorkersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchWorkersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchWorkers");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<SearchWorkersRequest, SearchWorkersResponse>()
                    .withOperationName("SearchWorkers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(searchWorkersRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchWorkersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an asynchronous request for getting aggregated statistics about queues and farms. Get the statistics using
     * the <code>GetSessionsStatisticsAggregation</code> operation. You can only have one running aggregation for your
     * Deadline Cloud farm. Call the <code>GetSessionsStatisticsAggregation</code> operation and check the
     * <code>status</code> field to see if an aggregation is running. Statistics are available for 1 hour after you call
     * the <code>StartSessionsStatisticsAggregation</code> operation.
     * </p>
     *
     * @param startSessionsStatisticsAggregationRequest
     * @return Result of the StartSessionsStatisticsAggregation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.StartSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/StartSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartSessionsStatisticsAggregationResponse startSessionsStatisticsAggregation(
            StartSessionsStatisticsAggregationRequest startSessionsStatisticsAggregationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartSessionsStatisticsAggregationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartSessionsStatisticsAggregationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSessionsStatisticsAggregationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startSessionsStatisticsAggregationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSessionsStatisticsAggregation");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<StartSessionsStatisticsAggregationRequest, StartSessionsStatisticsAggregationResponse>()
                            .withOperationName("StartSessionsStatisticsAggregation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(startSessionsStatisticsAggregationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartSessionsStatisticsAggregationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Tags a resource using the resource's ARN and desired tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a tag from a resource using the resource's ARN and tag to remove.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(untagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a budget that sets spending thresholds for rendering activity.
     * </p>
     *
     * @param updateBudgetRequest
     * @return Result of the UpdateBudget operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateBudget" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateBudgetResponse updateBudget(UpdateBudgetRequest updateBudgetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBudgetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateBudgetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBudgetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBudgetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBudget");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<UpdateBudgetRequest, UpdateBudgetResponse>()
                    .withOperationName("UpdateBudget").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateBudgetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBudgetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a farm.
     * </p>
     *
     * @param updateFarmRequest
     * @return Result of the UpdateFarm operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFarm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateFarmResponse updateFarm(UpdateFarmRequest updateFarmRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFarmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFarmResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFarm");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFarmRequest, UpdateFarmResponse>().withOperationName("UpdateFarm")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(updateFarmRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateFarmRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a fleet.
     * </p>
     *
     * @param updateFleetRequest
     * @return Result of the UpdateFleet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateFleetResponse updateFleet(UpdateFleetRequest updateFleetRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFleet");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<UpdateFleetRequest, UpdateFleetResponse>()
                    .withOperationName("UpdateFleet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(updateFleetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a job.
     * </p>
     * <p>
     * When you change the status of the job to <code>ARCHIVED</code>, the job can't be scheduled or archived.
     * </p>
     * <important>
     * <p>
     * An archived jobs and its steps and tasks are deleted after 120 days. The job can't be recovered.
     * </p>
     * </important>
     *
     * @param updateJobRequest
     * @return Result of the UpdateJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest updateJobRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateJob");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<UpdateJobRequest, UpdateJobResponse>()
                    .withOperationName("UpdateJob").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(updateJobRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the settings for a Deadline Cloud monitor. You can modify one or all of the settings when you call
     * <code>UpdateMonitor</code>.
     * </p>
     *
     * @param updateMonitorRequest
     * @return Result of the UpdateMonitor operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateMonitorResponse updateMonitor(UpdateMonitorRequest updateMonitorRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMonitorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateMonitorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMonitorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMonitor");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<UpdateMonitorRequest, UpdateMonitorResponse>()
                    .withOperationName("UpdateMonitor").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateMonitorRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateMonitorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a queue.
     * </p>
     *
     * @param updateQueueRequest
     * @return Result of the UpdateQueue operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateQueueResponse updateQueue(UpdateQueueRequest updateQueueRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateQueueResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateQueueResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQueue");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<UpdateQueueRequest, UpdateQueueResponse>()
                    .withOperationName("UpdateQueue").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(updateQueueRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateQueueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the queue environment.
     * </p>
     *
     * @param updateQueueEnvironmentRequest
     * @return Result of the UpdateQueueEnvironment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateQueueEnvironmentResponse updateQueueEnvironment(UpdateQueueEnvironmentRequest updateQueueEnvironmentRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateQueueEnvironmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateQueueEnvironmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQueueEnvironmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateQueueEnvironmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQueueEnvironment");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateQueueEnvironmentRequest, UpdateQueueEnvironmentResponse>()
                            .withOperationName("UpdateQueueEnvironment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(updateQueueEnvironmentRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateQueueEnvironmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a queue-fleet association.
     * </p>
     *
     * @param updateQueueFleetAssociationRequest
     * @return Result of the UpdateQueueFleetAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateQueueFleetAssociationResponse updateQueueFleetAssociation(
            UpdateQueueFleetAssociationRequest updateQueueFleetAssociationRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateQueueFleetAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateQueueFleetAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQueueFleetAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateQueueFleetAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQueueFleetAssociation");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateQueueFleetAssociationRequest, UpdateQueueFleetAssociationResponse>()
                            .withOperationName("UpdateQueueFleetAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(updateQueueFleetAssociationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateQueueFleetAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a session.
     * </p>
     *
     * @param updateSessionRequest
     * @return Result of the UpdateSession operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateSessionResponse updateSession(UpdateSessionRequest updateSessionRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSession");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<UpdateSessionRequest, UpdateSessionResponse>()
                    .withOperationName("UpdateSession").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateSessionRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a step.
     * </p>
     *
     * @param updateStepRequest
     * @return Result of the UpdateStep operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStep" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateStepResponse updateStep(UpdateStepRequest updateStepRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateStepResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateStepResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateStepRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStepRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStep");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateStepRequest, UpdateStepResponse>().withOperationName("UpdateStep")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(updateStepRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateStepRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a storage profile.
     * </p>
     *
     * @param updateStorageProfileRequest
     * @return Result of the UpdateStorageProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateStorageProfileResponse updateStorageProfile(UpdateStorageProfileRequest updateStorageProfileRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateStorageProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateStorageProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateStorageProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStorageProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStorageProfile");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler.execute(new ClientExecutionParams<UpdateStorageProfileRequest, UpdateStorageProfileResponse>()
                    .withOperationName("UpdateStorageProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateStorageProfileRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateStorageProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a task.
     * </p>
     *
     * @param updateTaskRequest
     * @return Result of the UpdateTask operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateTaskResponse updateTask(UpdateTaskRequest updateTaskRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTask");
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateTaskRequest, UpdateTaskResponse>().withOperationName("UpdateTask")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(updateTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a worker.
     * </p>
     *
     * @param updateWorkerRequest
     * @return Result of the UpdateWorker operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorker" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateWorkerResponse updateWorker(UpdateWorkerRequest updateWorkerRequest) throws AccessDeniedException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateWorkerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorker");
            String hostPrefix = "scheduling.";
            String resolvedHostExpression = "scheduling.";

            return clientHandler.execute(new ClientExecutionParams<UpdateWorkerRequest, UpdateWorkerResponse>()
                    .withOperationName("UpdateWorker").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateWorkerRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWorkerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the schedule for a worker.
     * </p>
     *
     * @param updateWorkerScheduleRequest
     * @return Result of the UpdateWorkerSchedule operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action.
     * @throws InternalServerErrorException
     *         Deadline Cloud can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a request rate quota.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ValidationException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeadlineException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeadlineClient.UpdateWorkerSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorkerSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateWorkerScheduleResponse updateWorkerSchedule(UpdateWorkerScheduleRequest updateWorkerScheduleRequest)
            throws AccessDeniedException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, DeadlineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkerScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateWorkerScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkerScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkerScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkerSchedule");
            String hostPrefix = "scheduling.";
            String resolvedHostExpression = "scheduling.";

            return clientHandler.execute(new ClientExecutionParams<UpdateWorkerScheduleRequest, UpdateWorkerScheduleResponse>()
                    .withOperationName("UpdateWorkerSchedule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateWorkerScheduleRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWorkerScheduleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link DeadlineWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link DeadlineWaiter}
     */
    @Override
    public DeadlineWaiter waiter() {
        return DeadlineWaiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        DeadlineServiceClientConfigurationBuilder serviceConfigBuilder = new DeadlineServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(DeadlineException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    @Override
    public final DeadlineServiceClientConfiguration serviceClientConfiguration() {
        return new DeadlineServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
