/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetJobEntityResponse extends DeadlineResponse implements
        ToCopyableBuilder<BatchGetJobEntityResponse.Builder, BatchGetJobEntityResponse> {
    private static final SdkField<List<JobEntity>> ENTITIES_FIELD = SdkField
            .<List<JobEntity>> builder(MarshallingType.LIST)
            .memberName("entities")
            .getter(getter(BatchGetJobEntityResponse::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GetJobEntityError>> ERRORS_FIELD = SdkField
            .<List<GetJobEntityError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetJobEntityResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GetJobEntityError> builder(MarshallingType.SDK_POJO)
                                            .constructor(GetJobEntityError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD, ERRORS_FIELD));

    private final List<JobEntity> entities;

    private final List<GetJobEntityError> errors;

    private BatchGetJobEntityResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the job entities, or details, in the batch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return A list of the job entities, or details, in the batch.
     */
    public final List<JobEntity> entities() {
        return entities;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors from the job error logs for the batch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of errors from the job error logs for the batch.
     */
    public final List<GetJobEntityError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetJobEntityResponse)) {
            return false;
        }
        BatchGetJobEntityResponse other = (BatchGetJobEntityResponse) obj;
        return hasEntities() == other.hasEntities() && Objects.equals(entities(), other.entities())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetJobEntityResponse").add("Entities", hasEntities() ? entities() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entities":
            return Optional.ofNullable(clazz.cast(entities()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetJobEntityResponse, T> g) {
        return obj -> g.apply((BatchGetJobEntityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetJobEntityResponse> {
        /**
         * <p>
         * A list of the job entities, or details, in the batch.
         * </p>
         * 
         * @param entities
         *        A list of the job entities, or details, in the batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<JobEntity> entities);

        /**
         * <p>
         * A list of the job entities, or details, in the batch.
         * </p>
         * 
         * @param entities
         *        A list of the job entities, or details, in the batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(JobEntity... entities);

        /**
         * <p>
         * A list of the job entities, or details, in the batch.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.JobEntity.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.deadline.model.JobEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.JobEntity.Builder#build()} is called immediately and
         * its result is passed to {@link #entities(List<JobEntity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.JobEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(java.util.Collection<JobEntity>)
         */
        Builder entities(Consumer<JobEntity.Builder>... entities);

        /**
         * <p>
         * A list of errors from the job error logs for the batch.
         * </p>
         * 
         * @param errors
         *        A list of errors from the job error logs for the batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<GetJobEntityError> errors);

        /**
         * <p>
         * A list of errors from the job error logs for the batch.
         * </p>
         * 
         * @param errors
         *        A list of errors from the job error logs for the batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(GetJobEntityError... errors);

        /**
         * <p>
         * A list of errors from the job error logs for the batch.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.GetJobEntityError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.deadline.model.GetJobEntityError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.GetJobEntityError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<GetJobEntityError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.GetJobEntityError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<GetJobEntityError>)
         */
        Builder errors(Consumer<GetJobEntityError.Builder>... errors);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private List<JobEntity> entities = DefaultSdkAutoConstructList.getInstance();

        private List<GetJobEntityError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetJobEntityResponse model) {
            super(model);
            entities(model.entities);
            errors(model.errors);
        }

        public final List<JobEntity.Builder> getEntities() {
            List<JobEntity.Builder> result = BatchGetJobEntityListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<JobEntity.BuilderImpl> entities) {
            this.entities = BatchGetJobEntityListCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<JobEntity> entities) {
            this.entities = BatchGetJobEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(JobEntity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<JobEntity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> JobEntity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GetJobEntityError.Builder> getErrors() {
            List<GetJobEntityError.Builder> result = BatchGetJobEntityErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<GetJobEntityError.BuilderImpl> errors) {
            this.errors = BatchGetJobEntityErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<GetJobEntityError> errors) {
            this.errors = BatchGetJobEntityErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(GetJobEntityError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<GetJobEntityError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> GetJobEntityError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetJobEntityResponse build() {
            return new BatchGetJobEntityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
