/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFleetRequest extends DeadlineRequest implements
        ToCopyableBuilder<CreateFleetRequest.Builder, CreateFleetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateFleetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(CreateFleetRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateFleetRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateFleetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateFleetRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Integer> MIN_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minWorkerCount").getter(getter(CreateFleetRequest::minWorkerCount))
            .setter(setter(Builder::minWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minWorkerCount").build()).build();

    private static final SdkField<Integer> MAX_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxWorkerCount").getter(getter(CreateFleetRequest::maxWorkerCount))
            .setter(setter(Builder::maxWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxWorkerCount").build()).build();

    private static final SdkField<FleetConfiguration> CONFIGURATION_FIELD = SdkField
            .<FleetConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(CreateFleetRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(FleetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateFleetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            FARM_ID_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, MIN_WORKER_COUNT_FIELD, MAX_WORKER_COUNT_FIELD,
            CONFIGURATION_FIELD, TAGS_FIELD));

    private final String clientToken;

    private final String farmId;

    private final String displayName;

    private final String description;

    private final String roleArn;

    private final Integer minWorkerCount;

    private final Integer maxWorkerCount;

    private final FleetConfiguration configuration;

    private final Map<String, String> tags;

    private CreateFleetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.minWorkerCount = builder.minWorkerCount;
        this.maxWorkerCount = builder.maxWorkerCount;
        this.configuration = builder.configuration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique token which the server uses to recognize retries of the same request.
     * </p>
     * 
     * @return The unique token which the server uses to recognize retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The farm ID of the farm to connect to the fleet.
     * </p>
     * 
     * @return The farm ID of the farm to connect to the fleet.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The display name of the fleet.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The display name of the fleet.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the fleet.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The description of the fleet.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The IAM role ARN for the role that the fleet's workers will use.
     * </p>
     * 
     * @return The IAM role ARN for the role that the fleet's workers will use.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The minimum number of workers for the fleet.
     * </p>
     * 
     * @return The minimum number of workers for the fleet.
     */
    public final Integer minWorkerCount() {
        return minWorkerCount;
    }

    /**
     * <p>
     * The maximum number of workers for the fleet.
     * </p>
     * 
     * @return The maximum number of workers for the fleet.
     */
    public final Integer maxWorkerCount() {
        return maxWorkerCount;
    }

    /**
     * <p>
     * The configuration settings for the fleet. Customer managed fleets are self-managed. Service managed Amazon EC2
     * fleets are managed by Deadline Cloud.
     * </p>
     * 
     * @return The configuration settings for the fleet. Customer managed fleets are self-managed. Service managed
     *         Amazon EC2 fleets are managed by Deadline Cloud.
     */
    public final FleetConfiguration configuration() {
        return configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be
     * empty strings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can
     *         be empty strings.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(minWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(minWorkerCount(), other.minWorkerCount())
                && Objects.equals(maxWorkerCount(), other.maxWorkerCount())
                && Objects.equals(configuration(), other.configuration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFleetRequest").add("ClientToken", clientToken()).add("FarmId", farmId())
                .add("DisplayName", displayName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("RoleArn", roleArn())
                .add("MinWorkerCount", minWorkerCount()).add("MaxWorkerCount", maxWorkerCount())
                .add("Configuration", configuration()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "minWorkerCount":
            return Optional.ofNullable(clazz.cast(minWorkerCount()));
        case "maxWorkerCount":
            return Optional.ofNullable(clazz.cast(maxWorkerCount()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetRequest, T> g) {
        return obj -> g.apply((CreateFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFleetRequest> {
        /**
         * <p>
         * The unique token which the server uses to recognize retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        The unique token which the server uses to recognize retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The farm ID of the farm to connect to the fleet.
         * </p>
         * 
         * @param farmId
         *        The farm ID of the farm to connect to the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The display name of the fleet.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param displayName
         *        The display name of the fleet.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the fleet.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param description
         *        The description of the fleet.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The IAM role ARN for the role that the fleet's workers will use.
         * </p>
         * 
         * @param roleArn
         *        The IAM role ARN for the role that the fleet's workers will use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The minimum number of workers for the fleet.
         * </p>
         * 
         * @param minWorkerCount
         *        The minimum number of workers for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minWorkerCount(Integer minWorkerCount);

        /**
         * <p>
         * The maximum number of workers for the fleet.
         * </p>
         * 
         * @param maxWorkerCount
         *        The maximum number of workers for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWorkerCount(Integer maxWorkerCount);

        /**
         * <p>
         * The configuration settings for the fleet. Customer managed fleets are self-managed. Service managed Amazon
         * EC2 fleets are managed by Deadline Cloud.
         * </p>
         * 
         * @param configuration
         *        The configuration settings for the fleet. Customer managed fleets are self-managed. Service managed
         *        Amazon EC2 fleets are managed by Deadline Cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(FleetConfiguration configuration);

        /**
         * <p>
         * The configuration settings for the fleet. Customer managed fleets are self-managed. Service managed Amazon
         * EC2 fleets are managed by Deadline Cloud.
         * </p>
         * This is a convenience method that creates an instance of the {@link FleetConfiguration.Builder} avoiding the
         * need to create one manually via {@link FleetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FleetConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(FleetConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link FleetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(FleetConfiguration)
         */
        default Builder configuration(Consumer<FleetConfiguration.Builder> configuration) {
            return configuration(FleetConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be
         * empty strings.
         * </p>
         * 
         * @param tags
         *        Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values
         *        can be empty strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String farmId;

        private String displayName;

        private String description;

        private String roleArn;

        private Integer minWorkerCount;

        private Integer maxWorkerCount;

        private FleetConfiguration configuration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetRequest model) {
            super(model);
            clientToken(model.clientToken);
            farmId(model.farmId);
            displayName(model.displayName);
            description(model.description);
            roleArn(model.roleArn);
            minWorkerCount(model.minWorkerCount);
            maxWorkerCount(model.maxWorkerCount);
            configuration(model.configuration);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Integer getMinWorkerCount() {
            return minWorkerCount;
        }

        public final void setMinWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
        }

        @Override
        public final Builder minWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
            return this;
        }

        public final Integer getMaxWorkerCount() {
            return maxWorkerCount;
        }

        public final void setMaxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
        }

        @Override
        public final Builder maxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
            return this;
        }

        public final FleetConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(FleetConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(FleetConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFleetRequest build() {
            return new CreateFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
