/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQueueResponse extends DeadlineResponse implements
        ToCopyableBuilder<CreateQueueResponse.Builder, CreateQueueResponse> {
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(CreateQueueResponse::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ID_FIELD));

    private final String queueId;

    private CreateQueueResponse(BuilderImpl builder) {
        super(builder);
        this.queueId = builder.queueId;
    }

    /**
     * <p>
     * The queue ID.
     * </p>
     * 
     * @return The queue ID.
     */
    public final String queueId() {
        return queueId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueueResponse)) {
            return false;
        }
        CreateQueueResponse other = (CreateQueueResponse) obj;
        return Objects.equals(queueId(), other.queueId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateQueueResponse").add("QueueId", queueId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateQueueResponse, T> g) {
        return obj -> g.apply((CreateQueueResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateQueueResponse> {
        /**
         * <p>
         * The queue ID.
         * </p>
         * 
         * @param queueId
         *        The queue ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private String queueId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueueResponse model) {
            super(model);
            queueId(model.queueId);
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        @Override
        public CreateQueueResponse build() {
            return new CreateQueueResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
