/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBudgetResponse extends DeadlineResponse implements
        ToCopyableBuilder<GetBudgetResponse.Builder, GetBudgetResponse> {
    private static final SdkField<String> BUDGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("budgetId").getter(getter(GetBudgetResponse::budgetId)).setter(setter(Builder::budgetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budgetId").build()).build();

    private static final SdkField<UsageTrackingResource> USAGE_TRACKING_RESOURCE_FIELD = SdkField
            .<UsageTrackingResource> builder(MarshallingType.SDK_POJO).memberName("usageTrackingResource")
            .getter(getter(GetBudgetResponse::usageTrackingResource)).setter(setter(Builder::usageTrackingResource))
            .constructor(UsageTrackingResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTrackingResource").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetBudgetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetBudgetResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetBudgetResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Float> APPROXIMATE_DOLLAR_LIMIT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("approximateDollarLimit").getter(getter(GetBudgetResponse::approximateDollarLimit))
            .setter(setter(Builder::approximateDollarLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateDollarLimit").build())
            .build();

    private static final SdkField<ConsumedUsages> USAGES_FIELD = SdkField.<ConsumedUsages> builder(MarshallingType.SDK_POJO)
            .memberName("usages").getter(getter(GetBudgetResponse::usages)).setter(setter(Builder::usages))
            .constructor(ConsumedUsages::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usages").build()).build();

    private static final SdkField<List<ResponseBudgetAction>> ACTIONS_FIELD = SdkField
            .<List<ResponseBudgetAction>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(GetBudgetResponse::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResponseBudgetAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResponseBudgetAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<BudgetSchedule> SCHEDULE_FIELD = SdkField.<BudgetSchedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(GetBudgetResponse::schedule)).setter(setter(Builder::schedule))
            .constructor(BudgetSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetBudgetResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetBudgetResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(GetBudgetResponse::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetBudgetResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> QUEUE_STOPPED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("queueStoppedAt")
            .getter(getter(GetBudgetResponse::queueStoppedAt))
            .setter(setter(Builder::queueStoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueStoppedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGET_ID_FIELD,
            USAGE_TRACKING_RESOURCE_FIELD, STATUS_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, APPROXIMATE_DOLLAR_LIMIT_FIELD,
            USAGES_FIELD, ACTIONS_FIELD, SCHEDULE_FIELD, CREATED_BY_FIELD, CREATED_AT_FIELD, UPDATED_BY_FIELD, UPDATED_AT_FIELD,
            QUEUE_STOPPED_AT_FIELD));

    private final String budgetId;

    private final UsageTrackingResource usageTrackingResource;

    private final String status;

    private final String displayName;

    private final String description;

    private final Float approximateDollarLimit;

    private final ConsumedUsages usages;

    private final List<ResponseBudgetAction> actions;

    private final BudgetSchedule schedule;

    private final String createdBy;

    private final Instant createdAt;

    private final String updatedBy;

    private final Instant updatedAt;

    private final Instant queueStoppedAt;

    private GetBudgetResponse(BuilderImpl builder) {
        super(builder);
        this.budgetId = builder.budgetId;
        this.usageTrackingResource = builder.usageTrackingResource;
        this.status = builder.status;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.approximateDollarLimit = builder.approximateDollarLimit;
        this.usages = builder.usages;
        this.actions = builder.actions;
        this.schedule = builder.schedule;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.updatedBy = builder.updatedBy;
        this.updatedAt = builder.updatedAt;
        this.queueStoppedAt = builder.queueStoppedAt;
    }

    /**
     * <p>
     * The budget ID.
     * </p>
     * 
     * @return The budget ID.
     */
    public final String budgetId() {
        return budgetId;
    }

    /**
     * <p>
     * The resource that the budget is tracking usage for.
     * </p>
     * 
     * @return The resource that the budget is tracking usage for.
     */
    public final UsageTrackingResource usageTrackingResource() {
        return usageTrackingResource;
    }

    /**
     * <p>
     * The status of the budget.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>–Get a budget being evaluated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>–Get an inactive budget. This can include expired, canceled, or deleted statuses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BudgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the budget.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>–Get a budget being evaluated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>–Get an inactive budget. This can include expired, canceled, or deleted statuses.
     *         </p>
     *         </li>
     * @see BudgetStatus
     */
    public final BudgetStatus status() {
        return BudgetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the budget.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>–Get a budget being evaluated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>–Get an inactive budget. This can include expired, canceled, or deleted statuses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BudgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the budget.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>–Get a budget being evaluated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>–Get an inactive budget. This can include expired, canceled, or deleted statuses.
     *         </p>
     *         </li>
     * @see BudgetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The display name of the budget.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The display name of the budget.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the budget.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The description of the budget.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The consumed usage limit for the budget.
     * </p>
     * 
     * @return The consumed usage limit for the budget.
     */
    public final Float approximateDollarLimit() {
        return approximateDollarLimit;
    }

    /**
     * <p>
     * The usages of the budget.
     * </p>
     * 
     * @return The usages of the budget.
     */
    public final ConsumedUsages usages() {
        return usages;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The budget actions for the budget.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The budget actions for the budget.
     */
    public final List<ResponseBudgetAction> actions() {
        return actions;
    }

    /**
     * <p>
     * The budget schedule.
     * </p>
     * 
     * @return The budget schedule.
     */
    public final BudgetSchedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The user or system that created this resource.
     * </p>
     * 
     * @return The user or system that created this resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The date and time the queue stopped.
     * </p>
     * 
     * @return The date and time the queue stopped.
     */
    public final Instant queueStoppedAt() {
        return queueStoppedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(budgetId());
        hashCode = 31 * hashCode + Objects.hashCode(usageTrackingResource());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(approximateDollarLimit());
        hashCode = 31 * hashCode + Objects.hashCode(usages());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(queueStoppedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBudgetResponse)) {
            return false;
        }
        GetBudgetResponse other = (GetBudgetResponse) obj;
        return Objects.equals(budgetId(), other.budgetId())
                && Objects.equals(usageTrackingResource(), other.usageTrackingResource())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(description(), other.description())
                && Objects.equals(approximateDollarLimit(), other.approximateDollarLimit())
                && Objects.equals(usages(), other.usages()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedBy(), other.updatedBy()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(queueStoppedAt(), other.queueStoppedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBudgetResponse").add("BudgetId", budgetId())
                .add("UsageTrackingResource", usageTrackingResource()).add("Status", statusAsString())
                .add("DisplayName", displayName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ApproximateDollarLimit", approximateDollarLimit()).add("Usages", usages())
                .add("Actions", hasActions() ? actions() : null).add("Schedule", schedule()).add("CreatedBy", createdBy())
                .add("CreatedAt", createdAt()).add("UpdatedBy", updatedBy()).add("UpdatedAt", updatedAt())
                .add("QueueStoppedAt", queueStoppedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "budgetId":
            return Optional.ofNullable(clazz.cast(budgetId()));
        case "usageTrackingResource":
            return Optional.ofNullable(clazz.cast(usageTrackingResource()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "approximateDollarLimit":
            return Optional.ofNullable(clazz.cast(approximateDollarLimit()));
        case "usages":
            return Optional.ofNullable(clazz.cast(usages()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "queueStoppedAt":
            return Optional.ofNullable(clazz.cast(queueStoppedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBudgetResponse, T> g) {
        return obj -> g.apply((GetBudgetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBudgetResponse> {
        /**
         * <p>
         * The budget ID.
         * </p>
         * 
         * @param budgetId
         *        The budget ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetId(String budgetId);

        /**
         * <p>
         * The resource that the budget is tracking usage for.
         * </p>
         * 
         * @param usageTrackingResource
         *        The resource that the budget is tracking usage for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageTrackingResource(UsageTrackingResource usageTrackingResource);

        /**
         * <p>
         * The resource that the budget is tracking usage for.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsageTrackingResource.Builder} avoiding
         * the need to create one manually via {@link UsageTrackingResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsageTrackingResource.Builder#build()} is called immediately and
         * its result is passed to {@link #usageTrackingResource(UsageTrackingResource)}.
         * 
         * @param usageTrackingResource
         *        a consumer that will call methods on {@link UsageTrackingResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageTrackingResource(UsageTrackingResource)
         */
        default Builder usageTrackingResource(Consumer<UsageTrackingResource.Builder> usageTrackingResource) {
            return usageTrackingResource(UsageTrackingResource.builder().applyMutation(usageTrackingResource).build());
        }

        /**
         * <p>
         * The status of the budget.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>–Get a budget being evaluated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>–Get an inactive budget. This can include expired, canceled, or deleted statuses.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the budget.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>–Get a budget being evaluated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>–Get an inactive budget. This can include expired, canceled, or deleted statuses.
         *        </p>
         *        </li>
         * @see BudgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the budget.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>–Get a budget being evaluated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>–Get an inactive budget. This can include expired, canceled, or deleted statuses.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the budget.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>–Get a budget being evaluated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>–Get an inactive budget. This can include expired, canceled, or deleted statuses.
         *        </p>
         *        </li>
         * @see BudgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetStatus
         */
        Builder status(BudgetStatus status);

        /**
         * <p>
         * The display name of the budget.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param displayName
         *        The display name of the budget.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the budget.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param description
         *        The description of the budget.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The consumed usage limit for the budget.
         * </p>
         * 
         * @param approximateDollarLimit
         *        The consumed usage limit for the budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateDollarLimit(Float approximateDollarLimit);

        /**
         * <p>
         * The usages of the budget.
         * </p>
         * 
         * @param usages
         *        The usages of the budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usages(ConsumedUsages usages);

        /**
         * <p>
         * The usages of the budget.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumedUsages.Builder} avoiding the need
         * to create one manually via {@link ConsumedUsages#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsumedUsages.Builder#build()} is called immediately and its
         * result is passed to {@link #usages(ConsumedUsages)}.
         * 
         * @param usages
         *        a consumer that will call methods on {@link ConsumedUsages.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usages(ConsumedUsages)
         */
        default Builder usages(Consumer<ConsumedUsages.Builder> usages) {
            return usages(ConsumedUsages.builder().applyMutation(usages).build());
        }

        /**
         * <p>
         * The budget actions for the budget.
         * </p>
         * 
         * @param actions
         *        The budget actions for the budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<ResponseBudgetAction> actions);

        /**
         * <p>
         * The budget actions for the budget.
         * </p>
         * 
         * @param actions
         *        The budget actions for the budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(ResponseBudgetAction... actions);

        /**
         * <p>
         * The budget actions for the budget.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.ResponseBudgetAction.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.deadline.model.ResponseBudgetAction#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.ResponseBudgetAction.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<ResponseBudgetAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.ResponseBudgetAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<ResponseBudgetAction>)
         */
        Builder actions(Consumer<ResponseBudgetAction.Builder>... actions);

        /**
         * <p>
         * The budget schedule.
         * </p>
         * 
         * @param schedule
         *        The budget schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(BudgetSchedule schedule);

        /**
         * <p>
         * The budget schedule.
         * </p>
         * This is a convenience method that creates an instance of the {@link BudgetSchedule.Builder} avoiding the need
         * to create one manually via {@link BudgetSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BudgetSchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #schedule(BudgetSchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link BudgetSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(BudgetSchedule)
         */
        default Builder schedule(Consumer<BudgetSchedule.Builder> schedule) {
            return schedule(BudgetSchedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The user or system that created this resource.
         * </p>
         * 
         * @param createdBy
         *        The user or system that created this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The date and time the queue stopped.
         * </p>
         * 
         * @param queueStoppedAt
         *        The date and time the queue stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueStoppedAt(Instant queueStoppedAt);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private String budgetId;

        private UsageTrackingResource usageTrackingResource;

        private String status;

        private String displayName;

        private String description;

        private Float approximateDollarLimit;

        private ConsumedUsages usages;

        private List<ResponseBudgetAction> actions = DefaultSdkAutoConstructList.getInstance();

        private BudgetSchedule schedule;

        private String createdBy;

        private Instant createdAt;

        private String updatedBy;

        private Instant updatedAt;

        private Instant queueStoppedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBudgetResponse model) {
            super(model);
            budgetId(model.budgetId);
            usageTrackingResource(model.usageTrackingResource);
            status(model.status);
            displayName(model.displayName);
            description(model.description);
            approximateDollarLimit(model.approximateDollarLimit);
            usages(model.usages);
            actions(model.actions);
            schedule(model.schedule);
            createdBy(model.createdBy);
            createdAt(model.createdAt);
            updatedBy(model.updatedBy);
            updatedAt(model.updatedAt);
            queueStoppedAt(model.queueStoppedAt);
        }

        public final String getBudgetId() {
            return budgetId;
        }

        public final void setBudgetId(String budgetId) {
            this.budgetId = budgetId;
        }

        @Override
        public final Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public final UsageTrackingResource.Builder getUsageTrackingResource() {
            return usageTrackingResource != null ? usageTrackingResource.toBuilder() : null;
        }

        public final void setUsageTrackingResource(UsageTrackingResource.BuilderImpl usageTrackingResource) {
            this.usageTrackingResource = usageTrackingResource != null ? usageTrackingResource.build() : null;
        }

        @Override
        public final Builder usageTrackingResource(UsageTrackingResource usageTrackingResource) {
            this.usageTrackingResource = usageTrackingResource;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BudgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Float getApproximateDollarLimit() {
            return approximateDollarLimit;
        }

        public final void setApproximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
        }

        @Override
        public final Builder approximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
            return this;
        }

        public final ConsumedUsages.Builder getUsages() {
            return usages != null ? usages.toBuilder() : null;
        }

        public final void setUsages(ConsumedUsages.BuilderImpl usages) {
            this.usages = usages != null ? usages.build() : null;
        }

        @Override
        public final Builder usages(ConsumedUsages usages) {
            this.usages = usages;
            return this;
        }

        public final List<ResponseBudgetAction.Builder> getActions() {
            List<ResponseBudgetAction.Builder> result = ResponseBudgetActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<ResponseBudgetAction.BuilderImpl> actions) {
            this.actions = ResponseBudgetActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<ResponseBudgetAction> actions) {
            this.actions = ResponseBudgetActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ResponseBudgetAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<ResponseBudgetAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> ResponseBudgetAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final BudgetSchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(BudgetSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(BudgetSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getQueueStoppedAt() {
            return queueStoppedAt;
        }

        public final void setQueueStoppedAt(Instant queueStoppedAt) {
            this.queueStoppedAt = queueStoppedAt;
        }

        @Override
        public final Builder queueStoppedAt(Instant queueStoppedAt) {
            this.queueStoppedAt = queueStoppedAt;
            return this;
        }

        @Override
        public GetBudgetResponse build() {
            return new GetBudgetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
