/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The error for the job entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobEntityError implements SdkPojo, Serializable,
        ToCopyableBuilder<GetJobEntityError.Builder, GetJobEntityError> {
    private static final SdkField<JobDetailsError> JOB_DETAILS_FIELD = SdkField
            .<JobDetailsError> builder(MarshallingType.SDK_POJO).memberName("jobDetails")
            .getter(getter(GetJobEntityError::jobDetails)).setter(setter(Builder::jobDetails))
            .constructor(JobDetailsError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDetails").build()).build();

    private static final SdkField<JobAttachmentDetailsError> JOB_ATTACHMENT_DETAILS_FIELD = SdkField
            .<JobAttachmentDetailsError> builder(MarshallingType.SDK_POJO).memberName("jobAttachmentDetails")
            .getter(getter(GetJobEntityError::jobAttachmentDetails)).setter(setter(Builder::jobAttachmentDetails))
            .constructor(JobAttachmentDetailsError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobAttachmentDetails").build())
            .build();

    private static final SdkField<StepDetailsError> STEP_DETAILS_FIELD = SdkField
            .<StepDetailsError> builder(MarshallingType.SDK_POJO).memberName("stepDetails")
            .getter(getter(GetJobEntityError::stepDetails)).setter(setter(Builder::stepDetails))
            .constructor(StepDetailsError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepDetails").build()).build();

    private static final SdkField<EnvironmentDetailsError> ENVIRONMENT_DETAILS_FIELD = SdkField
            .<EnvironmentDetailsError> builder(MarshallingType.SDK_POJO).memberName("environmentDetails")
            .getter(getter(GetJobEntityError::environmentDetails)).setter(setter(Builder::environmentDetails))
            .constructor(EnvironmentDetailsError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DETAILS_FIELD,
            JOB_ATTACHMENT_DETAILS_FIELD, STEP_DETAILS_FIELD, ENVIRONMENT_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final JobDetailsError jobDetails;

    private final JobAttachmentDetailsError jobAttachmentDetails;

    private final StepDetailsError stepDetails;

    private final EnvironmentDetailsError environmentDetails;

    private final Type type;

    private GetJobEntityError(BuilderImpl builder) {
        this.jobDetails = builder.jobDetails;
        this.jobAttachmentDetails = builder.jobAttachmentDetails;
        this.stepDetails = builder.stepDetails;
        this.environmentDetails = builder.environmentDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * The job details for the failed job entity.
     * </p>
     * 
     * @return The job details for the failed job entity.
     */
    public final JobDetailsError jobDetails() {
        return jobDetails;
    }

    /**
     * <p>
     * The job attachment details for the failed job entity.
     * </p>
     * 
     * @return The job attachment details for the failed job entity.
     */
    public final JobAttachmentDetailsError jobAttachmentDetails() {
        return jobAttachmentDetails;
    }

    /**
     * <p>
     * The step details for the failed job entity.
     * </p>
     * 
     * @return The step details for the failed job entity.
     */
    public final StepDetailsError stepDetails() {
        return stepDetails;
    }

    /**
     * <p>
     * The environment details for the failed job entity.
     * </p>
     * 
     * @return The environment details for the failed job entity.
     */
    public final EnvironmentDetailsError environmentDetails() {
        return environmentDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobDetails());
        hashCode = 31 * hashCode + Objects.hashCode(jobAttachmentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(stepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(environmentDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobEntityError)) {
            return false;
        }
        GetJobEntityError other = (GetJobEntityError) obj;
        return Objects.equals(jobDetails(), other.jobDetails())
                && Objects.equals(jobAttachmentDetails(), other.jobAttachmentDetails())
                && Objects.equals(stepDetails(), other.stepDetails())
                && Objects.equals(environmentDetails(), other.environmentDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJobEntityError").add("JobDetails", jobDetails())
                .add("JobAttachmentDetails", jobAttachmentDetails()).add("StepDetails", stepDetails())
                .add("EnvironmentDetails", environmentDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDetails":
            return Optional.ofNullable(clazz.cast(jobDetails()));
        case "jobAttachmentDetails":
            return Optional.ofNullable(clazz.cast(jobAttachmentDetails()));
        case "stepDetails":
            return Optional.ofNullable(clazz.cast(stepDetails()));
        case "environmentDetails":
            return Optional.ofNullable(clazz.cast(environmentDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #jobDetails()} initialized to the given value.
     *
     * <p>
     * The job details for the failed job entity.
     * </p>
     * 
     * @param jobDetails
     *        The job details for the failed job entity.
     */
    public static GetJobEntityError fromJobDetails(JobDetailsError jobDetails) {
        return builder().jobDetails(jobDetails).build();
    }

    /**
     * Create an instance of this class with {@link #jobDetails()} initialized to the given value.
     *
     * <p>
     * The job details for the failed job entity.
     * </p>
     * 
     * @param jobDetails
     *        The job details for the failed job entity.
     */
    public static GetJobEntityError fromJobDetails(Consumer<JobDetailsError.Builder> jobDetails) {
        JobDetailsError.Builder builder = JobDetailsError.builder();
        jobDetails.accept(builder);
        return fromJobDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #jobAttachmentDetails()} initialized to the given value.
     *
     * <p>
     * The job attachment details for the failed job entity.
     * </p>
     * 
     * @param jobAttachmentDetails
     *        The job attachment details for the failed job entity.
     */
    public static GetJobEntityError fromJobAttachmentDetails(JobAttachmentDetailsError jobAttachmentDetails) {
        return builder().jobAttachmentDetails(jobAttachmentDetails).build();
    }

    /**
     * Create an instance of this class with {@link #jobAttachmentDetails()} initialized to the given value.
     *
     * <p>
     * The job attachment details for the failed job entity.
     * </p>
     * 
     * @param jobAttachmentDetails
     *        The job attachment details for the failed job entity.
     */
    public static GetJobEntityError fromJobAttachmentDetails(Consumer<JobAttachmentDetailsError.Builder> jobAttachmentDetails) {
        JobAttachmentDetailsError.Builder builder = JobAttachmentDetailsError.builder();
        jobAttachmentDetails.accept(builder);
        return fromJobAttachmentDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stepDetails()} initialized to the given value.
     *
     * <p>
     * The step details for the failed job entity.
     * </p>
     * 
     * @param stepDetails
     *        The step details for the failed job entity.
     */
    public static GetJobEntityError fromStepDetails(StepDetailsError stepDetails) {
        return builder().stepDetails(stepDetails).build();
    }

    /**
     * Create an instance of this class with {@link #stepDetails()} initialized to the given value.
     *
     * <p>
     * The step details for the failed job entity.
     * </p>
     * 
     * @param stepDetails
     *        The step details for the failed job entity.
     */
    public static GetJobEntityError fromStepDetails(Consumer<StepDetailsError.Builder> stepDetails) {
        StepDetailsError.Builder builder = StepDetailsError.builder();
        stepDetails.accept(builder);
        return fromStepDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #environmentDetails()} initialized to the given value.
     *
     * <p>
     * The environment details for the failed job entity.
     * </p>
     * 
     * @param environmentDetails
     *        The environment details for the failed job entity.
     */
    public static GetJobEntityError fromEnvironmentDetails(EnvironmentDetailsError environmentDetails) {
        return builder().environmentDetails(environmentDetails).build();
    }

    /**
     * Create an instance of this class with {@link #environmentDetails()} initialized to the given value.
     *
     * <p>
     * The environment details for the failed job entity.
     * </p>
     * 
     * @param environmentDetails
     *        The environment details for the failed job entity.
     */
    public static GetJobEntityError fromEnvironmentDetails(Consumer<EnvironmentDetailsError.Builder> environmentDetails) {
        EnvironmentDetailsError.Builder builder = EnvironmentDetailsError.builder();
        environmentDetails.accept(builder);
        return fromEnvironmentDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobEntityError, T> g) {
        return obj -> g.apply((GetJobEntityError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetJobEntityError> {
        /**
         * <p>
         * The job details for the failed job entity.
         * </p>
         * 
         * @param jobDetails
         *        The job details for the failed job entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDetails(JobDetailsError jobDetails);

        /**
         * <p>
         * The job details for the failed job entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobDetailsError.Builder} avoiding the
         * need to create one manually via {@link JobDetailsError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobDetailsError.Builder#build()} is called immediately and its
         * result is passed to {@link #jobDetails(JobDetailsError)}.
         * 
         * @param jobDetails
         *        a consumer that will call methods on {@link JobDetailsError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobDetails(JobDetailsError)
         */
        default Builder jobDetails(Consumer<JobDetailsError.Builder> jobDetails) {
            return jobDetails(JobDetailsError.builder().applyMutation(jobDetails).build());
        }

        /**
         * <p>
         * The job attachment details for the failed job entity.
         * </p>
         * 
         * @param jobAttachmentDetails
         *        The job attachment details for the failed job entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobAttachmentDetails(JobAttachmentDetailsError jobAttachmentDetails);

        /**
         * <p>
         * The job attachment details for the failed job entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobAttachmentDetailsError.Builder}
         * avoiding the need to create one manually via {@link JobAttachmentDetailsError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobAttachmentDetailsError.Builder#build()} is called immediately
         * and its result is passed to {@link #jobAttachmentDetails(JobAttachmentDetailsError)}.
         * 
         * @param jobAttachmentDetails
         *        a consumer that will call methods on {@link JobAttachmentDetailsError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobAttachmentDetails(JobAttachmentDetailsError)
         */
        default Builder jobAttachmentDetails(Consumer<JobAttachmentDetailsError.Builder> jobAttachmentDetails) {
            return jobAttachmentDetails(JobAttachmentDetailsError.builder().applyMutation(jobAttachmentDetails).build());
        }

        /**
         * <p>
         * The step details for the failed job entity.
         * </p>
         * 
         * @param stepDetails
         *        The step details for the failed job entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepDetails(StepDetailsError stepDetails);

        /**
         * <p>
         * The step details for the failed job entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link StepDetailsError.Builder} avoiding the
         * need to create one manually via {@link StepDetailsError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StepDetailsError.Builder#build()} is called immediately and its
         * result is passed to {@link #stepDetails(StepDetailsError)}.
         * 
         * @param stepDetails
         *        a consumer that will call methods on {@link StepDetailsError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepDetails(StepDetailsError)
         */
        default Builder stepDetails(Consumer<StepDetailsError.Builder> stepDetails) {
            return stepDetails(StepDetailsError.builder().applyMutation(stepDetails).build());
        }

        /**
         * <p>
         * The environment details for the failed job entity.
         * </p>
         * 
         * @param environmentDetails
         *        The environment details for the failed job entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentDetails(EnvironmentDetailsError environmentDetails);

        /**
         * <p>
         * The environment details for the failed job entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentDetailsError.Builder} avoiding
         * the need to create one manually via {@link EnvironmentDetailsError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentDetailsError.Builder#build()} is called immediately
         * and its result is passed to {@link #environmentDetails(EnvironmentDetailsError)}.
         * 
         * @param environmentDetails
         *        a consumer that will call methods on {@link EnvironmentDetailsError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentDetails(EnvironmentDetailsError)
         */
        default Builder environmentDetails(Consumer<EnvironmentDetailsError.Builder> environmentDetails) {
            return environmentDetails(EnvironmentDetailsError.builder().applyMutation(environmentDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JobDetailsError jobDetails;

        private JobAttachmentDetailsError jobAttachmentDetails;

        private StepDetailsError stepDetails;

        private EnvironmentDetailsError environmentDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobEntityError model) {
            jobDetails(model.jobDetails);
            jobAttachmentDetails(model.jobAttachmentDetails);
            stepDetails(model.stepDetails);
            environmentDetails(model.environmentDetails);
        }

        public final JobDetailsError.Builder getJobDetails() {
            return jobDetails != null ? jobDetails.toBuilder() : null;
        }

        public final void setJobDetails(JobDetailsError.BuilderImpl jobDetails) {
            Object oldValue = this.jobDetails;
            this.jobDetails = jobDetails != null ? jobDetails.build() : null;
            handleUnionValueChange(Type.JOB_DETAILS, oldValue, this.jobDetails);
        }

        @Override
        public final Builder jobDetails(JobDetailsError jobDetails) {
            Object oldValue = this.jobDetails;
            this.jobDetails = jobDetails;
            handleUnionValueChange(Type.JOB_DETAILS, oldValue, this.jobDetails);
            return this;
        }

        public final JobAttachmentDetailsError.Builder getJobAttachmentDetails() {
            return jobAttachmentDetails != null ? jobAttachmentDetails.toBuilder() : null;
        }

        public final void setJobAttachmentDetails(JobAttachmentDetailsError.BuilderImpl jobAttachmentDetails) {
            Object oldValue = this.jobAttachmentDetails;
            this.jobAttachmentDetails = jobAttachmentDetails != null ? jobAttachmentDetails.build() : null;
            handleUnionValueChange(Type.JOB_ATTACHMENT_DETAILS, oldValue, this.jobAttachmentDetails);
        }

        @Override
        public final Builder jobAttachmentDetails(JobAttachmentDetailsError jobAttachmentDetails) {
            Object oldValue = this.jobAttachmentDetails;
            this.jobAttachmentDetails = jobAttachmentDetails;
            handleUnionValueChange(Type.JOB_ATTACHMENT_DETAILS, oldValue, this.jobAttachmentDetails);
            return this;
        }

        public final StepDetailsError.Builder getStepDetails() {
            return stepDetails != null ? stepDetails.toBuilder() : null;
        }

        public final void setStepDetails(StepDetailsError.BuilderImpl stepDetails) {
            Object oldValue = this.stepDetails;
            this.stepDetails = stepDetails != null ? stepDetails.build() : null;
            handleUnionValueChange(Type.STEP_DETAILS, oldValue, this.stepDetails);
        }

        @Override
        public final Builder stepDetails(StepDetailsError stepDetails) {
            Object oldValue = this.stepDetails;
            this.stepDetails = stepDetails;
            handleUnionValueChange(Type.STEP_DETAILS, oldValue, this.stepDetails);
            return this;
        }

        public final EnvironmentDetailsError.Builder getEnvironmentDetails() {
            return environmentDetails != null ? environmentDetails.toBuilder() : null;
        }

        public final void setEnvironmentDetails(EnvironmentDetailsError.BuilderImpl environmentDetails) {
            Object oldValue = this.environmentDetails;
            this.environmentDetails = environmentDetails != null ? environmentDetails.build() : null;
            handleUnionValueChange(Type.ENVIRONMENT_DETAILS, oldValue, this.environmentDetails);
        }

        @Override
        public final Builder environmentDetails(EnvironmentDetailsError environmentDetails) {
            Object oldValue = this.environmentDetails;
            this.environmentDetails = environmentDetails;
            handleUnionValueChange(Type.ENVIRONMENT_DETAILS, oldValue, this.environmentDetails);
            return this;
        }

        @Override
        public GetJobEntityError build() {
            return new GetJobEntityError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see GetJobEntityError#type()
     */
    public enum Type {
        JOB_DETAILS,

        JOB_ATTACHMENT_DETAILS,

        STEP_DETAILS,

        ENVIRONMENT_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
