/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTaskResponse extends DeadlineResponse implements
        ToCopyableBuilder<GetTaskResponse.Builder, GetTaskResponse> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(GetTaskResponse::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetTaskResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetTaskResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runStatus").getter(getter(GetTaskResponse::runStatusAsString)).setter(setter(Builder::runStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runStatus").build()).build();

    private static final SdkField<String> TARGET_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetRunStatus").getter(getter(GetTaskResponse::targetRunStatusAsString))
            .setter(setter(Builder::targetRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRunStatus").build()).build();

    private static final SdkField<Integer> FAILURE_RETRY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failureRetryCount").getter(getter(GetTaskResponse::failureRetryCount))
            .setter(setter(Builder::failureRetryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureRetryCount").build()).build();

    private static final SdkField<Map<String, TaskParameterValue>> PARAMETERS_FIELD = SdkField
            .<Map<String, TaskParameterValue>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(GetTaskResponse::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TaskParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(GetTaskResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(GetTaskResponse::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetTaskResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(GetTaskResponse::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<String> LATEST_SESSION_ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latestSessionActionId").getter(getter(GetTaskResponse::latestSessionActionId))
            .setter(setter(Builder::latestSessionActionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestSessionActionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            CREATED_AT_FIELD, CREATED_BY_FIELD, RUN_STATUS_FIELD, TARGET_RUN_STATUS_FIELD, FAILURE_RETRY_COUNT_FIELD,
            PARAMETERS_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD,
            LATEST_SESSION_ACTION_ID_FIELD));

    private final String taskId;

    private final Instant createdAt;

    private final String createdBy;

    private final String runStatus;

    private final String targetRunStatus;

    private final Integer failureRetryCount;

    private final Map<String, TaskParameterValue> parameters;

    private final Instant startedAt;

    private final Instant endedAt;

    private final Instant updatedAt;

    private final String updatedBy;

    private final String latestSessionActionId;

    private GetTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.runStatus = builder.runStatus;
        this.targetRunStatus = builder.targetRunStatus;
        this.failureRetryCount = builder.failureRetryCount;
        this.parameters = builder.parameters;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.latestSessionActionId = builder.latestSessionActionId;
    }

    /**
     * <p>
     * The task ID.
     * </p>
     * 
     * @return The task ID.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or system that created this resource.
     * </p>
     * 
     * @return The user or system that created this resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The run status for the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runStatus} will
     * return {@link TaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runStatusAsString}.
     * </p>
     * 
     * @return The run status for the task.
     * @see TaskRunStatus
     */
    public final TaskRunStatus runStatus() {
        return TaskRunStatus.fromValue(runStatus);
    }

    /**
     * <p>
     * The run status for the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runStatus} will
     * return {@link TaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runStatusAsString}.
     * </p>
     * 
     * @return The run status for the task.
     * @see TaskRunStatus
     */
    public final String runStatusAsString() {
        return runStatus;
    }

    /**
     * <p>
     * The run status with which to start the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetRunStatus}
     * will return {@link TaskTargetRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetRunStatusAsString}.
     * </p>
     * 
     * @return The run status with which to start the task.
     * @see TaskTargetRunStatus
     */
    public final TaskTargetRunStatus targetRunStatus() {
        return TaskTargetRunStatus.fromValue(targetRunStatus);
    }

    /**
     * <p>
     * The run status with which to start the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetRunStatus}
     * will return {@link TaskTargetRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetRunStatusAsString}.
     * </p>
     * 
     * @return The run status with which to start the task.
     * @see TaskTargetRunStatus
     */
    public final String targetRunStatusAsString() {
        return targetRunStatus;
    }

    /**
     * <p>
     * The number of times that the task failed and was retried.
     * </p>
     * 
     * @return The number of times that the task failed and was retried.
     */
    public final Integer failureRetryCount() {
        return failureRetryCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters for the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters for the task.
     */
    public final Map<String, TaskParameterValue> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The date and time the resource started running.
     * </p>
     * 
     * @return The date and time the resource started running.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The date and time the resource ended running.
     * </p>
     * 
     * @return The date and time the resource ended running.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The latest session ID for the task.
     * </p>
     * 
     * @return The latest session ID for the task.
     */
    public final String latestSessionActionId() {
        return latestSessionActionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(runStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureRetryCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(latestSessionActionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTaskResponse)) {
            return false;
        }
        GetTaskResponse other = (GetTaskResponse) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(runStatusAsString(), other.runStatusAsString())
                && Objects.equals(targetRunStatusAsString(), other.targetRunStatusAsString())
                && Objects.equals(failureRetryCount(), other.failureRetryCount()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(endedAt(), other.endedAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(updatedBy(), other.updatedBy())
                && Objects.equals(latestSessionActionId(), other.latestSessionActionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTaskResponse").add("TaskId", taskId()).add("CreatedAt", createdAt())
                .add("CreatedBy", createdBy()).add("RunStatus", runStatusAsString())
                .add("TargetRunStatus", targetRunStatusAsString()).add("FailureRetryCount", failureRetryCount())
                .add("Parameters", parameters() == null ? null : "*** Sensitive Data Redacted ***").add("StartedAt", startedAt())
                .add("EndedAt", endedAt()).add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy())
                .add("LatestSessionActionId", latestSessionActionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "runStatus":
            return Optional.ofNullable(clazz.cast(runStatusAsString()));
        case "targetRunStatus":
            return Optional.ofNullable(clazz.cast(targetRunStatusAsString()));
        case "failureRetryCount":
            return Optional.ofNullable(clazz.cast(failureRetryCount()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "latestSessionActionId":
            return Optional.ofNullable(clazz.cast(latestSessionActionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTaskResponse, T> g) {
        return obj -> g.apply((GetTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTaskResponse> {
        /**
         * <p>
         * The task ID.
         * </p>
         * 
         * @param taskId
         *        The task ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or system that created this resource.
         * </p>
         * 
         * @param createdBy
         *        The user or system that created this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The run status for the task.
         * </p>
         * 
         * @param runStatus
         *        The run status for the task.
         * @see TaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskRunStatus
         */
        Builder runStatus(String runStatus);

        /**
         * <p>
         * The run status for the task.
         * </p>
         * 
         * @param runStatus
         *        The run status for the task.
         * @see TaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskRunStatus
         */
        Builder runStatus(TaskRunStatus runStatus);

        /**
         * <p>
         * The run status with which to start the task.
         * </p>
         * 
         * @param targetRunStatus
         *        The run status with which to start the task.
         * @see TaskTargetRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskTargetRunStatus
         */
        Builder targetRunStatus(String targetRunStatus);

        /**
         * <p>
         * The run status with which to start the task.
         * </p>
         * 
         * @param targetRunStatus
         *        The run status with which to start the task.
         * @see TaskTargetRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskTargetRunStatus
         */
        Builder targetRunStatus(TaskTargetRunStatus targetRunStatus);

        /**
         * <p>
         * The number of times that the task failed and was retried.
         * </p>
         * 
         * @param failureRetryCount
         *        The number of times that the task failed and was retried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureRetryCount(Integer failureRetryCount);

        /**
         * <p>
         * The parameters for the task.
         * </p>
         * 
         * @param parameters
         *        The parameters for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, TaskParameterValue> parameters);

        /**
         * <p>
         * The date and time the resource started running.
         * </p>
         * 
         * @param startedAt
         *        The date and time the resource started running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The date and time the resource ended running.
         * </p>
         * 
         * @param endedAt
         *        The date and time the resource ended running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The latest session ID for the task.
         * </p>
         * 
         * @param latestSessionActionId
         *        The latest session ID for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestSessionActionId(String latestSessionActionId);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private String taskId;

        private Instant createdAt;

        private String createdBy;

        private String runStatus;

        private String targetRunStatus;

        private Integer failureRetryCount;

        private Map<String, TaskParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Instant startedAt;

        private Instant endedAt;

        private Instant updatedAt;

        private String updatedBy;

        private String latestSessionActionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTaskResponse model) {
            super(model);
            taskId(model.taskId);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            runStatus(model.runStatus);
            targetRunStatus(model.targetRunStatus);
            failureRetryCount(model.failureRetryCount);
            parameters(model.parameters);
            startedAt(model.startedAt);
            endedAt(model.endedAt);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            latestSessionActionId(model.latestSessionActionId);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getRunStatus() {
            return runStatus;
        }

        public final void setRunStatus(String runStatus) {
            this.runStatus = runStatus;
        }

        @Override
        public final Builder runStatus(String runStatus) {
            this.runStatus = runStatus;
            return this;
        }

        @Override
        public final Builder runStatus(TaskRunStatus runStatus) {
            this.runStatus(runStatus == null ? null : runStatus.toString());
            return this;
        }

        public final String getTargetRunStatus() {
            return targetRunStatus;
        }

        public final void setTargetRunStatus(String targetRunStatus) {
            this.targetRunStatus = targetRunStatus;
        }

        @Override
        public final Builder targetRunStatus(String targetRunStatus) {
            this.targetRunStatus = targetRunStatus;
            return this;
        }

        @Override
        public final Builder targetRunStatus(TaskTargetRunStatus targetRunStatus) {
            this.targetRunStatus(targetRunStatus == null ? null : targetRunStatus.toString());
            return this;
        }

        public final Integer getFailureRetryCount() {
            return failureRetryCount;
        }

        public final void setFailureRetryCount(Integer failureRetryCount) {
            this.failureRetryCount = failureRetryCount;
        }

        @Override
        public final Builder failureRetryCount(Integer failureRetryCount) {
            this.failureRetryCount = failureRetryCount;
            return this;
        }

        public final Map<String, TaskParameterValue.Builder> getParameters() {
            Map<String, TaskParameterValue.Builder> result = TaskParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, TaskParameterValue.BuilderImpl> parameters) {
            this.parameters = TaskParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, TaskParameterValue> parameters) {
            this.parameters = TaskParametersCopier.copy(parameters);
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final String getLatestSessionActionId() {
            return latestSessionActionId;
        }

        public final void setLatestSessionActionId(String latestSessionActionId) {
            this.latestSessionActionId = latestSessionActionId;
        }

        @Override
        public final Builder latestSessionActionId(String latestSessionActionId) {
            this.latestSessionActionId = latestSessionActionId;
            return this;
        }

        @Override
        public GetTaskResponse build() {
            return new GetTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
