/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of job parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobParameter implements SdkPojo, Serializable, ToCopyableBuilder<JobParameter.Builder, JobParameter> {
    private static final SdkField<String> INT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("int")
            .getter(getter(JobParameter::intValue)).setter(setter(Builder::intValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("int").build()).build();

    private static final SdkField<String> FLOAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("float")
            .getter(getter(JobParameter::floatValue)).setter(setter(Builder::floatValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("float").build()).build();

    private static final SdkField<String> STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("string")
            .getter(getter(JobParameter::string)).setter(setter(Builder::string))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("string").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("path")
            .getter(getter(JobParameter::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INT_FIELD, FLOAT_FIELD,
            STRING_FIELD, PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String intValue;

    private final String floatValue;

    private final String string;

    private final String path;

    private final Type type;

    private JobParameter(BuilderImpl builder) {
        this.intValue = builder.intValue;
        this.floatValue = builder.floatValue;
        this.string = builder.string;
        this.path = builder.path;
        this.type = builder.type;
    }

    /**
     * <p>
     * A signed integer represented as a string.
     * </p>
     * 
     * @return A signed integer represented as a string.
     */
    public final String intValue() {
        return intValue;
    }

    /**
     * <p>
     * A double precision IEEE-754 floating point number represented as a string.
     * </p>
     * 
     * @return A double precision IEEE-754 floating point number represented as a string.
     */
    public final String floatValue() {
        return floatValue;
    }

    /**
     * <p>
     * A UTF-8 string.
     * </p>
     * 
     * @return A UTF-8 string.
     */
    public final String string() {
        return string;
    }

    /**
     * <p>
     * A file system path represented as a string.
     * </p>
     * 
     * @return A file system path represented as a string.
     */
    public final String path() {
        return path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intValue());
        hashCode = 31 * hashCode + Objects.hashCode(floatValue());
        hashCode = 31 * hashCode + Objects.hashCode(string());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobParameter)) {
            return false;
        }
        JobParameter other = (JobParameter) obj;
        return Objects.equals(intValue(), other.intValue()) && Objects.equals(floatValue(), other.floatValue())
                && Objects.equals(string(), other.string()) && Objects.equals(path(), other.path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobParameter").add("Int", intValue()).add("Float", floatValue()).add("String", string())
                .add("Path", path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "int":
            return Optional.ofNullable(clazz.cast(intValue()));
        case "float":
            return Optional.ofNullable(clazz.cast(floatValue()));
        case "string":
            return Optional.ofNullable(clazz.cast(string()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #intValue()} initialized to the given value.
     *
     * <p>
     * A signed integer represented as a string.
     * </p>
     * 
     * @param intValue
     *        A signed integer represented as a string.
     */
    public static JobParameter fromIntValue(String intValue) {
        return builder().intValue(intValue).build();
    }

    /**
     * Create an instance of this class with {@link #floatValue()} initialized to the given value.
     *
     * <p>
     * A double precision IEEE-754 floating point number represented as a string.
     * </p>
     * 
     * @param floatValue
     *        A double precision IEEE-754 floating point number represented as a string.
     */
    public static JobParameter fromFloatValue(String floatValue) {
        return builder().floatValue(floatValue).build();
    }

    /**
     * Create an instance of this class with {@link #string()} initialized to the given value.
     *
     * <p>
     * A UTF-8 string.
     * </p>
     * 
     * @param string
     *        A UTF-8 string.
     */
    public static JobParameter fromString(String string) {
        return builder().string(string).build();
    }

    /**
     * Create an instance of this class with {@link #path()} initialized to the given value.
     *
     * <p>
     * A file system path represented as a string.
     * </p>
     * 
     * @param path
     *        A file system path represented as a string.
     */
    public static JobParameter fromPath(String path) {
        return builder().path(path).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobParameter, T> g) {
        return obj -> g.apply((JobParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobParameter> {
        /**
         * <p>
         * A signed integer represented as a string.
         * </p>
         * 
         * @param intValue
         *        A signed integer represented as a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intValue(String intValue);

        /**
         * <p>
         * A double precision IEEE-754 floating point number represented as a string.
         * </p>
         * 
         * @param floatValue
         *        A double precision IEEE-754 floating point number represented as a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder floatValue(String floatValue);

        /**
         * <p>
         * A UTF-8 string.
         * </p>
         * 
         * @param string
         *        A UTF-8 string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder string(String string);

        /**
         * <p>
         * A file system path represented as a string.
         * </p>
         * 
         * @param path
         *        A file system path represented as a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);
    }

    static final class BuilderImpl implements Builder {
        private String intValue;

        private String floatValue;

        private String string;

        private String path;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(JobParameter model) {
            intValue(model.intValue);
            floatValue(model.floatValue);
            string(model.string);
            path(model.path);
        }

        public final String getIntValue() {
            return intValue;
        }

        public final void setIntValue(String intValue) {
            Object oldValue = this.intValue;
            this.intValue = intValue;
            handleUnionValueChange(Type.INT, oldValue, this.intValue);
        }

        @Override
        public final Builder intValue(String intValue) {
            Object oldValue = this.intValue;
            this.intValue = intValue;
            handleUnionValueChange(Type.INT, oldValue, this.intValue);
            return this;
        }

        public final String getFloatValue() {
            return floatValue;
        }

        public final void setFloatValue(String floatValue) {
            Object oldValue = this.floatValue;
            this.floatValue = floatValue;
            handleUnionValueChange(Type.FLOAT, oldValue, this.floatValue);
        }

        @Override
        public final Builder floatValue(String floatValue) {
            Object oldValue = this.floatValue;
            this.floatValue = floatValue;
            handleUnionValueChange(Type.FLOAT, oldValue, this.floatValue);
            return this;
        }

        public final String getString() {
            return string;
        }

        public final void setString(String string) {
            Object oldValue = this.string;
            this.string = string;
            handleUnionValueChange(Type.STRING, oldValue, this.string);
        }

        @Override
        public final Builder string(String string) {
            Object oldValue = this.string;
            this.string = string;
            handleUnionValueChange(Type.STRING, oldValue, this.string);
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            Object oldValue = this.path;
            this.path = path;
            handleUnionValueChange(Type.PATH, oldValue, this.path);
        }

        @Override
        public final Builder path(String path) {
            Object oldValue = this.path;
            this.path = path;
            handleUnionValueChange(Type.PATH, oldValue, this.path);
            return this;
        }

        @Override
        public JobParameter build() {
            return new JobParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see JobParameter#type()
     */
    public enum Type {
        INT,

        FLOAT,

        STRING,

        PATH,

        UNKNOWN_TO_SDK_VERSION
    }
}
