/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Log configuration details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LogConfiguration.Builder, LogConfiguration> {
    private static final SdkField<String> LOG_DRIVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logDriver").getter(getter(LogConfiguration::logDriver)).setter(setter(Builder::logDriver))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDriver").build()).build();

    private static final SdkField<Map<String, String>> OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("options")
            .getter(getter(LogConfiguration::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(LogConfiguration::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(LogConfiguration::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_DRIVER_FIELD,
            OPTIONS_FIELD, PARAMETERS_FIELD, ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logDriver;

    private final Map<String, String> options;

    private final Map<String, String> parameters;

    private final String error;

    private LogConfiguration(BuilderImpl builder) {
        this.logDriver = builder.logDriver;
        this.options = builder.options;
        this.parameters = builder.parameters;
        this.error = builder.error;
    }

    /**
     * <p>
     * The log drivers for worker related logs.
     * </p>
     * 
     * @return The log drivers for worker related logs.
     */
    public final String logDriver() {
        return logDriver;
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The options for a log driver.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return The options for a log driver.
     */
    public final Map<String, String> options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters for the log configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters for the log configuration.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The log configuration error details.
     * </p>
     * 
     * @return The log configuration error details.
     */
    public final String error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logDriver());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration other = (LogConfiguration) obj;
        return Objects.equals(logDriver(), other.logDriver()) && hasOptions() == other.hasOptions()
                && Objects.equals(options(), other.options()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogConfiguration").add("LogDriver", logDriver()).add("Options", hasOptions() ? options() : null)
                .add("Parameters", hasParameters() ? parameters() : null).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logDriver":
            return Optional.ofNullable(clazz.cast(logDriver()));
        case "options":
            return Optional.ofNullable(clazz.cast(options()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogConfiguration, T> g) {
        return obj -> g.apply((LogConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogConfiguration> {
        /**
         * <p>
         * The log drivers for worker related logs.
         * </p>
         * 
         * @param logDriver
         *        The log drivers for worker related logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDriver(String logDriver);

        /**
         * <p>
         * The options for a log driver.
         * </p>
         * 
         * @param options
         *        The options for a log driver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Map<String, String> options);

        /**
         * <p>
         * The parameters for the log configuration.
         * </p>
         * 
         * @param parameters
         *        The parameters for the log configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The log configuration error details.
         * </p>
         * 
         * @param error
         *        The log configuration error details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);
    }

    static final class BuilderImpl implements Builder {
        private String logDriver;

        private Map<String, String> options = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfiguration model) {
            logDriver(model.logDriver);
            options(model.options);
            parameters(model.parameters);
            error(model.error);
        }

        public final String getLogDriver() {
            return logDriver;
        }

        public final void setLogDriver(String logDriver) {
            this.logDriver = logDriver;
        }

        @Override
        public final Builder logDriver(String logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        public final Map<String, String> getOptions() {
            if (options instanceof SdkAutoConstructMap) {
                return null;
            }
            return options;
        }

        public final void setOptions(Map<String, String> options) {
            this.options = LogOptionsCopier.copy(options);
        }

        @Override
        public final Builder options(Map<String, String> options) {
            this.options = LogOptionsCopier.copy(options);
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = LogParametersCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = LogParametersCopier.copy(parameters);
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public LogConfiguration build() {
            return new LogConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
