/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a queue summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueueSummary implements SdkPojo, Serializable, ToCopyableBuilder<QueueSummary.Builder, QueueSummary> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(QueueSummary::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farmId").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(QueueSummary::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(QueueSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(QueueSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DEFAULT_BUDGET_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultBudgetAction").getter(getter(QueueSummary::defaultBudgetActionAsString))
            .setter(setter(Builder::defaultBudgetAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBudgetAction").build())
            .build();

    private static final SdkField<String> BLOCKED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockedReason").getter(getter(QueueSummary::blockedReasonAsString))
            .setter(setter(Builder::blockedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedReason").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(QueueSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(QueueSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(QueueSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(QueueSummary::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, QUEUE_ID_FIELD,
            DISPLAY_NAME_FIELD, STATUS_FIELD, DEFAULT_BUDGET_ACTION_FIELD, BLOCKED_REASON_FIELD, CREATED_AT_FIELD,
            CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String farmId;

    private final String queueId;

    private final String displayName;

    private final String status;

    private final String defaultBudgetAction;

    private final String blockedReason;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private QueueSummary(BuilderImpl builder) {
        this.farmId = builder.farmId;
        this.queueId = builder.queueId;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.defaultBudgetAction = builder.defaultBudgetAction;
        this.blockedReason = builder.blockedReason;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The farm ID.
     * </p>
     * 
     * @return The farm ID.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The queue ID.
     * </p>
     * 
     * @return The queue ID.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The display name of the queue summary to update.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The display name of the queue summary to update.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * That status of the queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return That status of the queue.
     * @see QueueStatus
     */
    public final QueueStatus status() {
        return QueueStatus.fromValue(status);
    }

    /**
     * <p>
     * That status of the queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return That status of the queue.
     * @see QueueStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The default action taken on a queue summary if a budget wasn't configured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultBudgetAction} will return {@link DefaultQueueBudgetAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultBudgetActionAsString}.
     * </p>
     * 
     * @return The default action taken on a queue summary if a budget wasn't configured.
     * @see DefaultQueueBudgetAction
     */
    public final DefaultQueueBudgetAction defaultBudgetAction() {
        return DefaultQueueBudgetAction.fromValue(defaultBudgetAction);
    }

    /**
     * <p>
     * The default action taken on a queue summary if a budget wasn't configured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultBudgetAction} will return {@link DefaultQueueBudgetAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultBudgetActionAsString}.
     * </p>
     * 
     * @return The default action taken on a queue summary if a budget wasn't configured.
     * @see DefaultQueueBudgetAction
     */
    public final String defaultBudgetActionAsString() {
        return defaultBudgetAction;
    }

    /**
     * <p>
     * The reason the queue is blocked, if applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blockedReason}
     * will return {@link QueueBlockedReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blockedReasonAsString}.
     * </p>
     * 
     * @return The reason the queue is blocked, if applicable.
     * @see QueueBlockedReason
     */
    public final QueueBlockedReason blockedReason() {
        return QueueBlockedReason.fromValue(blockedReason);
    }

    /**
     * <p>
     * The reason the queue is blocked, if applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blockedReason}
     * will return {@link QueueBlockedReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blockedReasonAsString}.
     * </p>
     * 
     * @return The reason the queue is blocked, if applicable.
     * @see QueueBlockedReason
     */
    public final String blockedReasonAsString() {
        return blockedReason;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or system that created this resource.
     * </p>
     * 
     * @return The user or system that created this resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultBudgetActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockedReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueSummary)) {
            return false;
        }
        QueueSummary other = (QueueSummary) obj;
        return Objects.equals(farmId(), other.farmId()) && Objects.equals(queueId(), other.queueId())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(defaultBudgetActionAsString(), other.defaultBudgetActionAsString())
                && Objects.equals(blockedReasonAsString(), other.blockedReasonAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueueSummary").add("FarmId", farmId()).add("QueueId", queueId())
                .add("DisplayName", displayName()).add("Status", statusAsString())
                .add("DefaultBudgetAction", defaultBudgetActionAsString()).add("BlockedReason", blockedReasonAsString())
                .add("CreatedAt", createdAt()).add("CreatedBy", createdBy()).add("UpdatedAt", updatedAt())
                .add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "defaultBudgetAction":
            return Optional.ofNullable(clazz.cast(defaultBudgetActionAsString()));
        case "blockedReason":
            return Optional.ofNullable(clazz.cast(blockedReasonAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueueSummary, T> g) {
        return obj -> g.apply((QueueSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueueSummary> {
        /**
         * <p>
         * The farm ID.
         * </p>
         * 
         * @param farmId
         *        The farm ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The queue ID.
         * </p>
         * 
         * @param queueId
         *        The queue ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The display name of the queue summary to update.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param displayName
         *        The display name of the queue summary to update.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * That status of the queue.
         * </p>
         * 
         * @param status
         *        That status of the queue.
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(String status);

        /**
         * <p>
         * That status of the queue.
         * </p>
         * 
         * @param status
         *        That status of the queue.
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(QueueStatus status);

        /**
         * <p>
         * The default action taken on a queue summary if a budget wasn't configured.
         * </p>
         * 
         * @param defaultBudgetAction
         *        The default action taken on a queue summary if a budget wasn't configured.
         * @see DefaultQueueBudgetAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultQueueBudgetAction
         */
        Builder defaultBudgetAction(String defaultBudgetAction);

        /**
         * <p>
         * The default action taken on a queue summary if a budget wasn't configured.
         * </p>
         * 
         * @param defaultBudgetAction
         *        The default action taken on a queue summary if a budget wasn't configured.
         * @see DefaultQueueBudgetAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultQueueBudgetAction
         */
        Builder defaultBudgetAction(DefaultQueueBudgetAction defaultBudgetAction);

        /**
         * <p>
         * The reason the queue is blocked, if applicable.
         * </p>
         * 
         * @param blockedReason
         *        The reason the queue is blocked, if applicable.
         * @see QueueBlockedReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueBlockedReason
         */
        Builder blockedReason(String blockedReason);

        /**
         * <p>
         * The reason the queue is blocked, if applicable.
         * </p>
         * 
         * @param blockedReason
         *        The reason the queue is blocked, if applicable.
         * @see QueueBlockedReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueBlockedReason
         */
        Builder blockedReason(QueueBlockedReason blockedReason);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or system that created this resource.
         * </p>
         * 
         * @param createdBy
         *        The user or system that created this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl implements Builder {
        private String farmId;

        private String queueId;

        private String displayName;

        private String status;

        private String defaultBudgetAction;

        private String blockedReason;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueSummary model) {
            farmId(model.farmId);
            queueId(model.queueId);
            displayName(model.displayName);
            status(model.status);
            defaultBudgetAction(model.defaultBudgetAction);
            blockedReason(model.blockedReason);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDefaultBudgetAction() {
            return defaultBudgetAction;
        }

        public final void setDefaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
        }

        @Override
        public final Builder defaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
            return this;
        }

        @Override
        public final Builder defaultBudgetAction(DefaultQueueBudgetAction defaultBudgetAction) {
            this.defaultBudgetAction(defaultBudgetAction == null ? null : defaultBudgetAction.toString());
            return this;
        }

        public final String getBlockedReason() {
            return blockedReason;
        }

        public final void setBlockedReason(String blockedReason) {
            this.blockedReason = blockedReason;
        }

        @Override
        public final Builder blockedReason(String blockedReason) {
            this.blockedReason = blockedReason;
            return this;
        }

        @Override
        public final Builder blockedReason(QueueBlockedReason blockedReason) {
            this.blockedReason(blockedReason == null ? null : blockedReason.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public QueueSummary build() {
            return new QueueSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
