/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBudgetRequest extends DeadlineRequest implements
        ToCopyableBuilder<UpdateBudgetRequest.Builder, UpdateBudgetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateBudgetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(UpdateBudgetRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> BUDGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("budgetId").getter(getter(UpdateBudgetRequest::budgetId)).setter(setter(Builder::budgetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("budgetId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateBudgetRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateBudgetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateBudgetRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Float> APPROXIMATE_DOLLAR_LIMIT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("approximateDollarLimit").getter(getter(UpdateBudgetRequest::approximateDollarLimit))
            .setter(setter(Builder::approximateDollarLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateDollarLimit").build())
            .build();

    private static final SdkField<List<BudgetActionToAdd>> ACTIONS_TO_ADD_FIELD = SdkField
            .<List<BudgetActionToAdd>> builder(MarshallingType.LIST)
            .memberName("actionsToAdd")
            .getter(getter(UpdateBudgetRequest::actionsToAdd))
            .setter(setter(Builder::actionsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BudgetActionToAdd> builder(MarshallingType.SDK_POJO)
                                            .constructor(BudgetActionToAdd::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BudgetActionToRemove>> ACTIONS_TO_REMOVE_FIELD = SdkField
            .<List<BudgetActionToRemove>> builder(MarshallingType.LIST)
            .memberName("actionsToRemove")
            .getter(getter(UpdateBudgetRequest::actionsToRemove))
            .setter(setter(Builder::actionsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BudgetActionToRemove> builder(MarshallingType.SDK_POJO)
                                            .constructor(BudgetActionToRemove::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<BudgetSchedule> SCHEDULE_FIELD = SdkField.<BudgetSchedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(UpdateBudgetRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(BudgetSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            FARM_ID_FIELD, BUDGET_ID_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, APPROXIMATE_DOLLAR_LIMIT_FIELD,
            ACTIONS_TO_ADD_FIELD, ACTIONS_TO_REMOVE_FIELD, SCHEDULE_FIELD));

    private final String clientToken;

    private final String farmId;

    private final String budgetId;

    private final String displayName;

    private final String description;

    private final String status;

    private final Float approximateDollarLimit;

    private final List<BudgetActionToAdd> actionsToAdd;

    private final List<BudgetActionToRemove> actionsToRemove;

    private final BudgetSchedule schedule;

    private UpdateBudgetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.budgetId = builder.budgetId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.status = builder.status;
        this.approximateDollarLimit = builder.approximateDollarLimit;
        this.actionsToAdd = builder.actionsToAdd;
        this.actionsToRemove = builder.actionsToRemove;
        this.schedule = builder.schedule;
    }

    /**
     * <p>
     * The unique token which the server uses to recognize retries of the same request.
     * </p>
     * 
     * @return The unique token which the server uses to recognize retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The farm ID of the budget to update.
     * </p>
     * 
     * @return The farm ID of the budget to update.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The budget ID to update.
     * </p>
     * 
     * @return The budget ID to update.
     */
    public final String budgetId() {
        return budgetId;
    }

    /**
     * <p>
     * The display name of the budget to update.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The display name of the budget to update.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the budget to update.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The description of the budget to update.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Updates the status of the budget.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>–The budget is being evaluated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted statuses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BudgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Updates the status of the budget.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>–The budget is being evaluated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted
     *         statuses.
     *         </p>
     *         </li>
     * @see BudgetStatus
     */
    public final BudgetStatus status() {
        return BudgetStatus.fromValue(status);
    }

    /**
     * <p>
     * Updates the status of the budget.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>–The budget is being evaluated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted statuses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BudgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Updates the status of the budget.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>–The budget is being evaluated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted
     *         statuses.
     *         </p>
     *         </li>
     * @see BudgetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The dollar limit to update on the budget. Based on consumed usage.
     * </p>
     * 
     * @return The dollar limit to update on the budget. Based on consumed usage.
     */
    public final Float approximateDollarLimit() {
        return approximateDollarLimit;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionsToAdd property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionsToAdd() {
        return actionsToAdd != null && !(actionsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The budget actions to add. Budget actions specify what happens when the budget runs out.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionsToAdd} method.
     * </p>
     * 
     * @return The budget actions to add. Budget actions specify what happens when the budget runs out.
     */
    public final List<BudgetActionToAdd> actionsToAdd() {
        return actionsToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionsToRemove property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionsToRemove() {
        return actionsToRemove != null && !(actionsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The budget actions to remove from the budget.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionsToRemove} method.
     * </p>
     * 
     * @return The budget actions to remove from the budget.
     */
    public final List<BudgetActionToRemove> actionsToRemove() {
        return actionsToRemove;
    }

    /**
     * <p>
     * The schedule to update.
     * </p>
     * 
     * @return The schedule to update.
     */
    public final BudgetSchedule schedule() {
        return schedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(budgetId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(approximateDollarLimit());
        hashCode = 31 * hashCode + Objects.hashCode(hasActionsToAdd() ? actionsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActionsToRemove() ? actionsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBudgetRequest)) {
            return false;
        }
        UpdateBudgetRequest other = (UpdateBudgetRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(budgetId(), other.budgetId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(approximateDollarLimit(), other.approximateDollarLimit())
                && hasActionsToAdd() == other.hasActionsToAdd() && Objects.equals(actionsToAdd(), other.actionsToAdd())
                && hasActionsToRemove() == other.hasActionsToRemove()
                && Objects.equals(actionsToRemove(), other.actionsToRemove()) && Objects.equals(schedule(), other.schedule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBudgetRequest").add("ClientToken", clientToken()).add("FarmId", farmId())
                .add("BudgetId", budgetId()).add("DisplayName", displayName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Status", statusAsString()).add("ApproximateDollarLimit", approximateDollarLimit())
                .add("ActionsToAdd", hasActionsToAdd() ? actionsToAdd() : null)
                .add("ActionsToRemove", hasActionsToRemove() ? actionsToRemove() : null).add("Schedule", schedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "budgetId":
            return Optional.ofNullable(clazz.cast(budgetId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "approximateDollarLimit":
            return Optional.ofNullable(clazz.cast(approximateDollarLimit()));
        case "actionsToAdd":
            return Optional.ofNullable(clazz.cast(actionsToAdd()));
        case "actionsToRemove":
            return Optional.ofNullable(clazz.cast(actionsToRemove()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBudgetRequest, T> g) {
        return obj -> g.apply((UpdateBudgetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBudgetRequest> {
        /**
         * <p>
         * The unique token which the server uses to recognize retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        The unique token which the server uses to recognize retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The farm ID of the budget to update.
         * </p>
         * 
         * @param farmId
         *        The farm ID of the budget to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The budget ID to update.
         * </p>
         * 
         * @param budgetId
         *        The budget ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetId(String budgetId);

        /**
         * <p>
         * The display name of the budget to update.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param displayName
         *        The display name of the budget to update.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the budget to update.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param description
         *        The description of the budget to update.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Updates the status of the budget.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>–The budget is being evaluated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted
         * statuses.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Updates the status of the budget.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>–The budget is being evaluated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted
         *        statuses.
         *        </p>
         *        </li>
         * @see BudgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Updates the status of the budget.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>–The budget is being evaluated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted
         * statuses.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Updates the status of the budget.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>–The budget is being evaluated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted
         *        statuses.
         *        </p>
         *        </li>
         * @see BudgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetStatus
         */
        Builder status(BudgetStatus status);

        /**
         * <p>
         * The dollar limit to update on the budget. Based on consumed usage.
         * </p>
         * 
         * @param approximateDollarLimit
         *        The dollar limit to update on the budget. Based on consumed usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateDollarLimit(Float approximateDollarLimit);

        /**
         * <p>
         * The budget actions to add. Budget actions specify what happens when the budget runs out.
         * </p>
         * 
         * @param actionsToAdd
         *        The budget actions to add. Budget actions specify what happens when the budget runs out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsToAdd(Collection<BudgetActionToAdd> actionsToAdd);

        /**
         * <p>
         * The budget actions to add. Budget actions specify what happens when the budget runs out.
         * </p>
         * 
         * @param actionsToAdd
         *        The budget actions to add. Budget actions specify what happens when the budget runs out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsToAdd(BudgetActionToAdd... actionsToAdd);

        /**
         * <p>
         * The budget actions to add. Budget actions specify what happens when the budget runs out.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.BudgetActionToAdd.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.deadline.model.BudgetActionToAdd#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.BudgetActionToAdd.Builder#build()} is called
         * immediately and its result is passed to {@link #actionsToAdd(List<BudgetActionToAdd>)}.
         * 
         * @param actionsToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.BudgetActionToAdd.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionsToAdd(java.util.Collection<BudgetActionToAdd>)
         */
        Builder actionsToAdd(Consumer<BudgetActionToAdd.Builder>... actionsToAdd);

        /**
         * <p>
         * The budget actions to remove from the budget.
         * </p>
         * 
         * @param actionsToRemove
         *        The budget actions to remove from the budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsToRemove(Collection<BudgetActionToRemove> actionsToRemove);

        /**
         * <p>
         * The budget actions to remove from the budget.
         * </p>
         * 
         * @param actionsToRemove
         *        The budget actions to remove from the budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsToRemove(BudgetActionToRemove... actionsToRemove);

        /**
         * <p>
         * The budget actions to remove from the budget.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.BudgetActionToRemove.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.deadline.model.BudgetActionToRemove#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.BudgetActionToRemove.Builder#build()} is called
         * immediately and its result is passed to {@link #actionsToRemove(List<BudgetActionToRemove>)}.
         * 
         * @param actionsToRemove
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.BudgetActionToRemove.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionsToRemove(java.util.Collection<BudgetActionToRemove>)
         */
        Builder actionsToRemove(Consumer<BudgetActionToRemove.Builder>... actionsToRemove);

        /**
         * <p>
         * The schedule to update.
         * </p>
         * 
         * @param schedule
         *        The schedule to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(BudgetSchedule schedule);

        /**
         * <p>
         * The schedule to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link BudgetSchedule.Builder} avoiding the need
         * to create one manually via {@link BudgetSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BudgetSchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #schedule(BudgetSchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link BudgetSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(BudgetSchedule)
         */
        default Builder schedule(Consumer<BudgetSchedule.Builder> schedule) {
            return schedule(BudgetSchedule.builder().applyMutation(schedule).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String farmId;

        private String budgetId;

        private String displayName;

        private String description;

        private String status;

        private Float approximateDollarLimit;

        private List<BudgetActionToAdd> actionsToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<BudgetActionToRemove> actionsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BudgetSchedule schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBudgetRequest model) {
            super(model);
            clientToken(model.clientToken);
            farmId(model.farmId);
            budgetId(model.budgetId);
            displayName(model.displayName);
            description(model.description);
            status(model.status);
            approximateDollarLimit(model.approximateDollarLimit);
            actionsToAdd(model.actionsToAdd);
            actionsToRemove(model.actionsToRemove);
            schedule(model.schedule);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getBudgetId() {
            return budgetId;
        }

        public final void setBudgetId(String budgetId) {
            this.budgetId = budgetId;
        }

        @Override
        public final Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BudgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Float getApproximateDollarLimit() {
            return approximateDollarLimit;
        }

        public final void setApproximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
        }

        @Override
        public final Builder approximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
            return this;
        }

        public final List<BudgetActionToAdd.Builder> getActionsToAdd() {
            List<BudgetActionToAdd.Builder> result = BudgetActionsToAddCopier.copyToBuilder(this.actionsToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionsToAdd(Collection<BudgetActionToAdd.BuilderImpl> actionsToAdd) {
            this.actionsToAdd = BudgetActionsToAddCopier.copyFromBuilder(actionsToAdd);
        }

        @Override
        public final Builder actionsToAdd(Collection<BudgetActionToAdd> actionsToAdd) {
            this.actionsToAdd = BudgetActionsToAddCopier.copy(actionsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsToAdd(BudgetActionToAdd... actionsToAdd) {
            actionsToAdd(Arrays.asList(actionsToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsToAdd(Consumer<BudgetActionToAdd.Builder>... actionsToAdd) {
            actionsToAdd(Stream.of(actionsToAdd).map(c -> BudgetActionToAdd.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BudgetActionToRemove.Builder> getActionsToRemove() {
            List<BudgetActionToRemove.Builder> result = BudgetActionsToRemoveCopier.copyToBuilder(this.actionsToRemove);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionsToRemove(Collection<BudgetActionToRemove.BuilderImpl> actionsToRemove) {
            this.actionsToRemove = BudgetActionsToRemoveCopier.copyFromBuilder(actionsToRemove);
        }

        @Override
        public final Builder actionsToRemove(Collection<BudgetActionToRemove> actionsToRemove) {
            this.actionsToRemove = BudgetActionsToRemoveCopier.copy(actionsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsToRemove(BudgetActionToRemove... actionsToRemove) {
            actionsToRemove(Arrays.asList(actionsToRemove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsToRemove(Consumer<BudgetActionToRemove.Builder>... actionsToRemove) {
            actionsToRemove(Stream.of(actionsToRemove).map(c -> BudgetActionToRemove.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final BudgetSchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(BudgetSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(BudgetSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBudgetRequest build() {
            return new UpdateBudgetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
