/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSessionRequest extends DeadlineRequest implements
        ToCopyableBuilder<UpdateSessionRequest.Builder, UpdateSessionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateSessionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(UpdateSessionRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(UpdateSessionRequest::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(UpdateSessionRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(UpdateSessionRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<String> TARGET_LIFECYCLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetLifecycleStatus").getter(getter(UpdateSessionRequest::targetLifecycleStatusAsString))
            .setter(setter(Builder::targetLifecycleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetLifecycleStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            FARM_ID_FIELD, QUEUE_ID_FIELD, JOB_ID_FIELD, SESSION_ID_FIELD, TARGET_LIFECYCLE_STATUS_FIELD));

    private final String clientToken;

    private final String farmId;

    private final String queueId;

    private final String jobId;

    private final String sessionId;

    private final String targetLifecycleStatus;

    private UpdateSessionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.queueId = builder.queueId;
        this.jobId = builder.jobId;
        this.sessionId = builder.sessionId;
        this.targetLifecycleStatus = builder.targetLifecycleStatus;
    }

    /**
     * <p>
     * The unique token which the server uses to recognize retries of the same request.
     * </p>
     * 
     * @return The unique token which the server uses to recognize retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The farm ID to update in the session.
     * </p>
     * 
     * @return The farm ID to update in the session.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The queue ID to update in the session.
     * </p>
     * 
     * @return The queue ID to update in the session.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The job ID to update in the session.
     * </p>
     * 
     * @return The job ID to update in the session.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The session ID to update.
     * </p>
     * 
     * @return The session ID to update.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The life cycle status to update in the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetLifecycleStatus} will return {@link SessionLifecycleTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #targetLifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status to update in the session.
     * @see SessionLifecycleTargetStatus
     */
    public final SessionLifecycleTargetStatus targetLifecycleStatus() {
        return SessionLifecycleTargetStatus.fromValue(targetLifecycleStatus);
    }

    /**
     * <p>
     * The life cycle status to update in the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetLifecycleStatus} will return {@link SessionLifecycleTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #targetLifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status to update in the session.
     * @see SessionLifecycleTargetStatus
     */
    public final String targetLifecycleStatusAsString() {
        return targetLifecycleStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(targetLifecycleStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSessionRequest)) {
            return false;
        }
        UpdateSessionRequest other = (UpdateSessionRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(queueId(), other.queueId()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(targetLifecycleStatusAsString(), other.targetLifecycleStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSessionRequest").add("ClientToken", clientToken()).add("FarmId", farmId())
                .add("QueueId", queueId()).add("JobId", jobId()).add("SessionId", sessionId())
                .add("TargetLifecycleStatus", targetLifecycleStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "targetLifecycleStatus":
            return Optional.ofNullable(clazz.cast(targetLifecycleStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSessionRequest, T> g) {
        return obj -> g.apply((UpdateSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSessionRequest> {
        /**
         * <p>
         * The unique token which the server uses to recognize retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        The unique token which the server uses to recognize retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The farm ID to update in the session.
         * </p>
         * 
         * @param farmId
         *        The farm ID to update in the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The queue ID to update in the session.
         * </p>
         * 
         * @param queueId
         *        The queue ID to update in the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The job ID to update in the session.
         * </p>
         * 
         * @param jobId
         *        The job ID to update in the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The session ID to update.
         * </p>
         * 
         * @param sessionId
         *        The session ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The life cycle status to update in the session.
         * </p>
         * 
         * @param targetLifecycleStatus
         *        The life cycle status to update in the session.
         * @see SessionLifecycleTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionLifecycleTargetStatus
         */
        Builder targetLifecycleStatus(String targetLifecycleStatus);

        /**
         * <p>
         * The life cycle status to update in the session.
         * </p>
         * 
         * @param targetLifecycleStatus
         *        The life cycle status to update in the session.
         * @see SessionLifecycleTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionLifecycleTargetStatus
         */
        Builder targetLifecycleStatus(SessionLifecycleTargetStatus targetLifecycleStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String farmId;

        private String queueId;

        private String jobId;

        private String sessionId;

        private String targetLifecycleStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSessionRequest model) {
            super(model);
            clientToken(model.clientToken);
            farmId(model.farmId);
            queueId(model.queueId);
            jobId(model.jobId);
            sessionId(model.sessionId);
            targetLifecycleStatus(model.targetLifecycleStatus);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getTargetLifecycleStatus() {
            return targetLifecycleStatus;
        }

        public final void setTargetLifecycleStatus(String targetLifecycleStatus) {
            this.targetLifecycleStatus = targetLifecycleStatus;
        }

        @Override
        public final Builder targetLifecycleStatus(String targetLifecycleStatus) {
            this.targetLifecycleStatus = targetLifecycleStatus;
            return this;
        }

        @Override
        public final Builder targetLifecycleStatus(SessionLifecycleTargetStatus targetLifecycleStatus) {
            this.targetLifecycleStatus(targetLifecycleStatus == null ? null : targetLifecycleStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSessionRequest build() {
            return new UpdateSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
