/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a worker search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkerSearchSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkerSearchSummary.Builder, WorkerSearchSummary> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetId").getter(getter(WorkerSearchSummary::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetId").build()).build();

    private static final SdkField<String> WORKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerId").getter(getter(WorkerSearchSummary::workerId)).setter(setter(Builder::workerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WorkerSearchSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<HostPropertiesResponse> HOST_PROPERTIES_FIELD = SdkField
            .<HostPropertiesResponse> builder(MarshallingType.SDK_POJO).memberName("hostProperties")
            .getter(getter(WorkerSearchSummary::hostProperties)).setter(setter(Builder::hostProperties))
            .constructor(HostPropertiesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostProperties").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(WorkerSearchSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(WorkerSearchSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(WorkerSearchSummary::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(WorkerSearchSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            WORKER_ID_FIELD, STATUS_FIELD, HOST_PROPERTIES_FIELD, CREATED_BY_FIELD, CREATED_AT_FIELD, UPDATED_BY_FIELD,
            UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fleetId;

    private final String workerId;

    private final String status;

    private final HostPropertiesResponse hostProperties;

    private final String createdBy;

    private final Instant createdAt;

    private final String updatedBy;

    private final Instant updatedAt;

    private WorkerSearchSummary(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.workerId = builder.workerId;
        this.status = builder.status;
        this.hostProperties = builder.hostProperties;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.updatedBy = builder.updatedBy;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The fleet ID.
     * </p>
     * 
     * @return The fleet ID.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The worker ID.
     * </p>
     * 
     * @return The worker ID.
     */
    public final String workerId() {
        return workerId;
    }

    /**
     * <p>
     * The status of the worker search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the worker search.
     * @see WorkerStatus
     */
    public final WorkerStatus status() {
        return WorkerStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the worker search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the worker search.
     * @see WorkerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Provides the Amazon EC2 instance properties of the worker host.
     * </p>
     * 
     * @return Provides the Amazon EC2 instance properties of the worker host.
     */
    public final HostPropertiesResponse hostProperties() {
        return hostProperties;
    }

    /**
     * <p>
     * The user or system that created this resource.
     * </p>
     * 
     * @return The user or system that created this resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(workerId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostProperties());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerSearchSummary)) {
            return false;
        }
        WorkerSearchSummary other = (WorkerSearchSummary) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(workerId(), other.workerId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(hostProperties(), other.hostProperties()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedBy(), other.updatedBy())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkerSearchSummary").add("FleetId", fleetId()).add("WorkerId", workerId())
                .add("Status", statusAsString()).add("HostProperties", hostProperties()).add("CreatedBy", createdBy())
                .add("CreatedAt", createdAt()).add("UpdatedBy", updatedBy()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "workerId":
            return Optional.ofNullable(clazz.cast(workerId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "hostProperties":
            return Optional.ofNullable(clazz.cast(hostProperties()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkerSearchSummary, T> g) {
        return obj -> g.apply((WorkerSearchSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkerSearchSummary> {
        /**
         * <p>
         * The fleet ID.
         * </p>
         * 
         * @param fleetId
         *        The fleet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The worker ID.
         * </p>
         * 
         * @param workerId
         *        The worker ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerId(String workerId);

        /**
         * <p>
         * The status of the worker search.
         * </p>
         * 
         * @param status
         *        The status of the worker search.
         * @see WorkerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the worker search.
         * </p>
         * 
         * @param status
         *        The status of the worker search.
         * @see WorkerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerStatus
         */
        Builder status(WorkerStatus status);

        /**
         * <p>
         * Provides the Amazon EC2 instance properties of the worker host.
         * </p>
         * 
         * @param hostProperties
         *        Provides the Amazon EC2 instance properties of the worker host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostProperties(HostPropertiesResponse hostProperties);

        /**
         * <p>
         * Provides the Amazon EC2 instance properties of the worker host.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostPropertiesResponse.Builder} avoiding
         * the need to create one manually via {@link HostPropertiesResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostPropertiesResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #hostProperties(HostPropertiesResponse)}.
         * 
         * @param hostProperties
         *        a consumer that will call methods on {@link HostPropertiesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostProperties(HostPropertiesResponse)
         */
        default Builder hostProperties(Consumer<HostPropertiesResponse.Builder> hostProperties) {
            return hostProperties(HostPropertiesResponse.builder().applyMutation(hostProperties).build());
        }

        /**
         * <p>
         * The user or system that created this resource.
         * </p>
         * 
         * @param createdBy
         *        The user or system that created this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String fleetId;

        private String workerId;

        private String status;

        private HostPropertiesResponse hostProperties;

        private String createdBy;

        private Instant createdAt;

        private String updatedBy;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerSearchSummary model) {
            fleetId(model.fleetId);
            workerId(model.workerId);
            status(model.status);
            hostProperties(model.hostProperties);
            createdBy(model.createdBy);
            createdAt(model.createdAt);
            updatedBy(model.updatedBy);
            updatedAt(model.updatedAt);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getWorkerId() {
            return workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final HostPropertiesResponse.Builder getHostProperties() {
            return hostProperties != null ? hostProperties.toBuilder() : null;
        }

        public final void setHostProperties(HostPropertiesResponse.BuilderImpl hostProperties) {
            this.hostProperties = hostProperties != null ? hostProperties.build() : null;
        }

        @Override
        public final Builder hostProperties(HostPropertiesResponse hostProperties) {
            this.hostProperties = hostProperties;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public WorkerSearchSummary build() {
            return new WorkerSearchSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
