/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of details for a worker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkerSummary implements SdkPojo, Serializable, ToCopyableBuilder<WorkerSummary.Builder, WorkerSummary> {
    private static final SdkField<String> WORKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerId").getter(getter(WorkerSummary::workerId)).setter(setter(Builder::workerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerId").build()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(WorkerSummary::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farmId").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetId").getter(getter(WorkerSummary::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WorkerSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<HostPropertiesResponse> HOST_PROPERTIES_FIELD = SdkField
            .<HostPropertiesResponse> builder(MarshallingType.SDK_POJO).memberName("hostProperties")
            .getter(getter(WorkerSummary::hostProperties)).setter(setter(Builder::hostProperties))
            .constructor(HostPropertiesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostProperties").build()).build();

    private static final SdkField<LogConfiguration> LOG_FIELD = SdkField.<LogConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("log").getter(getter(WorkerSummary::log)).setter(setter(Builder::log))
            .constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("log").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(WorkerSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(WorkerSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(WorkerSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(WorkerSummary::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKER_ID_FIELD,
            FARM_ID_FIELD, FLEET_ID_FIELD, STATUS_FIELD, HOST_PROPERTIES_FIELD, LOG_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD,
            UPDATED_AT_FIELD, UPDATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workerId;

    private final String farmId;

    private final String fleetId;

    private final String status;

    private final HostPropertiesResponse hostProperties;

    private final LogConfiguration log;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private WorkerSummary(BuilderImpl builder) {
        this.workerId = builder.workerId;
        this.farmId = builder.farmId;
        this.fleetId = builder.fleetId;
        this.status = builder.status;
        this.hostProperties = builder.hostProperties;
        this.log = builder.log;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The worker ID.
     * </p>
     * 
     * @return The worker ID.
     */
    public final String workerId() {
        return workerId;
    }

    /**
     * <p>
     * The farm ID.
     * </p>
     * 
     * @return The farm ID.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The fleet ID.
     * </p>
     * 
     * @return The fleet ID.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The status of the worker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the worker.
     * @see WorkerStatus
     */
    public final WorkerStatus status() {
        return WorkerStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the worker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the worker.
     * @see WorkerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The host properties of the worker.
     * </p>
     * 
     * @return The host properties of the worker.
     */
    public final HostPropertiesResponse hostProperties() {
        return hostProperties;
    }

    /**
     * <p>
     * The log configuration for the worker.
     * </p>
     * 
     * @return The log configuration for the worker.
     */
    public final LogConfiguration log() {
        return log;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or system that created this resource.
     * </p>
     * 
     * @return The user or system that created this resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workerId());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostProperties());
        hashCode = 31 * hashCode + Objects.hashCode(log());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerSummary)) {
            return false;
        }
        WorkerSummary other = (WorkerSummary) obj;
        return Objects.equals(workerId(), other.workerId()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(fleetId(), other.fleetId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(hostProperties(), other.hostProperties()) && Objects.equals(log(), other.log())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkerSummary").add("WorkerId", workerId()).add("FarmId", farmId()).add("FleetId", fleetId())
                .add("Status", statusAsString()).add("HostProperties", hostProperties()).add("Log", log())
                .add("CreatedAt", createdAt()).add("CreatedBy", createdBy()).add("UpdatedAt", updatedAt())
                .add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workerId":
            return Optional.ofNullable(clazz.cast(workerId()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "fleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "hostProperties":
            return Optional.ofNullable(clazz.cast(hostProperties()));
        case "log":
            return Optional.ofNullable(clazz.cast(log()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkerSummary, T> g) {
        return obj -> g.apply((WorkerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkerSummary> {
        /**
         * <p>
         * The worker ID.
         * </p>
         * 
         * @param workerId
         *        The worker ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerId(String workerId);

        /**
         * <p>
         * The farm ID.
         * </p>
         * 
         * @param farmId
         *        The farm ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The fleet ID.
         * </p>
         * 
         * @param fleetId
         *        The fleet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The status of the worker.
         * </p>
         * 
         * @param status
         *        The status of the worker.
         * @see WorkerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the worker.
         * </p>
         * 
         * @param status
         *        The status of the worker.
         * @see WorkerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerStatus
         */
        Builder status(WorkerStatus status);

        /**
         * <p>
         * The host properties of the worker.
         * </p>
         * 
         * @param hostProperties
         *        The host properties of the worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostProperties(HostPropertiesResponse hostProperties);

        /**
         * <p>
         * The host properties of the worker.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostPropertiesResponse.Builder} avoiding
         * the need to create one manually via {@link HostPropertiesResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostPropertiesResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #hostProperties(HostPropertiesResponse)}.
         * 
         * @param hostProperties
         *        a consumer that will call methods on {@link HostPropertiesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostProperties(HostPropertiesResponse)
         */
        default Builder hostProperties(Consumer<HostPropertiesResponse.Builder> hostProperties) {
            return hostProperties(HostPropertiesResponse.builder().applyMutation(hostProperties).build());
        }

        /**
         * <p>
         * The log configuration for the worker.
         * </p>
         * 
         * @param log
         *        The log configuration for the worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder log(LogConfiguration log);

        /**
         * <p>
         * The log configuration for the worker.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #log(LogConfiguration)}.
         * 
         * @param log
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #log(LogConfiguration)
         */
        default Builder log(Consumer<LogConfiguration.Builder> log) {
            return log(LogConfiguration.builder().applyMutation(log).build());
        }

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or system that created this resource.
         * </p>
         * 
         * @param createdBy
         *        The user or system that created this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl implements Builder {
        private String workerId;

        private String farmId;

        private String fleetId;

        private String status;

        private HostPropertiesResponse hostProperties;

        private LogConfiguration log;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerSummary model) {
            workerId(model.workerId);
            farmId(model.farmId);
            fleetId(model.fleetId);
            status(model.status);
            hostProperties(model.hostProperties);
            log(model.log);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final String getWorkerId() {
            return workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final HostPropertiesResponse.Builder getHostProperties() {
            return hostProperties != null ? hostProperties.toBuilder() : null;
        }

        public final void setHostProperties(HostPropertiesResponse.BuilderImpl hostProperties) {
            this.hostProperties = hostProperties != null ? hostProperties.build() : null;
        }

        @Override
        public final Builder hostProperties(HostPropertiesResponse hostProperties) {
            this.hostProperties = hostProperties;
            return this;
        }

        public final LogConfiguration.Builder getLog() {
            return log != null ? log.toBuilder() : null;
        }

        public final void setLog(LogConfiguration.BuilderImpl log) {
            this.log = log != null ? log.build() : null;
        }

        @Override
        public final Builder log(LogConfiguration log) {
            this.log = log;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public WorkerSummary build() {
            return new WorkerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
