/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of the session action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionActionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionActionDefinition.Builder, SessionActionDefinition> {
    private static final SdkField<EnvironmentEnterSessionActionDefinition> ENV_ENTER_FIELD = SdkField
            .<EnvironmentEnterSessionActionDefinition> builder(MarshallingType.SDK_POJO).memberName("envEnter")
            .getter(getter(SessionActionDefinition::envEnter)).setter(setter(Builder::envEnter))
            .constructor(EnvironmentEnterSessionActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("envEnter").build()).build();

    private static final SdkField<EnvironmentExitSessionActionDefinition> ENV_EXIT_FIELD = SdkField
            .<EnvironmentExitSessionActionDefinition> builder(MarshallingType.SDK_POJO).memberName("envExit")
            .getter(getter(SessionActionDefinition::envExit)).setter(setter(Builder::envExit))
            .constructor(EnvironmentExitSessionActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("envExit").build()).build();

    private static final SdkField<TaskRunSessionActionDefinition> TASK_RUN_FIELD = SdkField
            .<TaskRunSessionActionDefinition> builder(MarshallingType.SDK_POJO).memberName("taskRun")
            .getter(getter(SessionActionDefinition::taskRun)).setter(setter(Builder::taskRun))
            .constructor(TaskRunSessionActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRun").build()).build();

    private static final SdkField<SyncInputJobAttachmentsSessionActionDefinition> SYNC_INPUT_JOB_ATTACHMENTS_FIELD = SdkField
            .<SyncInputJobAttachmentsSessionActionDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("syncInputJobAttachments").getter(getter(SessionActionDefinition::syncInputJobAttachments))
            .setter(setter(Builder::syncInputJobAttachments))
            .constructor(SyncInputJobAttachmentsSessionActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncInputJobAttachments").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENV_ENTER_FIELD,
            ENV_EXIT_FIELD, TASK_RUN_FIELD, SYNC_INPUT_JOB_ATTACHMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final EnvironmentEnterSessionActionDefinition envEnter;

    private final EnvironmentExitSessionActionDefinition envExit;

    private final TaskRunSessionActionDefinition taskRun;

    private final SyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments;

    private final Type type;

    private SessionActionDefinition(BuilderImpl builder) {
        this.envEnter = builder.envEnter;
        this.envExit = builder.envExit;
        this.taskRun = builder.taskRun;
        this.syncInputJobAttachments = builder.syncInputJobAttachments;
        this.type = builder.type;
    }

    /**
     * <p>
     * The environment to enter into.
     * </p>
     * 
     * @return The environment to enter into.
     */
    public final EnvironmentEnterSessionActionDefinition envEnter() {
        return envEnter;
    }

    /**
     * <p>
     * The environment to exit from.
     * </p>
     * 
     * @return The environment to exit from.
     */
    public final EnvironmentExitSessionActionDefinition envExit() {
        return envExit;
    }

    /**
     * <p>
     * The task run in the session.
     * </p>
     * 
     * @return The task run in the session.
     */
    public final TaskRunSessionActionDefinition taskRun() {
        return taskRun;
    }

    /**
     * <p>
     * The job attachments to sync with a session action.
     * </p>
     * 
     * @return The job attachments to sync with a session action.
     */
    public final SyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments() {
        return syncInputJobAttachments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(envEnter());
        hashCode = 31 * hashCode + Objects.hashCode(envExit());
        hashCode = 31 * hashCode + Objects.hashCode(taskRun());
        hashCode = 31 * hashCode + Objects.hashCode(syncInputJobAttachments());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionActionDefinition)) {
            return false;
        }
        SessionActionDefinition other = (SessionActionDefinition) obj;
        return Objects.equals(envEnter(), other.envEnter()) && Objects.equals(envExit(), other.envExit())
                && Objects.equals(taskRun(), other.taskRun())
                && Objects.equals(syncInputJobAttachments(), other.syncInputJobAttachments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionActionDefinition").add("EnvEnter", envEnter()).add("EnvExit", envExit())
                .add("TaskRun", taskRun()).add("SyncInputJobAttachments", syncInputJobAttachments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "envEnter":
            return Optional.ofNullable(clazz.cast(envEnter()));
        case "envExit":
            return Optional.ofNullable(clazz.cast(envExit()));
        case "taskRun":
            return Optional.ofNullable(clazz.cast(taskRun()));
        case "syncInputJobAttachments":
            return Optional.ofNullable(clazz.cast(syncInputJobAttachments()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #envEnter()} initialized to the given value.
     *
     * <p>
     * The environment to enter into.
     * </p>
     * 
     * @param envEnter
     *        The environment to enter into.
     */
    public static SessionActionDefinition fromEnvEnter(EnvironmentEnterSessionActionDefinition envEnter) {
        return builder().envEnter(envEnter).build();
    }

    /**
     * Create an instance of this class with {@link #envEnter()} initialized to the given value.
     *
     * <p>
     * The environment to enter into.
     * </p>
     * 
     * @param envEnter
     *        The environment to enter into.
     */
    public static SessionActionDefinition fromEnvEnter(Consumer<EnvironmentEnterSessionActionDefinition.Builder> envEnter) {
        EnvironmentEnterSessionActionDefinition.Builder builder = EnvironmentEnterSessionActionDefinition.builder();
        envEnter.accept(builder);
        return fromEnvEnter(builder.build());
    }

    /**
     * Create an instance of this class with {@link #envExit()} initialized to the given value.
     *
     * <p>
     * The environment to exit from.
     * </p>
     * 
     * @param envExit
     *        The environment to exit from.
     */
    public static SessionActionDefinition fromEnvExit(EnvironmentExitSessionActionDefinition envExit) {
        return builder().envExit(envExit).build();
    }

    /**
     * Create an instance of this class with {@link #envExit()} initialized to the given value.
     *
     * <p>
     * The environment to exit from.
     * </p>
     * 
     * @param envExit
     *        The environment to exit from.
     */
    public static SessionActionDefinition fromEnvExit(Consumer<EnvironmentExitSessionActionDefinition.Builder> envExit) {
        EnvironmentExitSessionActionDefinition.Builder builder = EnvironmentExitSessionActionDefinition.builder();
        envExit.accept(builder);
        return fromEnvExit(builder.build());
    }

    /**
     * Create an instance of this class with {@link #taskRun()} initialized to the given value.
     *
     * <p>
     * The task run in the session.
     * </p>
     * 
     * @param taskRun
     *        The task run in the session.
     */
    public static SessionActionDefinition fromTaskRun(TaskRunSessionActionDefinition taskRun) {
        return builder().taskRun(taskRun).build();
    }

    /**
     * Create an instance of this class with {@link #taskRun()} initialized to the given value.
     *
     * <p>
     * The task run in the session.
     * </p>
     * 
     * @param taskRun
     *        The task run in the session.
     */
    public static SessionActionDefinition fromTaskRun(Consumer<TaskRunSessionActionDefinition.Builder> taskRun) {
        TaskRunSessionActionDefinition.Builder builder = TaskRunSessionActionDefinition.builder();
        taskRun.accept(builder);
        return fromTaskRun(builder.build());
    }

    /**
     * Create an instance of this class with {@link #syncInputJobAttachments()} initialized to the given value.
     *
     * <p>
     * The job attachments to sync with a session action.
     * </p>
     * 
     * @param syncInputJobAttachments
     *        The job attachments to sync with a session action.
     */
    public static SessionActionDefinition fromSyncInputJobAttachments(
            SyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments) {
        return builder().syncInputJobAttachments(syncInputJobAttachments).build();
    }

    /**
     * Create an instance of this class with {@link #syncInputJobAttachments()} initialized to the given value.
     *
     * <p>
     * The job attachments to sync with a session action.
     * </p>
     * 
     * @param syncInputJobAttachments
     *        The job attachments to sync with a session action.
     */
    public static SessionActionDefinition fromSyncInputJobAttachments(
            Consumer<SyncInputJobAttachmentsSessionActionDefinition.Builder> syncInputJobAttachments) {
        SyncInputJobAttachmentsSessionActionDefinition.Builder builder = SyncInputJobAttachmentsSessionActionDefinition.builder();
        syncInputJobAttachments.accept(builder);
        return fromSyncInputJobAttachments(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionActionDefinition, T> g) {
        return obj -> g.apply((SessionActionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionActionDefinition> {
        /**
         * <p>
         * The environment to enter into.
         * </p>
         * 
         * @param envEnter
         *        The environment to enter into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder envEnter(EnvironmentEnterSessionActionDefinition envEnter);

        /**
         * <p>
         * The environment to enter into.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EnvironmentEnterSessionActionDefinition.Builder} avoiding the need to create one manually via
         * {@link EnvironmentEnterSessionActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentEnterSessionActionDefinition.Builder#build()} is
         * called immediately and its result is passed to {@link #envEnter(EnvironmentEnterSessionActionDefinition)}.
         * 
         * @param envEnter
         *        a consumer that will call methods on {@link EnvironmentEnterSessionActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #envEnter(EnvironmentEnterSessionActionDefinition)
         */
        default Builder envEnter(Consumer<EnvironmentEnterSessionActionDefinition.Builder> envEnter) {
            return envEnter(EnvironmentEnterSessionActionDefinition.builder().applyMutation(envEnter).build());
        }

        /**
         * <p>
         * The environment to exit from.
         * </p>
         * 
         * @param envExit
         *        The environment to exit from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder envExit(EnvironmentExitSessionActionDefinition envExit);

        /**
         * <p>
         * The environment to exit from.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EnvironmentExitSessionActionDefinition.Builder} avoiding the need to create one manually via
         * {@link EnvironmentExitSessionActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentExitSessionActionDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #envExit(EnvironmentExitSessionActionDefinition)}.
         * 
         * @param envExit
         *        a consumer that will call methods on {@link EnvironmentExitSessionActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #envExit(EnvironmentExitSessionActionDefinition)
         */
        default Builder envExit(Consumer<EnvironmentExitSessionActionDefinition.Builder> envExit) {
            return envExit(EnvironmentExitSessionActionDefinition.builder().applyMutation(envExit).build());
        }

        /**
         * <p>
         * The task run in the session.
         * </p>
         * 
         * @param taskRun
         *        The task run in the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRun(TaskRunSessionActionDefinition taskRun);

        /**
         * <p>
         * The task run in the session.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskRunSessionActionDefinition.Builder}
         * avoiding the need to create one manually via {@link TaskRunSessionActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskRunSessionActionDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #taskRun(TaskRunSessionActionDefinition)}.
         * 
         * @param taskRun
         *        a consumer that will call methods on {@link TaskRunSessionActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskRun(TaskRunSessionActionDefinition)
         */
        default Builder taskRun(Consumer<TaskRunSessionActionDefinition.Builder> taskRun) {
            return taskRun(TaskRunSessionActionDefinition.builder().applyMutation(taskRun).build());
        }

        /**
         * <p>
         * The job attachments to sync with a session action.
         * </p>
         * 
         * @param syncInputJobAttachments
         *        The job attachments to sync with a session action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments);

        /**
         * <p>
         * The job attachments to sync with a session action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SyncInputJobAttachmentsSessionActionDefinition.Builder} avoiding the need to create one manually via
         * {@link SyncInputJobAttachmentsSessionActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SyncInputJobAttachmentsSessionActionDefinition.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinition)}.
         * 
         * @param syncInputJobAttachments
         *        a consumer that will call methods on {@link SyncInputJobAttachmentsSessionActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinition)
         */
        default Builder syncInputJobAttachments(
                Consumer<SyncInputJobAttachmentsSessionActionDefinition.Builder> syncInputJobAttachments) {
            return syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinition.builder()
                    .applyMutation(syncInputJobAttachments).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EnvironmentEnterSessionActionDefinition envEnter;

        private EnvironmentExitSessionActionDefinition envExit;

        private TaskRunSessionActionDefinition taskRun;

        private SyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SessionActionDefinition model) {
            envEnter(model.envEnter);
            envExit(model.envExit);
            taskRun(model.taskRun);
            syncInputJobAttachments(model.syncInputJobAttachments);
        }

        public final EnvironmentEnterSessionActionDefinition.Builder getEnvEnter() {
            return envEnter != null ? envEnter.toBuilder() : null;
        }

        public final void setEnvEnter(EnvironmentEnterSessionActionDefinition.BuilderImpl envEnter) {
            Object oldValue = this.envEnter;
            this.envEnter = envEnter != null ? envEnter.build() : null;
            handleUnionValueChange(Type.ENV_ENTER, oldValue, this.envEnter);
        }

        @Override
        public final Builder envEnter(EnvironmentEnterSessionActionDefinition envEnter) {
            Object oldValue = this.envEnter;
            this.envEnter = envEnter;
            handleUnionValueChange(Type.ENV_ENTER, oldValue, this.envEnter);
            return this;
        }

        public final EnvironmentExitSessionActionDefinition.Builder getEnvExit() {
            return envExit != null ? envExit.toBuilder() : null;
        }

        public final void setEnvExit(EnvironmentExitSessionActionDefinition.BuilderImpl envExit) {
            Object oldValue = this.envExit;
            this.envExit = envExit != null ? envExit.build() : null;
            handleUnionValueChange(Type.ENV_EXIT, oldValue, this.envExit);
        }

        @Override
        public final Builder envExit(EnvironmentExitSessionActionDefinition envExit) {
            Object oldValue = this.envExit;
            this.envExit = envExit;
            handleUnionValueChange(Type.ENV_EXIT, oldValue, this.envExit);
            return this;
        }

        public final TaskRunSessionActionDefinition.Builder getTaskRun() {
            return taskRun != null ? taskRun.toBuilder() : null;
        }

        public final void setTaskRun(TaskRunSessionActionDefinition.BuilderImpl taskRun) {
            Object oldValue = this.taskRun;
            this.taskRun = taskRun != null ? taskRun.build() : null;
            handleUnionValueChange(Type.TASK_RUN, oldValue, this.taskRun);
        }

        @Override
        public final Builder taskRun(TaskRunSessionActionDefinition taskRun) {
            Object oldValue = this.taskRun;
            this.taskRun = taskRun;
            handleUnionValueChange(Type.TASK_RUN, oldValue, this.taskRun);
            return this;
        }

        public final SyncInputJobAttachmentsSessionActionDefinition.Builder getSyncInputJobAttachments() {
            return syncInputJobAttachments != null ? syncInputJobAttachments.toBuilder() : null;
        }

        public final void setSyncInputJobAttachments(
                SyncInputJobAttachmentsSessionActionDefinition.BuilderImpl syncInputJobAttachments) {
            Object oldValue = this.syncInputJobAttachments;
            this.syncInputJobAttachments = syncInputJobAttachments != null ? syncInputJobAttachments.build() : null;
            handleUnionValueChange(Type.SYNC_INPUT_JOB_ATTACHMENTS, oldValue, this.syncInputJobAttachments);
        }

        @Override
        public final Builder syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments) {
            Object oldValue = this.syncInputJobAttachments;
            this.syncInputJobAttachments = syncInputJobAttachments;
            handleUnionValueChange(Type.SYNC_INPUT_JOB_ATTACHMENTS, oldValue, this.syncInputJobAttachments);
            return this;
        }

        @Override
        public SessionActionDefinition build() {
            return new SessionActionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SessionActionDefinition#type()
     */
    public enum Type {
        ENV_ENTER,

        ENV_EXIT,

        TASK_RUN,

        SYNC_INPUT_JOB_ATTACHMENTS,

        UNKNOWN_TO_SDK_VERSION
    }
}
