/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a session action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionActionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionActionSummary.Builder, SessionActionSummary> {
    private static final SdkField<String> SESSION_ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionActionId").getter(getter(SessionActionSummary::sessionActionId))
            .setter(setter(Builder::sessionActionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionActionId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SessionActionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(SessionActionSummary::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(SessionActionSummary::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> WORKER_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("workerUpdatedAt")
            .getter(getter(SessionActionSummary::workerUpdatedAt))
            .setter(setter(Builder::workerUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Float> PROGRESS_PERCENT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("progressPercent").getter(getter(SessionActionSummary::progressPercent))
            .setter(setter(Builder::progressPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressPercent").build()).build();

    private static final SdkField<SessionActionDefinitionSummary> DEFINITION_FIELD = SdkField
            .<SessionActionDefinitionSummary> builder(MarshallingType.SDK_POJO).memberName("definition")
            .getter(getter(SessionActionSummary::definition)).setter(setter(Builder::definition))
            .constructor(SessionActionDefinitionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ACTION_ID_FIELD,
            STATUS_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, WORKER_UPDATED_AT_FIELD, PROGRESS_PERCENT_FIELD, DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sessionActionId;

    private final String status;

    private final Instant startedAt;

    private final Instant endedAt;

    private final Instant workerUpdatedAt;

    private final Float progressPercent;

    private final SessionActionDefinitionSummary definition;

    private SessionActionSummary(BuilderImpl builder) {
        this.sessionActionId = builder.sessionActionId;
        this.status = builder.status;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.workerUpdatedAt = builder.workerUpdatedAt;
        this.progressPercent = builder.progressPercent;
        this.definition = builder.definition;
    }

    /**
     * <p>
     * The session action ID.
     * </p>
     * 
     * @return The session action ID.
     */
    public final String sessionActionId() {
        return sessionActionId;
    }

    /**
     * <p>
     * The status of the session action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the session action.
     * @see SessionActionStatus
     */
    public final SessionActionStatus status() {
        return SessionActionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the session action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the session action.
     * @see SessionActionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time the resource started running.
     * </p>
     * 
     * @return The date and time the resource started running.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The date and time the resource ended running.
     * </p>
     * 
     * @return The date and time the resource ended running.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The Linux timestamp of the last date and time that the session action was updated.
     * </p>
     * 
     * @return The Linux timestamp of the last date and time that the session action was updated.
     */
    public final Instant workerUpdatedAt() {
        return workerUpdatedAt;
    }

    /**
     * <p>
     * The completion percentage for the session action.
     * </p>
     * 
     * @return The completion percentage for the session action.
     */
    public final Float progressPercent() {
        return progressPercent;
    }

    /**
     * <p>
     * The session action definition.
     * </p>
     * 
     * @return The session action definition.
     */
    public final SessionActionDefinitionSummary definition() {
        return definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionActionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(workerUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(progressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionActionSummary)) {
            return false;
        }
        SessionActionSummary other = (SessionActionSummary) obj;
        return Objects.equals(sessionActionId(), other.sessionActionId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(endedAt(), other.endedAt()) && Objects.equals(workerUpdatedAt(), other.workerUpdatedAt())
                && Objects.equals(progressPercent(), other.progressPercent()) && Objects.equals(definition(), other.definition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionActionSummary").add("SessionActionId", sessionActionId()).add("Status", statusAsString())
                .add("StartedAt", startedAt()).add("EndedAt", endedAt()).add("WorkerUpdatedAt", workerUpdatedAt())
                .add("ProgressPercent", progressPercent()).add("Definition", definition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionActionId":
            return Optional.ofNullable(clazz.cast(sessionActionId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "workerUpdatedAt":
            return Optional.ofNullable(clazz.cast(workerUpdatedAt()));
        case "progressPercent":
            return Optional.ofNullable(clazz.cast(progressPercent()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionActionSummary, T> g) {
        return obj -> g.apply((SessionActionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionActionSummary> {
        /**
         * <p>
         * The session action ID.
         * </p>
         * 
         * @param sessionActionId
         *        The session action ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionActionId(String sessionActionId);

        /**
         * <p>
         * The status of the session action.
         * </p>
         * 
         * @param status
         *        The status of the session action.
         * @see SessionActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionActionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the session action.
         * </p>
         * 
         * @param status
         *        The status of the session action.
         * @see SessionActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionActionStatus
         */
        Builder status(SessionActionStatus status);

        /**
         * <p>
         * The date and time the resource started running.
         * </p>
         * 
         * @param startedAt
         *        The date and time the resource started running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The date and time the resource ended running.
         * </p>
         * 
         * @param endedAt
         *        The date and time the resource ended running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The Linux timestamp of the last date and time that the session action was updated.
         * </p>
         * 
         * @param workerUpdatedAt
         *        The Linux timestamp of the last date and time that the session action was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerUpdatedAt(Instant workerUpdatedAt);

        /**
         * <p>
         * The completion percentage for the session action.
         * </p>
         * 
         * @param progressPercent
         *        The completion percentage for the session action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercent(Float progressPercent);

        /**
         * <p>
         * The session action definition.
         * </p>
         * 
         * @param definition
         *        The session action definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(SessionActionDefinitionSummary definition);

        /**
         * <p>
         * The session action definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionActionDefinitionSummary.Builder}
         * avoiding the need to create one manually via {@link SessionActionDefinitionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionActionDefinitionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #definition(SessionActionDefinitionSummary)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link SessionActionDefinitionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(SessionActionDefinitionSummary)
         */
        default Builder definition(Consumer<SessionActionDefinitionSummary.Builder> definition) {
            return definition(SessionActionDefinitionSummary.builder().applyMutation(definition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sessionActionId;

        private String status;

        private Instant startedAt;

        private Instant endedAt;

        private Instant workerUpdatedAt;

        private Float progressPercent;

        private SessionActionDefinitionSummary definition;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionActionSummary model) {
            sessionActionId(model.sessionActionId);
            status(model.status);
            startedAt(model.startedAt);
            endedAt(model.endedAt);
            workerUpdatedAt(model.workerUpdatedAt);
            progressPercent(model.progressPercent);
            definition(model.definition);
        }

        public final String getSessionActionId() {
            return sessionActionId;
        }

        public final void setSessionActionId(String sessionActionId) {
            this.sessionActionId = sessionActionId;
        }

        @Override
        public final Builder sessionActionId(String sessionActionId) {
            this.sessionActionId = sessionActionId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getWorkerUpdatedAt() {
            return workerUpdatedAt;
        }

        public final void setWorkerUpdatedAt(Instant workerUpdatedAt) {
            this.workerUpdatedAt = workerUpdatedAt;
        }

        @Override
        public final Builder workerUpdatedAt(Instant workerUpdatedAt) {
            this.workerUpdatedAt = workerUpdatedAt;
            return this;
        }

        public final Float getProgressPercent() {
            return progressPercent;
        }

        public final void setProgressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        public final Builder progressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final SessionActionDefinitionSummary.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(SessionActionDefinitionSummary.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(SessionActionDefinitionSummary definition) {
            this.definition = definition;
            return this;
        }

        @Override
        public SessionActionSummary build() {
            return new SessionActionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
