/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of step attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StepAttributeCapability implements SdkPojo, Serializable,
        ToCopyableBuilder<StepAttributeCapability.Builder, StepAttributeCapability> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StepAttributeCapability::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> ANY_OF_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("anyOf")
            .getter(getter(StepAttributeCapability::anyOf))
            .setter(setter(Builder::anyOf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anyOf").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALL_OF_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allOf")
            .getter(getter(StepAttributeCapability::allOf))
            .setter(setter(Builder::allOf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allOf").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ANY_OF_FIELD,
            ALL_OF_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> anyOf;

    private final List<String> allOf;

    private StepAttributeCapability(BuilderImpl builder) {
        this.name = builder.name;
        this.anyOf = builder.anyOf;
        this.allOf = builder.allOf;
    }

    /**
     * <p>
     * The name of the step attribute.
     * </p>
     * 
     * @return The name of the step attribute.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnyOf property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAnyOf() {
        return anyOf != null && !(anyOf instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Requires any of the step attributes in a given list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnyOf} method.
     * </p>
     * 
     * @return Requires any of the step attributes in a given list.
     */
    public final List<String> anyOf() {
        return anyOf;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllOf property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAllOf() {
        return allOf != null && !(allOf instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Requires all of the step attribute values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllOf} method.
     * </p>
     * 
     * @return Requires all of the step attribute values.
     */
    public final List<String> allOf() {
        return allOf;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnyOf() ? anyOf() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllOf() ? allOf() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepAttributeCapability)) {
            return false;
        }
        StepAttributeCapability other = (StepAttributeCapability) obj;
        return Objects.equals(name(), other.name()) && hasAnyOf() == other.hasAnyOf() && Objects.equals(anyOf(), other.anyOf())
                && hasAllOf() == other.hasAllOf() && Objects.equals(allOf(), other.allOf());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StepAttributeCapability").add("Name", name()).add("AnyOf", hasAnyOf() ? anyOf() : null)
                .add("AllOf", hasAllOf() ? allOf() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "anyOf":
            return Optional.ofNullable(clazz.cast(anyOf()));
        case "allOf":
            return Optional.ofNullable(clazz.cast(allOf()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StepAttributeCapability, T> g) {
        return obj -> g.apply((StepAttributeCapability) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StepAttributeCapability> {
        /**
         * <p>
         * The name of the step attribute.
         * </p>
         * 
         * @param name
         *        The name of the step attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Requires any of the step attributes in a given list.
         * </p>
         * 
         * @param anyOf
         *        Requires any of the step attributes in a given list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anyOf(Collection<String> anyOf);

        /**
         * <p>
         * Requires any of the step attributes in a given list.
         * </p>
         * 
         * @param anyOf
         *        Requires any of the step attributes in a given list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anyOf(String... anyOf);

        /**
         * <p>
         * Requires all of the step attribute values.
         * </p>
         * 
         * @param allOf
         *        Requires all of the step attribute values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allOf(Collection<String> allOf);

        /**
         * <p>
         * Requires all of the step attribute values.
         * </p>
         * 
         * @param allOf
         *        Requires all of the step attribute values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allOf(String... allOf);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> anyOf = DefaultSdkAutoConstructList.getInstance();

        private List<String> allOf = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StepAttributeCapability model) {
            name(model.name);
            anyOf(model.anyOf);
            allOf(model.allOf);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getAnyOf() {
            if (anyOf instanceof SdkAutoConstructList) {
                return null;
            }
            return anyOf;
        }

        public final void setAnyOf(Collection<String> anyOf) {
            this.anyOf = ListAttributeCapabilityValueCopier.copy(anyOf);
        }

        @Override
        public final Builder anyOf(Collection<String> anyOf) {
            this.anyOf = ListAttributeCapabilityValueCopier.copy(anyOf);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anyOf(String... anyOf) {
            anyOf(Arrays.asList(anyOf));
            return this;
        }

        public final Collection<String> getAllOf() {
            if (allOf instanceof SdkAutoConstructList) {
                return null;
            }
            return allOf;
        }

        public final void setAllOf(Collection<String> allOf) {
            this.allOf = ListAttributeCapabilityValueCopier.copy(allOf);
        }

        @Override
        public final Builder allOf(Collection<String> allOf) {
            this.allOf = ListAttributeCapabilityValueCopier.copy(allOf);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allOf(String... allOf) {
            allOf(Arrays.asList(allOf));
            return this;
        }

        @Override
        public StepAttributeCapability build() {
            return new StepAttributeCapability(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
