/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a task run in a session action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskRunSessionActionDefinitionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskRunSessionActionDefinitionSummary.Builder, TaskRunSessionActionDefinitionSummary> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(TaskRunSessionActionDefinitionSummary::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> STEP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stepId")
            .getter(getter(TaskRunSessionActionDefinitionSummary::stepId)).setter(setter(Builder::stepId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, STEP_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String taskId;

    private final String stepId;

    private TaskRunSessionActionDefinitionSummary(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.stepId = builder.stepId;
    }

    /**
     * <p>
     * The task ID.
     * </p>
     * 
     * @return The task ID.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The step ID.
     * </p>
     * 
     * @return The step ID.
     */
    public final String stepId() {
        return stepId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(stepId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskRunSessionActionDefinitionSummary)) {
            return false;
        }
        TaskRunSessionActionDefinitionSummary other = (TaskRunSessionActionDefinitionSummary) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(stepId(), other.stepId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskRunSessionActionDefinitionSummary").add("TaskId", taskId()).add("StepId", stepId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "stepId":
            return Optional.ofNullable(clazz.cast(stepId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskRunSessionActionDefinitionSummary, T> g) {
        return obj -> g.apply((TaskRunSessionActionDefinitionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskRunSessionActionDefinitionSummary> {
        /**
         * <p>
         * The task ID.
         * </p>
         * 
         * @param taskId
         *        The task ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The step ID.
         * </p>
         * 
         * @param stepId
         *        The step ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepId(String stepId);
    }

    static final class BuilderImpl implements Builder {
        private String taskId;

        private String stepId;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskRunSessionActionDefinitionSummary model) {
            taskId(model.taskId);
            stepId(model.stepId);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getStepId() {
            return stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        @Override
        public TaskRunSessionActionDefinitionSummary build() {
            return new TaskRunSessionActionDefinitionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
