/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.JobAttachmentsFileSystem;
import software.amazon.awssdk.services.deadline.model.ManifestProperties;
import software.amazon.awssdk.services.deadline.model.ManifestPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Attachments
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Attachments> {
    private static final SdkField<List<ManifestProperties>> MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("manifests").getter(Attachments.getter(Attachments::manifests)).setter(Attachments.setter(Builder::manifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManifestProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FILE_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileSystem").getter(Attachments.getter(Attachments::fileSystemAsString)).setter(Attachments.setter(Builder::fileSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFESTS_FIELD, FILE_SYSTEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("manifests", MANIFESTS_FIELD);
            this.put("fileSystem", FILE_SYSTEM_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<ManifestProperties> manifests;
    private final String fileSystem;

    private Attachments(BuilderImpl builder) {
        this.manifests = builder.manifests;
        this.fileSystem = builder.fileSystem;
    }

    public final boolean hasManifests() {
        return this.manifests != null && !(this.manifests instanceof SdkAutoConstructList);
    }

    public final List<ManifestProperties> manifests() {
        return this.manifests;
    }

    public final JobAttachmentsFileSystem fileSystem() {
        return JobAttachmentsFileSystem.fromValue(this.fileSystem);
    }

    public final String fileSystemAsString() {
        return this.fileSystem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManifests() ? this.manifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachments)) {
            return false;
        }
        Attachments other = (Attachments)obj;
        return this.hasManifests() == other.hasManifests() && Objects.equals(this.manifests(), other.manifests()) && Objects.equals(this.fileSystemAsString(), other.fileSystemAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Attachments").add("Manifests", (Object)(this.manifests() == null ? null : "*** Sensitive Data Redacted ***")).add("FileSystem", (Object)this.fileSystemAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "manifests": {
                return Optional.ofNullable(clazz.cast(this.manifests()));
            }
            case "fileSystem": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Attachments, T> g) {
        return obj -> g.apply((Attachments)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ManifestProperties> manifests = DefaultSdkAutoConstructList.getInstance();
        private String fileSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(Attachments model) {
            this.manifests(model.manifests);
            this.fileSystem(model.fileSystem);
        }

        public final List<ManifestProperties.Builder> getManifests() {
            List<ManifestProperties.Builder> result = ManifestPropertiesListCopier.copyToBuilder(this.manifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManifests(Collection<ManifestProperties.BuilderImpl> manifests) {
            this.manifests = ManifestPropertiesListCopier.copyFromBuilder(manifests);
        }

        @Override
        public final Builder manifests(Collection<ManifestProperties> manifests) {
            this.manifests = ManifestPropertiesListCopier.copy(manifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder manifests(ManifestProperties ... manifests) {
            this.manifests(Arrays.asList(manifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder manifests(Consumer<ManifestProperties.Builder> ... manifests) {
            this.manifests(Stream.of(manifests).map(c -> (ManifestProperties)((ManifestProperties.Builder)ManifestProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFileSystem() {
            return this.fileSystem;
        }

        public final void setFileSystem(String fileSystem) {
            this.fileSystem = fileSystem;
        }

        @Override
        public final Builder fileSystem(String fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        @Override
        public final Builder fileSystem(JobAttachmentsFileSystem fileSystem) {
            this.fileSystem(fileSystem == null ? null : fileSystem.toString());
            return this;
        }

        public Attachments build() {
            return new Attachments(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Attachments> {
        public Builder manifests(Collection<ManifestProperties> var1);

        public Builder manifests(ManifestProperties ... var1);

        public Builder manifests(Consumer<ManifestProperties.Builder> ... var1);

        public Builder fileSystem(String var1);

        public Builder fileSystem(JobAttachmentsFileSystem var1);
    }
}

