/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.TaskParameterValue;
import software.amazon.awssdk.services.deadline.model.TaskParametersCopier;
import software.amazon.awssdk.services.deadline.model.TaskRunStatus;
import software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskSummary> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(TaskSummary.getter(TaskSummary::taskId)).setter(TaskSummary.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(TaskSummary.getter(TaskSummary::createdAt)).setter(TaskSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(TaskSummary.getter(TaskSummary::createdBy)).setter(TaskSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runStatus").getter(TaskSummary.getter(TaskSummary::runStatusAsString)).setter(TaskSummary.setter(Builder::runStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runStatus").build()}).build();
    private static final SdkField<String> TARGET_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetRunStatus").getter(TaskSummary.getter(TaskSummary::targetRunStatusAsString)).setter(TaskSummary.setter(Builder::targetRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRunStatus").build()}).build();
    private static final SdkField<Integer> FAILURE_RETRY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failureRetryCount").getter(TaskSummary.getter(TaskSummary::failureRetryCount)).setter(TaskSummary.setter(Builder::failureRetryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureRetryCount").build()}).build();
    private static final SdkField<Map<String, TaskParameterValue>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(TaskSummary.getter(TaskSummary::parameters)).setter(TaskSummary.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(TaskSummary.getter(TaskSummary::startedAt)).setter(TaskSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(TaskSummary.getter(TaskSummary::endedAt)).setter(TaskSummary.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(TaskSummary.getter(TaskSummary::updatedAt)).setter(TaskSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(TaskSummary.getter(TaskSummary::updatedBy)).setter(TaskSummary.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<String> LATEST_SESSION_ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latestSessionActionId").getter(TaskSummary.getter(TaskSummary::latestSessionActionId)).setter(TaskSummary.setter(Builder::latestSessionActionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestSessionActionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, RUN_STATUS_FIELD, TARGET_RUN_STATUS_FIELD, FAILURE_RETRY_COUNT_FIELD, PARAMETERS_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, LATEST_SESSION_ACTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("taskId", TASK_ID_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("runStatus", RUN_STATUS_FIELD);
            this.put("targetRunStatus", TARGET_RUN_STATUS_FIELD);
            this.put("failureRetryCount", FAILURE_RETRY_COUNT_FIELD);
            this.put("parameters", PARAMETERS_FIELD);
            this.put("startedAt", STARTED_AT_FIELD);
            this.put("endedAt", ENDED_AT_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("updatedBy", UPDATED_BY_FIELD);
            this.put("latestSessionActionId", LATEST_SESSION_ACTION_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final Instant createdAt;
    private final String createdBy;
    private final String runStatus;
    private final String targetRunStatus;
    private final Integer failureRetryCount;
    private final Map<String, TaskParameterValue> parameters;
    private final Instant startedAt;
    private final Instant endedAt;
    private final Instant updatedAt;
    private final String updatedBy;
    private final String latestSessionActionId;

    private TaskSummary(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.runStatus = builder.runStatus;
        this.targetRunStatus = builder.targetRunStatus;
        this.failureRetryCount = builder.failureRetryCount;
        this.parameters = builder.parameters;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.latestSessionActionId = builder.latestSessionActionId;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final TaskRunStatus runStatus() {
        return TaskRunStatus.fromValue(this.runStatus);
    }

    public final String runStatusAsString() {
        return this.runStatus;
    }

    public final TaskTargetRunStatus targetRunStatus() {
        return TaskTargetRunStatus.fromValue(this.targetRunStatus);
    }

    public final String targetRunStatusAsString() {
        return this.targetRunStatus;
    }

    public final Integer failureRetryCount() {
        return this.failureRetryCount;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, TaskParameterValue> parameters() {
        return this.parameters;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final String latestSessionActionId() {
        return this.latestSessionActionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.runStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureRetryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestSessionActionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskSummary)) {
            return false;
        }
        TaskSummary other = (TaskSummary)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.runStatusAsString(), other.runStatusAsString()) && Objects.equals(this.targetRunStatusAsString(), other.targetRunStatusAsString()) && Objects.equals(this.failureRetryCount(), other.failureRetryCount()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy()) && Objects.equals(this.latestSessionActionId(), other.latestSessionActionId());
    }

    public final String toString() {
        return ToString.builder((String)"TaskSummary").add("TaskId", (Object)this.taskId()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("RunStatus", (Object)this.runStatusAsString()).add("TargetRunStatus", (Object)this.targetRunStatusAsString()).add("FailureRetryCount", (Object)this.failureRetryCount()).add("Parameters", (Object)(this.parameters() == null ? null : "*** Sensitive Data Redacted ***")).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).add("LatestSessionActionId", (Object)this.latestSessionActionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "runStatus": {
                return Optional.ofNullable(clazz.cast(this.runStatusAsString()));
            }
            case "targetRunStatus": {
                return Optional.ofNullable(clazz.cast(this.targetRunStatusAsString()));
            }
            case "failureRetryCount": {
                return Optional.ofNullable(clazz.cast(this.failureRetryCount()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "latestSessionActionId": {
                return Optional.ofNullable(clazz.cast(this.latestSessionActionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TaskSummary, T> g) {
        return obj -> g.apply((TaskSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private Instant createdAt;
        private String createdBy;
        private String runStatus;
        private String targetRunStatus;
        private Integer failureRetryCount;
        private Map<String, TaskParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Instant startedAt;
        private Instant endedAt;
        private Instant updatedAt;
        private String updatedBy;
        private String latestSessionActionId;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskSummary model) {
            this.taskId(model.taskId);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.runStatus(model.runStatus);
            this.targetRunStatus(model.targetRunStatus);
            this.failureRetryCount(model.failureRetryCount);
            this.parameters(model.parameters);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
            this.latestSessionActionId(model.latestSessionActionId);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getRunStatus() {
            return this.runStatus;
        }

        public final void setRunStatus(String runStatus) {
            this.runStatus = runStatus;
        }

        @Override
        public final Builder runStatus(String runStatus) {
            this.runStatus = runStatus;
            return this;
        }

        @Override
        public final Builder runStatus(TaskRunStatus runStatus) {
            this.runStatus(runStatus == null ? null : runStatus.toString());
            return this;
        }

        public final String getTargetRunStatus() {
            return this.targetRunStatus;
        }

        public final void setTargetRunStatus(String targetRunStatus) {
            this.targetRunStatus = targetRunStatus;
        }

        @Override
        public final Builder targetRunStatus(String targetRunStatus) {
            this.targetRunStatus = targetRunStatus;
            return this;
        }

        @Override
        public final Builder targetRunStatus(TaskTargetRunStatus targetRunStatus) {
            this.targetRunStatus(targetRunStatus == null ? null : targetRunStatus.toString());
            return this;
        }

        public final Integer getFailureRetryCount() {
            return this.failureRetryCount;
        }

        public final void setFailureRetryCount(Integer failureRetryCount) {
            this.failureRetryCount = failureRetryCount;
        }

        @Override
        public final Builder failureRetryCount(Integer failureRetryCount) {
            this.failureRetryCount = failureRetryCount;
            return this;
        }

        public final Map<String, TaskParameterValue.Builder> getParameters() {
            Map<String, TaskParameterValue.Builder> result = TaskParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, TaskParameterValue.BuilderImpl> parameters) {
            this.parameters = TaskParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, TaskParameterValue> parameters) {
            this.parameters = TaskParametersCopier.copy(parameters);
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final String getLatestSessionActionId() {
            return this.latestSessionActionId;
        }

        public final void setLatestSessionActionId(String latestSessionActionId) {
            this.latestSessionActionId = latestSessionActionId;
        }

        @Override
        public final Builder latestSessionActionId(String latestSessionActionId) {
            this.latestSessionActionId = latestSessionActionId;
            return this;
        }

        public TaskSummary build() {
            return new TaskSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskSummary> {
        public Builder taskId(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder runStatus(String var1);

        public Builder runStatus(TaskRunStatus var1);

        public Builder targetRunStatus(String var1);

        public Builder targetRunStatus(TaskTargetRunStatus var1);

        public Builder failureRetryCount(Integer var1);

        public Builder parameters(Map<String, TaskParameterValue> var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);

        public Builder latestSessionActionId(String var1);
    }
}

