/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.FarmSummariesCopier;
import software.amazon.awssdk.services.deadline.model.FarmSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFarmsResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, ListFarmsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFarmsResponse.getter(ListFarmsResponse::nextToken)).setter(ListFarmsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<FarmSummary>> FARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("farms").getter(ListFarmsResponse.getter(ListFarmsResponse::farms)).setter(ListFarmsResponse.setter(Builder::farms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FarmSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, FARMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFarmsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<FarmSummary> farms;

    private ListFarmsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.farms = builder.farms;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFarms() {
        return this.farms != null && !(this.farms instanceof SdkAutoConstructList);
    }

    public final List<FarmSummary> farms() {
        return this.farms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFarms() ? this.farms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFarmsResponse)) {
            return false;
        }
        ListFarmsResponse other = (ListFarmsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasFarms() == other.hasFarms() && Objects.equals(this.farms(), other.farms());
    }

    public final String toString() {
        return ToString.builder((String)"ListFarmsResponse").add("NextToken", (Object)this.nextToken()).add("Farms", this.hasFarms() ? this.farms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "farms": {
                return Optional.ofNullable(clazz.cast(this.farms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("farms", FARMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFarmsResponse, T> g) {
        return obj -> g.apply((ListFarmsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<FarmSummary> farms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFarmsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.farms(model.farms);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FarmSummary.Builder> getFarms() {
            List<FarmSummary.Builder> result = FarmSummariesCopier.copyToBuilder(this.farms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFarms(Collection<FarmSummary.BuilderImpl> farms) {
            this.farms = FarmSummariesCopier.copyFromBuilder(farms);
        }

        @Override
        public final Builder farms(Collection<FarmSummary> farms) {
            this.farms = FarmSummariesCopier.copy(farms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder farms(FarmSummary ... farms) {
            this.farms(Arrays.asList(farms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder farms(Consumer<FarmSummary.Builder> ... farms) {
            this.farms(Stream.of(farms).map(c -> (FarmSummary)((FarmSummary.Builder)FarmSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFarmsResponse build() {
            return new ListFarmsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFarmsResponse> {
        public Builder nextToken(String var1);

        public Builder farms(Collection<FarmSummary> var1);

        public Builder farms(FarmSummary ... var1);

        public Builder farms(Consumer<FarmSummary.Builder> ... var1);
    }
}

